<?php

/*
|--------------------------------------------------------------------------
| 后台路由
|--------------------------------------------------------------------------
|
| 统一命名空间 Admin
| 统一前缀 admin
| 用户认证统一使用 auth:admin 中间件
| 权限认证统一使用 permission:权限名称
|
*/

use Illuminate\Support\Facades\Route;
// use App\Models\Admin\Role;
// use App\Models\Admin\Permission;
// $role = Role::findOrFail(1);
// $permissions = Permission::get()->pluck('id');
// $role->syncPermissions($permissions);

Route::group(['prefix' => env('APP_LOGIN_NAME'), 'namespace' => 'Admin'], function () {
    /*
    |--------------------------------------------------------------------------
    | 用户登录、退出、更改密码，首页，上传
    |--------------------------------------------------------------------------
    */
    //登录
    Route::get('login', 'Admin\UserController@showLoginForm')->name('admin.loginForm');
    Route::post('login', 'Admin\UserController@login')->name('admin.login');
    //退出
    Route::get('logout', 'Admin\UserController@logout')->name('admin.logout')->middleware('auth:admin');
    //更改密码
    Route::get('change_my_password_form', 'Admin\UserController@changeMyPasswordForm')->name('admin.changeMyPasswordForm')->middleware('auth:admin');
    Route::post('change_my_password', 'Admin\UserController@changeMyPassword')->name('admin.changeMyPassword')->middleware('auth:admin');
    //后台布局
    Route::get('/', 'Admin\IndexController@layout')->name('admin.layout')->middleware('auth:admin');
    Route::post('/index/user/data', 'Admin\IndexController@userData')->name('index.user.data')->middleware('auth:admin');
    //后台首页
    Route::get('/index', 'Admin\IndexController@index')->name('admin.index')->middleware('auth:admin');
    // 上传
    Route::any('uploads/images', 'Admin\UploadsController@images')->name('admin.uploads.images')->middleware('auth:admin'); // 图片上传
    Route::any('uploads/image', 'Admin\UploadsController@image')->name('admin.uploads.image')->middleware('auth:admin'); // 图片上传
    Route::any('uploads/audio', 'Admin\UploadsController@audio')->name('admin.uploads.audio')->middleware('auth:admin'); // 音频上传
    Route::any('uploads/video', 'Admin\UploadsController@video')->name('admin.uploads.video')->middleware('auth:admin'); // 视频上传
    Route::any('uploads/file', 'Admin\UploadsController@file')->name('admin.uploads.file')->middleware('auth:admin'); // 文件上传
    /*
    |--------------------------------------------------------------------------
    | 用户管理
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:users']], function () {
        //用户管理
        Route::group(['middleware' => ['permission:users.users']], function () {
            Route::get('users/users', 'Users\UsersController@index')->name('users.users');
            Route::get('users/users/data', 'Users\UsersController@data')->name('users.users.data');
            Route::get('users/users/team', 'Users\TeamController@index')->name('users.team');
            Route::get('users/team/data', 'Users\TeamController@data')->name('users.team.data');
            Route::any('users/users/store', 'Users\UsersController@store')->name('users.users.store')->middleware('permission:users.users.store');
            Route::any('users/users/show', 'Users\UsersController@show')->name('users.users.show');
            Route::any('users/users/edit_money', 'Users\UsersController@edit_money')->name('users.users.edit_money')->middleware('permission:users.users.edit_money');
        });
        //推广列表
        Route::group(['middleware' => ['permission:users.dailiList']], function () {
            Route::get('users/dailiList', 'Users\DailiListController@index')->name('users.dailiList');
            Route::get('users/dailiList/data', 'Users\DailiListController@data')->name('users.dailiList.data');
            Route::get('users/dailiList/team', 'Users\TeamController@index')->name('users.team');
            Route::get('users/team/data', 'Users\TeamController@data')->name('users.team.data');
            Route::any('users/dailiList/store', 'Users\DailiListController@store')->name('users.dailiList.store')->middleware('permission:users.dailiList.store');
        });
        //提现列表
        Route::group(['middleware' => ['permission:users.withdraw']], function () {
            Route::get('users/withdraw', 'Users\WithdrawController@index')->name('users.withdraw');
            Route::get('users/withdraw/data', 'Users\WithdrawController@data')->name('users.withdraw.data');
            Route::any('users/withdraw/edit', 'Users\WithdrawController@edit')->name('users.withdraw.edit')->middleware('permission:users.hang.edit');
        });
        //代理申请列表
        Route::group(['middleware' => ['permission:users.daili']], function () {
            Route::get('users/daili', 'Users\DailiController@index')->name('users.daili');
            Route::get('users/daili/data', 'Users\DailiController@data')->name('users.daili.data');
            Route::any('users/daili/edit', 'Users\DailiController@edit')->name('users.daili.edit')->middleware('permission:users.daili.edit');
        });
        //发货列表
        Route::group(['middleware' => ['permission:users.ship']], function () {
            Route::get('users/ship', 'Users\ShipController@index')->name('users.ship');
            Route::get('users/ship/data', 'Users\ShipController@data')->name('users.ship.data');
            Route::any('users/ship/edit', 'Users\ShipController@edit')->name('users.ship.edit')->middleware('permission:users.ship.edit');
        });

    });
    /*
    |--------------------------------------------------------------------------
    | 流水统计
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:stats']], function () {
        //余额明细
        Route::group(['middleware' => ['permission:stats.money']], function () {
            Route::get('stats/money', 'Stats\MoneyController@index')->name('stats.money');
            Route::get('stats/money/data', 'Stats\MoneyController@data')->name('stats.money.data');
        });
        //积分明细
        Route::group(['middleware' => ['permission:stats.coin']], function () {
            Route::get('stats/coin', 'Stats\CoinController@index')->name('stats.coin');
            Route::get('stats/coin/data', 'Stats\CoinController@data')->name('stats.coin.data');
        });
        //购物金明细
        Route::group(['middleware' => ['permission:stats.gold']], function () {
            Route::get('stats/gold', 'Stats\GoldController@index')->name('stats.gold');
            Route::get('stats/gold/data', 'Stats\GoldController@data')->name('stats.gold.data');
        });
        //开盒记录
        Route::group(['middleware' => ['permission:stats.box']], function () {
            Route::get('stats/box', 'Stats\BoxController@index')->name('stats.box');
            Route::get('stats/box/data', 'Stats\BoxController@data')->name('stats.box.data');
            Route::get('stats/box/award', 'Stats\BoxController@award')->name('stats.box.award');
            Route::get('stats/box/award/data', 'Stats\BoxController@awardData')->name('stats.box.award.data');
        });
        //订单列表
        Route::group(['middleware' => ['permission:stats.order']], function () {
            Route::get('stats/order', 'Stats\OrderController@index')->name('stats.order');
            Route::get('stats/order/data', 'Stats\OrderController@data')->name('stats.order.data');
            Route::any('stats/order/refund', 'Stats\OrderController@refund')->name('stats.order.refund')->middleware('permission:stats.order.refund');
        });
        //充值记录
        Route::group(['middleware' => ['permission:stats.recharge']], function () {
            Route::get('stats/recharge', 'Stats\RechargeLogController@index')->name('stats.recharge');
            Route::get('stats/recharge/data', 'Stats\RechargeLogController@data')->name('stats.recharge.data');
        });
    });
    /*
    |--------------------------------------------------------------------------
    | 商城管理
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:shop']], function () {
        // 商品管理
        Route::group(['middleware' => ['permission:shop.goods']], function () {
            Route::get('shop/goods', 'Shop\GoodsController@index')->name('shop.goods');
            Route::get('shop/goods/data', 'Shop\GoodsController@data')->name('shop.goods.data');
            Route::get('shop/goods/specData', 'Shop\GoodsController@specData')->name('shop.goods.specData');
            Route::get('shop/goods/skuData', 'Shop\GoodsController@skuData')->name('shop.goods.skuData');
            Route::any('shop/goods/store', 'Shop\GoodsController@store')->name('shop.goods.store')->middleware('permission:shop.goods.store');
            Route::delete('shop/goods/del', 'Shop\GoodsController@del')->name('shop.goods.del')->middleware('permission:shop.goods.del');
            Route::post('shop/goods/show', 'Shop\GoodsController@show')->name('shop.goods.show');
        });
        //商城分类
        Route::group(['middleware' => ['permission:shop.cat']], function () {
            Route::get('shop/cat', 'Shop\CatController@index')->name('shop.cat');
            Route::get('shop/cat/data', 'Shop\CatController@data')->name('shop.cat.data');
            Route::any('shop/cat/store', 'Shop\CatController@store')->name('shop.cat.store')->middleware('permission:shop.cat.store');
            Route::delete('shop/cat/del', 'Shop\CatController@del')->name('shop.cat.del')->middleware('permission:shop.cat.del');
            Route::post('shop/cat/show', 'Shop\CatController@show')->name('shop.cat.show');
        });
        //商城品牌
        Route::group(['middleware' => ['permission:shop.brand']], function () {
            Route::get('shop/brand', 'Shop\BrandController@index')->name('shop.brand');
            Route::get('shop/brand/data', 'Shop\BrandController@data')->name('shop.brand.data');
            Route::any('shop/brand/store', 'Shop\BrandController@store')->name('shop.brand.store')->middleware('permission:shop.brand.store');
            Route::delete('shop/brand/del', 'Shop\BrandController@del')->name('shop.brand.del')->middleware('permission:shop.brand.del');
            Route::post('shop/brand/show', 'Shop\BrandController@show')->name('shop.brand.show');
        });
        //商城品牌
        Route::group(['middleware' => ['permission:shop.hotsearch']], function () {
            Route::get('shop/hotsearch', 'Shop\HotsearchController@index')->name('shop.hotsearch');
            Route::get('shop/hotsearch/data', 'Shop\HotsearchController@data')->name('shop.hotsearch.data');
            Route::any('shop/hotsearch/store', 'Shop\HotsearchController@store')->name('shop.hotsearch.store')->middleware('permission:shop.hotsearch.store');
            Route::delete('shop/hotsearch/del', 'Shop\HotsearchController@del')->name('shop.hotsearch.del')->middleware('permission:shop.hotsearch.del');
            Route::post('shop/hotsearch/show', 'Shop\HotsearchController@show')->name('shop.hotsearch.show');
        });
        // 置换商品
        Route::group(['middleware' => ['permission:shop.change']], function () {
            Route::get('shop/change', 'Shop\ChangeController@index')->name('shop.change');
            Route::get('shop/change/data', 'Shop\ChangeController@data')->name('shop.change.data');
            Route::get('shop/change/specData', 'Shop\ChangeController@specData')->name('shop.change.specData');
            Route::get('shop/change/skuData', 'Shop\ChangeController@skuData')->name('shop.change.skuData');
            Route::any('shop/change/store', 'Shop\ChangeController@store')->name('shop.change.store')->middleware('permission:shop.change.store');
            Route::delete('shop/change/del', 'Shop\ChangeController@del')->name('shop.change.del')->middleware('permission:shop.change.del');
            Route::post('shop/change/show', 'Shop\ChangeController@show')->name('shop.change.show');
        });
    });
    /*
    |--------------------------------------------------------------------------
    |  盒子管理
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:box']], function () {
        // 盒子列表
        Route::group(['middleware' => ['permission:box.box']], function () {
            Route::get('box/box', 'Box\BoxController@index')->name('box.box');
            Route::get('box/box/new', 'Box\BoxController@index')->name('box.box.new');
            Route::get('box/box/wel', 'Box\BoxController@index')->name('box.box.wel');
            Route::get('box/box/free', 'Box\BoxController@index')->name('box.box.free');
            Route::get('box/box/data', 'Box\BoxController@data')->name('box.box.data');
            Route::any('box/box/store', 'Box\BoxController@store')->name('box.box.store')->middleware('permission:box.box.store');
            Route::delete('box/box/del', 'Box\BoxController@del')->name('box.box.del')->middleware('permission:box.box.del');
            Route::post('box/box/show', 'Box\BoxController@show')->name('box.box.show');
            Route::post('box/box/show2', 'Box\BoxController@show2')->name('box.box.show2');
            Route::post('box/box/show3', 'Box\BoxController@show3')->name('box.box.show3');
        });
        // 盒子奖品
        Route::group(['middleware' => ['permission:box.award']], function () {
            Route::get('box/award', 'Box\AwardController@index')->name('box.award');
            Route::get('box/award/data', 'Box\AwardController@data')->name('box.award.data');
            Route::any('box/award/store', 'Box\AwardController@store')->name('box.award.store')->middleware('permission:box.award.store');
            Route::delete('box/award/del', 'Box\AwardController@del')->name('box.award.del')->middleware('permission:box.award.del');
        });
        // 抽取方式
        Route::group(['middleware' => ['permission:box.draw']], function () {
            Route::get('box/draw', 'Box\DrawController@index')->name('box.draw');
            Route::get('box/draw/data', 'Box\DrawController@data')->name('box.draw.data');
            Route::any('box/draw/store', 'Box\DrawController@store')->name('box.draw.store')->middleware('permission:box.draw.store');
            Route::delete('box/draw/del', 'Box\DrawController@del')->name('box.draw.del')->middleware('permission:box.draw.del');
            Route::post('box/draw/show', 'Box\DrawController@show')->name('box.draw.show');
        });
        // 中奖记录
        Route::group(['middleware' => ['permission:box.log']], function () {
            Route::get('box/log', 'Box\LogController@index')->name('box.log');
            Route::get('box/log/data', 'Box\LogController@data')->name('box.log.data');
        });
    });
    /*
    |--------------------------------------------------------------------------
    |  幸运盲盒
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:luckbox']], function () {
        // 盒子奖品
        Route::group(['middleware' => ['permission:luckbox.award']], function () {
            Route::get('luckbox/award', 'Luckbox\AwardController@index')->name('luckbox.award');
            Route::get('luckbox/award/data', 'Luckbox\AwardController@data')->name('luckbox.award.data');
            Route::any('luckbox/award/store', 'Luckbox\AwardController@store')->name('luckbox.award.store')->middleware('permission:luckbox.award.store');
            Route::delete('luckbox/award/del', 'Luckbox\AwardController@del')->name('luckbox.award.del')->middleware('permission:luckbox.award.del');
            Route::any('luckbox/award/show', 'Luckbox\AwardController@show')->name('luckbox.award.show');
        });
    });
    /*
    |--------------------------------------------------------------------------
    | 运营管理
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:operate']], function () {
        // 轮播图列表
        Route::group(['middleware' => ['permission:operate.banners']], function () {
            Route::get('operate/banners1', 'Operate\BannersController@index')->name('operate.banners1');
            Route::get('operate/banners2', 'Operate\BannersController@index')->name('operate.banners2');
            Route::get('operate/banners3', 'Operate\BannersController@index')->name('operate.banners3');
            Route::get('operate/banners4', 'Operate\BannersController@index')->name('operate.banners4');
            Route::get('operate/banners/data', 'Operate\BannersController@data')->name('operate.banners.data');
            Route::any('operate/banners/store', 'Operate\BannersController@store')->name('operate.banners.store')->middleware('permission:operate.banners.store');
            Route::delete('operate/banners/del', 'Operate\BannersController@del')->name('operate.banners.del')->middleware('permission:operate.banners.del');
            Route::post('operate/banners/show', 'Operate\BannersController@show')->name('operate.banners.show');
        });
        // 红包列表
        Route::group(['middleware' => ['permission:operate.redpack']], function () {
            Route::get('operate/redpack', 'Operate\RedpackController@index')->name('operate.redpack');
            Route::get('operate/redpack/data', 'Operate\RedpackController@data')->name('operate.redpack.data');
            Route::any('operate/redpack/store', 'Operate\RedpackController@store')->name('operate.redpack.store')->middleware('permission:operate.redpack.store');
            Route::delete('operate/redpack/del', 'Operate\RedpackController@del')->name('operate.redpack.del')->middleware('permission:operate.redpack.del');
        });
        // 充值选项管理
        Route::group(['middleware' => ['permission:operate.recharge']], function () {
            Route::get('operate/recharge', 'Operate\RechargeController@index')->name('operate.recharge');
            Route::get('operate/recharge/data', 'Operate\RechargeController@data')->name('operate.recharge.data');
            Route::any('operate/recharge/store', 'Operate\RechargeController@store')->name('operate.recharge.store')->middleware('permission:operate.recharge.store');
            Route::delete('operate/recharge/del', 'Operate\RechargeController@del')->name('operate.recharge.del')->middleware('permission:operate.recharge.del');
        });
    });
    /*
    |--------------------------------------------------------------------------
    | 投诉
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:complain']], function () {
        //投诉分类
        Route::group(['middleware' => ['permission:complain.type']], function () {
            Route::get('complain/type', 'Complain\TypeController@index')->name('complain.type');
            Route::get('complain/type/data', 'Complain\TypeController@data')->name('complain.type.data');
            Route::any('complain/type/store', 'Complain\TypeController@store')->name('complain.type.store')->middleware('permission:complain.type.store');
            Route::delete('complain/type/del', 'Complain\TypeController@del')->name('complain.type.del')->middleware('permission:complain.type.del');
        });
        //投诉列表
        Route::group(['middleware' => ['permission:complain.complain']], function () {
            Route::get('complain/complain', 'Complain\ComplainController@index')->name('complain.complain');
            Route::get('complain/complain/data', 'Complain\ComplainController@data')->name('complain.complain.data');
            Route::any('complain/complain/reply', 'Complain\ComplainController@reply')->name('complain.complain.reply')->middleware('permission:complain.complain.reply');
        });
    });
    /*
    |--------------------------------------------------------------------------
    | 系统配置
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:sys']], function () {
        // 规则协议
        Route::group(['middleware' => ['permission:sys.rule']], function () {
            Route::get('sys/Rule', 'Sys\RuleController@index')->name('sys.rule');
            Route::get('sys/Rule/data', 'Sys\RuleController@data')->name('sys.rule.data');
            //编辑
            Route::any('sys/Rule/store', 'Sys\RuleController@store')->name('sys.rule.store')->middleware('permission:sys.rule.store');
        });
        //配置项
        Route::group(['middleware' => 'permission:system.configuration'], function () {
            Route::get('configuration', 'Admin\ConfigurationController@index')->name('admin.configuration');
            //添加
            Route::get('configuration/create', 'Admin\ConfigurationController@create')->name('admin.configuration.create')->middleware('permission:system.configuration.create');
            Route::post('configuration/store', 'Admin\ConfigurationController@store')->name('admin.configuration.store')->middleware('permission:system.configuration.create');
            //编辑
            Route::put('configuration/update', 'Admin\ConfigurationController@update')->name('admin.configuration.update')->middleware('permission:system.configuration.edit');
        });
        // 数据库备份
        Route::group(['middleware' => ['permission:sys.backup']], function () {
            Route::get('sys/backup', 'Sys\BackupController@index')->name('sys.backup');
            Route::get('sys/backup/data', 'Sys\BackupController@data')->name('sys.backup.data');
            //编辑
            Route::any('sys/backup/store', 'Sys\BackupController@store')->name('sys.backup.store')->middleware('permission:sys.backup.store');
            Route::any('sys/backup/before', 'Sys\BackupController@before')->name('sys.backup.before')->middleware('permission:sys.backup.before');
            Route::any('sys/backup/del', 'Sys\BackupController@del')->name('sys.backup.del')->middleware('permission:sys.backup.del');
        });
    });
    /*
    |--------------------------------------------------------------------------
    | 系统管理模块
    |--------------------------------------------------------------------------
    */
    Route::group(['middleware' => ['auth:admin', 'permission:system']], function () {
        //用户管理
        Route::group(['middleware' => ['permission:system.user']], function () {
            Route::get('user', 'Admin\UserController@index')->name('admin.user');
            Route::get('user/data', 'Admin\UserController@data')->name('admin.user.data');
            //添加
            Route::get('user/create', 'Admin\UserController@create')->name('admin.user.create')->middleware('permission:system.user.create');
            Route::post('user/store', 'Admin\UserController@store')->name('admin.user.store')->middleware('permission:system.user.create');
            //编辑
            Route::get('user/edit', 'Admin\UserController@edit')->name('admin.user.edit')->middleware('permission:system.user.edit');
            Route::post('user/update', 'Admin\UserController@update')->name('admin.user.update')->middleware('permission:system.user.edit');
            //删除
            Route::delete('user/destroy', 'Admin\UserController@destroy')->name('admin.user.destroy')->middleware('permission:system.user.destroy');
            //分配角色
            Route::get('user/role', 'Admin\UserController@role')->name('admin.user.role')->middleware('permission:system.user.role');
            Route::post('user/assignRole', 'Admin\UserController@assignRole')->name('admin.user.assignRole')->middleware('permission:system.user.role');
        });
        //角色管理
        Route::group(['middleware' => 'permission:system.role'], function () {
            Route::get('role', 'Admin\RoleController@index')->name('admin.role');
            Route::get('role/data', 'Admin\RoleController@data')->name('admin.role.data');
            //添加
            Route::get('role/create', 'Admin\RoleController@create')->name('admin.role.create')->middleware('permission:system.role.create');
            Route::post('role/store', 'Admin\RoleController@store')->name('admin.role.store')->middleware('permission:system.role.create');
            //编辑
            Route::get('role/edit', 'Admin\RoleController@edit')->name('admin.role.edit')->middleware('permission:system.role.edit');
            Route::post('role/update', 'Admin\RoleController@update')->name('admin.role.update')->middleware('permission:system.role.edit');
            //删除
            Route::delete('role/destroy', 'Admin\RoleController@destroy')->name('admin.role.destroy')->middleware('permission:system.role.destroy');
            //分配权限
            Route::get('role/permission', 'Admin\RoleController@permission')->name('admin.role.permission')->middleware('permission:system.role.permission');
            Route::post('role/assignPermission', 'Admin\RoleController@assignPermission')->name('admin.role.assignPermission')->middleware('permission:system.role.permission');
        });
        //权限管理
        Route::group(['middleware' => 'permission:system.permission'], function () {
            Route::get('permission', 'Admin\PermissionController@index')->name('admin.permission');
            Route::get('permission/data', 'Admin\PermissionController@data')->name('admin.permission.data');
            //添加
            Route::get('permission/create', 'Admin\PermissionController@create')->name('admin.permission.create')->middleware('permission:system.permission.create');
            Route::post('permission/store', 'Admin\PermissionController@store')->name('admin.permission.store')->middleware('permission:system.permission.create');
            //编辑
            Route::get('permission/edit', 'Admin\PermissionController@edit')->name('admin.permission.edit')->middleware('permission:system.permission.edit');
            Route::post('permission/update', 'Admin\PermissionController@update')->name('admin.permission.update')->middleware('permission:system.permission.edit');
            //删除
            Route::delete('permission/destroy', 'Admin\PermissionController@destroy')->name('admin.permission.destroy')->middleware('permission:system.permission.destroy');
        });
    });
});
