@extends('admin.base')

@section('content')
<div class="layui-card">
    
    <div class="layui-card-header layuiadmin-card-header-auto">
        <!-- form -->
        <div class="layui-form">

            <div class="layui-input-inline">
                <input type="text" name="id" id="id" placeholder="请输入用户ID" class="layui-input">
            </div>&emsp;

            <div class="layui-input-inline">
                <input type="text" name="mobile" id="mobile" placeholder="请输入用户手机号" class="layui-input">
            </div>&emsp;

            <div class="layui-input-inline" style="width:182px;">
                <select name="status" id="status">
                    <option value="">请选择状态</option>
                    <option value="0" @if(isset(request()->status) && request()->status==0) selected @endif>待审核</option>
                    <option value="1" @if(isset(request()->status) && request()->status==1) selected @endif>已通过</option>
                    <option value="-1" @if(isset(request()->status) && request()->status==-1) selected @endif>已驳回</option>
                </select>
            </div>&emsp;

            <div class="layui-inline" id="datesection">
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="start_time" id="start_time" class="layui-input" placeholder="开始日期">
                </div>
                -
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="end_time" id="end_time" class="layui-input" placeholder="结束日期">
                </div>
            </div>
            <button class="layui-btn layuiadmin-btn-useradmin" id="searchBtn" lay-submit lay-filter="LAY-user-front-search">
                <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
            </button>
        </div>
    </div>

    <div class="layui-card-body">
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 头像 -->
        <script type="text/html" id="templet_thumb">
            <img class="pimg" src="@{{d.userinfo.avatar}}" style="width: 40px;height:40px;border-radius: 20px;object-fit: contain;">
        </script>
        <!-- 收款二维码 -->
        <script type="text/html" id="templet_qrcode">
            @{{#  if(d.qrcode){ }}
            <img class="pimg" src="@{{d.qrcode}}" style="width: 40px;height:60px;object-fit: contain;">
            @{{#  } }}
        </script>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
                @can('users.withdraw.edit')
                @{{#  if(d.status==0){ }}
                <a class="layui-btn layui-btn-xs layui-btn-normal" lay-event="edit">审核</a>
                @{{#  } }}
                @endcan
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('users.withdraw')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-130',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{{ route('users.withdraw.data',request()->all()) }}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'id',title: 'ID',sort: true,align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.id+'</b></i>';}},
                    {field: 'mobile',title: '用户手机号',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.userinfo.mobile+'</b></i>';}},
                    {field: 'nickName',title: '昵称',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.userinfo.nickName+'</b></i>';}},
                    {field: 'withdraw_fee',title: '提现金额 ￥',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.withdraw_fee+'</b></i>';}},
                    {field: 'handling_fee',title: '手续费 ￥',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.handling_fee+'</b></i>';}},
                    {field: 'pay_fee',title: '打款金额 ￥',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.pay_fee+'</b></i>';}},
                    {field: 'qrcode',title: '收款二维码',align: 'center',minWidth: 100,templet: "#templet_qrcode"},
                    {field: 'created_at',minWidth: 200,title: '申请时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}},
                    {field: 'status',title: '提现状态',align: 'center',minWidth: 150,templet: function(d){
                        if(d.status==0){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal  layui-btn-radius">待审核</button>';
                        }
                        if(d.status==1){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-radius">已通过</button>';
                        }
                        if(d.status==-1){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-danger layui-btn-radius">已驳回</button>';
                        }
                    }},
                    {title: '操作',align: 'center',toolbar: '#options',minWidth: 150,fixed: 'right'}
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'edit') {
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '80%'],
                    content: "{{route('users.withdraw.edit')}}?id="+data.id
                });
            }
        });

        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    id: $("#id").val(),
                    mobile: $("#mobile").val(),
                    status: $("#status").val(),
                    start_time: $("#start_time").val(),
                    end_time: $("#end_time").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
        })
    })
</script>
@endcan
@endsection