@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header  layuiadmin-card-header-auto">
        <h2>添加/编辑用户</h2>
    </div>
    <div class="layui-card-body">
        <form class="layui-form" method="post">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$model->id}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">昵称</label>
                <div class="layui-input-block">
                    <input type="text" value="{{$model->nickName ?? '' }}" class="layui-input" disabled>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">手机号</label>
                <div class="layui-input-block">
                    <input type="text" value="{{$model->mobile??''}}" class="layui-input" disabled>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">头像</label>
                <div class="layui-input-block">
                    <img src="{{$model->avatar??''}}" style="width: 100px;height:100px;object-fit: contain;"/>
                </div>
            </div>

            <div class="layui-form-item">
                <label class="layui-form-label">用户状态</label>
                <div class="layui-input-block">
                    <input type="checkbox" name="status" lay-skin="switch" lay-filter="switchTest" lay-text="启用|禁用" @if($model->status ==1) checked @endif>
                    <div class="layui-unselect layui-form-switch layui-form-onswitch" lay-skin="_switch">
                    </div>
                </div>
            </div>


            <div class="layui-form-item">
                <label class="layui-form-label">是否主播</label>
                <div class="layui-input-block">
                    <input type="checkbox" name="level" lay-skin="switch" lay-filter="switchTest" lay-text="启用|禁用" @if($model->level ==1) checked @endif>
                    <div class="layui-unselect layui-form-switch layui-form-onswitch" lay-skin="_switch">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    layui.use(['element', 'form'], function() {
        var form = layui.form
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('users.users.store')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layui.table.reload('dataTable');
                            parent.layer.close(index);
                        });
                    } else {
                        layer.msg(res.msg,{icon:2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    layer.msg('服务器错误',{icon:2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });
    })
</script>
@endsection