@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header layuiadmin-card-header-auto">
        <!-- form -->
        <div class="layui-form">

            <div class="layui-input-inline">
                <input type="text" name="id" id="id" value="{{request()->id}}" placeholder="请输入用户ID" class="layui-input">
            </div>&emsp;

            <div class="layui-input-inline">
                <input type="text" name="mobile" id="mobile" placeholder="请输入用户手机号" class="layui-input">
            </div>&emsp;

            <div class="layui-input-inline">
                <input type="text" name="order_sn" id="order_sn"  placeholder="请输入订单号" class="layui-input">
            </div>&emsp;

            <div class="layui-input-inline">
                <input type="text" name="box_id" id="box_id"  placeholder="请输入盒子ID" class="layui-input">
            </div>&emsp;

            <div class="layui-inline" id="datesection">
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="start_time" id="start_time" class="layui-input" placeholder="开始日期">
                </div>
                -
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="end_time" id="end_time" class="layui-input" placeholder="结束日期">
                </div>
            </div>
            <button class="layui-btn layuiadmin-btn-useradmin" id="searchBtn" lay-submit lay-filter="LAY-user-front-search">
                <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
            </button>
        </div>
    </div>

    <div class="layui-card-body">
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
                <a class="layui-btn layui-btn-xs" lay-event="award">查看奖品</a>
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('stats.box')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-130',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{!! route('stats.box.data',['id'=>request()->id]) !!}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'order_sn',title: '订单号',align: 'center',minWidth: 180},
                    {field: 'nickName',title: '用户信息',minWidth: 250,templet:function(d){
                        return '<div style="display:flex;align-items:center"><img class="pimg" src='+d.userinfo.avatar+' style="width: 40px;height:40px;border-radius: 20px;vertical-align: middle;">'+
                               '<div style="margin-left:10px;"><span style="font-size: 50%;">昵称：'+d.userinfo.nickName+'</span><br>'+
                               '<span style="font-size: 50%;">ID：'+d.user_id+'</span><br></div></div>';
                    }},
                    
                    {field: 'nickName',title: '盒子信息',minWidth: 250,templet:function(d){
                        return '<div style="display:flex;align-items:center"><img class="pimg" src='+d.data['thumb']+' style="width: 40px;height:40px;border-radius: 20px;vertical-align: middle;">'+
                               '<div style="margin-left:10px;"><span style="font-size: 50%;">标题：'+d.data['title']+'</span><br>'+
                               '<span style="font-size: 50%;">购买发数：'+d.data['num']+'</span><br></div></div>';
                    }},
                    {field: 'total_money',title: '总金额',align: 'center',minWidth: 100},
                    {field: 'money_dis',title: '余额抵扣',align: 'center',minWidth: 100},
                    {field: 'pay_money',title: '实际支付金额',align: 'center',minWidth: 100},
                    {field: 'pay_type',title: '支付类型',align: 'center',minWidth: 100,templet: function(d){
                        if(d.pay_type==1){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal  layui-btn-radius">购物金支付</button>';
                        }
                        if(d.pay_type==2){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal  layui-btn-radius">余额支付</button>';
                        }
                        if(d.pay_type==3){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal layui-btn-radius">微信支付</button>';
                        }
                    }},
                    {field: 'created_at',width: 180,title: '开盒时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}}, 
                    {title: '操作',align: 'center',toolbar: '#options',minWidth: 130,fixed: 'right'}
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'award') {
               layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['90%', '90%'],
                    content: "{{route('stats.box.award')}}?id="+data.id
                });
            }
        });

        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    id: $("#id").val(),
                    mobile: $("#mobile").val(),
                    order_sn: $("#order_sn").val(),
                    box_id: $("#box_id").val(),
                    start_time: $("#start_time").val(),
                    end_time: $("#end_time").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
        })
    })
</script>
@endcan
@endsection