@extends('admin.base')

@section('content')
<div class="layui-card">

    <div class="layui-card-body">
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 盒子图 -->
        <script type="text/html" id="templet_goods_thumb">
            <img class="pimg" src="@{{d.thumb}}" style="width: 40px;height:40px;border-radius: 20px;object-fit: contain;">
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
                <a class="layui-btn layui-btn-xs" lay-event="award">查看奖品</a>
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('stats.box')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-50',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{!! route('stats.box.award.data',['id'=>request()->id]) !!}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'goods_id',title: '奖品ID',align: 'center',minWidth: 100},
                    {field: 'title',title: '奖品名称',align: 'center',minWidth: 100},
                    {field: 'thumb',title: '奖品图',align: 'center',minWidth: 100,templet: "#templet_goods_thumb"},
                    {field: 'mark',title: '奖品等级',align: 'center',minWidth: 100,templet:function(d){
                        return d.markinfo.title
                    }},
                    {field: 'status',title: '状态',align: 'center',minWidth: 150,templet: function(d){
                         if(d.status==0){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal  layui-btn-radius">待提货</button>';
                        }
                        if(d.status==1){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal  layui-btn-radius">待发货</button>';
                        }
                        if(d.status==2){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal  layui-btn-radius">待收货</button>';
                        }
                        if(d.status==3){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal layui-btn-radius">待评价</button>';
                        }
                        if(d.status==4){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal layui-btn-radius">已完成</button>';
                        }
                        if(d.status==5){
                            return '<button type="button" class="layui-btn layui-btn-xs layui-btn-normal layui-btn-radius">已退货</button>';
                        }
                    }},
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'edit') {
               
            }
        });

        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    id: $("#id").val(),
                    order_sn: $("#order_sn").val(),
                    start_time: $("#start_time").val(),
                    end_time: $("#end_time").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
        })
    })
</script>
@endcan
@endsection