@extends('admin.base')

@section('content')
<div class="layui-card">

    <div class="layui-card-body">
        <!-- 表格 -->
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 盒子图 -->
        <script type="text/html" id="templet_thumb">
            <img class="pimg" src="@{{d.thumb}}" style="width: 90px;height:45px;object-fit: contain;">
        </script>
        <!-- 状态 -->
        <script type="text/html" id="templet_switch">
            <!-- 这里的 checked 的状态只是演示 -->
            <input id="checkShow" type="checkbox" name="Show" value="@{{d.id}}" lay-skin="switch" lay-text="启用|禁用" @{{ d.status == "1" ? "checked" : "" }} lay-filter="ShowDemo">
        </script>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
                @can('box.draw.store')
                <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
                @endcan
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('box.draw')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-50',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{{ route('box.draw.data',['type'=>request()->type]) }}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'id',title: 'ID',sort: true,align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.id+'</b></i>';}},
                    {field: 'title',title: '赏名称',align: 'center',minWidth: 200,templet: function(d){ return '<i><b>'+d.title+'</b></i>';}},
                    {field: 'times',title: '抽取发数',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.times+'</b></i>';}},
                    {field: 'sort',title: '权重（从小到大）',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.sort+'</b></i>';}},
                    {field: 'status',title: '状态',align: 'center',minWidth: 150,templet: "#templet_switch"},
                    {title: '操作',align: 'center',toolbar: '#options',minWidth: 200,fixed: 'right'}
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,      // data 数据
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'del') {
                // 单挑删除
            } else if (layEvent === 'edit') {
                // 编辑
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['40%', '40%'],
                    content: "{{route('box.draw.store')}}?id="+data.id
                });
            }
        });

        //监听状态操作
        form.on('switch(ShowDemo)', function (data) {
            var swithcData = data;
            var id = data.value;// 获取要修改的ID
            $.ajax({
                type: 'POST',
                url: "{{route('box.draw.show')}}",
                data: {"id": id,},
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1});
                    } else {
                        layer.msg(res.msg, {icon: 2});
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                }
            });
        });
    })
</script>
@endcan
@endsection