@extends('admin.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <h2>添加/编辑分类</h2>
        </div>
        <div class="layui-card-body">
            <form class="layui-form" method="post">
                {{csrf_field()}}
                <input type="hidden" name="id" value="{{$model->id}}">

                <div class="layui-form-item">
                    <label for="" class="layui-form-label">分类名称</label>
                    <div class="layui-input-block">
                        <input type="text" name="title" value="{{$model->title??''}}" class="layui-input">
                    </div>
                </div>

                <div class="layui-form-item">
                    <label for="" class="layui-form-label">分类权重</label>
                    <div class="layui-input-block">
                        <input type="text" name="sort" value="{{$model->sort??'0'}}" class="layui-input">
                    </div>
                </div>

                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('script')
<script>
    layui.use(['element', 'form','util'], function() {
        var form = layui.form
        var util = layui.util
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('complain.type.store')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layer.close(index);
                            window.parent.location.reload();
                        });
                    } else {
                        layer.msg(res.msg, {icon: 2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });
    })
</script>
@endsection