@extends('admin.base')

@section('content')
<div class="layui-card">

    <div class="layui-card-header layuiadmin-card-header-auto">
        <!-- form -->
        <div class="layui-form">

            <div class="layui-input-inline">
                <input type="text" name="title" id="title" placeholder="请输入标题" class="layui-input">
            </div>&emsp;

            <div class="layui-input-inline" style="width:182px;">
                <select name="city" id="status">
                    <option value="">请选择状态</option>
                    <option value="1">启用</option>
                    <option value="2">禁用</option>
                </select>
            </div>&emsp;
            <button class="layui-btn layuiadmin-btn-useradmin" id="searchBtn" lay-submit lay-filter="LAY-user-front-search">
                <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
            </button>
        </div>
        <!-- form -->
    </div>

    <div class="layui-card-body">
        <!-- 表格 -->
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 盒子图 -->
        <script type="text/html" id="templet_thumb">
            <img class="pimg" src="@{{d.thumb}}" style="width: 45px;height:45px;object-fit: contain;">
        </script>
        <!-- 状态 -->
        <script type="text/html" id="templet_switch">
            <!-- 这里的 checked 的状态只是演示 -->
            <input id="checkShow" type="checkbox" name="Show" value="@{{d.id}}" lay-skin="switch" lay-text="启用|禁用" @{{ d.status == "1" ? "checked" : "" }} lay-filter="ShowDemo">
        </script>
          <!-- 邀请开关 -->
        <script type="text/html" id="invite_templet_switch">
            <!-- 这里的 checked 的状态只是演示 -->
            <input id="checkShow2" type="checkbox" name="Show" value="@{{d.id}}" lay-skin="switch" lay-text="受邀|全部" @{{ d.invite_switch == "1" ? "checked" : "" }} lay-filter="ShowDemo2">
        </script>
        <!-- 邀请开关 -->
        <script type="text/html" id="animation">
            <!-- 这里的 checked 的状态只是演示 -->
            <input id="checkShow3" type="checkbox" name="Show" value="@{{d.id}}" lay-skin="switch" lay-text="滚动|金蛋" @{{ d.animation == "1" ? "checked" : "" }} lay-filter="ShowDemo3">
        </script>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                @can('box.box.store')
                <div class="layui-inline" lay-event="add"><i class="layui-icon layui-icon-add-1"></i></div>
                @endcan
                @can('box.box.del')
                <div class="layui-inline" lay-event="delete"><i class="layui-icon layui-icon-delete"></i></div>
                @endcan
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
                @can('box.award')
                <a class="layui-btn layui-btn-normal layui-btn-xs" lay-event="award">奖品</a>
                @endcan
                @can('box.log')
                <a class="layui-btn layui-btn-warm layui-btn-xs" lay-event="log">中奖记录</a>
                @endcan
                @can('box.box.store')
                <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
                @endcan
                @can('box.box.del')
                <a class="layui-btn layui-btn-danger layui-btn-xs " lay-event="del">删除</a>
                @endcan
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('box.box')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-130',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{{ route('box.box.data',['type'=>request()->type]) }}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true},
                    {field: 'id',title: 'ID',sort: true,align: 'center',width: 100},
                    {field: 'title',title: '盒子标题',align: 'center',width: 300,templet: function(d){ return '<i><b>'+d.title+'</b></i>';}},
                    {field: 'animation',title: '动画选择：滚动/金蛋',align: 'center',width: 150,templet: "#animation"},
                    {field: 'thumb',title: '盒子奖品图',align: 'center',width: 150,templet: "#templet_thumb"},
                    {field: 'price',title: '价格￥',align: 'center',width: 150},
                    {field: 'send_coin',title: '赠送积分',align: 'center',width: 100,templet: function(d){ return '<i><b>'+d.send_coin+'</b></i>';}},
                    {field: 'send_money',title: '赠送现金',align: 'center',width: 100,templet: function(d){ return '<i><b>'+d.send_money+'</b></i>';}},
                    {field: 'sales',title: '已开箱数',align: 'center',width: 100},
                    {field: 'sort',title: '权重值【大到小】',align: 'center',width: 150},
                    {field: 'created_at',width: 200,title: '创建时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}},
                    // {field: 'status',title: '启用/禁用',align: 'center',width: 150,templet: "#templet_switch"},
                      {field: 'status',title: '启用/禁用',align: 'center',width: 150,templet: "#templet_switch"},
                    {field: 'invite_switch',title: '受邀/全部',align: 'center',width: 150,templet: "#invite_templet_switch"},

                    {title: '操作',align: 'center',toolbar: '#options',minWidth: 200,fixed: 'right'}
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    layer.open({
                        type: 2,
                        shade: 0.8,
                        area: ['60%', '90%'],
                        content: "{{route('box.box.store',['type'=>request()->type])}}"
                    });
                    break;
                // 批量删除
                case 'delete':
                    var ids = [];
                    var hasCheck = table.checkStatus('dataTable');
                    var hasCheckData = hasCheck.data;
                    if (hasCheckData.length > 0) {
                        $.each(hasCheckData, function(index, element) {
                            ids.push(element.id)
                        })
                    }
                    if (ids.length > 0) {
                        layer.confirm('确认删除吗？', function(index) {
                            layer.close(index);
                            var load = layer.load();
                            $.post("{{ route('box.box.del') }}", {
                                _method: 'delete',
                                ids: ids
                            }, function(res) {
                                // 删除询问按钮
                                layer.close(load);
                                if (res.code == 200) {
                                    // 关闭当前页 刷新父页面
                                    layer.msg(res.msg, { icon: 1, time:500}, function() {
                                        table.reload('dataTable');
                                    })
                                } else {
                                    layer.msg(res.msg, {icon: 2})
                                }
                            });
                        })
                    } else {
                        layer.msg('请选择删除项', {icon: 2})
                    }
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,      // data 数据
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'del') {
                // 单挑删除
                layer.confirm('确认删除吗？', function(index) {
                    layer.close(index);
                    var load = layer.load();
                    $.post("{{ route('box.box.del') }}", {
                        _method: 'delete',
                        ids: [data.id]
                    }, function(res) {
                        // 删除询问按钮
                        layer.close(load);
                        if (res.code == '200') {
                            // 弹窗并删除行
                            layer.msg(res.msg , { icon: 1, time:500}, function() {
                                obj.del();
                            })
                        } else {
                            // 失败弹窗
                            layer.msg(res.msg, {icon: 2})
                        }
                    });
                });
            } else if (layEvent === 'edit') {
                // 编辑
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '90%'],
                    content: "{{route('box.box.store')}}?id="+data.id
                });
            } else if (layEvent === 'award') {
                // 奖品
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['95%', '95%'],
                    content: "{{route('box.award')}}?box_id="+data.id
                });
            } else if (layEvent === 'log') {
                // 中奖记录
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['90%', '95%'],
                    content: "{{route('box.log')}}?box_id="+data.id
                });
            }
        });

        //监听状态操作
        form.on('switch(ShowDemo)', function (data) {
            var swithcData = data;
            var id = data.value;// 获取要修改的ID
            $.ajax({
                type: 'POST',
                url: "{{route('box.box.show')}}",
                data: {"id": id,},
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1});
                    } else {
                        layer.msg(res.msg, {icon: 2});
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                }
            });
        });
          //监听状态操作2
        form.on('switch(ShowDemo2)', function (data) {
            var swithcData = data;
            var id = data.value;// 获取要修改的ID
            $.ajax({
                type: 'POST',
                url: "{{route('box.box.show2')}}",
                data: {"id": id,},
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1});
                    } else {
                        layer.msg(res.msg, {icon: 2});
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                }
            });
        });

        //监听状态操作2
        form.on('switch(ShowDemo3)', function (data) {
            var swithcData = data;
            var id = data.value;// 获取要修改的ID
            $.ajax({
                type: 'POST',
                url: "{{route('box.box.show3')}}",
                data: {"id": id,},
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1});
                    } else {
                        layer.msg(res.msg, {icon: 2});
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                }
            });
        });


        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    title: $("#title").val(),
                    cat_id: $("#cat_id").val(),
                    status: $("#status").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
        })
    })
</script>
@endcan
@endsection
