@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header  layuiadmin-card-header-auto">
        <h2>添加/编辑盒子</h2>
    </div>
    <div class="layui-card-body">
        <form class="layui-form" method="post">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$model->id}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">盒子图</label>
                <div class="layui-input-block">
                    <div class="upload_thumb" id="thumb" name="thumb" src="{{$model->thumb}}"></div>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">标题</label>
                <div class="layui-input-block">
                    <input type="text" name="title" value="{{$model->title}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">价格</label>
                <div class="layui-input-block">
                    <input type="number" name="price" value="{{$model->price??''}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">邀请好友购买赠送积分</label>
                <div class="layui-input-block">
                    <input type="number" name="send_coin" value="{{$model->send_coin??'0'}}" class="layui-input">
                </div>
            </div>
            
            <div class="layui-form-item">
                <label for="" class="layui-form-label">邀请好友购买赠送现金</label>
                <div class="layui-input-block">
                    <input type="number" name="send_money" value="{{$model->send_money??'0'}}" class="layui-input">
                </div>
            </div>

            @foreach($markList as $k=>$v)
            <div class="layui-form-item">
                <label for="" class="layui-form-label">{{$v->title}}比例</label>
                <div class="layui-input-block">
                    <input type="number" name="mark_rate[{{$v->id}}]" value="{{$model->mark_rate[$v->id]??'0.00'}}" class="layui-input">
                </div>
            </div>
            @endforeach

            <div class="layui-form-item">
                <label for="" class="layui-form-label">排序权重</label>
                <div class="layui-input-block">
                    <input type="number" name="sort" value="{{$model->sort??'0'}}" class="layui-input">
                </div>
            </div>

            @if($model->id)
            <div class="layui-form-item">
                <label class="layui-form-label">启用/禁用</label>
                <div class="layui-input-block">
                    <input type="checkbox" name="status" lay-skin="switch" lay-filter="switchTest" lay-text="启用|禁用" @if($model->status ==1) checked @endif>
                    <div class="layui-unselect layui-form-switch layui-form-onswitch" lay-skin="_switch">
                    </div>
                </div>
            </div>
            @endif

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    layui.use(['element', 'form','util'], function() {
        var form = layui.form
        var util = layui.util
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('box.box.store')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layui.table.reload('dataTable');
                            parent.layer.close(index);
                        });
                    } else {
                        layer.msg(res.msg, {icon: 2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });
    })
</script>
@endsection