@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header  layuiadmin-card-header-auto">
        <h2>添加/编辑盒子赏品</h2>
    </div>
    <div class="layui-card-body">
        <form class="layui-form" method="post">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$model->id}}">
            <input type="hidden" name="box_id" value="{{$model->id?$model->box_id:request()->box_id}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">赏品图</label>
                <div class="layui-input-block">
                    <div class="upload_thumb" id="thumb" name="thumb" src="{{$model->thumb}}"></div>
                </div>
            </div>

             <div class="layui-form-item">
                 <label for="" class="layui-form-label">赏类型</label>
                 <div class="layui-input-block">
                     <select name="mark_id">
                        <option value="">--请选择--</option>
                        @foreach($mark as $v)
                        <option value="{{$v->id}}" {{ $model->id && $v->id == $model->mark_id ? 'selected' : '' }}>{{$v->title}}</option>
                        @endforeach
                     </select>
                 </div>
             </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">标题</label>
                <div class="layui-input-block">
                    <input type="text" name="title" value="{{$model->title}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">价格(￥)</label>
                <div class="layui-input-block">
                    <input type="number" name="price" value="{{$model->price??''}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">展示概率</label>
                <div class="layui-input-block">
                    <input type="number" name="show_rate" value="{{$model->show_rate??''}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">真实概率</label>
                <div class="layui-input-block">
                    <input type="number" name="real_rate" value="{{$model->real_rate??''}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">测试员中奖概率</label>
                <div class="layui-input-block">
                    <input type="number" name="anchor_rate" value="{{$model->anchor_rate??''}}" class="layui-input">
                </div>
            </div>
            <div class="layui-form-item">
                <label for="" class="layui-form-label">商品回收比例</label>
                <div class="layui-input-block">
                    <input type="number" name="dissolve_rate" value="{{$model->dissolve_rate??''}}" class="layui-input">
                </div>
            </div>
            <div class="layui-form-item">
                <label for="" class="layui-form-label">详情</label>
                <div class="layui-input-block">
                    <!-- 百度编辑器的容器 -->
                    <script id="ueditor" name="editor" type="text/plain">{!!$model->editor!!}</script>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    layui.use(['element', 'form','util'], function() {
        var form = layui.form
        var util = layui.util
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('box.award.store')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layui.table.reload('dataTable');
                            parent.layer.close(index);
                        });
                    } else {
                        layer.msg(res.msg, {icon: 2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });
    })
</script>
@endsection