@extends('admin.base')

@section('content')
<div class="layui-card">

    <div class="layui-card-header layuiadmin-card-header-auto">
        <!-- form -->
        <div class="layui-form">

            <div class="layui-input-inline">
                <input type="text" name="username" id="username" placeholder="请输入用户名" class="layui-input">
            </div>&emsp;

            <button class="layui-btn layuiadmin-btn-useradmin" id="searchBtn" lay-submit lay-filter="LAY-user-front-search">
                <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
            </button>
        </div>
    </div>

    <div class="layui-card-body">
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                @can('system.user.create')
                <div class="layui-inline" lay-event="add"><i class="layui-icon layui-icon-add-1"></i></div>
                @endcan
                @can('system.user.destroy')
                <div class="layui-inline" lay-event="delete"><i class="layui-icon layui-icon-delete"></i></div>
                @endcan
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
                @can('system.user.edit')
                <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
                @endcan
                @can('system.user.role')
                <a class="layui-btn layui-btn-xs" lay-event="role">角色</a>
                @endcan
                @can('system.user.destroy')
                <a class="layui-btn layui-btn-danger layui-btn-xs " lay-event="del">删除</a>
                @endcan
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('system.user')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-130',
            toolbar: '#toolbarDemo',
            url: "{{ route('admin.user.data') }}",
            page: true, //开启分页
            cols: [[
                    {checkbox: true,}, 
                    {field: 'id',title: 'ID',sort: true,align: 'center',minWidth: 100}, 
                    {field: 'username',title: '用户名',align: 'center',minWidth: 150}, 
                    {field: 'nickname',title: '昵称',align: 'center',minWidth: 150}, 
                    {field: 'email',title: '邮箱',align: 'center',minWidth: 150}, 
                    {field: 'phone',title: '电话',align: 'center',minWidth: 150}, 
                    {field: 'created_at',title: '创建时间',align: 'center',minWidth: 200}, 
                    {field: 'updated_at',title: '更新时间',align: 'center',minWidth: 200},
                    {title: '操作',align: 'center',toolbar: '#options',minWidth: 150,fixed: 'right'}
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    layer.open({
                        type: 2,
                        shade: 0.8,
                        area: ['60%', '90%'],
                        content: "{{route('admin.user.create')}}"
                    });
                    break;
                // 批量删除
                case 'delete':
                    var ids = [];
                    var hasCheck = table.checkStatus('dataTable');
                    var hasCheckData = hasCheck.data;
                    if (hasCheckData.length > 0) {
                        $.each(hasCheckData, function(index, element) {
                            ids.push(element.id)
                        })
                    }
                    if (ids.length > 0) {
                        layer.confirm('确认删除吗？', function(index) {
                            layer.close(index);
                            var load = layer.load();
                            $.post("{{ route('admin.user.destroy') }}", {
                                _method: 'delete',
                                ids: ids
                            }, function(res) {
                                // 删除询问按钮
                                layer.close(load);
                                if (res.code == 200) {
                                    // 关闭当前页 刷新父页面
                                    layer.msg(res.msg, { icon: 1, time:500}, function() {
                                        table.reload('dataTable');
                                    })
                                } else {
                                    layer.msg(res.msg, {icon: 2})
                                }
                            });
                        })
                    } else {
                        layer.msg('请选择删除项', {icon: 2})
                    }
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data, //获得当前行数据
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'del') {
                layer.confirm('确认删除吗？', function(index) {
                    layer.close(index);
                    var load = layer.load();
                    $.post("{{ route('admin.user.destroy') }}", {
                        _method: 'delete',
                        ids: [data.id]
                    }, function(res) {
                        // 删除询问按钮
                        layer.close(load);
                        if (res.code == '200') {
                            // 弹窗并删除行
                            layer.msg(res.msg , { icon: 1, time:500}, function() {
                                obj.del();
                            })
                        } else {
                            // 失败弹窗
                            layer.msg(res.msg, {icon: 2})
                        }
                    });
                });
            } else if (layEvent === 'edit') {
                // 编辑
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '90%'],
                    content: "{{route('admin.user.edit')}}?id="+data.id
                });
            } else if (layEvent === 'role') {
                // 分配角色
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '90%'],
                    content: "{{route('admin.user.role')}}?id="+data.id
                });
            }
        });

        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    username: $("#username").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
        })
    })
</script>
@endcan
@endsection