@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header layuiadmin-card-header-auto">
        <h2>分配权限</h2>
    </div>
    <div class="layui-card-body">
        <form method="post" class="layui-form">
            {{csrf_field()}}

            <input type="hidden" name="id" value="{{$role->id}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">名称</label>
                <div class="layui-word-aux layui-form-mid">{{ $role->name }}</div>
            </div>
            <div class="layui-form-item">
                <label for="" class="layui-form-label">显示名称</label>
                <div class="layui-word-aux layui-form-mid">{{ $role->display_name }}</div>
            </div>
            <div class="layui-form-item">
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">权限</label>
                    <div class="layui-input-block">
                        <table class="layui-table layui-input-block">
                            <tbody>
                                @foreach($permissions as $p1)
                                <tr>
                                    <td>
                                        <input type="checkbox" lay-filter="checkall" name="permissions[]" value="{{$p1->id}}" title="{{$p1->display_name}}" lay-skin="primary" {{$p1->own??''}}>
                                    </td>
                                    <td>
                                        <div class="layui-input-block">
                                            <ul>
                                                @foreach($p1->childs as $p2)
                                                <li>
                                                    <input name="permissions[]" lay-skin="primary" type="checkbox" title="{{$p2->display_name}}" value="{{$p2->id}}" lay-skin="primary" {{$p2->own??''}}>
                                                    @foreach($p2->childs as $p3)
                                                    <input name="permissions[]" lay-skin="primary" type="checkbox" title="{{$p3->display_name}}" value="{{$p3->id}}" lay-skin="primary" {{$p3->own??''}}>
                                                    @endforeach
                                                </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>

                <div class="layui-form-item">
                    <label for="" class="layui-form-label"></label>
                    <div style="float:right">
                        <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                    </div>
                </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script type="text/javascript">
    layui.use(['layer', 'table', 'form'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;

        form.on('checkbox(checkall)', function(data) {
            var that = data.elem;
            if (data.elem.checked) {
                $(that).parent().parent().find('input[type="checkbox"]').prop('checked', true);
            } else {
                $(that).parent().parent().find('input[type="checkbox"]').prop('checked', false);
            }
            form.render('checkbox');
        });
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('admin.role.assignPermission')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layui.table.reload('dataTable');
                            parent.layer.close(index);
                        });
                    } else {
                        layer.msg(res.msg, {icon: 2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });
    })
</script>
@endsection