@extends('admin.base')

@section('content')
<div class="layui-card" style="min-height:890px;">
    <div class="layui-card-header layuiadmin-card-header-auto">
        <div class="layui-btn-group">
            @can('system.configuration.create')
            <a class="layui-btn layui-btn-sm" href="#" id="add">添 加</a>
            @endcan
        </div>
    </div>
    <div class="layui-card-body">
        <div class="layui-tab layui-tab-brief" lay-filter="docDemoTabBrief">
            <ul class="layui-tab-title">
                @foreach($groups as $group)
                <li @if($loop->index==0) class="layui-this" @endif >{{$group->name}}</li>
                @endforeach
            </ul>
            <div class="layui-tab-content">
                @foreach($groups as $group)
                <div class="layui-tab-item @if($loop->index==0) layui-show @endif">
                    <form class="layui-form">
                        @foreach($group->configurations as $configuration)
                        <div class="layui-form-item">
                            <label for="" class="layui-form-label" style="width: 120px">{{$configuration->label}}</label>
                            <div class="layui-input-inline" style="min-width: 600px">
                                @switch($configuration->type)
                                @case('input')
                                <!-- 文本框 -->
                                <input type="input" class="layui-input" name="{{$configuration->key}}" value="{{$configuration->val}}">
                                @break
                                @case('textarea')
                                <textarea name="{{$configuration->key}}" class="layui-textarea">{{$configuration->val}}</textarea>
                                @break
                                @case('select')
                                <!-- 下拉 -->
                                <select name="{{$configuration->key}}">
                                    @php
                                    $content = json_decode($configuration->content,true);
                                    @endphp
                                    @if($content)
                                    @foreach($content as $k=>$v)
                                    <option value="{{$key}}" @if($key==$configuration->val) selected @endif >{{$val}}</option>
                                    @endforeach
                                    @endif
                                </select>
                                @break
                                @case('radio')
                                <!-- 单选框 -->
                                @php
                                $content = json_decode($configuration->content,true);
                                @endphp
                                @if($content)
                                @foreach($content as $k=>$v)
                                <input type="radio" name="{{$configuration->key}}" value="{{$v}}" @if($v==$configuration->val) checked @endif title="{{$k}}">
                                @endforeach
                                @endif
                                @break
                                @case('image')
                                <!-- 图片 -->
                                <div class="layui-upload">
                                    <div class="layui-upload-list">
                                        <div class="upload_thumb" id="{{$configuration->key}}" name="{{$configuration->key}}" src="{{$configuration->val}}"></div>
                                    </div>
                                </div>
                                @break
                                @default
                                @break
                                @case('audio')
                                <!-- 音频 -->
                                <button type="button" class="layui-btn upload_audio" id="{{$configuration->key}}"><i class="layui-icon"></i>上传音频</button>
                                <input type="hidden" name="{{$configuration->key}}" value="{{$configuration->val}}">
                                <p>{{$configuration->val}}</p>
                                @break
                                @case('video')
                                <!-- 视频 -->
                                <button type="button" class="layui-btn upload_video" id="{{$configuration->key}}"><i class="layui-icon"></i>上传视频</button>
                                <input type="hidden" name="{{$configuration->key}}" value="{{$configuration->val}}">
                                <p>{{$configuration->val}}</p>
                                @break
                                @case('file')
                                <!-- 文件 -->
                                <button type="button" class="layui-btn upload_file" id="{{$configuration->key}}"><i class="layui-icon"></i>上传文件</button>
                                <input type="hidden" name="{{$configuration->key}}" value="{{$configuration->val}}">
                                <p>{{$configuration->val}}</p>
                                @break
                                @endswitch
                                @if($configuration->tips)
                                <div class="layui-form-mid layui-word-aux">{{$configuration->tips}}</div>
                                @endif
                            </div>
                        </div>
                        @endforeach
                        <div class="layui-form-item">
                            <div class="layui-input-block">
                                <button type="submit" class="layui-btn preservation" lay-submit lay-filter="config_group">确 认</button>
                            </div>
                        </div>
                    </form>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
@can('system.configuration')
<script>
    layui.use(['layer', 'table', 'form', 'upload', 'element'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var upload = layui.upload;

        //提交
        form.on('submit(config_group)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            var parm = data.field;
            parm['_method'] = 'put';
            var load = layer.load();
            $.post("{{route('admin.configuration.update')}}", data.field, function(res) {
                layer.close(load);
                if (res.code == 0) {
                    layer.msg(res.msg, {icon: 1})
                } else {
                    layer.msg(res.msg, {icon: 2});
                }
                // 单击之后提交按钮不可选,防止重复提交
                $('.preservation').removeClass(DISABLED);
                $('.preservation').removeAttr('disabled');
            });
            return false;
        });

        // 音频上传
        $(function() {
            var ele = '.upload_audio';
            $(ele).each(function() {
                var obj = $(this)
                var id = '#'+$(this).attr('id');
                var url = "{{Route('admin.uploads.audio')}}"
                //指定允许上传的文件类型
                upload.render({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    elem: id
                    ,url: url //此处配置你自己的上传接口即可
                    ,accept: 'file' //普通文件
                    ,before:function(){
                        layer.msg('拼命执行中...', {icon: 16,shade: [0.5, '#f5f5f5'],scrollbar: false,offset: 'auto', time:100000});
                    }
                    ,done: function(res){
                        layer.msg(res.msg);
                        if(res.code==0){
                            obj.next().next().val(res.data.src);
                            obj.next().next().next().text(res.data.src);
                        }
                    }
                });
            })
        })

        // 视频上传
        $(function() {
            var ele = '.upload_video';
            $(ele).each(function() {
                var obj = $(this)
                var id = '#'+$(this).attr('id');
                var url = "{{Route('admin.uploads.video')}}"
                //指定允许上传的文件类型
                upload.render({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    elem: id
                    ,url: url //此处配置你自己的上传接口即可
                    ,accept: 'file' //普通文件
                    ,before:function(){
                        layer.msg('拼命执行中...', {icon: 16,shade: [0.5, '#f5f5f5'],scrollbar: false,offset: 'auto', time:100000});
                    }
                    ,done: function(res){
                        layer.msg(res.msg);
                        if(res.code==0){
                            obj.next().next().val(res.data.src);
                            obj.next().next().next().text(res.data.src);
                        }
                    }
                });
            })
        })

        // 文件上传
        $(function() {
            var ele = '.upload_file';
            $(ele).each(function() {
                var obj = $(this)
                var id = '#'+$(this).attr('id');
                var url = "{{Route('admin.uploads.file')}}"
                //指定允许上传的文件类型
                upload.render({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    elem: id
                    ,url: url //此处配置你自己的上传接口即可
                    ,accept: 'file' //普通文件
                    ,before:function(){
                        layer.msg('拼命执行中...', {icon: 16,shade: [0.5, '#f5f5f5'],scrollbar: false,offset: 'auto', time:100000});
                    }
                    ,done: function(res){
                        layer.msg(res.msg);
                        if(res.code==0){
                            obj.next().next().val(res.data.src);
                            obj.next().next().next().text(res.data.src);
                        }
                    }
                });
            })
        })
    })
</script>
@endcan
<script>
    // 刷新
    $('.layui-tab-title li').click(function() {
        var picTabNum = $(this).index();
        sessionStorage.setItem("picTabNum", picTabNum);
    })
    // //刷新保持在当前页面
    $(function() {
        var getPicTabNum = sessionStorage.getItem("picTabNum");
        if (!getPicTabNum && typeof(getPicTabNum) != "undefined" && getPicTabNum != 0) {
            $('.layui-tab-title li').eq(1).addClass("layui-this").siblings().removeClass("layui-this");
            $('.layui-tab-content>div').eq(1).addClass("layui-show").siblings().removeClass("layui-show");
        } else {
            $('.layui-tab-title li').eq(getPicTabNum).addClass("layui-this").siblings().removeClass("layui-this");
            $('.layui-tab-content>div').eq(getPicTabNum).addClass("layui-show").siblings().removeClass("layui-show");
        }
    })
</script>
<script>
    // 添加配置
    $('#add').click(function(){
        // 编辑
        layer.open({
            type: 2,
            shade: 0.8,
            area: ['60%', '80%'],
            content: "{{route('admin.configuration.create')}}"
        });
    })
</script>
@endsection