<script>
    $(document).on('click', '.pimg', function() {
        var _this = $(this);
        var src = _this.attr("src");
        $("<img/>").attr("src", src).load(function() {
            var windowW = $(window).width(); //获取当前窗口宽度  
            var windowH = $(window).height(); //获取当前窗口高度  
            var realWidth = this.width; //获取图片真实宽度  
            var realHeight = this.height; //获取图片真实高度  
            var imgWidth, imgHeight;
            var scale = 0.8; //缩放尺寸，当图片真实宽度和高度大于窗口宽度和高度时进行缩放  

            //判断图片高度 
            if (realHeight > windowH * scale) {
                imgHeight = windowH * scale; //如大于窗口高度，图片高度进行缩放  
                imgWidth = imgHeight / realHeight * realWidth; //等比例缩放宽度  
                if (imgWidth > windowW * scale) { //如宽度扔大于窗口宽度  
                    imgWidth = windowW * scale; //再对宽度进行缩放  
                }
            } else if (realWidth > windowW * scale) { //如图片高度合适，判断图片宽度  
                imgWidth = windowW * scale; //如大于窗口宽度，图片宽度进行缩放  
                imgHeight = imgWidth / realWidth * realHeight; //等比例缩放高度  
            } else { //如果图片真实高度和宽度都符合要求，高宽不变  
                imgWidth = realWidth;
                imgHeight = realHeight;
            }
            var w = (windowW - imgWidth) / 2; //计算图片与窗口左边距  
            var h = (windowH - imgHeight) / 2; //计算图片与窗口上边距  
            layer.open({
                type: 1,
                title: false,
                closeBtn: 0,
                shadeClose: true, //点击阴影关闭
                area: [imgWidth + 'px', imgHeight + 'px'], //宽高
                content: "<img src=" + $(this).attr('src') + " width=" + imgWidth + " height=" + imgHeight + " />"
            });
        })

    });
</script>