[TOC]

###开发者需要掌握的111

- Linux基本命令使用、文件、进程管理、Nginx+PHP+MySQL+Redis环境配置

- PHP开发

- MySQL数据库

- Redis数据库

- <a href="https://learnku.com/docs/laravel/6.x" target="_blank">Laravel 框架</a>

- <a href="https://getcomposer.org/doc/00-intro.md" target="_blank">Composer</a>

- <a href="https://layuion.com" target="_blank">Layui 后台搭建模板</a>

- <a href="https://easywechat.com" target="_blank">EasyWeChat 微信开发SDK</a>

- <a href="https://learnku.com/docs/psr" target="_blank">PSR-2 编码风格规范(必须遵守)</a>

### 运行环境


- Linux+Nginx+PHP7.3+MySQL(5.6|5.7)+Redis(5|6)
- 禁用 proc_open 函数
- 禁用 proc_get_status 函数


## 安装教程Git版本

1. `git clone 项目链接`
2. `cd 文件夹` 
3. `composer install`，安装依赖扩展
4. `cp .env.example .env` 生成配置文件
5. `php artisan key:generate` 生成秘钥
6. `chmod -R 777 uploads` 给项目权限指定到上传文件
7. `chmod -R 777 storage` 给项目权限指定到日志文件
8. `git config core.filemode false` 设置忽略权限
9. `git config core.ignorecase false` 设置不忽略大小写问题
10. `php artisan jwt:secret` 在.env 文件下生成一个加密密钥
11. `php artisan storage:link` 配置软链接到网站根目录下（可选）

------

## 其他要求

**数据库规范**

- 明确字段是否是NOT NULL的，如果是NOT NULL，就不用设置默认值了，除非真的需要，如果是可以为NULL，请设置成NOT NULL并添加默认值。

- 表、字段 Charset 统一 `utf8mb4`，Collation 统一 `utf8mb4_unicode_ci`，存储引擎统一 `InnoDB`。

- 除非情况特殊，严禁使用 `TEXT` / `LONGTEXT` / `BLOB` / `LONGBLOB` 等类型。

- 每张表必须加入 `created_at(创建时间)` / `updated_at(更新时间)` 字段， `deleted_at(软删除时间)` 字段可按需添加。 字段类型统一为`TIMESTAMP`,
`TINYINT(1)类型(1是2否)`, 

- 类似 `user_id` `store_id` 等常用查询的字段，且必须建 Index 索引。

## 使用说明
* 公共方法/助手类

>- 公共函数放在`/app/Common/Method/function.php`, 有公共方法可以补充到这里。
>- Redis常量定义在`/app/Common/Enum/RedisEnum.php`, Redis常量相关可以补充到这里。

* 公共请求头
>- t：时间戳
>- r：随机字符串（16位）
>- s：签名

*  签名的算法
>- token：11fds45452432FED5FS4D
>- s = stringVar.tolocaleUpperCase(md5(sha1(token + t + r)))
>- 1.先按顺序拼接成字符串 (token +  时间戳 + 随机字符串)
>- 2.再 sha1加密
>- 3.再 MD5 加密
>- 4.再 所有的字母字符都被转换为大写

* 状态码说明
>- | 状态码  | 解释  |
>- |  200 |  请求成功 |
>- |  400 | 请求失败（接口失败信息） |
>- |  500 | 服务器错误！  |
>- |  1000 | 签名错误 |
>- |  1001 | 需要注册 |
>- |  1002 | 需要登录 |

## 项目使用

* 任务调度
  1. 执行laravel 任务调度如下
  >- 宝塔进入命令行 执行 crontab -e 命令
  >- 按 i 进入编辑模式
  >- 添加：* * * * * /www/server/php/73/bin/php /www/wwwroot/根目录/artisan schedule:run >> /dev/null 2>&1
  >- 编辑好按ESC 退出，执行 ‘:wq’ 命令保存并退出
* 支付
  1.  支付App\Http\Controllers\Api\V1\Wechat 32行 关闭微信支付测试模式
* 数据同步
  1.  la_admin_permissions
  2.  la_admin_role_has_permissions
  3.  la_configuration
  4.  la_sys_rule
* 数据清空
    TRUNCATE la_box;
    TRUNCATE la_box_award;
    TRUNCATE la_box_rating;
    TRUNCATE la_complain;
    TRUNCATE la_luckbox_award;
    TRUNCATE la_luckbox_join;
    TRUNCATE la_luckbox_notice;
    TRUNCATE la_luckbox_sign;
    TRUNCATE la_luckbox_term;
    TRUNCATE la_order;
    TRUNCATE la_order_list;
    TRUNCATE la_order_list_change;
    TRUNCATE la_order_list_ship;
    TRUNCATE la_shop_collect;
    TRUNCATE la_shop_change;
    TRUNCATE la_shop_goods;
    TRUNCATE la_shop_sku;
    TRUNCATE la_shop_spec;
    TRUNCATE la_shop_spec_value;
    TRUNCATE la_test;
    TRUNCATE la_users;
    TRUNCATE la_users_address;
    TRUNCATE la_users_bind_log;
    TRUNCATE la_users_coin_log;
    TRUNCATE la_users_gold_log;
    TRUNCATE la_users_info;
    TRUNCATE la_users_money_log;
    TRUNCATE la_users_sms_log;
    TRUNCATE la_users_tree;
    TRUNCATE la_users_withdraw;