-- mysqldump-php https://github.com/ifsnop/mysqldump-php
--
-- Host: 127.0.0.1	Database: 123_npkw_cn
-- ------------------------------------------------------
-- Server version 	5.7.42-log
-- Date: Tue, 08 Aug 2023 00:29:22 +0800

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `123_npkw_cn`
--

/*!40000 DROP DATABASE IF EXISTS `123_npkw_cn`*/;

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `123_npkw_cn` /*!40100 DEFAULT CHARACTER SET utf8  COLLATE utf8_general_ci */;

USE `123_npkw_cn`;

--
-- Table structure for table `la_admin_model_has_permissions`
--

DROP TABLE IF EXISTS `la_admin_model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_admin_model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`) USING BTREE,
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `la_admin_permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 用户-权限中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_admin_model_has_permissions`
--

LOCK TABLES `la_admin_model_has_permissions` WRITE;
/*!40000 ALTER TABLE `la_admin_model_has_permissions` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_admin_model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_admin_model_has_permissions` with 0 row(s)
--

--
-- Table structure for table `la_admin_model_has_roles`
--

DROP TABLE IF EXISTS `la_admin_model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_admin_model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`) USING BTREE,
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `la_admin_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 用户-角色中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_admin_model_has_roles`
--

LOCK TABLES `la_admin_model_has_roles` WRITE;
/*!40000 ALTER TABLE `la_admin_model_has_roles` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_admin_model_has_roles` VALUES (1,'App\\Models\\Admin\\User',1);
/*!40000 ALTER TABLE `la_admin_model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_admin_model_has_roles` with 1 row(s)
--

--
-- Table structure for table `la_admin_permissions`
--

DROP TABLE IF EXISTS `la_admin_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_admin_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `route` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '路由名称',
  `param` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图标class',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `type` int(11) NOT NULL DEFAULT '1' COMMENT '类型：1按钮，2菜单',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 权限表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_admin_permissions`
--

LOCK TABLES `la_admin_permissions` WRITE;
/*!40000 ALTER TABLE `la_admin_permissions` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_admin_permissions` VALUES (1,'system','admin','权限管理','',NULL,'layui-icon-set',0,100,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(2,'system.user','admin','用户管理','admin.user',NULL,'1',1,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(3,'system.user.create','admin','添加用户','admin.user.create',NULL,'1',2,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(4,'system.user.edit','admin','编辑用户','admin.user.edit',NULL,'1',2,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(5,'system.user.destroy','admin','删除用户','admin.user.destroy',NULL,'1',2,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(6,'system.user.role','admin','分配角色','admin.user.role',NULL,'1',2,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(8,'system.role','admin','角色管理','admin.role',NULL,'1',1,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(9,'system.role.create','admin','添加角色','admin.role.create',NULL,'1',8,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(10,'system.role.edit','admin','编辑角色','admin.role.edit',NULL,'1',8,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(11,'system.role.destroy','admin','删除角色','admin.role.destroy',NULL,'1',8,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(12,'system.role.permission','admin','分配权限','admin.role.permission',NULL,'1',8,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(13,'system.permission','admin','权限管理','admin.permission',NULL,'1',1,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(14,'system.permission.create','admin','添加权限','admin.permission.create',NULL,'1',13,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(15,'system.permission.edit','admin','编辑权限','admin.permission.edit',NULL,'1',13,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(16,'system.permission.destroy','admin','删除权限','admin.permission.destroy',NULL,'1',13,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(21,'system.configuration','admin','系统配置项','admin.configuration',NULL,'1',44,3,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(22,'system.configuration.create','admin','添加组','admin.configuration.create',NULL,'1',21,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(23,'system.configuration.edit','admin','编辑组','admin.configuration.edit',NULL,'1',21,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(25,'users','admin','用户管理',NULL,NULL,'layui-icon-group',0,1,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(26,'users.users','admin','用户列表','users.users',NULL,NULL,25,1,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(28,'users.users.store','admin','添加编辑','users.users.store',NULL,NULL,26,2,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(44,'sys','admin','系统配置','',NULL,'layui-icon-engine',0,99,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(45,'sys.rule','admin','规则协议','sys.rule',NULL,NULL,44,1,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(46,'sys.rule.store','admin','编辑','sys.rule.store',NULL,NULL,45,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(47,'sys.backup','admin','数据库备份','sys.backup',NULL,NULL,44,4,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(48,'sys.backup.store','admin','添加备份','sys.backup.store',NULL,NULL,47,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(49,'sys.backup.before','admin','还原备份','sys.backup.before',NULL,NULL,47,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(50,'sys.backup.del','admin','删除备份','sys.backup.del',NULL,NULL,47,0,2,'2022-09-02 05:42:54','2022-09-02 05:42:54'),(52,'users.users.edit_money','admin','金额编辑','users.users.edit_money',NULL,NULL,26,0,2,'2022-09-02 05:42:54','2022-09-13 02:42:18'),(53,'stats','admin','流水统计','stats',NULL,'layui-icon-spread-left',0,2,2,'2022-10-27 09:52:04','2022-10-27 09:52:04'),(54,'stats.money','admin','余额明细','stats.money',NULL,NULL,53,1,2,'2022-10-27 09:52:33','2022-10-27 09:52:33'),(55,'stats.coin','admin','金币明细','stats.coin',NULL,NULL,53,2,2,'2022-10-27 09:52:49','2022-10-27 09:52:49'),(56,'shop','admin','商城管理','shop',NULL,'layui-icon-spread-left',0,4,2,'2022-11-22 06:42:44','2022-11-22 06:42:44'),(57,'shop.goods','admin','商品管理','shop.goods',NULL,NULL,56,1,2,'2022-11-22 06:43:38','2022-11-22 06:43:38'),(58,'shop.goods.store','admin','添加/编辑','shop.goods.store',NULL,NULL,57,1,2,'2022-11-22 06:43:55','2022-11-22 06:43:55'),(59,'shop.goods.del','admin','删除','shop.goods.del',NULL,NULL,57,2,2,'2022-11-22 06:44:18','2022-11-22 06:44:18'),(60,'shop.cat','admin','商品分类','shop.cat',NULL,NULL,56,2,2,'2022-11-22 06:44:41','2022-11-22 06:44:41'),(61,'shop.cat.store','admin','添加/编辑','shop.cat.store',NULL,NULL,60,1,2,'2022-11-22 06:44:58','2022-11-22 06:44:58'),(62,'shop.cat.del','admin','删除','shop.cat.del',NULL,NULL,60,2,2,'2022-11-22 06:45:15','2022-11-22 06:45:15'),(63,'shop.brand','admin','商品品牌','shop.brand',NULL,NULL,56,3,2,'2022-11-22 09:42:04','2022-11-22 09:42:04'),(64,'shop.brand.store','admin','添加/编辑','shop.brand.store',NULL,NULL,63,1,2,'2022-11-22 09:42:28','2022-11-22 09:42:28'),(65,'shop.brand.del','admin','删除','shop.brand.del',NULL,NULL,63,2,2,'2022-11-22 09:42:40','2022-11-22 09:42:40'),(66,'operate','admin','运营管理','operate',NULL,'layui-icon-spread-left',0,50,2,'2022-11-22 10:41:54','2022-11-22 10:41:54'),(67,'operate.banners1','admin','首页顶部轮播','operate.banners1','?cat_id=1',NULL,66,1,2,'2022-11-22 10:42:18','2022-11-23 09:48:54'),(68,'operate.banners.store','admin','添加/编辑','operate.banners.store',NULL,NULL,67,1,2,'2022-11-22 10:42:49','2022-11-22 10:42:49'),(69,'operate.banners.del','admin','删除','operate.banners.del',NULL,NULL,67,2,2,'2022-11-22 10:43:02','2022-11-22 10:43:02'),(70,'box','admin','抽盒管理','box',NULL,'layui-icon-spread-left',0,3,2,'2022-11-23 07:22:30','2022-11-23 07:22:30'),(71,'box.box','admin','盒子列表','box.box',NULL,NULL,70,1,2,'2022-11-23 07:23:02','2022-11-23 07:23:02'),(72,'box.box.store','admin','添加/编辑','box.box.store',NULL,NULL,71,1,2,'2022-11-23 07:23:19','2022-11-23 07:23:19'),(73,'box.box.del','admin','删除','box.box.del',NULL,NULL,71,2,2,'2022-11-23 07:23:33','2022-11-23 07:23:33'),(74,'box.draw','admin','抽取方式','box.draw',NULL,NULL,70,2,2,'2022-11-23 07:24:16','2022-11-23 07:24:52'),(75,'box.draw.store','admin','添加/编辑','box.draw.store',NULL,NULL,74,1,2,'2022-11-23 07:25:10','2022-11-23 07:25:10'),(76,'box.draw.del','admin','删除','box.draw.del',NULL,NULL,74,2,2,'2022-11-23 07:25:23','2022-11-23 07:25:23'),(77,'operate.banners2','admin','首页中部轮播','operate.banners2','?cat_id=2',NULL,66,2,2,'2022-11-23 09:49:24','2022-11-23 09:49:24'),(78,'operate.banners3','admin','抽盒顶部轮播','operate.banners3','?cat_id=3',NULL,66,3,2,'2022-11-23 09:49:45','2022-11-23 09:49:45'),(79,'box.award','admin','奖品列表','box.award',NULL,NULL,70,3,1,'2022-11-24 01:21:25','2022-11-24 01:21:25'),(80,'box.award.store','admin','添加/编辑','box.award.store',NULL,NULL,79,1,1,'2022-11-24 01:21:46','2022-11-24 01:21:46'),(81,'box.award.del','admin','删除','box.award.del',NULL,NULL,79,2,1,'2022-11-24 01:22:00','2022-11-24 01:22:16'),(82,'complain','admin','投诉举报','complain',NULL,'layui-icon-spread-left',0,51,2,'2022-11-28 03:46:41','2022-11-28 03:46:41'),(83,'complain.type','admin','问题类型','complain.type',NULL,NULL,82,2,2,'2022-11-28 03:47:29','2022-11-28 03:47:29'),(84,'complain.type.store','admin','添加/编辑','complain.type.store',NULL,NULL,83,1,2,'2022-11-28 03:48:09','2022-11-28 03:48:09'),(85,'complain.type.del','admin','删除','complain.type.del',NULL,NULL,83,2,2,'2022-11-28 03:48:43','2022-11-28 03:48:43'),(86,'complain.complain','admin','投诉列表','complain.complain','?status=0',NULL,82,1,2,'2022-11-28 08:22:40','2022-11-28 08:22:40'),(87,'complain.complain.reply','admin','回复用户','complain.complain.reply',NULL,NULL,86,1,2,'2022-11-28 08:28:05','2022-11-28 08:28:05'),(88,'shop.change','admin','置换商品','shop.change',NULL,NULL,56,5,2,'2022-11-29 02:13:09','2022-12-24 01:48:27'),(89,'shop.change.store','admin','添加/编辑','shop.change.store',NULL,NULL,88,1,2,'2022-11-29 02:13:24','2022-11-29 02:13:24'),(90,'shop.change.del','admin','删除','shop.change.del',NULL,NULL,88,2,2,'2022-11-29 02:13:44','2022-11-29 02:13:44'),(92,'users.withdraw','admin','提现列表','users.withdraw','?status=0',NULL,25,2,2,'2022-11-30 08:26:15','2022-11-30 08:26:15'),(93,'users.withdraw.edit','admin','提现审核','users.withdraw.edit',NULL,NULL,92,1,2,'2022-11-30 08:26:36','2022-11-30 08:26:36'),(94,'stats.gold','admin','购物金明细','stats.gold',NULL,NULL,53,3,2,'2022-11-30 09:01:29','2022-11-30 09:01:29'),(95,'luckbox','admin','幸运盲盒','luckbox',NULL,'layui-icon-spread-left',0,5,2,'2022-12-03 07:51:51','2022-12-05 07:27:19'),(96,'luckbox.award','admin','奖品列表','luckbox.award',NULL,NULL,95,1,2,'2022-12-03 07:52:24','2022-12-03 07:52:24'),(97,'luckbox.award.store','admin','添加/编辑','luckbox.award.store',NULL,NULL,96,1,2,'2022-12-03 07:52:42','2022-12-03 07:52:42'),(98,'luckbox.award.del','admin','删除','luckbox.award.del',NULL,NULL,96,2,2,'2022-12-03 07:53:01','2022-12-03 07:53:01'),(99,'users.ship','admin','发货列表','users.ship','?status=1',NULL,25,3,2,'2022-12-09 08:03:26','2022-12-09 08:03:26'),(100,'users.ship.edit','admin','编辑','users.ship.edit',NULL,NULL,99,1,2,'2022-12-09 08:05:20','2022-12-09 08:05:20'),(101,'box.log','admin','中奖记录','box.log',NULL,NULL,70,4,1,'2022-12-09 09:25:17','2022-12-09 09:26:16'),(102,'stats.box','admin','开盒记录','stats.box',NULL,NULL,53,4,2,'2022-12-09 09:54:29','2022-12-09 09:54:29'),(103,'stats.order','admin','订单列表','stats.order',NULL,NULL,53,5,2,'2022-12-10 07:57:08','2022-12-10 07:57:08'),(104,'stats.order.refund','admin','退款','stats.order.refund',NULL,NULL,103,1,2,'2022-12-10 07:58:58','2022-12-10 07:58:58'),(105,'shop.hotsearch','admin','热门搜索','shop.hotsearch',NULL,NULL,56,4,2,'2022-12-24 01:49:00','2022-12-24 01:49:00'),(106,'shop.hotsearch.store','admin','添加/编辑','shop.hotsearch.store',NULL,NULL,105,1,2,'2022-12-24 01:49:19','2022-12-24 01:49:19'),(107,'shop.hotsearch.del','admin','删除','shop.hotsearch.del',NULL,NULL,105,2,2,'2022-12-24 01:49:34','2022-12-24 01:49:34'),(108,'operate.redpack','admin','红包管理','operate.redpack',NULL,NULL,66,4,2,'2023-01-09 07:53:22','2023-01-09 07:53:22'),(109,'operate.redpack.store','admin','添加/编辑','operate.redpack.store',NULL,NULL,108,1,2,'2023-01-09 07:54:13','2023-01-09 08:10:06'),(110,'operate.redpack.del','admin','删除','operate.redpack.del',NULL,NULL,108,2,2,'2023-01-09 07:55:34','2023-01-09 07:55:34'),(111,'users.users.team','admin','团队列表','users.users.team',NULL,NULL,26,0,2,'2023-05-24 08:37:51','2023-05-24 08:37:51'),(112,'operate.recharge','admin','充值选项管理','operate.recharge',NULL,NULL,66,5,2,'2023-06-04 09:42:24','2023-06-04 09:42:49'),(113,'operate.recharge.store','admin','添加/编辑','operate.recharge.store',NULL,NULL,112,0,2,'2023-06-04 09:44:23','2023-06-04 09:44:23'),(114,'operate.recharge.del','admin','删除','operate.recharge.del',NULL,NULL,112,0,2,'2023-06-04 09:44:35','2023-06-04 09:44:35'),(115,'stats.recharge','admin','充值记录','stats.recharge',NULL,NULL,53,6,2,'2023-06-04 10:07:44','2023-06-04 10:07:44'),(116,'users.daili','admin','推广员申请','users.daili',NULL,NULL,25,4,2,'2023-06-04 18:08:42','2023-06-04 18:08:42'),(117,'users.daili.edit','admin','审核推广员','users.daili.edit',NULL,NULL,116,0,2,'2023-06-04 18:09:19','2023-06-04 18:09:19'),(118,'users.dailiList','admin','推广员列表','users.dailiList',NULL,NULL,25,6,2,'2023-06-07 18:56:41','2023-06-07 18:56:41'),(119,'users.dailiList.team','admin','团队列表','users.dailiList.team',NULL,NULL,118,0,2,'2023-06-07 18:57:09','2023-06-07 18:57:09');
/*!40000 ALTER TABLE `la_admin_permissions` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_admin_permissions` with 95 row(s)
--

--
-- Table structure for table `la_admin_role_has_permissions`
--

DROP TABLE IF EXISTS `la_admin_role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_admin_role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`) USING BTREE,
  KEY `role_has_permissions_role_id_foreign` (`role_id`) USING BTREE,
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `la_admin_permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `la_admin_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 角色-权限中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_admin_role_has_permissions`
--

LOCK TABLES `la_admin_role_has_permissions` WRITE;
/*!40000 ALTER TABLE `la_admin_role_has_permissions` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_admin_role_has_permissions` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(21,1),(22,1),(23,1),(25,1),(26,1),(28,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1);
/*!40000 ALTER TABLE `la_admin_role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_admin_role_has_permissions` with 95 row(s)
--

--
-- Table structure for table `la_admin_roles`
--

DROP TABLE IF EXISTS `la_admin_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_admin_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 角色表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_admin_roles`
--

LOCK TABLES `la_admin_roles` WRITE;
/*!40000 ALTER TABLE `la_admin_roles` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_admin_roles` VALUES (1,'超级管理员','admin','超级管理员','2022-09-02 05:42:54','2022-09-21 01:43:01');
/*!40000 ALTER TABLE `la_admin_roles` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_admin_roles` with 1 row(s)
--

--
-- Table structure for table `la_admin_users`
--

DROP TABLE IF EXISTS `la_admin_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_admin_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户名',
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号码',
  `nickname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '昵称',
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邮箱',
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '密码',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `api_token` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `users_username_unique` (`username`) USING BTREE,
  UNIQUE KEY `users_phone_unique` (`phone`) USING BTREE,
  UNIQUE KEY `users_email_unique` (`email`) USING BTREE,
  UNIQUE KEY `users_api_token_unique` (`api_token`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 用户表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_admin_users`
--

LOCK TABLES `la_admin_users` WRITE;
/*!40000 ALTER TABLE `la_admin_users` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_admin_users` VALUES (1,'admin','18213342446','超级管理员','18213342446@qq.com','$2y$10$Oghrs6uTG0KhZkpRT2E/CunSvP6YbORsiOIqaLb46psKQhjI8FKEq',NULL,'9394ddf067075bf31087681966e2adf05fe4068178d10027f1fdc4ffc0c0d31d','2022-07-10 01:50:05','2023-07-05 08:56:36');
/*!40000 ALTER TABLE `la_admin_users` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_admin_users` with 1 row(s)
--

--
-- Table structure for table `la_box`
--

DROP TABLE IF EXISTS `la_box`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_box` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL COMMENT '标题',
  `thumb` varchar(191) NOT NULL DEFAULT '' COMMENT '盒子图',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `send_coin` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '好友邀请赠送积分',
  `send_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '好友邀请赠送现金',
  `mark_rate` text NOT NULL COMMENT '等级比例',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序',
  `sales` int(10) unsigned DEFAULT '0' COMMENT '销量',
  `status` int(4) unsigned DEFAULT '1' COMMENT '状态：1上架，2下架',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='抽盒 - 盒子';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_box`
--

LOCK TABLES `la_box` WRITE;
/*!40000 ALTER TABLE `la_box` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_box` VALUES (1,'盒子','/uploads/upload/admin/2023/03/24/8133657b6c01986fab957cc85f4585e4.png',10.00,0,0.00,'{\"1\":\"100.00\",\"2\":\"0.00\",\"3\":\"0.00\",\"4\":\"0.00\"}',0,0,1,1679623064,1679625769,1679625769),(2,'超值新人福利 & 全家桶','/aliyun/db4e50f5c4176c754a365a697f498989.jpg',16.67,0,0.00,'{\"1\":\"0.60\",\"2\":\"1.40\",\"3\":\"16.00\",\"4\":\"82.00\"}',99,14503,1,1679625841,1691425579,NULL),(3,'新人福利のiPhone开箱初体验','/aliyun/48fdbf0f1744778a887a41deb1e1397c.jpg',19.00,95,0.00,'{\"1\":\"0.06\",\"2\":\"0.24\",\"3\":\"10.90\",\"4\":\"88.80\"}',95,7875,1,1679728988,1686927799,1686927799),(4,'果粉专场のApple全家桶高爆','/aliyun/c4e537548cadf4c9db51bb87fdd321db.jpg',199.00,995,0.00,'{\"1\":\"0.38\",\"2\":\"1.47\",\"3\":\"9.92\",\"4\":\"88.23\"}',93,2251,1,1679729841,1686927795,1686927795),(5,'畅游电玩のPS5+Switch游戏天堂','/aliyun/f200439cdda15a06b304575a018b7034.jpg',39.00,195,0.00,'{\"1\":\"0.25\",\"2\":\"2.39\",\"3\":\"10.80\",\"4\":\"86.56\"}',89,412,1,1679731642,1686927785,1686927785),(6,'潮男专区の得物鉴定发货','/aliyun/1955089c9f8d039134dc4889440d3357.jpg',99.00,495,0.00,'{\"1\":\"0.26\",\"2\":\"1.85\",\"3\":\"12.37\",\"4\":\"85.52\"}',88,1412,1,1679820265,1686927807,1686927807),(7,'99必出209以上产品-超值盒','/aliyun/ffa47091eaf3c315a61b925746b3df1a.jpg',99.00,495,0.00,'{\"1\":\"0.10\",\"2\":\"0.50\",\"3\":\"2.70\",\"4\":\"96.79\"}',7,0,2,1679825986,1686927778,1686927778),(8,'平板大集の追剧网课人手必备','/aliyun/b1ed65241eb2fe9b7619ef9499af73b0.jpg',49.00,245,0.00,'{\"1\":\"0.23\",\"2\":\"0.19\",\"3\":\"4.97\",\"4\":\"94.61\"}',91,178,1,1679996151,1686927790,1686927790),(9,'测试主播概率盲盒','/aliyun/37c09fbc174f65aa3fbd6aef6b9bcb9d.jpg',99.00,0,0.00,'{\"1\":\"0.03\",\"2\":\"0.07\",\"3\":\"0.20\",\"4\":\"97.00\"}',1,9,1,1683352414,1683356667,1683356667),(10,'璀璨夺目の宝格丽假一赔三','/aliyun/238796e7dd7f045d4f0b0cb97487c510.jpg',89.00,445,0.00,'{\"1\":\"0.52\",\"2\":\"2.22\",\"3\":\"7.90\",\"4\":\"89.36\"}',91,285,1,1685174512,1686927787,1686927787),(11,'灵动岛主のiPhone14Pro Max','/aliyun/a6c3ff5c002e756097d04bb3c954f1ce.jpg',98.00,490,0.00,'{\"1\":\"0.10\",\"2\":\"0.36\",\"3\":\"15.80\",\"4\":\"83.74\"}',94,2022,1,1685209444,1686927797,1686927797),(12,'屏幕超大のiPhone14Plus来袭','/aliyun/bb589f1e20c6ac8c86cbf69d924a5efc.jpg',65.00,325,0.00,'{\"1\":\"0.15\",\"2\":\"0.55\",\"3\":\"7.80\",\"4\":\"91.50\"}',97,396,1,1685222394,1686927804,1686927804),(13,'智能手表のWatch Ultra系列','/aliyun/b9657a706a7be43326db4a118c382370.jpg',59.00,295,0.00,'{\"1\":\"0.10\",\"2\":\"0.54\",\"3\":\"3.60\",\"4\":\"95.76\"}',87,8,1,1685224042,1686927782,1686927782),(14,'强悍性能の游戏电竞主机','/aliyun/ef5e37d104a1f2fa919b90ed1e7ecc3e.jpg',78.00,390,0.00,'{\"1\":\"0.32\",\"2\":\"2.69\",\"3\":\"11.23\",\"4\":\"85.76\"}',96,85,1,1686168755,1686927801,1686927801),(15,'小米生态の美好的事即将发生','/aliyun/fb4ea8f5e795bdfa6f0940b14e66f659.jpg',55.00,275,0.00,'{\"1\":\"0.55\",\"2\":\"4.29\",\"3\":\"11.40\",\"4\":\"83.76\"}',92,0,1,1686174618,1686927793,1686927793),(16,'1','/aliyun/82178ef0e6170fad1d455187c4136844.jpg',1.00,0,0.00,'{\"1\":\"0.00\",\"2\":\"0.00\",\"3\":\"0.00\",\"4\":\"0.00\"}',0,0,2,1688547849,1688547866,1688547866),(17,'123','/aliyun/131dd5cea595f8dc2bea5ee1df1973e6.jpg',123.00,1,1.00,'{\"1\":\"1.00\",\"2\":\"1.00\",\"3\":\"1.00\",\"4\":\"1.00\"}',2,1,1,1691245741,1691257259,NULL),(18,'1','/aliyun/e8867c5c8979d5500472a19b859c1c51.jpg',5.00,0,0.00,'{\"1\":\"0.00\",\"2\":\"0.00\",\"3\":\"0.00\",\"4\":\"0.00\"}',0,0,2,1691425328,1691425328,NULL),(19,'12561','/aliyun/c423f834b2abed1bcd5d1ee0d2f403af.jpg',1.00,0,0.00,'{\"1\":\"15.00\",\"2\":\"5.00\",\"3\":\"6.00\",\"4\":\"8.00\"}',0,0,2,1691425655,1691425655,NULL);
/*!40000 ALTER TABLE `la_box` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_box` with 19 row(s)
--

--
-- Table structure for table `la_box_award`
--

DROP TABLE IF EXISTS `la_box_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_box_award` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `box_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '盒子ID',
  `mark_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '赏类型',
  `title` varchar(191) NOT NULL DEFAULT '' COMMENT '奖品标题',
  `thumb` varchar(191) NOT NULL DEFAULT '' COMMENT '缩略图',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '展示价格',
  `show_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '展示比例',
  `real_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '普通比例',
  `anchor_rate` decimal(10,2) NOT NULL COMMENT '主播概率',
  `dissolve_rate` decimal(10,2) DEFAULT '0.00',
  `num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  `editor` text COMMENT '详情',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `box_id` (`box_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=581 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='抽盒 - 盒子奖品';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_box_award`
--

LOCK TABLES `la_box_award` WRITE;
/*!40000 ALTER TABLE `la_box_award` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_box_award` VALUES (1,1,1,'传说款','/uploads/upload/admin/2023/03/24/8e12b4239258ff4218e95205e6d80214.png',10.00,25.00,25.00,0.00,0.00,2500,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679623090391418.png\" title=\"1679623090391418.png\" alt=\"4ae7221658e9af4a022cb7da6c925f0f.png\"/></p>',1679623100,1679623100,NULL),(2,1,2,'史诗款','/uploads/upload/admin/2023/03/24/65f4995976c700e8ba14925817584aec.png',10.00,25.00,25.00,0.00,0.00,2500,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679623133712216.png\" title=\"1679623133712216.png\" alt=\"4ae7221658e9af4a022cb7da6c925f0f.png\"/></p>',1679623138,1679623138,NULL),(3,1,3,'稀有款','/uploads/upload/admin/2023/03/24/e24025d3ef85ed9c3f477de287698a49.png',10.00,25.00,25.00,0.00,0.00,2500,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679623159176403.png\" title=\"1679623159176403.png\" alt=\"4ae7221658e9af4a022cb7da6c925f0f.png\"/></p>',1679623161,1679623161,NULL),(4,1,4,'普通款','/uploads/upload/admin/2023/03/24/912d7bfd654cf6e83daea12882ea10c2.png',10.00,25.00,25.00,0.00,0.00,2500,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679623176259106.png\" title=\"1679623176259106.png\" alt=\"4ae7221658e9af4a022cb7da6c925f0f.png\"/></p>',1679623178,1679623178,NULL),(5,2,1,'外星人主机','/uploads/upload/admin/2023/03/24/d5a10cbdec144034590766c114a38a10.jpeg',18888.00,0.01,0.01,0.00,0.00,1,NULL,1679625887,1679636249,1679636249),(6,2,1,'外星人笔记本','/uploads/upload/admin/2023/03/24/1bb4e9feb98967b2b1bc28ba693f9abc.jpeg',15888.00,0.01,0.01,0.00,0.00,1,NULL,1679625934,1679636249,1679636249),(7,2,1,'苹果14','/uploads/upload/admin/2023/03/24/6139636b6576b4d732d3ea85247e6bb3.jpeg',8999.00,0.01,0.01,0.00,0.00,1,NULL,1679625991,1679636249,1679636249),(8,2,2,'智能手表','/uploads/upload/admin/2023/03/24/0863988d6e54cf53b124b542425d5f20.jpeg',5888.00,0.07,0.07,0.00,0.00,7,NULL,1679626073,1679636249,1679636249),(9,2,2,'显卡','/uploads/upload/admin/2023/03/24/0113f36c02995b3223540ca4d285e9cd.jpeg',4888.00,0.20,0.20,0.00,0.00,20,NULL,1679626136,1679636249,1679636249),(10,2,2,'雷神键盘','/uploads/upload/admin/2023/03/24/fbaba6a5250788223838307b389b9111.png',1999.00,0.70,0.70,0.00,0.00,70,NULL,1679626263,1679636249,1679636249),(11,2,3,'自拍杆','/uploads/upload/admin/2023/03/24/798c8e08de38c1710ac33ecd3214f328.jpeg',1999.00,4.00,4.00,0.00,0.00,400,NULL,1679626681,1679636249,1679636249),(12,2,3,'电器','/uploads/upload/admin/2023/03/24/debff6505ace647217355ca340976e36.jpeg',999.00,5.00,5.00,0.00,0.00,495,NULL,1679626772,1679636249,1679636249),(13,2,3,'无限充电','/uploads/upload/admin/2023/03/24/ba585aaa1f7ca44f3b6705e99178962b.png',599.00,10.00,10.00,0.00,0.00,997,NULL,1679626821,1679636249,1679636249),(14,2,4,'手机壳','/uploads/upload/admin/2023/03/24/a663ecdca9b99de56ce7ff59e93943c7.jpeg',99.00,40.00,40.00,0.00,0.00,3926,NULL,1679626916,1679636249,1679636249),(15,2,4,'数据线','/uploads/upload/admin/2023/03/24/42d3a468e0221a3233c2fcee35caa223.jpeg',99.00,40.00,40.00,0.00,0.00,3926,NULL,1679626952,1679636249,1679636249),(16,2,1,'香奈儿魅力丝绒唇膏明星色号','/uploads/upload/admin/2023/03/24/d3ec25d5acd2bd6fd003773c5d6b22ce.png',420.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679639779840751.jpg\" title=\"1679639779840751.jpg\" alt=\"716631618672719919.jpg\"/></p>',1679636452,1679644056,1679644056),(17,2,2,'萝卜丁黑管丝滑-玫红色 亮面','/uploads/upload/admin/2023/03/28/91edaef4c5a11d260009653efc57a596.png',580.00,0.13,0.13,0.00,0.00,12,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679639461203105.jpg\" title=\"1679639461203105.jpg\" alt=\"285384429391129724.jpg\"/></p>',1679637023,1684964501,1684964501),(18,2,2,'迪奥  烈艳蓝金唇膏','/uploads/upload/admin/2023/03/27/86d4737738b6030228c04de8780acabf.png',460.00,0.13,0.13,0.00,0.00,12,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679639971310024.jpg\" title=\"1679639971310024.jpg\" alt=\"912556273118496617.jpg\"/></p>',1679637924,1684964501,1684964501),(19,2,2,'圣罗兰小金条-皮革哑光 浓郁显色','/uploads/upload/admin/2023/03/28/55e4b511b211d47a97865269726b343c.png',458.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679640146485042.jpg\" title=\"1679640146485042.jpg\" alt=\"120046138741599132.jpg\"/></p>',1679638847,1684964501,1684964501),(20,2,2,'TF汤姆福特黑管哑光口红','/uploads/upload/admin/2023/03/28/d0417d590e905458e37cb8da7da54a60.png',437.00,0.13,0.13,0.00,0.00,12,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679640520336235.jpg\" title=\"1679640520336235.jpg\" alt=\"微信图片_20230324144825.jpg\"/></p>',1679640523,1684964501,1684964501),(21,2,2,'魅可黑魔杖细管口红','/uploads/upload/admin/2023/03/24/a00a67c795901ab95b815ed25e0f2286.jpeg',288.00,0.30,0.30,0.00,0.00,30,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679640899270321.jpg\" title=\"1679640899270321.jpg\" alt=\"微信图片_20230324145443.jpg\"/></p>',1679640965,1679758625,1679758625),(22,2,2,'魅可子弹头口红唇膏','/uploads/upload/admin/2023/03/28/f46aaafcde28634ebb537d23904b9ed1.png',238.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679641180728702.jpg\" title=\"1679641180728702.jpg\" alt=\"微信图片_20230324145831.jpg\"/></p>',1679641185,1684964501,1684964501),(23,2,2,'兰蔻口红196小蛮腰菁纯丝绒哑光滋润唇膏','/uploads/upload/admin/2023/03/28/f3554d9f4e129e6496e13df282ea6934.png',220.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/24/1679641613881237.jpg\" title=\"1679641613881237.jpg\" alt=\"微信图片_20230324150453.jpg\"/></p>',1679641615,1684964501,1684964501),(24,2,4,'879989','/uploads/upload/admin/2023/03/24/a45d93ba5d7110955c15d79fa5a05516.jpeg',97678.00,0.30,1.00,0.00,0.00,100,NULL,1679643999,1679644185,1679644185),(25,2,3,'uujj','/uploads/upload/admin/2023/03/24/aab0575d02b5682b10c9ae1451406273.jpeg',4.00,8.00,8.00,0.00,0.00,800,NULL,1679644132,1679644174,1679644174),(26,2,4,'uyiugk','/uploads/upload/admin/2023/03/24/f62426791fff224050893e9168b954c0.png',1.00,1.00,1.00,0.00,0.00,100,NULL,1679648468,1679648523,1679648523),(27,2,4,'我改完给我','/uploads/upload/admin/2023/03/24/b8093e951d6518c0999e7f2bbc239eec.jpeg',1.00,1.00,1.00,0.00,0.00,100,NULL,1679648791,1679648866,1679648866),(28,3,1,'Jordan官方耐克乔丹AJ37男子实战篮球鞋秋冬新款','/uploads/upload/admin/2023/03/28/7e66df3bdcac2d89ac2e769227fd1005.png',1800.00,0.10,0.10,0.00,0.00,9,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679729409946073.png\" title=\"1679729409946073.png\" alt=\"3a16dcf167012fd2435c5fa85bbc3cd.png\"/></p>',1679729414,1685015028,1685015028),(29,3,1,'㉿SavadyFashion ㉿ K517','/uploads/upload/admin/2023/03/28/f4b4bff620fb1cdc068b14ef9557e2e9.png',1980.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679729874119483.jpg\" title=\"1679729874119483.jpg\" alt=\"3c45cb86999e3a2718afd05c1a0be0f.jpg\"/></p>',1679729911,1685015028,1685015028),(30,3,1,'350V2椰子350纯白2.0冰淇淋','/uploads/upload/admin/2023/03/28/c5a2643c05629b07b33a839cda612d37.png',1888.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679730135162409.jpg\" title=\"1679730135162409.jpg\" alt=\"193f7a2561d4d5ac099c7a84dc6a403.jpg\"/></p>',1679730141,1685015028,1685015028),(31,3,1,'JordanAJ1女运动鞋春新款板鞋','/uploads/upload/admin/2023/03/28/29260211c0fae3bc66411f87d0e59d48.png',1388.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679730416980652.jpg\" title=\"1679730416980652.jpg\" alt=\"e2ab707a214d1db68ceaec7f0720fb2.jpg\"/></p>',1679730419,1685015028,1685015028),(32,4,1,'Apple/苹果 iPhone12 128G','/uploads/upload/admin/2023/03/28/9ead0a95eb68f7759b48a313ff9e83be.png',3800.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679731037623290.jpg\" title=\"1679731037623290.jpg\" alt=\"微信图片_20230325154956.jpg\"/></p>',1679731041,1685003014,1685003014),(33,4,1,'HUAWEI/华为Mate 50','/uploads/upload/admin/2023/03/28/65cf38f2277a378dbcf412a4d4204c7c.png',5500.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680079478826033.jpg\" title=\"1680079478826033.jpg\" alt=\"微信图片_20230329164424.jpg\"/></p>',1679731303,1685003014,1685003014),(34,3,1,'apples8苹果智能手表','/uploads/upload/admin/2023/03/28/4bf3d0b1763d83816e295b4335a6a95c.png',2200.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679731394608913.jpg\" title=\"1679731394608913.jpg\" alt=\"94e9ad3e07dd612990da12908f234d1.jpg\"/></p>',1679731398,1685015028,1685015028),(35,3,1,'Watch 3智能手表eSIM独立通话心率血氧检测','/uploads/upload/admin/2023/03/28/29382b3e30f0b529e865a3712ad2f5dc.png',2088.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679731664306025.jpg\" title=\"1679731664306025.jpg\" alt=\"0157fa0f57bd0591cc7b09925b1cef0.jpg\"/></p>',1679731667,1685015028,1685015028),(36,3,1,'WATCH3/3Pro eSIM防水智能独立通话手表','/uploads/upload/admin/2023/03/28/0b4ca8af2590c9366859254193ada089.png',2038.00,0.10,0.10,0.00,0.00,9,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679731920348329.jpg\" title=\"1679731920348329.jpg\" alt=\"8c5f9933e33b503b05b90de237ce59c.jpg\"/></p>',1679731923,1685015028,1685015028),(37,4,2,'微单高清美颜可自拍数码相机录制vlog旅游照相机','/uploads/upload/admin/2023/03/28/b245cf314b47614acd6d75c1bce08939.png',450.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679731963888023.jpg\" title=\"1679731963888023.jpg\" alt=\"微信图片_20230325160357.jpg\"/></p>',1679731966,1685003014,1685003014),(38,3,2,'卡西欧洲杯超火情侣款手表一对电子表女学生运动休闲潮流防水表男','/uploads/upload/admin/2023/03/28/601e902397e3d1e0f7620f06b46e8450.png',388.00,0.20,0.20,0.00,0.00,19,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679732073498788.png\" title=\"1679732073498788.png\" alt=\"a8c3d8ca451cef4da93f45e3c0556d9.png\"/></p>',1679732076,1685015028,1685015028),(39,4,2,'OPPOK10x 5G手机拍照智能全面屏新款游戏','/uploads/upload/admin/2023/03/28/e04e318489db5853edc62cf4b22bd515.png',1500.00,0.13,0.13,0.00,0.00,13,'<p><img class=\"loadingclass\" id=\"loading_lfnp30f1\" src=\"/static/admin/ueditor/themes/default/images/spacer.gif\" title=\"正在上传...\"/></p>',1679732455,1685003014,1685003014),(40,3,2,'机械表全自动情侣女夜光防水透明镂空学生潮流2023年新款','/uploads/upload/admin/2023/03/28/1426ed5aea116668114d9f9dd8e400cc.png',368.00,0.20,0.20,0.00,0.00,19,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679732498624681.jpg\" title=\"1679732498624681.jpg\" alt=\"cf5028bbbfdeed83be0452b9b5d76bf.jpg\"/></p>',1679732501,1685015028,1685015028),(41,4,2,'vivo Y73t新品5G智能手机大电池vivo','/uploads/upload/admin/2023/03/28/1d435c10b36ed38a41115f425498684e.png',1500.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679732755945812.png\" title=\"1679732755945812.png\" alt=\"22.png\"/></p>',1679732759,1685003014,1685003014),(42,3,2,'mlb美职棒潮牌手表男女士镂空机械风时尚复古防水情侣款手表','/uploads/upload/admin/2023/03/28/39f400944a196cb6f97b26d54f92f402.png',663.00,0.20,0.20,0.00,0.00,20,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679732764228603.jpg\" title=\"1679732764228603.jpg\" alt=\"43db1e04dd0841cea29558988ba51c0.jpg\"/></p>',1679732767,1685015028,1685015028),(43,5,2,'正品菱格单肩斜挎包女士真皮包','/uploads/upload/admin/2023/03/25/dcb32022d7526d45246d68108b8766ff.jpeg',360.00,0.05,0.05,0.00,0.00,5,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679733252263562.jpg\" title=\"1679733252263562.jpg\" alt=\"651009037274656966.jpg\"/></p>',1679732968,1679733467,1679733467),(44,5,1,'真皮包包新款包包女夏季斜挎包高级感小圆包','/uploads/upload/admin/2023/03/25/505a3e66d530d42db2df521a9b7fa0d1.jpeg',1380.00,0.10,0.00,0.00,0.00,0,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679733328599937.jpg\" title=\"1679733328599937.jpg\" alt=\"微信图片_20230325163458.jpg\"/></p>',1679733390,1679846333,1679846333),(45,4,2,'PRO无线游戏耳机头戴式电竞吃鸡专用蓝牙台式电脑耳麦','/uploads/upload/admin/2023/03/28/ba4179498b0f1dbf2c58aa76ba320847.png',458.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679733692662322.jpg\" title=\"1679733692662322.jpg\" alt=\"微信图片_20230325163327.jpg\"/></p>',1679733717,1685003014,1685003014),(46,4,3,'开心米奇 10000毫安大容量充电宝','/uploads/upload/admin/2023/03/28/f0aea6ed055d547fa5f943fcab7b522c.png',68.00,18.00,18.00,0.00,0.00,1797,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679737431878289.jpg\" title=\"1679737431878289.jpg\" alt=\".....jpg\"/></p>',1679734029,1685003017,1685003017),(47,4,3,'AI智能无线蓝牙音响低音炮','/uploads/upload/admin/2023/03/28/8f91a89affa22120d920cd08a3b50b4f.png',68.00,18.00,18.00,0.00,0.00,1799,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679737890641469.jpg\" title=\"1679737890641469.jpg\" alt=\"ec7fd42af5783a477b9a11ed9f83776.jpg\"/></p>',1679734373,1685003017,1685003017),(48,4,3,'新款耳机适用于苹果lightning有线耳机','/uploads/upload/admin/2023/03/28/41326b759f04c523e1a30c244ce6a0bc.png',58.00,18.00,18.00,0.00,0.00,1799,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679738138321903.png\" title=\"1679738138321903.png\" alt=\"1679737664(1).png\"/></p>',1679734593,1685003017,1685003017),(49,4,4,'苹果14手机壳网红透明耐磨防摔磨砂抗指纹保护套','/uploads/upload/admin/2023/03/28/88577223a54b1d07cd9ae600cce2c5f3.png',28.80,81.80,81.80,0.00,80.00,8172,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679734764109693.jpg\" title=\"1679734764109693.jpg\" alt=\"27911973192a64a0e442cb6f511c21c.jpg\"/></p>',1679734836,1685003017,1685003017),(50,4,4,'适用华为mate40Pro星钻手机壳','/uploads/upload/admin/2023/03/25/edc40cd58342be9e964321437ff6c615.jpeg',28.80,95.00,95.00,0.00,0.00,9500,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679735102281202.jpg\" title=\"1679735102281202.jpg\" alt=\"微信图片_20230325165754.jpg\"/></p>',1679735106,1679821725,1679821725),(51,4,4,'PD快充20W适用iphone苹果数据线','/uploads/upload/admin/2023/03/28/9d29904368b0673e4698a5ba6bd94fe1.png',20.00,81.80,81.80,0.00,0.00,8170,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679735272306883.jpg\" title=\"1679735272306883.jpg\" alt=\"b347b078fad990025d5a2931f769fa3.jpg\"/></p>',1679735277,1685003017,1685003017),(52,4,4,'安卓数据线typec适用华为快充线vivo','/uploads/upload/admin/2023/03/28/96ebd7d7ce0172e4116d46fb094e27a6.png',18.80,81.80,81.80,0.00,80.00,8174,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679735531182934.jpg\" title=\"1679735531182934.jpg\" alt=\"fa99b6882da9b6499dcce1176fad87a.jpg\"/></p>',1679735534,1685003017,1685003017),(53,5,1,'小香菱格羊皮鱼子酱方胖子 CF链条迷你小球纹口盖包单肩女包','/uploads/upload/admin/2023/03/25/406f1086487f762b56ce7b2371d0d824.jpeg',1288.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679750024765631.jpg\" title=\"1679750024765631.jpg\" alt=\"93323839966951257.jpg\"/></p>',1679750047,1679846343,1679846343),(54,3,2,'阿玛尼手表女满天星时尚镶钻钢带防水女士石英表','/uploads/upload/admin/2023/03/28/3173f226d820bc80934037cf903ff2ed.png',1180.00,0.20,0.20,0.00,0.00,19,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679750335725294.jpg\" title=\"1679750335725294.jpg\" alt=\"微信图片_20230325211703.jpg\"/></p>',1679750338,1685015028,1685015028),(55,3,2,'华为手表智能运动男女款闪变换壳蓝牙通话血氧监测','/uploads/upload/admin/2023/03/28/3750b3052f35116148c846ed7ec6ca27.png',1888.00,0.20,0.20,0.00,0.00,20,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679750675923290.jpg\" title=\"1679750675923290.jpg\" alt=\"微信图片_20230325212340.jpg\"/></p>',1679750678,1685015028,1685015028),(56,5,2,'女爵流行新款纯色质感斜挎包单肩手提小方包','/uploads/upload/admin/2023/03/25/6530eaa5572b7082a78c4df460b7a86f.jpeg',129.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679750695682915.jpg\" title=\"1679750695682915.jpg\" alt=\"微信图片_20230325212307.jpg\"/></p>',1679750765,1679846315,1679846315),(57,3,1,'Apple Watch Series S8 新款运动智能手表','/uploads/upload/admin/2023/03/28/ba5690fb57c33eca95efc1b9ea9b6cf8.png',3686.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679751279512134.jpg\" title=\"1679751279512134.jpg\" alt=\"微信图片_20230325213207.jpg\"/></p>',1679751303,1685015028,1685015028),(58,5,2,'复古风几何印花新款手机包','/uploads/upload/admin/2023/03/25/f38a74182035f402467a2c9ce4c4a216.jpeg',88.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679751386445778.jpg\" title=\"1679751386445778.jpg\" alt=\"微信图片_20230325213423.jpg\"/></p>',1679751403,1679846319,1679846319),(59,3,1,'Apple Watch Series 8红色铝金属表壳','/uploads/upload/admin/2023/03/28/85fe4d885b9717a813984afc35bd666e.png',4599.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679751529594017.jpg\" title=\"1679751529594017.jpg\" alt=\"微信图片_20230325213635.jpg\"/></p>',1679751531,1685015028,1685015028),(60,3,1,'Jordan耐克乔丹AJ5男子运动鞋春新款缓震透气轻便','/uploads/upload/admin/2023/03/28/c169eb381afae482627625b7f4b60222.png',1980.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679751841291144.jpg\" title=\"1679751841291144.jpg\" alt=\"微信图片_20230325214248.jpg\"/></p>',1679751845,1685015028,1685015028),(61,5,2,'小包包2023女生手机包吊饰珍珠零钱小包包','/uploads/upload/admin/2023/03/25/4cc3ee1fa7d00dbdef22a2f21bac93b1.jpeg',127.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679752058215884.jpg\" title=\"1679752058215884.jpg\" alt=\"微信图片_20230325214252.jpg\"/></p>',1679752084,1679846321,1679846321),(62,3,2,'Air Jordan 3 AJ3白灰 白水泥 复古篮球鞋','/uploads/upload/admin/2023/03/28/f54f7bf533d31a46aa77e8b8ef40620d.png',1238.00,0.20,0.20,0.00,0.00,20,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679752261807281.png\" title=\"1679752261807281.png\" alt=\"微信图片_20230325214911.png\"/></p>',1679752264,1685015028,1685015028),(63,3,2,'Air Jordan 4 Zen AJ4 紫星空 篮球鞋','/uploads/upload/admin/2023/03/28/cc431f29e40814155c9a578aedf3a407.png',1680.00,0.20,0.20,0.00,0.00,20,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679752497712678.jpg\" title=\"1679752497712678.jpg\" alt=\"微信图片_20230325215341.jpg\"/></p>',1679752500,1685015028,1685015028),(64,3,2,'Air Jordan AJ1祖母绿男低帮运动休闲篮球鞋','/uploads/upload/admin/2023/03/28/56469f86fee565ece5abb9d92112f2af.png',1630.00,0.20,0.20,0.00,0.00,20,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679752701458023.jpg\" title=\"1679752701458023.jpg\" alt=\"微信图片_20230325215743.jpg\"/></p>',1679752725,1685015028,1685015028),(65,3,2,'Air Jordan 1 AJ1 黑白红芝加哥休闲低帮球鞋','/uploads/upload/admin/2023/03/28/062dfa746e9411433e855af26269eeac.png',1086.00,0.20,0.20,0.00,0.00,20,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679752897132913.jpg\" title=\"1679752897132913.jpg\" alt=\"微信图片_20230325220056.jpg\"/></p>',1679752900,1685015028,1685015028),(66,3,2,'空军一号AF1新款国潮中国风二次元黑白低帮情侣鞋','/uploads/upload/admin/2023/03/28/f9fba28dd108f65d3bbe6cde4e3ed858.png',1500.00,0.20,0.20,0.00,0.00,20,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679753077726480.jpg\" title=\"1679753077726480.jpg\" alt=\"微信图片_20230325220329.jpg\"/></p>',1679753080,1685015028,1685015028),(67,3,3,'新款黑武士手表男士全自动机械正品防水夜光男表','/uploads/upload/admin/2023/03/28/107f29152131d3eb511b74c9290a01c9.png',68.00,19.00,19.00,0.00,0.00,1876,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679754819940346.jpg\" title=\"1679754819940346.jpg\" alt=\"微信图片_20230325223227.jpg\"/></p>',1679754822,1685015016,1685015016),(68,3,3,'爆款慕迪男士手表时尚石英表商务防水学生表','/uploads/upload/admin/2023/03/28/f5f8be988f7d957f3fb3f37de0bef4e0.png',99.00,19.00,19.00,0.00,0.00,1875,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679755030689690.jpg\" title=\"1679755030689690.jpg\" alt=\"微信图片_20230325223617.jpg\"/></p>',1679755033,1685015016,1685015016),(69,3,3,'新款绿水怪水鬼成人男士手表全自动机械男表','/uploads/upload/admin/2023/03/28/4e8ff9ee9cb031678e382c2a7974f9e0.png',106.00,19.00,19.00,0.00,0.00,1866,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679755275777167.jpg\" title=\"1679755275777167.jpg\" alt=\"微信图片_20230325224022.jpg\"/></p>',1679755276,1685015016,1685015016),(70,3,4,'休闲时尚个性创意赛车石英表','/uploads/upload/admin/2023/03/28/237c70deb1fd3ae744cda5bbe69028a3.png',18.88,80.70,80.70,0.00,0.00,7899,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679755520377822.jpg\" title=\"1679755520377822.jpg\" alt=\"微信图片_20230325224339.jpg\"/></p>',1679755473,1685015016,1685015016),(71,3,3,'包头帆布半拖鞋男夏季新款网红爆款小白鞋百搭一脚蹬懒人拖鞋','/uploads/upload/admin/2023/03/28/d53439d6197ceb262e1c6729e057ba98.png',58.00,19.00,19.00,0.00,0.00,1877,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679755670305472.jpg\" title=\"1679755670305472.jpg\" alt=\"微信图片_20230325224638.jpg\"/></p>',1679755657,1685015016,1685015016),(72,3,3,'2023春季新款透气休闲百搭男鞋子韩','/uploads/upload/admin/2023/03/28/4949cac68186c553add2c02084e14740.png',138.00,19.00,19.00,0.00,0.00,1874,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679755857646923.jpg\" title=\"1679755857646923.jpg\" alt=\"微信图片_20230325224939.jpg\"/></p>',1679755860,1685015016,1685015016),(73,3,4,'男士运动鞋2023春季新款潮流休闲鞋跑步鞋','/uploads/upload/admin/2023/03/28/611de54f1aa19dfcc6b970dbc3a9c5b8.png',18.88,80.70,80.70,0.00,0.00,7898,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679756067686014.jpg\" title=\"1679756067686014.jpg\" alt=\"微信图片_20230325225335.jpg\"/></p>',1679756069,1685015016,1685015016),(74,3,4,'春季潮休闲鞋韩版情侣运动休闲跑步鞋','/uploads/upload/admin/2023/03/28/effd6968c85dda964e0574c5d4b75d3e.png',26.88,80.70,80.70,0.00,0.00,7899,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679756490569467.jpg\" title=\"1679756490569467.jpg\" alt=\"微信图片_20230325230057.jpg\"/></p>',1679756492,1685015016,1685015016),(75,3,4,'春夏网鞋男士休闲男鞋潮流飞织鞋','/uploads/upload/admin/2023/03/28/4faec17a4fb38cf316011f1d1a8a8375.png',28.00,80.70,80.70,0.00,0.00,7893,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679756659121629.jpg\" title=\"1679756659121629.jpg\" alt=\"微信图片_20230325230328.jpg\"/></p>',1679756663,1685015016,1685015016),(76,3,4,'防水电子手表 多功能彩灯手表','/uploads/upload/admin/2023/03/28/8d84b548d37de221db7417920b134e9d.png',36.88,80.70,80.70,0.00,0.00,7898,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679757120871645.jpg\" title=\"1679757120871645.jpg\" alt=\"微信图片_20230325231118.jpg\"/></p>',1679757123,1685015016,1685015016),(77,2,1,'CHANEL 香奈儿蔚蓝男士香水系列 木质芳香调持久留香','/uploads/upload/admin/2023/03/28/4a37ad21b75488320729da69a8812ccf.png',1380.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679758982463220.jpg\" title=\"1679758982463220.jpg\" alt=\"200fa16eb9cdc61665d155184e64e01.jpg\"/></p>',1679758985,1684964501,1684964501),(78,2,1,'CHANEL 香奈儿邂逅系列香水 粉瓶绿瓶持久女士淡香氛','/uploads/upload/admin/2023/03/28/d1a1503fb0d037cb9c59a9a21218d309.png',1560.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679759738892156.jpg\" title=\"1679759738892156.jpg\" alt=\"8983d6886d911d8a9186c1469729c94.jpg\"/></p>',1679759266,1684964501,1684964501),(79,2,1,'CHANEL 香奈儿嘉柏丽尔天性香水 持久留香花香调香氛','/uploads/upload/admin/2023/03/28/48f6e6ca0e2dcb4195e9eacad25cc07e.png',1828.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/25/1679759395653670.jpg\" title=\"1679759395653670.jpg\" alt=\"eb3dd090c0cd05df540697669fcdfa6.jpg\"/></p>',1679759397,1684964501,1684964501),(80,2,1,'圣罗兰反转巴黎女士淡香水50ml失魂果持久清新留香浓香EDP','/uploads/upload/admin/2023/03/28/be008f572b8a2a8c729a3e6d6a1fd0e4.png',1068.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679760028459788.jpg\" title=\"1679760028459788.jpg\" alt=\"88681b5ccb5e77d1328b926cc44f36e.jpg\"/></p>',1679760031,1684964501,1684964501),(81,2,1,'圣罗兰黑鸦片女士浓香EDP持久清新花香水','/uploads/upload/admin/2023/03/28/88432a72b5c17852ef59ef7bcdf983a9.png',888.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679760315979189.jpg\" title=\"1679760315979189.jpg\" alt=\"7e0be2d70c52910bcb32212bb8ae564.jpg\"/></p>',1679760349,1684964501,1684964501),(82,2,1,'限量YSL圣罗兰口红1966套盒全套礼盒装正品套装杨树林','/uploads/upload/admin/2023/03/28/9aa59a8f0303da6baace0fd59b605d97.png',1690.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679760625998342.jpg\" title=\"1679760625998342.jpg\" alt=\"84a6842eb65ded4deb18da81439d446.jpg\"/></p>',1679760631,1684964501,1684964501),(83,2,1,'YSL圣罗兰小金条小黑条口红礼盒套装 黑皮革气垫礼物1966','/uploads/upload/admin/2023/03/28/b3a014e4e830851de21b0cf7b38c2bb1.png',888.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679760875360751.jpg\" title=\"1679760875360751.jpg\" alt=\"05ad5a8bcd5234cd13ca91679f4062b.jpg\"/></p>',1679760878,1684964501,1684964501),(84,2,1,'DIOR迪奥烈艳蓝金唇膏高顶套装限量口红情人节','/uploads/upload/admin/2023/03/28/5350e515170ccd002cbdf0a7ad16647e.png',1718.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679761386879240.jpg\" title=\"1679761386879240.jpg\" alt=\"68220d6a38fcce7da19bb408f9c4355.jpg\"/></p>',1679761389,1684964501,1684964501),(85,2,1,'情人节兰蔻棋盘格限定双支唇膏礼盒口红196香水套盒','/uploads/upload/admin/2023/03/28/36efa76bc331b2a0474d9b81028ef1ac.png',999.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679761875111533.jpg\" title=\"1679761875111533.jpg\" alt=\"微信图片_20230326003020.jpg\"/></p>',1679761877,1684964501,1684964501),(86,2,1,'CL萝卜丁权杖口红黑管三支装限量礼盒套装','/uploads/upload/admin/2023/03/28/d12b049238ac56b6ff0a20451bf83dd2.png',1163.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679762056359296.jpg\" title=\"1679762056359296.jpg\" alt=\"微信图片_20230326003330.jpg\"/></p>',1679762059,1684964501,1684964501),(87,5,2,'新款潮流女包单肩斜挎包小清新时尚小方包','/uploads/upload/admin/2023/03/26/a9fa97e4714f90c514385d9912cff125.jpeg',128.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679762053118684.jpg\" title=\"1679762053118684.jpg\" alt=\"微信图片_20230326002917.jpg\"/></p>',1679762061,1679846324,1679846324),(88,2,2,'Cartier卡地亚 猎豹女士淡香水栀子花香EDT','/uploads/upload/admin/2023/03/28/3eb49d283e5d7517a2181129449e08b6.png',838.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679762278810717.jpg\" title=\"1679762278810717.jpg\" alt=\"c5452246b62bdb10ec7c1128d5374cc.jpg\"/></p>',1679762281,1684964501,1684964501),(89,2,2,'Gucci古驰竹韵竹节bamboo女士正品持久淡浓香水','/uploads/upload/admin/2023/03/28/d8dcc491a038eef6499dc043e8c4acea.png',723.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679762466800585.jpg\" title=\"1679762466800585.jpg\" alt=\"a7ecd92c1dacabe7c76120d362d4f64.jpg\"/></p>',1679762468,1684964501,1684964501),(90,5,2,'款时尚女包布纹转锁小包纯色简约日韩系链条单肩斜跨包','/uploads/upload/admin/2023/03/26/6dd2f367ad45b134a55fa28a6e1fc5ee.jpeg',137.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679762648932819.jpg\" title=\"1679762648932819.jpg\" alt=\"微信图片_20230326004315.jpg\"/></p>',1679762713,1679846327,1679846327),(91,2,2,'卡地亚Déclaration宣言淡香水 中性木质香调 EDT','/uploads/upload/admin/2023/03/28/5b0359e78053119d616af0c3d064abb0.png',760.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679762718592483.jpg\" title=\"1679762718592483.jpg\" alt=\"ad06cb215463b7382906dc3ac88ea9a.jpg\"/></p>',1679762728,1684964501,1684964501),(92,2,2,'迪奥芭伊颂纵情淡香水经典Poison香水女','/uploads/upload/admin/2023/03/28/185300ea291f4d2a91bcf9009afc949f.png',960.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679762881564909.jpg\" title=\"1679762881564909.jpg\" alt=\"7a81d2b88abea3599612ca59c03cc28.jpg\"/></p>',1679762884,1684964501,1684964501),(93,5,2,'2023新款双肩包女韩版时尚印花女背包学生双肩背包','/uploads/upload/admin/2023/03/26/de326745bb00af6ef4b9fddd88bdc225.jpeg',158.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679763164627844.jpg\" title=\"1679763164627844.jpg\" alt=\"微信图片_20230326005107.jpg\"/></p>',1679763180,1679846331,1679846331),(94,2,3,'NOVO六色口红不掉色变色防水','/uploads/upload/admin/2023/03/28/6250eb71a0a13a4a66516494d8723ab6.png',86.00,18.22,18.22,0.00,0.00,1816,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679763654677690.jpg\" title=\"1679763654677690.jpg\" alt=\"2e4274c5111a074c456d4258310e0d1.jpg\"/></p>',1679763657,1684964504,1684964504),(95,2,3,'小提琴三色哑光雾面口红不易掉色易上色','/uploads/upload/admin/2023/03/28/06045e9911e3a0bafd5d7459f025b75a.png',79.99,18.22,18.22,0.00,0.00,1817,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680019038892313.jpg\" title=\"1680019038892313.jpg\" alt=\"1679763795903407.jpg\"/></p>',1679763799,1684964504,1684964504),(96,2,3,'三色口红不易掉色不易沾杯','/uploads/upload/admin/2023/03/28/63972d1579657b2a5a9ca963a5aa1ac1.png',108.00,18.22,18.22,0.00,0.00,1815,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679764013867615.jpg\" title=\"1679764013867615.jpg\" alt=\"0f5a9bf0dbcbd337c13e8064af838b1.jpg\"/></p>',1679764016,1684964504,1684964504),(97,2,3,'香水女士持久淡香','/uploads/upload/admin/2023/03/28/7388522ff0a5ebd174f207a9b496ece3.png',58.00,18.22,18.22,0.00,0.00,1819,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679764428432095.jpg\" title=\"1679764428432095.jpg\" alt=\"2109ac9e71f4610171fd5d89d4474fd.jpg\"/></p>',1679764430,1684964504,1684964504),(98,2,3,'柔情邂逅香水持久淡香清新自然优雅女人味花果香调','/uploads/upload/admin/2023/03/28/54fbdb0f90db5e5cfbe94427ab50ea04.png',68.88,18.22,18.22,0.00,0.00,1813,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679764890967858.jpg\" title=\"1679764890967858.jpg\" alt=\"61d2147fa4a26adf786c911d0eae72d.jpg\"/></p>',1679764900,1684964504,1684964504),(99,2,4,'英皇家正品黑鸦女士香水 持久留香清新自然','/uploads/upload/admin/2023/03/28/38cd2ae03854ecadfc99365bcc63768c.png',28.88,81.57,81.57,0.00,0.00,8123,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679765181180919.jpg\" title=\"1679765181180919.jpg\" alt=\"2904c929212295d6f3d98ac5d272cfe.jpg\"/></p>',1679765183,1684964504,1684964504),(100,2,4,'魅惑之吻女士香水持久淡香清新自然花果香','/uploads/upload/admin/2023/03/28/0f7fabaa17c54c4b38b78c2b264e78c2.png',26.88,81.57,81.57,0.00,0.00,8122,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679765346508210.jpg\" title=\"1679765346508210.jpg\" alt=\"21b57d7c1bb695103c4d358ac1b4913.jpg\"/></p>',1679765348,1684964505,1684964505),(101,2,4,'小金条口红新品 丝绒哑光雾面不易掉色不易沾杯唇膏','/uploads/upload/admin/2023/03/28/5e6d66a8abd222e14851086d29476b65.png',19.88,81.57,81.57,0.00,0.00,8123,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679765779494919.jpg\" title=\"1679765779494919.jpg\" alt=\"a3db667edb94efb4436e1045ed65e60.jpg\"/></p>',1679765781,1684964505,1684964505),(102,2,4,'口红 小金条 杨树林细管口红 哑光雾面方管YSR红棕色保湿','/uploads/upload/admin/2023/03/28/138deb9a4b15d20b30d4cc0aff29cf8d.png',18.88,81.57,81.57,0.00,0.00,8118,NULL,1679766162,1684964505,1684964505),(103,2,4,'杨树林细管口红 哑光雾面方管YSR红棕色','/uploads/upload/admin/2023/03/28/922e637167c402f08fb587f40d7c0c4a.png',20.88,81.57,81.57,0.00,0.00,8122,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679766257762786.jpg\" title=\"1679766257762786.jpg\" alt=\"8f951f1b1cc7caaf6e7e9665687d7c0.jpg\"/></p>',1679766259,1684964505,1684964505),(104,4,1,'Apple/苹果iPhone 14支持移动联通电信5G','/uploads/upload/admin/2023/03/28/7a0da342dcd849f8bcca90bfd327aeb9.png',6300.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679815566203802.jpg\" title=\"1679815566203802.jpg\" alt=\"微信图片_20230326152557.jpg\"/></p>',1679815571,1685003014,1685003014),(105,4,1,'Apple/苹果iPhone 13粉色','/uploads/upload/admin/2023/03/28/d860546bbbb4181dfa2ea267b16747ac.png',4200.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679815925285997.jpg\" title=\"1679815925285997.jpg\" alt=\"微信图片_20230326153114.jpg\"/></p>',1679815929,1685003014,1685003014),(106,4,1,'华为 Mate 40 Pro正品华为mate40pro','/uploads/upload/admin/2023/03/28/304ddba4fc9e336520a22c82240dcbd7.png',4380.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679816340638597.jpg\" title=\"1679816340638597.jpg\" alt=\"微信图片_20230326153754.jpg\"/></p>',1679816344,1685003014,1685003014),(107,4,1,'黑鲨5pro电竞智能手机','/uploads/upload/admin/2023/03/28/2b89214db9f6653628659ddfc1cb6b2b.png',4280.00,0.08,0.07,60.00,80.00,0,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679816576522477.jpg\" title=\"1679816576522477.jpg\" alt=\"微信图片_20230326154219.jpg\"/></p>',1679816582,1685003014,1685003014),(108,4,2,'苹果Apple 苹果手表SE2 GPS款','/uploads/upload/admin/2023/03/28/28fc4a6d1beda68b5e7d6438e944827e.png',2200.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679817052422569.jpg\" title=\"1679817052422569.jpg\" alt=\"微信图片_20230326154900.jpg\"/></p>',1679817057,1685003014,1685003014),(109,4,2,'honor/荣耀Play5T 全网通8+128G 4G','/uploads/upload/admin/2023/03/28/7291445a1781a4867283edeca71f3e8c.png',1080.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679817397557991.jpg\" title=\"1679817397557991.jpg\" alt=\"微信图片_20230326155607.jpg\"/></p>',1679817405,1685003014,1685003014),(110,4,2,'索尼 WF-1000XM4 真无线蓝牙噪音耳机','/uploads/upload/admin/2023/03/28/e4bf30bf1234d539ef62245c2f5f182e.png',1143.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679818968480501.jpg\" title=\"1679818968480501.jpg\" alt=\"微信图片_20230326162150.jpg\"/><img src=\"/uploads/upload/admin/2023/03/26/1679818974249211.jpg\" title=\"1679818974249211.jpg\" alt=\"微信图片_20230326162153.jpg\"/></p>',1679819001,1685003014,1685003014),(111,4,2,'OPPO K9X 全网通5G手机','/uploads/upload/admin/2023/03/28/038ea746a84a3516d23ed476cba5dd51.png',1220.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679819113129732.jpg\" title=\"1679819113129732.jpg\" alt=\"微信图片_20230326162357.jpg\"/><img src=\"/uploads/upload/admin/2023/03/26/1679819105991273.jpg\" title=\"1679819105991273.jpg\" alt=\"微信图片_20230326162352.jpg\"/></p>',1679819118,1685003014,1685003014),(112,4,2,'X40plus 6+128GB 5G全网通','/uploads/upload/admin/2023/03/28/1af3b760c3cab4dee29b4a33cd337e47.png',1380.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679819168229259.jpg\" title=\"1679819168229259.jpg\" alt=\"微信图片_20230326162530.jpg\"/></p>',1679819172,1685003014,1685003014),(113,4,2,'华为FreeBuds4E无线蓝牙耳机','/uploads/upload/admin/2023/03/28/d43daae462baefce6b2e4cdfff65eac4.png',890.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679819227909677.jpg\" title=\"1679819227909677.jpg\" alt=\"微信图片_20230326162622.jpg\"/><img src=\"/uploads/upload/admin/2023/03/26/1679819231418634.jpg\" title=\"1679819231418634.jpg\" alt=\"微信图片_20230326162625.jpg\"/></p>',1679819236,1685003014,1685003014),(114,4,3,'迷你小钢炮蓝牙音箱','/uploads/upload/admin/2023/03/28/3c839f38e6da8b3f4c265515da961e33.png',58.00,18.00,18.00,0.00,80.00,1796,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820418354168.jpg\" title=\"1679820418354168.jpg\" alt=\"微信图片_20230326164606.jpg\"/></p>',1679820428,1685003014,1685003014),(115,4,3,'i7 TWS 无线蓝牙运动耳塞式耳机','/uploads/upload/admin/2023/03/28/f2bc126572d0df39d9229e937534133f.png',44.00,18.00,18.00,0.00,0.00,1799,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820467754382.jpg\" title=\"1679820467754382.jpg\" alt=\"微信图片_20230326164720.jpg\"/></p>',1679820471,1685003014,1685003014),(116,4,3,'创意无线蓝牙音箱镜面时钟闹钟','/uploads/upload/admin/2023/03/28/773896156d5baba4749a3e2ed35ee52a.png',45.00,18.00,18.00,0.00,0.00,1793,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820520783374.jpg\" title=\"1679820520783374.jpg\" alt=\"微信图片_20230326164802.jpg\"/><img src=\"/uploads/upload/admin/2023/03/26/1679820536967509.jpg\" title=\"1679820536967509.jpg\" alt=\"微信图片_20230326164804.jpg\"/></p>',1679820544,1685003014,1685003014),(117,6,1,'ka复联4反浩克装甲可装载钢铁侠合金手办','/uploads/upload/admin/2023/03/28/83dcf62e2de7628d09843a75f7c14d4c.png',1680.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820552231330.jpg\" title=\"1679820552231330.jpg\" alt=\"微信图片_20230326164618.jpg\"/></p>',1679820556,1685042810,1685042810),(118,6,1,'千手万代黑金印花MG红异端改迷惘电镜高达拼装模型','/uploads/upload/admin/2023/03/28/1825eec85194e87315fe11e9438486e6.png',1888.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820633770034.jpg\" title=\"1679820633770034.jpg\" alt=\"微信图片_20230326164940.jpg\"/></p>',1679820636,1685042810,1685042810),(119,4,3,'充电宝5000毫安自带线快充','/uploads/upload/admin/2023/03/28/754214ba98cf751ea99c1c3e4728d209.png',38.00,18.00,18.00,0.00,0.00,1798,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820639758914.jpg\" title=\"1679820639758914.jpg\" alt=\"微信图片_20230326164941.jpg\"/></p>',1679820658,1685003014,1685003014),(120,6,1,'美杜莎手办1/4雕像幕后旋律动漫模型艺术摆件私人定制GK','/uploads/upload/admin/2023/03/28/331ce91272978e8e9e321869a91965ea.png',3680.00,0.07,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820700243678.jpg\" title=\"1679820700243678.jpg\" alt=\"微信图片_20230326165056.jpg\"/></p>',1679820712,1685042810,1685042810),(121,6,1,'MegaHouse WA路飞太郎 和之国 海贼航海王再版','/uploads/upload/admin/2023/03/28/99675c4f5d6769078104805b77548816.png',1260.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820794526474.jpg\" title=\"1679820794526474.jpg\" alt=\"微信图片_20230326165215.jpg\"/></p>',1679820809,1685042810,1685042810),(122,6,1,'动漫海贼王手办模型路飞索隆玩偶七武海艾斯乔巴','/uploads/upload/admin/2023/03/28/40a037bc53c1f4ad3b0582864cd34908.png',1030.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820890673680.jpg\" title=\"1679820890673680.jpg\" alt=\"微信图片_20230326165351.jpg\"/></p>',1679820893,1685042810,1685042810),(123,6,1,'暴力熊大摆件空山基积木熊公仔潮玩手办','/uploads/upload/admin/2023/03/28/722be979a173a7e601288f0d8d7fad6b.png',2860.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679820966973052.jpg\" title=\"1679820966973052.jpg\" alt=\"微信图片_20230326165514.jpg\"/></p>',1679820968,1685042810,1685042810),(124,6,1,'星际熊冰雪单板滑雪手办吉祥物潮玩纪念品手办运动会','/uploads/upload/admin/2023/03/28/63a81d2e83a60c38e9295cab9d1b92d9.png',1180.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821050218232.jpg\" title=\"1679821050218232.jpg\" alt=\"微信图片_20230326165644.jpg\"/></p>',1679821053,1685042810,1685042810),(125,6,2,'湘北集结 ARK 超大GK模型樱木花道流川枫三井寿','/uploads/upload/admin/2023/03/28/bac00242f963e731b4c83b7a30b80e0c.png',688.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821133767331.jpg\" title=\"1679821133767331.jpg\" alt=\"微信图片_20230326165800.jpg\"/></p>',1679821166,1685042810,1685042810),(126,6,2,'复仇者联盟2钢铁侠MK44反浩克绿巨人套装甲手办','/uploads/upload/admin/2023/03/28/f68cecf3c91b39cb79560bb9f8c12a7a.png',810.00,0.13,0.13,0.00,0.00,12,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821256611764.jpg\" title=\"1679821256611764.jpg\" alt=\"微信图片_20230326165951.jpg\"/></p>',1679821259,1685042810,1685042810),(127,6,2,'黑Saber摩托 阿尔托莉雅 黑呆 新宿 手办','/uploads/upload/admin/2023/03/28/8d0fdae6cc9153becce7e49f190e247a.png',378.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821317203675.jpg\" title=\"1679821317203675.jpg\" alt=\"微信图片_20230326170117.jpg\"/></p>',1679821319,1685042810,1685042810),(128,4,4,'粉色渐变镭射卡通适用iPhone14内','/uploads/upload/admin/2023/03/28/ee644f2ce9e500fb3759c77c8a10fc7c.png',25.00,81.80,81.80,0.00,80.00,8172,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821395575517.jpg\" title=\"1679821395575517.jpg\" alt=\"微信图片_20230326170246.jpg\"/></p>',1679821399,1685003017,1685003017),(129,6,2,'黑曼巴 放大合金版 LS-06坦克威司令官变形可动手办模型','/uploads/upload/admin/2023/03/28/782cae429300c13bcc972438b1a3776f.png',330.00,0.13,0.13,0.00,0.00,12,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821407967368.jpg\" title=\"1679821407967368.jpg\" alt=\"微信图片_20230326170213.jpg\"/></p>',1679821409,1685042810,1685042810),(130,4,4,'锌合金超级快充极客数据线','/uploads/upload/admin/2023/03/28/a783e1596f081e130cdabafa960bd18e.png',28.00,81.80,81.80,0.00,80.00,8175,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821443253699.jpg\" title=\"1679821443253699.jpg\" alt=\"微信图片_20230326170328.jpg\"/></p>',1679821447,1685003017,1685003017),(131,6,2,'火影忍者CS 六代目火影 旗木卡卡西 拷贝忍者 GK手办模型','/uploads/upload/admin/2023/03/28/dfe7164c7aee48b4ca9110766dae4374.png',480.00,0.13,0.13,0.00,0.00,12,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821522764403.jpg\" title=\"1679821522764403.jpg\" alt=\"微信图片_20230326170430.jpg\"/></p>',1679821526,1685042810,1685042810),(132,4,4,'金属小钢炮迷你蓝牙音响','/uploads/upload/admin/2023/03/28/990a7e0a64ed5394edf60a376657239e.png',28.00,81.80,81.80,0.00,0.00,8171,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821539107317.jpg\" title=\"1679821539107317.jpg\" alt=\"微信图片_20230326170418.jpg\"/></p>',1679821543,1685003017,1685003017),(133,4,4,'S109蓝牙爆款商务单耳蓝牙','/uploads/upload/admin/2023/03/28/0ef2d2d87915581eef4aad54e6650b9b.png',27.00,81.80,81.80,0.00,0.00,8163,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821582337161.jpg\" title=\"1679821582337161.jpg\" alt=\"微信图片_20230326170552.jpg\"/></p>',1679821586,1685003017,1685003017),(134,6,2,'APEX-TOYS 英雄联盟 源计划 艾希 寒冰射手 可动','/uploads/upload/admin/2023/03/28/927e6f102ad0e504a9aafd6fbc2973b3.png',1080.00,0.13,0.13,0.00,0.00,13,NULL,1679821592,1685042810,1685042810),(135,6,1,'变形大黄蜂金刚擎天之柱模型手办合金版机器人','/uploads/upload/admin/2023/03/28/7b9988ff0200b00c7d94506aa706961b.png',1068.00,0.07,0.07,0.00,0.00,7,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679821741387015.jpg\" title=\"1679821741387015.jpg\" alt=\"微信图片_20230326170806.jpg\"/></p>',1679821745,1685042810,1685042810),(136,6,2,'正版24号科比手办限量版生日礼物','/uploads/upload/admin/2023/03/28/4ffe703e06a53cc98d83df1cf535783f.png',724.00,0.13,0.13,0.00,0.00,13,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679822691844707.jpg\" title=\"1679822691844707.jpg\" alt=\"微信图片_20230326172345.jpg\"/></p>',1679822693,1685042810,1685042810),(137,6,2,'钢铁侠模型美国队长摆件复仇者联盟手办','/uploads/upload/admin/2023/03/28/494321c59846227a1732af4625ee8312.png',680.00,0.13,0.13,0.00,0.00,12,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679822791624111.jpg\" title=\"1679822791624111.jpg\" alt=\"微信图片_20230326172516.jpg\"/></p>',1679822794,1685042810,1685042810),(138,6,3,'火影手办忍者 GK 宇智波斑 六道斑 雕像可换头','/uploads/upload/admin/2023/03/28/f0e70d70907d3cd43c62d585e7a0f351.png',66.88,18.00,18.00,0.00,0.00,1780,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679823595249766.jpg\" title=\"1679823595249766.jpg\" alt=\"微信图片_20230326173843.jpg\"/></p>',1679823597,1685042820,1685042820),(139,6,3,'海贼王 手办 九蛇女帝 王蛇姬 汉库克 踢腿','/uploads/upload/admin/2023/03/28/dc79b4215e031d62c9a323dde66ace06.png',77.00,18.00,18.00,0.00,0.00,1772,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679823653960186.jpg\" title=\"1679823653960186.jpg\" alt=\"微信图片_20230326174009.jpg\"/></p>',1679823655,1685042810,1685042810),(140,6,3,'七龙珠20周年纪念版孙悟空手办摆件 拿棍悟空动漫模型','/uploads/upload/admin/2023/03/28/114d1f67f1ca33fe1799b33a292ff5e1.png',83.00,18.00,18.00,0.00,0.00,1778,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679823748791500.jpg\" title=\"1679823748791500.jpg\" alt=\"微信图片_20230326174120.jpg\"/></p>',1679823750,1685042810,1685042810),(141,6,4,'鬼灭之刃手办动漫盒装','/uploads/upload/admin/2023/03/28/35ae8238f27d506e6f17a806682b9fb0.png',26.00,81.80,81.80,0.00,0.00,8006,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679823814802913.jpg\" title=\"1679823814802913.jpg\" alt=\"微信图片_20230326174256.jpg\"/></p>',1679823816,1685042820,1685042820),(142,6,4,'火影忍者手办Q版坐姿卡卡西佐助车载摆件','/uploads/upload/admin/2023/03/28/5cfa29afe79190e42bf28a8422aa0e1b.png',18.88,81.80,81.80,0.00,0.00,8005,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679823873691528.jpg\" title=\"1679823873691528.jpg\" alt=\"微信图片_20230326174352.jpg\"/></p>',1679823876,1685042820,1685042820),(143,6,4,'七龙珠手办模型 武道会7 布罗利站姿','/uploads/upload/admin/2023/03/26/434017121c30fa0cdf0dbe9d3ee747f8.jpeg',23.88,80.00,80.00,0.00,0.00,8000,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679823946522454.jpg\" title=\"1679823946522454.jpg\" alt=\"微信图片_20230326174455.jpg\"/></p>',1679823948,1679825562,1679825562),(144,6,4,'正版授权宇航员创意摆件手办模型','/uploads/upload/admin/2023/03/28/4daa58b777fca47f2e388f9871c1b030.png',23.00,81.80,81.80,0.00,0.00,8006,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679824598727806.jpg\" title=\"1679824598727806.jpg\" alt=\"微信图片_20230326175603.jpg\"/></p>',1679824604,1685042820,1685042820),(145,6,3,'鬼灭之刃灶弥祢豆子女动漫手办周边二次元机箱模型','/uploads/upload/admin/2023/03/28/f90c95ea1f37563080dfbebd9e2ad5bc.png',86.00,18.00,18.00,0.00,0.00,1767,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679824685386930.jpg\" title=\"1679824685386930.jpg\" alt=\"微信图片_20230326175657.jpg\"/></p>',1679824690,1685042810,1685042810),(146,6,3,'NBA球星手办科比詹姆斯篮球球星萌神模型人偶摆件玩具','/uploads/upload/admin/2023/03/28/1bdf0f87f499efacb1929e993d58c150.png',76.00,18.00,18.00,0.00,0.00,1777,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679824882395838.jpg\" title=\"1679824882395838.jpg\" alt=\"微信图片_20230326180031.jpg\"/></p>',1679824885,1685042810,1685042810),(147,6,4,'斗罗大陆手办摆件唐三公仔模型','/uploads/upload/admin/2023/03/28/b432d4c3307f5dfd620880a038a9106d.png',18.88,81.80,81.80,0.00,0.00,8006,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679825111482778.jpg\" title=\"1679825111482778.jpg\" alt=\"微信图片_20230326180431.jpg\"/></p>',1679825114,1685042820,1685042820),(148,7,1,'德国NICI泰迪熊毛绒玩具抱抱熊大号','/uploads/upload/admin/2023/03/28/c94ddf665d7fe3e4f479053cfaa17d26.png',1080.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826026262505.jpg\" title=\"1679826026262505.jpg\" alt=\"微信图片_20230326182010.jpg\"/></p>',1679826051,1679992527,NULL),(149,6,4,'孙悟空手办玩偶齐天大圣西游记树脂摆件工艺品','/uploads/upload/admin/2023/03/28/afdb4462d51916bd00c374e690f0e488.png',18.88,81.80,81.80,0.00,0.00,8007,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826083688159.jpg\" title=\"1679826083688159.jpg\" alt=\"微信图片_20230326182046.jpg\"/></p>',1679826088,1685042820,1685042820),(150,7,1,'可爱猫咪公仔毛绒玩具布娃娃90cm+70cm','/uploads/upload/admin/2023/03/28/b44ad49bf46966008d425921ce5f97a4.png',1580.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826106407751.jpg\" title=\"1679826106407751.jpg\" alt=\"微信图片_20230326182108.jpg\"/></p>',1679826110,1679992468,NULL),(151,7,1,'独角兽公仔布娃娃抱枕女生睡觉抱睡 1.3m','/uploads/upload/admin/2023/03/28/310c244f892c3133fa9551cb3c353a87.png',1480.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826147671836.jpg\" title=\"1679826147671836.jpg\" alt=\"微信图片_20230326182158.jpg\"/></p>',1679826151,1679992454,NULL),(152,7,1,'正版泰迪熊公仔毛绒玩具大熊玩偶睡觉抱枕1.8m','/uploads/upload/admin/2023/03/28/b35da5ef6c89a0e49767a769a1be090b.png',1430.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826189659816.jpg\" title=\"1679826189659816.jpg\" alt=\"微信图片_20230326182239.jpg\"/></p>',1679826194,1679992436,NULL),(153,7,1,'兔子玩偶睡觉抱枕女生布娃娃 1.4m','/uploads/upload/admin/2023/03/28/b4503a8de74d4d25adf2839a417512aa.png',1320.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826230972664.jpg\" title=\"1679826230972664.jpg\" alt=\"微信图片_20230326182320.jpg\"/></p>',1679826234,1679992425,NULL),(154,7,1,'玩偶睡觉抱大粉色兔兔熊 1.6m','/uploads/upload/admin/2023/03/28/8f65720b702a4743d896c4534979f0ae.png',1420.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826270358993.jpg\" title=\"1679826270358993.jpg\" alt=\"微信图片_20230326182400.jpg\"/></p>',1679826275,1679992413,NULL),(155,7,1,'大号可爱蓝狐本色毛绒公仔真毛','/uploads/upload/admin/2023/03/28/9a2422c7f238ea7e84d57ce54c919a0e.png',1250.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826321789929.jpg\" title=\"1679826321789929.jpg\" alt=\"微信图片_20230326182445.jpg\"/></p>',1679826325,1679992344,NULL),(156,7,1,'大章鱼公仔巨大懒人沙发 1.6m','/uploads/upload/admin/2023/03/28/59c16f22b1060fc59ed80198468d3091.png',1320.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826394600320.jpg\" title=\"1679826394600320.jpg\" alt=\"微信图片_20230326182535.jpg\"/></p>',1679826398,1679992312,NULL),(157,7,2,'熊熊毛绒玩具抱抱熊泰 1m','/uploads/upload/admin/2023/03/28/60f31748bc3244d5a06208bec3069b2d.png',890.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826448872878.jpg\" title=\"1679826448872878.jpg\" alt=\"微信图片_20230326182649.jpg\"/></p>',1679826452,1679992678,NULL),(158,7,2,'兔娃娃玩偶毛绒玩具睡觉抱枕 60cm','/uploads/upload/admin/2023/03/28/d51fbc3b043619a3afcc7750f1c04393.png',850.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826495536904.jpg\" title=\"1679826495536904.jpg\" alt=\"微信图片_20230326182747.jpg\"/></p>',1679826501,1679992665,NULL),(159,7,2,'大白鹅抱枕玩偶可爱公仔睡觉鸭 40cm','/uploads/upload/admin/2023/03/28/bfb86905f1c0003dcee1ceadabdcbb1f.png',780.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826546362142.jpg\" title=\"1679826546362142.jpg\" alt=\"微信图片_20230326182829.jpg\"/></p>',1679826551,1679992653,NULL),(160,7,2,'兔娃娃玩偶洛丽塔毛绒玩具小熊公仔35cm','/uploads/upload/admin/2023/03/28/250e98671c795b7473c585091baa55bb.png',730.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826597402633.jpg\" title=\"1679826597402633.jpg\" alt=\"微信图片_20230326182920.jpg\"/></p>',1679826601,1679992641,NULL),(161,7,2,'伽百利Gabriel毛绒玩具超大兔子公仔抱枕 50cm','/uploads/upload/admin/2023/03/28/ab79ffa1878eaa8c059507e1198bac83.png',690.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826635168909.jpg\" title=\"1679826635168909.jpg\" alt=\"微信图片_20230326183007.jpg\"/></p>',1679826638,1679992628,NULL),(162,7,2,'可爱泰迪熊毛绒玩具熊公仔抱抱熊 65cm','/uploads/upload/admin/2023/03/28/4ef2bf096094b28c927276c1e599f55c.png',620.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826679835961.jpg\" title=\"1679826679835961.jpg\" alt=\"微信图片_20230326183045.jpg\"/></p>',1679826684,1679992614,NULL),(163,7,2,'泰迪熊公仔毛绒玩具大熊抱抱熊 60cm','/uploads/upload/admin/2023/03/28/ebfd4bc84e5238c43215cba9a26d728c.png',610.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826799510080.jpg\" title=\"1679826799510080.jpg\" alt=\"微信图片_20230326183131.jpg\"/></p>',1679826805,1679992599,NULL),(164,7,2,'Bunnies小羊抱枕女生睡觉夹腿床上沙发 45cm','/uploads/upload/admin/2023/03/28/12457c8108c43b90180449130f4c8796.png',590.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826852471059.jpg\" title=\"1679826852471059.jpg\" alt=\"微信图片_20230326183339.jpg\"/></p>',1679826855,1679992572,NULL),(165,7,3,'大白鹅公仔毛绒玩具抱枕 50cm','/uploads/upload/admin/2023/03/28/7409fc6b499982e95525cfeb17d89ab9.png',68.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826906274953.jpg\" title=\"1679826906274953.jpg\" alt=\"微信图片_20230326183429.jpg\"/></p>',1679826910,1679992752,NULL),(166,7,3,'真香蕉卡通睡觉抱枕毛绒玩具 35cm','/uploads/upload/admin/2023/03/28/8de0f39796375681ee2ae822dabaefe7.png',58.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826948968816.jpg\" title=\"1679826948968816.jpg\" alt=\"微信图片_20230326183523.jpg\"/></p>',1679826953,1679992738,NULL),(167,7,3,'鲨鱼抱枕毛绒玩具布娃娃 30cm','/uploads/upload/admin/2023/03/28/7feaccdbb82d27cf47362b78d2eb852a.png',52.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679826988432301.jpg\" title=\"1679826988432301.jpg\" alt=\"微信图片_20230326183603.jpg\"/></p>',1679826992,1679992726,NULL),(168,7,3,'可爱彩虹独角兽公仔毛绒玩具 30cm','/uploads/upload/admin/2023/03/28/0f0ea9e37ef796574556c6f7de238b1f.png',48.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679827032857271.jpg\" title=\"1679827032857271.jpg\" alt=\"微信图片_20230326183648.jpg\"/></p>',1679827036,1679992709,NULL),(169,7,3,'牛油果玩偶水果娃娃公仔 30cm','/uploads/upload/admin/2023/03/28/6e71e933c6a72e1a8200c60928550d35.png',53.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679827070607219.jpg\" title=\"1679827070607219.jpg\" alt=\"微信图片_20230326183725.jpg\"/></p>',1679827074,1679992696,NULL),(170,7,4,'鳄鱼趴趴抱枕毛绒玩具 40cm','/uploads/upload/admin/2023/03/28/2dfd8182862a9f159537703b3c12617f.png',30.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679827121113960.jpg\" title=\"1679827121113960.jpg\" alt=\"微信图片_20230326183809.jpg\"/></p>',1679827125,1679992808,NULL),(171,7,4,'创意可爱表情包毛绒玩具 32cm','/uploads/upload/admin/2023/03/28/4de1d51fa5eaec4afafaf8e416c7a523.png',25.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679827161823983.jpg\" title=\"1679827161823983.jpg\" alt=\"微信图片_20230326183857.jpg\"/></p>',1679827165,1679992797,NULL),(172,7,4,'网红抖音翻转章鱼抱枕公仔 20cm','/uploads/upload/admin/2023/03/28/0bef40ae68479e6a22ecca8874f6567d.png',24.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679827201560429.jpg\" title=\"1679827201560429.jpg\" alt=\"微信图片_20230326183936.jpg\"/></p>',1679827206,1679992787,NULL),(173,7,4,'糖果暴力熊加礼品盒泰迪熊 25cm','/uploads/upload/admin/2023/03/28/7fd06e9c2548572519d7501e67533c2a.png',23.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679827245472178.jpg\" title=\"1679827245472178.jpg\" alt=\"微信图片_20230326184016.jpg\"/></p>',1679827250,1679992773,NULL),(174,7,4,'创意原神史莱姆抱枕 10cm','/uploads/upload/admin/2023/03/28/955cd2a955ca38565bc1fc97b510d3be.png',23.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/26/1679827287440255.jpg\" title=\"1679827287440255.jpg\" alt=\"微信图片_20230326184057.jpg\"/></p>',1679827291,1679992764,NULL),(175,5,2,'轻奢品牌女包真皮单肩包高级感链条斜挎小方包女','/uploads/upload/admin/2023/03/28/3e67967728fde3f184ff37074d16bde4.png',690.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856352435451.jpg\" title=\"1679856352435451.jpg\" alt=\"0069f3934cb6fd552ec01151527ee1e.jpg\"/></p>',1679856353,1685036641,1685036641),(176,5,2,'轻奢品牌包包女新款时尚兔子设计斜挎包高级感真皮单肩小方包','/uploads/upload/admin/2023/03/28/49f40f0cb31177fbfcc6ac64edd3fe32.png',790.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856409229694.jpg\" title=\"1679856409229694.jpg\" alt=\"7c8331933e53370f952d7489a9e1a6a.jpg\"/></p>',1679856420,1685036641,1685036641),(177,5,2,'正品名牌女包高端奢侈品时尚大牌真皮单肩斜挎小方包','/uploads/upload/admin/2023/03/28/58b83dc4e194f9c9cbdc68eff99f8641.png',768.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856456419943.jpg\" title=\"1679856456419943.jpg\" alt=\"47601515c7caaa79bfdff744a1d8920.jpg\"/></p>',1679856457,1685036641,1685036641),(178,5,2,'爱心包2023新款高质感小香风菱格链条包时尚斜挎单肩腋下包','/uploads/upload/admin/2023/03/28/3cadbb5b6091049e347f45b76fc1330a.png',758.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856520353389.jpg\" title=\"1679856520353389.jpg\" alt=\"605ad093f55b200480befa4dad757ae.jpg\"/></p>',1679856521,1685036641,1685036641),(179,5,2,'名牌菱格百搭单肩时尚真皮斜挎链条小方包','/uploads/upload/admin/2023/03/28/dff978e27790f691cb2d497ccc79ac8a.png',758.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856561683493.jpg\" title=\"1679856561683493.jpg\" alt=\"a2c025aba9732dd91aed89084c3bac8.jpg\"/></p>',1679856562,1685036641,1685036641),(180,5,2,'太阳镜女夏季防紫外线偏光眼镜大圆脸网红时尚韩版墨镜','/uploads/upload/admin/2023/03/28/9d0f73a1873358ab3bb49adbb461ff2f.png',820.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856603515883.jpg\" title=\"1679856603515883.jpg\" alt=\"9ca2b158d1eb1f69fd0dc42aef51a3e.jpg\"/></p>',1679856604,1685036641,1685036641),(181,5,2,'舒曼纯钛无框近视眼镜男可配有度数大脸时尚商务超轻眼睛架','/uploads/upload/admin/2023/03/28/2c06adca3c959df7640cf2583926e4d0.png',788.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856646276425.jpg\" title=\"1679856646276425.jpg\" alt=\"4ae0fb8a223573cceded631b8b6ea36.jpg\"/></p>',1679856647,1685036641,1685036641),(182,5,2,'诗莱尔纯钛半框近视眼镜女士可配有度数时尚高档超轻眼睛架','/uploads/upload/admin/2023/03/28/4992b1c25b291e5d1cc0a3a9134f1de8.png',673.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856693868697.jpg\" title=\"1679856693868697.jpg\" alt=\"7f0824fe838f200a688ab3d3268a80d.jpg\"/></p>',1679856695,1685036641,1685036641),(183,5,2,'OAKLEY欧克利眼镜架','/uploads/upload/admin/2023/03/28/285020c4f198343a3415d722f5cf6f60.png',740.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856731894600.jpg\" title=\"1679856731894600.jpg\" alt=\"a29bf66785ab4717ff3d9a59d7c7ae7.jpg\"/></p>',1679856732,1685036641,1685036641),(184,5,2,'LOHO超轻钛近视眼镜框文艺复古小框可配度数镜架配近视女','/uploads/upload/admin/2023/03/28/1af84464525c02a772440d2df4eb4d4f.png',799.00,0.90,0.90,0.00,0.00,90,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856768391921.jpg\" title=\"1679856768391921.jpg\" alt=\"a8850dc1a9031f9723cbc140f53d1c7.jpg\"/></p>',1679856769,1685036641,1685036641),(185,5,1,'默守女士包包单肩斜挎包真皮女包','/uploads/upload/admin/2023/03/28/637b02e637baefb080d5224eed7c88d2.png',1688.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856907446568.jpg\" title=\"1679856907446568.jpg\" alt=\"6fc28a29e1ddf0763aa33b63ae8d70c.jpg\"/></p>',1679856908,1685036641,1685036641),(186,5,1,'YOL7轻奢女包高级感复古小方包小众时尚单肩斜挎包','/uploads/upload/admin/2023/03/28/13548e08cc2c3ce50c296b5010b430e7.png',1580.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856940645350.jpg\" title=\"1679856940645350.jpg\" alt=\"29fb6761473594a27a31ca646b5d0f7.jpg\"/></p>',1679856941,1685036641,1685036641),(187,5,1,'YOL7轻奢高级感包包妈妈手提包女斜挎','/uploads/upload/admin/2023/03/28/285db246841c4d145528e4d9247d379d.png',1839.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679856993721740.jpg\" title=\"1679856993721740.jpg\" alt=\"372da5e49a20bddcddd44c0722d2fb9.jpg\"/></p>',1679856995,1685036641,1685036641),(188,5,1,'纪诗哲轻奢品牌2023新款单肩斜挎包','/uploads/upload/admin/2023/03/28/6ecdd251b2682c750f5ac937b3779829.png',1558.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679857277639282.jpg\" title=\"1679857277639282.jpg\" alt=\"28a5000812b3aa81131c49c5da5500e.jpg\"/></p>',1679857280,1685036641,1685036641),(189,5,1,'女包新款斜挎包小方包真皮高级感秋冬时尚链条单肩包','/uploads/upload/admin/2023/03/28/959eaf4b65e09c34d731b62c6d3c8e36.png',1501.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679857308242178.jpg\" title=\"1679857308242178.jpg\" alt=\"24109a451dfa161e50f5a8837c19d54.jpg\"/></p>',1679857323,1685036641,1685036641),(190,5,1,'意大利太阳镜女偏光时尚墨镜防晒','/uploads/upload/admin/2023/03/28/0a5e6518205efcb0a538c8084c149c9d.png',1475.00,0.10,0.10,0.00,0.00,10,NULL,1679857363,1685036641,1685036641),(191,5,1,'新款CHANEL香奈儿女士太阳眼镜网红款时尚墨镜方框眼镜链条','/uploads/upload/admin/2023/03/28/21317920e992f089e69bc4500e2e91fb.png',1228.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679857397709541.jpg\" title=\"1679857397709541.jpg\" alt=\"8346dba9dff90ff4623105782292232.jpg\"/></p>',1679857398,1685036641,1685036641),(192,5,1,'东海纯天然水晶眼镜男款老石头墨镜高清养目太阳镜','/uploads/upload/admin/2023/03/28/be3b704178aa0fc594ff96da618ecf83.png',1980.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679857426180084.jpg\" title=\"1679857426180084.jpg\" alt=\"e922e1b3010da677315a622ce5c31d6.jpg\"/></p>',1679857428,1685036641,1685036641),(193,5,1,'DIOR/迪奥女墨镜多边形显瘦太阳镜时尚CD圆脸遮阳男眼镜','/uploads/upload/admin/2023/03/28/ced72960089a4006fa9e6d56d86d47ad.png',1190.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679857456569920.jpg\" title=\"1679857456569920.jpg\" alt=\"60d9d4230902794e13e61a4cc3c0b6e.jpg\"/></p>',1679857457,1685036641,1685036641),(194,5,1,'正品FENDI芬迪墨镜女链条太阳镜方型老花眼镜圆脸多边形防紫','/uploads/upload/admin/2023/03/28/ff66bb761a01e9a5cb28caace996cde4.png',1180.00,0.10,0.10,0.00,0.00,10,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679857494774084.jpg\" title=\"1679857494774084.jpg\" alt=\"932b987268ae5373a83694f82285ee9.jpg\"/></p>',1679857497,1685036641,1685036641),(195,5,4,'腋下包包女新款ladies bag单肩包','/uploads/upload/admin/2023/03/28/27de7f3e73ad7f8f8de0e3b797b2b8fe.png',16.88,80.00,80.00,0.00,0.00,8000,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679858504106389.jpg\" title=\"1679858504106389.jpg\" alt=\"162bc4282d8f27159c1a0d6c2be4d35.jpg\"/></p>',1679858506,1685036645,1685036645),(196,5,4,'果冻包迷你包口红包女士链条时尚单肩斜挎包包','/uploads/upload/admin/2023/03/28/925eed2732801f2d6fdd8274655a69fd.png',20.33,80.00,80.00,0.00,0.00,8000,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679858645897239.jpg\" title=\"1679858645897239.jpg\" alt=\"49e23ff53ff2158722f56d98cc8ee24.jpg\"/></p>',1679858647,1685036645,1685036645),(197,5,3,'链条小包女包高级感绣线小方包百搭单肩斜挎包包','/uploads/upload/admin/2023/03/28/b79a82e64a6622594db62d3df92ba120.png',56.66,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679858704398245.jpg\" title=\"1679858704398245.jpg\" alt=\"542aec659ac40a932a228135e7663be.jpg\"/></p>',1679858706,1685036645,1685036645),(198,5,3,'女包彩色蛇纹丝巾手提包链条单肩斜跨小方包','/uploads/upload/admin/2023/03/28/79654ba9a7ca93507c2f7d3936be7abb.png',87.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679858767270820.jpg\" title=\"1679858767270820.jpg\" alt=\"3beb5787d94b1cd815f365b8d3894f4.jpg\"/></p>',1679858768,1685036645,1685036645),(199,5,3,'流行韩版时尚潮流亮钻斜挎小众斜挎包手提包','/uploads/upload/admin/2023/03/28/bcefe078da589b4259e60ff5c5c671e2.png',98.88,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679858801838252.jpg\" title=\"1679858801838252.jpg\" alt=\"7be8d25872cfb83c98eb330b7b68403.jpg\"/></p>',1679858802,1685036645,1685036645),(200,5,4,'墨镜女韩版潮小脸复古圆框太阳镜防紫外线','/uploads/upload/admin/2023/03/28/aa0c689ced17028f4c5509d717cd75e5.png',18.88,80.00,80.00,0.00,0.00,8000,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679858971262255.jpg\" title=\"1679858971262255.jpg\" alt=\"eb44e7b76c9b8968730d86d365e18bc.jpg\"/></p>',1679858973,1685036645,1685036645),(201,5,4,'遮阳墨镜男女开车防紫外线大框GM方框太阳镜','/uploads/upload/admin/2023/03/28/585af74751953c2c54821f9351fc49ce.png',20.00,80.00,80.00,0.00,0.00,8000,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679859082270323.jpg\" title=\"1679859082270323.jpg\" alt=\"1a48ffe7b766c539e0d1762a1dd5d2d.jpg\"/></p>',1679859083,1685036645,1685036645),(202,5,3,'近视眼镜套镜太阳眼镜男款潮偏光防紫外线近视眼墨镜开车专用女','/uploads/upload/admin/2023/03/28/771db7821239e9d3268abf8f0831f5fa.png',48.88,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679859283466386.jpg\" title=\"1679859283466386.jpg\" alt=\"309432202b5dac7d0e4e31fc85c75fc.jpg\"/></p>',1679859284,1685036645,1685036645),(203,5,3,'墨镜女夏季高级感ins防紫外线太阳眼镜新款潮显瘦开车专用','/uploads/upload/admin/2023/03/28/9e35571537fd1685410378c979ea5c07.png',73.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679859561328415.jpg\" title=\"1679859561328415.jpg\" alt=\"44a2a4cac404932be2cba1a63f795ec.jpg\"/></p>',1679859563,1685036645,1685036645),(204,5,4,'新款时尚欧美方形D太阳镜 街拍走秀大框女士墨镜潮流太阳眼镜','/uploads/upload/admin/2023/03/28/7cb27443154911719a11eb36a2822fa5.png',22.00,80.00,80.00,0.00,0.00,8000,'<p><img src=\"/uploads/upload/admin/2023/03/27/1679859658817941.jpg\" title=\"1679859658817941.jpg\" alt=\"945f9b7d3cc402508adc4a2335929d1.jpg\"/></p>',1679859659,1685036645,1685036645),(205,8,1,'华为 Mate 40 Pro正品华为mate40pro','/uploads/upload/admin/2023/03/28/770f029291888784f58b120846029062.png',4380.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017369833923.jpg\" title=\"1680017369833923.jpg\" alt=\"1679816340638597.jpg\"/></p>',1679996728,1685033475,1685033475),(206,8,1,'Apple/苹果iPhone 13粉色','/uploads/upload/admin/2023/03/28/fe77fa6ad40fa4845de2fc0a6859dae7.png',4200.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017342227484.jpg\" title=\"1680017342227484.jpg\" alt=\"1679815925285997.jpg\"/></p>',1679996801,1685033475,1685033475),(207,8,1,'WATCH3/3Pro eSIM防水智能独立通话手表','/uploads/upload/admin/2023/03/28/9cfeb12127fe05b4de0206de22dbbda1.png',2038.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018283879503.jpg\" title=\"1680018283879503.jpg\" alt=\"1679731920348329.jpg\"/></p>',1679997054,1685033475,1685033475),(208,8,1,'JordanAJ1女运动鞋春新款板鞋','/uploads/upload/admin/2023/03/28/e94f9bf8017c7da859db35951e696873.png',1388.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018274711258.jpg\" title=\"1680018274711258.jpg\" alt=\"1679730416980652.jpg\"/></p>',1679997210,1685033475,1685033475),(209,8,1,'CL萝卜丁权杖口红黑管三支装限量礼盒套装','/uploads/upload/admin/2023/03/28/3f47352330269d197441a5773606ab15.png',1163.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018088784224.jpg\" title=\"1680018088784224.jpg\" alt=\"1679762056359296.jpg\"/></p>',1679997319,1685033475,1685033475),(210,8,1,'圣罗兰反转巴黎女士淡香水50ml失魂果持久清新留香浓香EDP','/uploads/upload/admin/2023/03/28/953ec289a2d02067ee8977146ccba065.png',1068.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018007138978.jpg\" title=\"1680018007138978.jpg\" alt=\"1679760028459788.jpg\"/></p>',1679997393,1685033475,1685033475),(211,8,1,'变形大黄蜂金刚擎天之柱模型手办合金版机器人','/uploads/upload/admin/2023/03/28/f81884e95e7916d953a753b16fd0a949.png',1068.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018446457325.jpg\" title=\"1680018446457325.jpg\" alt=\"1679821741387015.jpg\"/></p>',1679997501,1685033475,1685033475),(212,8,1,'动漫海贼王手办模型路飞索隆玩偶七武海艾斯乔巴','/uploads/upload/admin/2023/03/28/a910e6dfefef8cf12ed45ccda28c41b2.png',1030.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018456242357.jpg\" title=\"1680018456242357.jpg\" alt=\"1679820890673680.jpg\"/></p>',1679997570,1685033475,1685033475),(213,8,1,'YOL7轻奢女包高级感复古小方包小众时尚单肩斜挎包','/uploads/upload/admin/2023/03/28/810094361f10f8ae4b747830f5c783be.png',1580.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018734160884.jpg\" title=\"1680018734160884.jpg\" alt=\"1679856940645350.jpg\"/></p>',1679997671,1685033475,1685033475),(214,8,1,'纪诗哲轻奢品牌2023新款单肩斜挎包','/uploads/upload/admin/2023/03/28/bc017d1ed99d5b30021f0882e061f2c7.png',1558.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018769697282.jpg\" title=\"1680018769697282.jpg\" alt=\"1679857277639282.jpg\"/></p>',1679997749,1685033475,1685033475),(215,8,1,'独角兽公仔布娃娃抱枕女生睡觉抱睡 1.3m','/uploads/upload/admin/2023/03/28/5894c8e4472e68b33831ca1c6c58f2ed.png',1480.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017711469080.jpg\" title=\"1680017711469080.jpg\" alt=\"1679826147671836.jpg\"/></p>',1679997851,1685033475,1685033475),(216,8,1,'大章鱼公仔巨大懒人沙发 1.6m','/uploads/upload/admin/2023/03/28/837dff8e851e37762d162691a2cbfb0f.png',1320.00,0.03,0.03,0.00,0.00,3,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017690351958.jpg\" title=\"1680017690351958.jpg\" alt=\"1679826394600320.jpg\"/></p>',1679997904,1685033475,1685033475),(217,8,2,'华为FreeBuds4E无线蓝牙耳机','/uploads/upload/admin/2023/03/28/eedb1c6a8653d986ed0c93d7891fc6ee.png',890.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017449820682.jpg\" title=\"1680017449820682.jpg\" alt=\"1679819227909677.jpg\"/></p>',1679998053,1685033480,1685033480),(218,8,2,'honor/荣耀Play5T 全网通8+128G 4G','/uploads/upload/admin/2023/03/28/405b4d8d5099f1a4deb4e896ff08f681.png',1080.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017436430650.jpg\" title=\"1680017436430650.jpg\" alt=\"1679817397557991.jpg\"/></p>',1679998117,1685033480,1685033480),(219,8,2,'Gucci古驰竹韵竹节bamboo女士正品持久淡浓香水','/uploads/upload/admin/2023/03/28/02c925369c36b41bf98e147154fa6dab.png',723.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018119350278.jpg\" title=\"1680018119350278.jpg\" alt=\"1679762466800585.jpg\"/></p>',1679998232,1685033480,1685033480),(220,8,2,'迪奥  烈艳蓝金唇膏','/uploads/upload/admin/2023/03/28/fc2bf789f49bc0017896dbd92dc7f7b1.png',460.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018075201387.jpg\" title=\"1680018075201387.jpg\" alt=\"1679639971310024.jpg\"/></p>',1679998364,1685033480,1685033480),(221,8,2,'钢铁侠模型美国队长摆件复仇者联盟手办','/uploads/upload/admin/2023/03/28/1635c079e24eb01d80342df0cd873fa9.png',680.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018476857580.jpg\" title=\"1680018476857580.jpg\" alt=\"1679822791624111.jpg\"/></p>',1679998465,1685033475,1685033475),(222,8,2,'火影忍者CS 六代目火影 旗木卡卡西 拷贝忍者 GK手办模型','/uploads/upload/admin/2023/03/28/0701676012227bdec7b6cc6be8632d7e.png',480.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018468548631.jpg\" title=\"1680018468548631.jpg\" alt=\"1679821522764403.jpg\"/></p>',1679998519,1685033475,1685033475),(223,8,2,'Air Jordan 1 AJ1 黑白红芝加哥休闲低帮球鞋','/uploads/upload/admin/2023/03/28/96b534f71e2184d93eb431bcec5e71f1.png',1086.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018304845390.jpg\" title=\"1680018304845390.jpg\" alt=\"1679752897132913.jpg\"/></p>',1679998630,1685033475,1685033475),(224,8,2,'mlb美职棒潮牌手表男女士镂空机械风时尚复古防水情侣款手表','/uploads/upload/admin/2023/03/28/985715f3453f1c30669ce89d668e3598.png',663.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018295561097.jpg\" title=\"1680018295561097.jpg\" alt=\"1679732764228603.jpg\"/></p>',1679998699,1685033475,1685033475),(225,8,2,'爱心包2023新款高质感小香风菱格链条包时尚斜挎单肩腋下包','/uploads/upload/admin/2023/03/28/db8f54bf3385dbee87cffeab1a444946.png',758.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018781759138.jpg\" title=\"1680018781759138.jpg\" alt=\"1679856520353389.jpg\"/></p>',1679998785,1685033475,1685033475),(226,8,2,'轻奢品牌女包真皮单肩包高级感链条斜挎小方包女','/uploads/upload/admin/2023/03/28/dedeebf3bdbced095c349743ec7975e2.png',690.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018708527262.jpg\" title=\"1680018708527262.jpg\" alt=\"1679856352435451.jpg\"/></p>',1679998943,1685033475,1685033475),(227,8,2,'泰迪熊公仔毛绒玩具大熊抱抱熊 60cm','/uploads/upload/admin/2023/03/28/9990e857240d56a6917d4782144995bc.png',610.00,0.08,0.08,0.00,0.00,8,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017744706904.jpg\" title=\"1680017744706904.jpg\" alt=\"1679826799510080.jpg\"/></p>',1679999014,1685033475,1685033475),(228,8,3,'迷你小钢炮蓝牙音箱','/uploads/upload/admin/2023/03/28/5a3d3f72fc1dcf172a7e2ef32bcb475b.png',58.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017501185755.jpg\" title=\"1680017501185755.jpg\" alt=\"1679820418354168.jpg\"/></p>',1679999146,1685033480,1685033480),(229,8,3,'创意无线蓝牙音箱镜面时钟闹钟','/uploads/upload/admin/2023/03/28/33c24ffa269c73ba3bbd259e0100c1e4.png',45.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017487574508.jpg\" title=\"1680017487574508.jpg\" alt=\"1679820536967509.jpg\"/></p>',1679999202,1685033480,1685033480),(230,8,3,'香水女士持久淡香','/uploads/upload/admin/2023/03/28/9e40c6b94336082a47b29f1b23bfbbc3.png',58.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018131800213.jpg\" title=\"1680018131800213.jpg\" alt=\"1679764428432095.jpg\"/></p>',1679999298,1685033480,1685033480),(231,8,3,'小提琴三色哑光雾面口红不易掉色易上色','/uploads/upload/admin/2023/03/28/47003856a94906a9bd1ca6b120f92ef0.png',79.99,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680019085615586.jpg\" title=\"1680019085615586.jpg\" alt=\"1679763795903407.jpg\"/></p>',1679999473,1685033480,1685033480),(232,8,3,'海贼王 手办 九蛇女帝 王蛇姬 汉库克 踢腿','/uploads/upload/admin/2023/03/28/03c8136a3f889d1a02337a13a79a4bee.png',77.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018496349545.jpg\" title=\"1680018496349545.jpg\" alt=\"1679823653960186.jpg\"/></p>',1679999565,1685033480,1685033480),(233,8,3,'火影手办忍者 GK 宇智波斑 六道斑 雕像可换头','/uploads/upload/admin/2023/03/28/134ae0e610f12f3d90887172e564177d.png',66.88,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018486412221.jpg\" title=\"1680018486412221.jpg\" alt=\"1679823595249766.jpg\"/></p>',1679999621,1685033480,1685033480),(234,8,3,'包头帆布半拖鞋男夏季新款网红爆款小白鞋百搭一脚蹬懒人拖鞋','/uploads/upload/admin/2023/03/28/b79a926b9a3a219f4963c8448bb7d7a6.png',58.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018333462935.jpg\" title=\"1680018333462935.jpg\" alt=\"1679755670305472.jpg\"/></p>',1679999693,1685033480,1685033480),(235,8,3,'新款黑武士手表男士全自动机械正品防水夜光男表','/uploads/upload/admin/2023/03/28/ce73c93c580a14faee28d7cf000f48ce.png',68.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018323490789.jpg\" title=\"1680018323490789.jpg\" alt=\"1679754819940346.jpg\"/></p>',1679999856,1685033480,1685033480),(236,8,3,'墨镜女夏季高级感ins防紫外线太阳眼镜新款潮显瘦开车专用','/uploads/upload/admin/2023/03/28/8b0edc8573795596205bdf373d4d7796.png',73.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018847702770.jpg\" title=\"1680018847702770.jpg\" alt=\"1679859561328415.jpg\"/></p>',1679999973,1685033480,1685033480),(237,8,3,'墨镜女夏季高级感ins防紫外线太阳眼镜新款潮显瘦开车专用','/uploads/upload/admin/2023/03/28/8b6d0e0b5a53eebb849d50a90cccfd24.png',73.00,19.00,19.00,0.00,0.00,1900,NULL,1680000016,1680000033,1680000033),(238,8,3,'链条小包女包高级感绣线小方包百搭单肩斜挎包包','/uploads/upload/admin/2023/03/28/1ec7c39fb17dc36edcb9b3a53c61a712.png',56.66,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680018835374635.jpg\" title=\"1680018835374635.jpg\" alt=\"1679858704398245.jpg\"/></p>',1680000108,1685033480,1685033480),(239,8,3,'牛油果玩偶水果娃娃公仔 30cm','/uploads/upload/admin/2023/03/28/208d0f7cbeab3d855cf92c642aab5886.png',53.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017772763671.jpg\" title=\"1680017772763671.jpg\" alt=\"1679827070607219.jpg\"/></p>',1680000194,1685033480,1685033480),(240,8,3,'鲨鱼抱枕毛绒玩具布娃娃 30cm','/uploads/upload/admin/2023/03/28/f934f9086e1bd010f776da110820b4bc.png',52.00,19.00,19.00,0.00,0.00,1900,'<p><img src=\"/uploads/upload/admin/2023/03/28/1680017754448804.jpg\" title=\"1680017754448804.jpg\" alt=\"1679826988432301.jpg\"/></p>',1680000255,1685033480,1685033480),(241,8,4,'金属小钢炮迷你蓝牙音响','/uploads/upload/admin/2023/03/28/7c6656382b035fef55433a27c3b58e93.png',28.00,80.89,80.89,0.00,0.00,8089,NULL,1680000382,1680016912,1680016912),(242,8,4,'锌合金超级快充极客数据线','/uploads/upload/admin/2023/03/28/9eba405c70bb8f2e0d3d7ce8cf3fe25c.png',28.00,80.89,80.89,0.00,0.00,8089,NULL,1680000451,1680016909,1680016909),(243,8,4,'口红 小金条 杨树林细管口红 哑光雾面方管YSR红棕色保湿','/uploads/upload/admin/2023/03/28/21425bad863721920079f0884a26e493.png',18.88,80.89,80.89,0.00,0.00,8089,NULL,1680000532,1680016906,1680016906),(244,4,1,'1','/aliyun/224957f4e568948e542e4879324159e5.jpg',1.00,1.00,1.00,0.00,0.00,100,'<p>1</p>',1683122008,1683122022,1683122022),(245,9,1,'传说款-1','/aliyun/25384ad2f8a90af1e0764b9264366d1a.jpg',999.00,0.07,0.07,80.00,0.00,3,NULL,1683352448,1683352721,NULL),(246,9,1,'传说款-2','/aliyun/4085fc4fcf976eb3417c91d5cea4b9d6.jpg',9999.00,0.07,0.07,80.00,0.00,5,NULL,1683352470,1683352721,NULL),(247,9,2,'史诗款-1','/aliyun/4a7b708a55fcc4f1988ec94778219d23.jpg',999.00,0.23,0.23,10.00,0.00,23,NULL,1683352554,1683352554,NULL),(248,9,2,'史诗款-2','/aliyun/50d04a06b0b18936d446f2338b295016.jpg',88888.00,0.23,0.23,10.00,0.00,23,NULL,1683352572,1683352572,NULL),(249,9,3,'稀有款','/aliyun/d24fa208f97465dffe71001b02718c87.jpg',777.00,0.70,0.70,5.00,0.00,70,NULL,1683352628,1683352628,NULL),(250,9,4,'普通科-1','/aliyun/06247073f095ec900e125f5f8526eb8f.jpg',7777.00,99.00,99.00,5.00,0.00,9897,NULL,1683352661,1683352753,NULL),(251,2,4,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,5.95,5.95,0.00,20.00,558,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930221565579.jpg\" title=\"1680672337754609.jpg\" alt=\"0ff84bcd08ef28f5cdb3ce96522658e5.jpg\"/></p>',1684966073,1691334531,NULL),(252,2,3,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1.50,1.50,0.00,20.00,147,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930024112581.jpg\" title=\"1680671855545965.jpg\" alt=\"ac9c9ce5bd20f4f998104ba68ff197e5.jpg\"/></p>',1684966216,1691334531,NULL),(253,2,1,'华为畅享 20e 4+128G 颜色随机','/aliyun/9a8f7b61b1fd9b6643fdb53bc551527d.jpg',1599.00,0.10,0.10,0.00,20.00,10,'<p><img src=\"/uploads/upload/admin/2023/07/09/1688914512617863.png\" title=\"1688914512617863.png\" alt=\"5bf8c516ca79e243f286563cd4a77f8.png\"/></p>',1684967123,1688914514,NULL),(254,2,1,'华为/HUAWEI 畅享50z 5000万高清三摄大屏','/aliyun/2645147fac6f26dd1ddaa33e6b009b8b.jpg',1699.00,0.10,0.10,0.00,20.00,10,'<p><img src=\"/uploads/upload/admin/2023/07/09/1688914554549696.png\" title=\"1688914554549696.png\" alt=\"7b0773684f0d52947f5e48ad363e292.png\"/></p>',1684967414,1688914560,NULL),(255,2,1,'华为Nova8 SE 8+128G 4G手机颜色随机','/aliyun/80e73928ec7dc4f3245632b6d119d042.jpg',1699.00,0.10,0.10,0.00,20.00,10,'<p><img src=\"/uploads/upload/admin/2023/07/09/1688914604266341.png\" title=\"1688914604266341.png\" alt=\"7b0773684f0d52947f5e48ad363e292.png\"/></p>',1684967749,1688914609,NULL),(256,2,2,'124124','/aliyun/f751f21d8bf3a44ef3887a4bf42d9359.jpg',1232.00,0.10,0.10,0.10,10.00,10,NULL,1684967782,1684967796,1684967796),(257,2,1,'华为畅享60 8+128G颜色随机','/aliyun/53a3a169e724536b83cbe7ea4c0b8fa7.jpg',1799.00,0.10,0.10,0.00,20.00,10,'<p><img src=\"/uploads/upload/admin/2023/07/09/1688914649204210.png\" title=\"1688914649204210.png\" alt=\"ebf02dc6ab99f75b46b2154e21e5030.png\"/></p>',1684969533,1688914652,NULL),(258,2,1,'荣耀X40 6+128GB 5G手机曲面屏','/aliyun/ce7d2ccb7ccf61b3667402b69e56ae50.jpg',1899.00,0.10,0.10,0.00,20.00,10,'<p><img src=\"/uploads/upload/admin/2023/07/09/1688914685848044.jpg\" title=\"1688914685848044.jpg\" alt=\"ddc4d2a4f6faa0b87c2c799c5b5937d5_672a15157f42415e36936fd90f358c5a.jpg\"/></p>',1684969700,1688914695,NULL),(259,2,1,'红米Note 11 5G智能手机 颜色随机','/aliyun/6d2fee63a27cc4b3d4534799944c3955.jpg',1599.00,0.10,0.10,0.00,20.00,10,'<p><img src=\"/uploads/upload/admin/2023/07/16/1689485592235626.jpg\" title=\"1689485592235626.jpg\" alt=\"487b6fd13d2e9f6a4123fa8b1496e3f.jpg\"/></p>',1684969850,1689485595,NULL),(260,2,3,'多功能心率血氧检测手环','/aliyun/884aa32b72b79db9587c0bdc9b09071d.jpg',38.88,3.50,3.50,0.00,20.00,350,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929605520720.jpg\" title=\"1680671942946688.jpg\" alt=\"b3e5ee2281c69238ec12518502d7690b.jpg\"/></p>',1684977708,1688554934,1688554934),(261,2,2,'Beats Fit Pro真无线降噪蓝牙耳机','/aliyun/60ca12cfbe8049288639731077d30940.jpg',1599.00,0.20,0.20,0.00,20.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929552743288.jpg\" title=\"1680671577947058.jpg\" alt=\"616878f0221ecf073e27e18c8f7b57f8.jpg\"/></p>',1684977778,1688549770,NULL),(262,2,2,'Beats Studio3 Wireless蓝牙无线降噪耳机','/aliyun/eea41efc3ecc224e56f96ef4ebab4ddf.jpg',2789.00,0.20,0.20,0.00,20.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929511106900.jpg\" title=\"1680671520530822.jpg\" alt=\"a00e8d3ad59f4be091d39be8f15dec27.jpg\"/></p>',1684977838,1688549762,NULL),(263,2,2,'Apple/苹果AirPods Pro (第二代)','/aliyun/75389860493279e2ebf466e54855c10c.jpg',1899.00,0.20,0.20,0.00,20.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929470543612.jpg\" title=\"1680671485402390.jpg\" alt=\"9994f4b9bbc1871625100b3ce162459e.jpg\"/></p>',1684977917,1688549752,NULL),(264,2,2,'Apple Watch Series7','/aliyun/104c513e348cb0243244dfd96ee40129.jpg',2798.00,0.20,0.20,0.00,13.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929404517131.jpg\" title=\"1680671438570077.jpg\" alt=\"b7a7bb5aa3419f2c06d4e820b99b290c.jpg\"/></p>',1684978009,1688549741,NULL),(265,2,2,'Apple Watch Series8','/aliyun/11933b2a974f719420d9b50cc2ca9a4c.jpg',3299.00,0.20,0.20,0.00,20.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929364267755.jpg\" title=\"1680671399893207.jpg\" alt=\"9511b5edf16eeb1a651291627f8d0f86.jpg\"/></p>',1684978071,1688549725,NULL),(266,2,3,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1.50,1.50,0.00,20.00,145,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929986202536.jpg\" title=\"1680671867911168.jpg\" alt=\"461a41bec9fc268e9f0ef2352565131c.jpg\"/></p>',1684978290,1691075669,NULL),(267,2,3,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,2.00,2.00,0.00,20.00,195,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929940695883.jpg\" title=\"1680671770452713.jpg\" alt=\"44cc4e68759ad5d318df988d7d134e5d.jpg\"/></p>',1684978484,1691248582,NULL),(268,2,3,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1.50,1.50,0.00,20.00,146,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929891715291.jpg\" title=\"1680671733943895.jpg\" alt=\"7f8b5ce020f9eba051bd846645aed04b.jpg\"/></p>',1684978624,1691334519,NULL),(269,2,2,'SOOPii PR06投影仪','/aliyun/977e187068a1a03c235435834a271b0f.jpg',1288.00,0.20,0.20,0.00,20.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929695722234.jpg\" title=\"1680671649624171.jpg\" alt=\"c53c6d0dae144f4a4ac9e5c381687e4d.jpg\"/></p>',1684978710,1688550955,NULL),(270,2,2,'JBL UA Streak 无线运动蓝牙耳机','/aliyun/680852c41da28a09a2111e0afd95054f.jpg',680.00,0.20,0.20,0.00,20.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686929654799162.jpg\" title=\"1680671609344628.jpg\" alt=\"357d282ee822eab7c8189bdddc65c26e.jpg\"/></p>',1684979182,1688550947,NULL),(271,2,4,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,5.85,5.85,0.00,20.00,579,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930195900799.jpg\" title=\"1680672366220777.jpg\" alt=\"84a324cb2ad946696dd1382ec97e567a.jpg\"/></p>',1684979286,1690958364,NULL),(272,4,1,'苹果14Plus 128G颜色随机','/aliyun/93b4481ab28ff868c596539e0959cbbe.jpg',6699.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685007156284246.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685007161,1685007161,NULL),(273,4,1,'苹果14 256G 颜色随机','/aliyun/9e07b12acea899c495b8fc566a1aad3e.jpg',6799.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685007221860126.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685007223,1685007223,NULL),(274,4,1,'Apple iPadpro 2022款11寸 128G','/aliyun/30474c492fceb86c8d8a7b57e944a54a.jpg',7099.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685007355531002.jpg\" class=\"descV8-singleImage-image lazyload\"/><br/></p>',1685007361,1685007361,NULL),(275,4,1,'苹果14Plus 256G颜色随机','/aliyun/61f7e485a9c4f5e60e4eef9f2326882b.jpg',7599.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685007454945550.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685007458,1685007458,NULL),(276,4,1,'Apple iPadpro 2022款11寸256G','/aliyun/49b4ac966bb1e08a98e0794c825d2dd8.jpg',7899.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685007719663247.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685007737,1685007737,NULL),(277,4,1,'苹果14Pro 128G颜色随机','/aliyun/bfeb76735873aa1742802ed7513811e8.jpg',8499.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685007863158749.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685007864,1685007864,NULL),(278,4,1,'苹果14Pro 256G颜色随机','/aliyun/8c2fa4a74be64ddc871041bb1c41bd87.jpg',9399.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008303192983.jpg\" class=\"descV8-singleImage-image lazyload\"/></p><p><br/></p>',1685008306,1685008306,NULL),(279,4,1,'苹果14ProMax 128G颜色随机','/aliyun/2b18f928c7ea4ab1d392f2d168035346.jpg',9699.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008369522191.jpg\" class=\"descV8-singleImage-image lazyload\"/><br/></p>',1685008375,1685008886,NULL),(280,4,1,'苹果14Plus 512G颜色随机','/aliyun/cada8821d4b92e8aa50076ad79dd0761.jpg',9319.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008452371574.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685008454,1685008454,NULL),(281,4,1,'Apple MacBook Air13.6 8核M2','/aliyun/2232947ba0872884477be4508e238ab6.jpg',9999.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008499128041.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685008520,1685008520,NULL),(282,4,1,'苹果14ProMax 256G颜色随机','/aliyun/76d82f7cd059364a8721dcea2a22d02e.jpg',10599.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008655266532.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685008662,1685008662,NULL),(283,4,1,'苹果14Pro 512G颜色随机','/aliyun/a7a5a7d7392d044e835191f4c3e62a98.jpg',11099.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008701669562.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685008702,1685008702,NULL),(284,4,1,'苹果14ProMax 512G颜色随机','/aliyun/f6cdb03381db7ac08091186f0abb7b67.jpg',12399.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008738563691.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685008739,1685008876,NULL),(285,4,1,'苹果14ProMax 1TB颜色随机','/aliyun/e152d967ea7307c3ae47203371d49c2d.jpg',13999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685008783457609.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685008784,1685008784,NULL),(286,4,2,'苹果手表AppleWatch Se','/aliyun/1cb16c8cea116995c9add6aa779802db.jpg',2799.00,0.15,0.15,0.15,60.00,15,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685010304264347.jpg\"/></p>',1685010312,1686039489,NULL),(287,4,2,'Apple MagSafe双向充电器','/aliyun/503c8cfe1c19bb6858ce39bd73d4dd1e.jpg',1599.00,0.18,0.18,0.18,60.00,18,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685010392178564.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685010421,1685010421,NULL),(288,4,2,'Apple AirPods 三代蓝牙耳机','/aliyun/3d8b3ec74faff0150e588f1bc30ed82f.jpg',2099.00,0.16,0.16,0.16,60.00,16,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685010549105471.jpeg\" class=\"lazyload\"/></p>',1685010552,1685010552,NULL),(289,4,2,'妙控键盘代数字小键盘苹果适用','/aliyun/c252a50f379823bc9fc352df830f133d.jpg',1299.00,0.60,0.60,0.60,60.00,60,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685010771402263.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685010775,1685012818,NULL),(290,4,2,'苹果手表AppleWatch S8 颜色随机','/aliyun/7f14c4b968afb052fabec144928b704a.jpg',3499.00,0.08,0.08,0.08,60.00,8,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685011072871379.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685011088,1685011088,NULL),(291,4,2,'Apple iPhone SE3 128G颜色随机','/aliyun/dd04d89a0b17f36b2ff7b81545b1302a.jpg',4299.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685011370178104.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685011397,1685011397,NULL),(292,4,2,'苹果13MiNi 128G 颜色随机','/aliyun/e142dfce84c4d12728d7f0dc2ac43ad3.jpg',5199.00,0.06,0.06,0.06,60.00,6,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685011471675214.jpg\" class=\"lazyload\" width=\"790\"/></p>',1685011477,1685011477,NULL),(293,4,2,'苹果13 128G颜色随机','/aliyun/575fea8085a578bf8ac74de220a3f2fa.jpg',5299.00,0.06,0.06,0.06,60.00,6,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685011535387301.jpg\" class=\"lazyload\" width=\"790\"/></p>',1685011537,1685025638,NULL),(294,4,2,'苹果14 128G颜色随机','/aliyun/ddd3db924ea236f65397153435033aa0.jpg',5899.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685011586767286.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685011587,1685011587,NULL),(295,4,2,'Apple iPad 10代 10.9英寸2022款64G','/aliyun/6b36212b0c38755f26272934ded4b4c4.jpg',4099.00,0.06,0.06,0.06,60.00,6,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685011678122169.jpg\" class=\"\"/></p>',1685011681,1685011681,NULL),(296,4,3,'Apple 苹果原装AirTag防丢器1个装','/aliyun/7b6008083e08d547b4bdf8601019a045.jpg',299.00,2.00,2.00,2.00,60.00,189,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685012015597405.jpg\"/></p>',1685012059,1686169270,NULL),(297,4,3,'Apple MagSafe苹果原装无线充','/aliyun/69bb9586354ff2aece0f6ce4925e0fd5.jpg',299.00,3.80,3.80,3.80,60.00,372,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685012124348184.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685012143,1686169453,NULL),(298,4,3,'妙控蓝牙鼠标适用苹果','/aliyun/da7ef8fae6cd73b7d0b2548ae74bfa83.jpg',599.00,2.60,2.60,2.60,45.00,249,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685012249361172.jpg\" class=\"lazyload\"/></p>',1685012269,1686169453,NULL),(299,4,3,'Apple Magic Keyboard','/aliyun/4a661c9ecc038f910953a39a8e435c63.jpg',799.00,1.00,1.00,1.00,40.00,95,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685012371410847.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685012378,1686134492,NULL),(300,4,3,'Apple HomePod mini音响','/aliyun/de3bcd553ceaf573076f7ff7e564f318.jpg',899.00,0.19,0.19,0.19,50.00,19,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685012484713392.jpg\"/></p>',1685012491,1685012606,NULL),(301,4,3,'Apple 苹果原装AirTag防丢器4个装','/aliyun/6fc6e19c542364e87f4130f42b606980.jpg',929.00,0.17,0.17,0.17,50.00,17,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685012561886463.jpg\"/></p>',1685012565,1685012599,NULL),(302,4,3,'Apple AirPods 二代蓝牙耳机','/aliyun/68d124befc49cd638a4dabb9a54fddf6.jpg',1099.00,0.16,0.16,0.16,50.00,16,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685012761465890.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685012765,1685012900,NULL),(303,4,4,'Magsafe磁吸充电宝20w快充适用苹果','/aliyun/68c3efcaad435a7c9618260ec2ad048a.jpg',199.00,29.40,29.40,29.40,70.00,2758,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685013062393528.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685013064,1686169467,NULL),(304,4,4,'苹果充电器套装','/aliyun/110bb40aeff0c544462a38058a361b86.jpg',199.00,29.43,29.43,29.43,70.00,2630,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685013446842278.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685013454,1686169467,NULL),(305,4,4,'适用苹果耳机有线半入耳式','/aliyun/e658a92c11458079060052b37714b2f4.jpg',199.00,29.40,29.40,29.40,70.00,2702,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685013551149295.jpg\" class=\"lazyload\"/></p>',1685013560,1686169467,NULL),(306,3,1,'苹果13MiNi 128G颜色随机','/aliyun/fe8d9aa0532757d03a4fe175a694f71c.jpg',5199.00,0.02,0.02,0.05,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685015521599035.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685015524,1685098326,NULL),(307,3,1,'苹果13 128G颜色随机','/aliyun/6d5b00edfd15a23cb0f60540cf19dfa2.jpg',5299.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685015544292325.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685015577,1685297656,NULL),(308,3,1,'苹果14 128G星光色','/aliyun/6334c8ce22e378463fd5c5f2976d9c49.jpg',5899.00,0.01,0.01,0.03,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685015653715514.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685015673,1685297656,NULL),(309,3,1,'苹果14 128G 紫色','/aliyun/70a4cc26660a8e66ef99d6f7fb1f82ac.jpg',5899.00,0.01,0.01,0.01,60.00,0,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685015680519673.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685015713,1685634995,NULL),(310,3,1,'苹果14 128G蓝色','/aliyun/36ee565b12d188466195ed108fc18f16.jpg',5899.00,0.01,0.01,0.01,60.00,0,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685015734706766.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685015744,1685383965,NULL),(311,3,1,'苹果14 128G午夜色','/aliyun/302d9becb06efe9b6f1e767a374f6c5d.jpg',5899.00,0.01,0.01,20.00,60.00,0,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685015773407707.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685015774,1686202389,NULL),(312,3,2,'苹果充电器套装','/aliyun/ee6d5458d6620ecf801da55d362c037f.jpg',199.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685021953738359.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685021955,1685297656,NULL),(313,3,2,'Magsafe磁吸充电宝20w快充','/aliyun/6e699008a483d464b87035237137d606.jpg',199.00,0.09,0.09,0.50,60.00,9,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685022027477082.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685022029,1685297656,NULL),(314,3,2,'Apple AirPods 二代蓝牙耳机','/aliyun/30ae9eed0d574b3a0d85cb3387f27675.jpg',1499.00,0.03,0.03,0.03,40.00,0,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685022112405225.jpg\" class=\"\" width=\"750\" height=\"1065\"/></p>',1685022118,1685775799,NULL),(315,3,2,'苹果手表AppleWatch Se','/aliyun/2721233f51d82d9d5a5a8e1890473b7d.jpg',2799.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685022257829781.jpg\"/><br/></p>',1685022258,1685375537,NULL),(316,3,3,'无线蓝牙鼠标 颜色随机','/aliyun/d624b2f3fbaed29dabbb59bcd6112d40.jpg',29.00,3.60,3.60,3.60,50.00,244,'<p><img class=\"descV6-mobile-image lazyload\" src=\"/uploads/upload/admin/2023/05/25/1685022413797881.jpg\"/></p>',1685022419,1686197248,NULL),(317,3,3,'新款俄罗斯方块游戏机手掌机','/aliyun/4ca2aa33daee336db8aecd7a7f449425.jpg',29.00,3.00,3.00,3.00,50.00,181,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685022479301351.jpg\"/></p>',1685022537,1686187984,NULL),(318,3,3,'智能蓝牙音箱家用闹钟','/aliyun/fb3497d08d5e1fc47b20d7baae2058b4.jpg',39.00,2.50,2.50,2.50,50.00,184,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685022627526147.jpg\" class=\"lazyload\"/></p>',1685022630,1686167285,NULL),(319,3,3,'SUP童年回忆掌上游戏机','/aliyun/8fe06cacd8fdab00722119a166d22ef4.jpg',49.00,1.80,1.80,1.80,50.00,143,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685022678306151.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685022705,1686197281,NULL),(320,3,4,'苹果14手机气垫壳 顺风顺水','/aliyun/b45dfff913a7aceb9741e15231aee5bc.jpg',19.00,22.20,22.20,22.20,60.00,1313,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685023128822862.jpg\"/></p>',1685023130,1686205796,NULL),(321,3,4,'苹果14 气垫手机壳 风生水起','/aliyun/efd86df3f7b95b9351f57192e57ce203.jpg',19.00,22.20,22.20,22.20,60.00,1238,'<p><img src=\"/uploads/upload/admin/2023/05/25/1685023207833924.jpg\"/></p>',1685023208,1686206063,NULL),(322,8,1,'Vivo Pad 8+128G雪青紫高通骁龙870','/aliyun/d6ee738337a7588060d8074533370abb.jpg',2499.00,0.03,0.03,0.03,59.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685033465780117.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685033468,1685033468,NULL),(323,8,1,'小米平板5 11英寸2.5K高清8+256G','/aliyun/2f247557981e0e9a7ec409215dac99bb.jpg',2499.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685033564757986.jpg\" class=\"lazyload\"/></p>',1685033566,1685033566,NULL),(324,8,1,'oppo Pad11英寸2.5K120HZ 6+128G','/aliyun/97a5a0ecde0f8ce1285a4912862501f3.jpg',2899.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685033638838119.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685033674,1685033674,NULL),(325,8,1,'小米平板5Pro 12.4英寸2.5K高刷6+128G','/aliyun/d3e99c51ec0f194194a3989ddd541884.jpg',3199.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685033772534565.jpg\" class=\"lazyload\"/></p>',1685033811,1685033811,NULL),(326,8,1,'华为MatePad Pro12.6寸 128G','/aliyun/02965190e0b01a7ea7fade8c22074018.jpg',4399.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685033989894864.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034016,1685034016,NULL),(327,8,1,'iPad 10代 10.9英寸256G','/aliyun/de813fb5e72dad92d61f74dff144395a.jpg',4899.00,0.02,0.02,0.02,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685034070577168.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034118,1685161625,NULL),(328,8,1,'iPad Air 第5代 10.9英寸2022年256G','/aliyun/2f4d74427db83ed6e70f26d79f0d92d2.jpg',5199.00,0.02,0.02,0.02,50.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685034196313920.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034208,1685034208,NULL),(329,8,1,'华为MatePad Pro11英寸性能版8+256','/aliyun/e5c08acddc4b509791d5d48e6ad924ef.jpg',5199.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685034302404547.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034323,1685034323,NULL),(330,8,1,'华为MateBookE12.6英寸全面屏二合一','/aliyun/265e5660ccf6b0342fec139419131ad0.jpg',6999.00,0.01,0.01,0.01,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685034410734292.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034491,1685034491,NULL),(331,8,1,'iPad Pro11英寸平板电脑256G','/aliyun/7a942cf02457f778931d7e43a3a22732.jpg',7899.00,0.01,0.01,0.01,60.00,0,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685034596545942.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034601,1685775969,NULL),(332,8,1,'iPad Pro12.9英寸平板电脑256G','/aliyun/1f9e54ce0c234da3fdcd9395a1e8e32b.jpg',9299.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685034652256316.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034669,1685034669,NULL),(333,8,2,'小米/Redmi Pad 红米平板4+128G','/aliyun/db474a9a7583d1ed93573b22f90e4264.jpg',1399.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685034932888271.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685034952,1685034952,NULL),(334,8,2,'荣耀平板8 12英寸高清大屏6+128G','/aliyun/7ff46c295bffe37ca2131fe7dc82a33e.jpg',1799.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035048304857.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685035050,1685035050,NULL),(335,8,2,'OPPO Pad Air平板电脑4+128G','/aliyun/09992d8281594f3c6fd5a6fbb09c7bea.jpg',1799.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035144303517.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685035149,1685035149,NULL),(336,8,2,'华为平板matepadSE 10.4英寸','/aliyun/cd91ea3841b5487f1db9b70c4cfa3b20.jpg',1999.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035227881819.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685035229,1685035229,NULL),(337,8,2,'小米平板5 2.5K 120HZ 11英寸 6+128G','/aliyun/3bcf0154b7b1767088d70266a29f4741.jpg',1999.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035337750721.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685035339,1685035339,NULL),(338,8,3,'小米平板保护套','/aliyun/1c4b3d8a1a23144b8528ce34f9584fb3.jpg',99.00,2.60,2.60,2.60,50.00,258,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035459673354.jpg\"/></p>',1685035460,1686044047,NULL),(339,8,3,'oppopad 智能平板保护套','/aliyun/4a74a53f63ad1796e1fc05c856cf9e59.jpg',129.00,1.30,1.30,1.30,50.00,129,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035503934331.jpg\"/></p>',1685035504,1685146942,NULL),(340,8,3,'oppo pad Air智能手写笔','/aliyun/e03477da1427f7a8e67154943734c86b.jpg',299.00,0.60,0.60,0.60,50.00,60,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035584206500.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685035596,1685035596,NULL),(341,8,3,'小米灵感触控笔','/aliyun/d18725d5d1f08964051726c4cd263272.jpg',499.00,0.30,0.30,0.30,60.00,30,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035650805184.jpg\"/></p>',1685035674,1685035674,NULL),(342,8,3,'华为M-Pencil手写笔','/aliyun/48fa83d2cab093ec7afc4f0b47a0a00a.jpg',599.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035745450499.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685035764,1685035764,NULL),(343,8,3,'Apple Pencil二代笔','/aliyun/4c243de40fc1f3149af5b02b42cfd89f.jpg',999.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035811709378.jpg\"/></p>',1685035832,1685035832,NULL),(344,8,4,'Typec 接口平板耳机','/aliyun/207f83c51df061f4efbbecbc1b1df88f.jpg',49.00,47.31,47.31,47.31,70.00,4617,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685035915173763.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685035920,1686063525,NULL),(345,8,4,'铝合金笔记本电脑支架悬空可升降调节','/aliyun/d26e66d001a81ddf5893fadaf8f261bb.jpg',49.00,47.30,47.30,47.30,70.00,4679,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685036074434828.jpg\" class=\"lazyload\"/></p>',1685036075,1686063474,NULL),(346,5,1,'任天堂Switch 国行续航版','/aliyun/a77c80274063a5db4ecd8205206578e9.jpg',2199.00,0.06,0.06,0.06,70.00,6,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685036805317387.jpg\" class=\"lazyload\"/></p>',1685036807,1685036807,NULL),(347,5,1,'Xbox360 体感游戏机','/aliyun/907407c0554403fa467374714fcb8d16.jpg',2688.00,0.06,0.06,0.06,60.00,6,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685036891585298.jpg\"/><br/></p>',1685036895,1685036895,NULL),(348,5,1,'任天堂Switch oled版白色','/aliyun/3743af9611a30d1186ab2b5810df1ac7.jpg',2799.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685036954812178.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685036956,1685036956,NULL),(349,5,1,'索尼SONY PS5国行数字版','/aliyun/a61b9a4023f530c3fd13c64c93ff75aa.jpg',3299.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685037011191378.jpg\" class=\"lazyload\"/></p><p><br/></p>',1685037014,1685037014,NULL),(350,5,1,'索尼SONY PS5国行光驱版','/aliyun/eb2aeceeabb69ee24c74a82e2be36432.jpg',3899.00,0.03,0.03,0.03,59.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685037052297892.jpg\" class=\"lazyload\"/></p>',1685037088,1685037088,NULL),(351,5,1,'微软Xbox Series X主机游戏机','/aliyun/34a68a4c892bdaae0022921ee9189bc8.jpg',4199.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685037152234194.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685037154,1685037154,NULL),(352,5,2,'《双人成行》Switch游戏卡','/aliyun/e8b5df4c02e9aab0383154c70f0ef151.jpg',298.00,0.68,0.68,0.68,60.00,68,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685039140201870.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685039143,1685039143,NULL),(353,5,2,'《FIFA23》Switch游戏卡','/aliyun/56cae7b258a525977193ac88f7b26646.jpg',299.00,0.68,0.68,0.68,59.00,68,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685039634724520.jpg\" class=\"lazyload\"/></p>',1685039651,1685039651,NULL),(354,5,2,'《赛达尔传说》Switch游戏卡','/aliyun/2eedb83c7128ee3b37e94e3b7c5b645a.jpg',368.00,0.40,0.40,0.40,60.00,40,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685039752202714.jpg\" class=\"img-ks-lazyload lazyload\"/></p>',1685039754,1685039754,NULL),(355,5,2,'《艾尔登法环》Ps5游戏光碟','/aliyun/4514a5bc16b26c93c5637171caba35c6.jpg',438.00,0.38,0.38,0.38,60.00,38,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685039821813328.jpg\"/></p>',1685039823,1685039823,NULL),(356,5,2,'《战神5》PS5游戏光碟','/aliyun/7c11fe7ae4e66c8e04226fe90fd39d73.jpg',498.00,0.25,0.25,0.25,60.00,25,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685039881955445.jpg\"/></p>',1685039882,1685040233,NULL),(357,5,3,'适用于Xbox 游戏手柄','/aliyun/eb95aaccc9b5c8b78e186a397f9586f2.jpg',89.00,3.60,3.60,3.60,60.00,355,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685040057811886.jpg\"/></p>',1685040061,1686185817,NULL),(358,5,3,'使用任天堂 游戏手柄','/aliyun/50a09284cf2996b9f2c432d250820f12.jpg',89.00,3.60,3.60,3.60,60.00,354,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685040100760802.jpg\"/></p>',1685040101,1686185705,NULL),(359,5,3,'SUP童年回忆掌上游戏机','/aliyun/f1bc1f30ec28f52dfa668515c92e3fdc.jpg',89.00,3.60,3.60,3.60,60.00,350,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685040202495366.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685040206,1686185754,NULL),(360,5,4,'童年记忆俄罗斯方块游戏机','/aliyun/9a647f4768dbb320449ea7f02f516e24.jpg',39.00,28.86,28.86,28.86,60.00,2755,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685040506220463.jpg\"/></p>',1685040509,1686185817,NULL),(361,5,4,'Ps5手柄收纳包','/aliyun/a3a53c6375661fe2cc2c493ebed870fb.jpg',39.00,28.85,28.85,28.85,60.00,2812,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685040603581411.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685040614,1686185817,NULL),(362,5,4,'PS5手柄横向飞机充','/aliyun/ff08569b80f38aeb23e298fb1ab5678c.jpg',49.00,28.85,28.85,28.85,60.00,2778,'<p><img alt=\"undefined\" src=\"/uploads/upload/admin/2023/05/26/1685040658123044.jpg\" width=\"790\" height=\"790\"/></p>',1685040660,1686185817,NULL),(363,6,1,'Air Jordan1 黑摩卡小倒钩','/aliyun/82dccbf5e94b598506ad07c3c9586c08.jpg',4379.00,0.01,0.01,0.01,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685046787936466.jpg\"/></p>',1685046799,1685047197,1685047197),(364,6,1,'Adidas Yeezy 黄斑马','/aliyun/15cc45ecfe0b5b1a1b96142488ba22cd.jpg',3705.00,0.01,0.01,0.01,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685046839327230.jpg\"/></p>',1685046843,1685047197,1685047197),(365,6,1,'Edison Chen x Air Jordan1 白丝绸','/aliyun/50e21642a7a986f4f3c95c0d1483dea9.jpg',3479.00,0.10,0.10,0.10,50.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685046928579018.jpg\"/></p><p><br/></p><p><br/></p>',1685046939,1685047197,1685047197),(366,6,1,'Adidas Yeezy350 脏黄欧洲限定','/aliyun/3da0c049ac1d86b0cd0a3ad9990dc0fd.jpg',2675.00,0.01,0.01,0.01,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047033230966.jpg\"/></p>',1685047039,1685047197,1685047197),(367,6,1,'OMEGAxSwatch联名手表 木星款','/aliyun/526686d5d404d1de51af461a46988e8e.jpg',2419.00,0.01,0.01,0.01,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047129917397.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685047144,1685047197,1685047197),(368,6,1,'Jordan Air 1low 白橙','/aliyun/46c166295ee1259cc1e27cef11833889.jpg',1589.00,0.05,0.05,0.05,50.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047274571344.jpg\"/></p>',1685047315,1685047315,NULL),(369,6,1,'Jordan Air 1 烟灰','/aliyun/a4e0afd312208963a5e465a7fe9e7650.jpg',1789.00,0.05,0.05,0.05,50.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047356668860.jpg\"/></p>',1685047365,1685047365,NULL),(370,6,1,'Casio卡西欧ENTICER赛车系列MTD-1079D','/aliyun/cbaf9e1ea1333db6bebdbf6467e21d50.jpg',1869.00,0.04,0.04,0.04,50.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047423659954.jpg\"/></p>',1685047453,1685047453,NULL),(371,6,1,'OMEGAxSwatch联名手表 木星款','/aliyun/95b4af8e4122c7906f7f4325e6ddd19c.jpg',2219.00,0.03,0.03,0.03,50.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047491465446.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685047506,1685047506,NULL),(372,6,1,'Nike耐克 SB Dunk 青苹果','/aliyun/d155ad2ad5bea214c8e0a16152c7c581.jpg',2599.00,0.03,0.03,0.03,50.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047554513099.png\" title=\"1685047554513099.png\" alt=\"图片.png\"/></p>',1685047574,1685047574,NULL),(373,6,1,'Adidas Yeezy350 脏黄欧洲限定','/aliyun/086178c4d1bfad3e7b4536c7ebfd87aa.jpg',2675.00,0.02,0.02,0.02,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047599404952.jpg\"/></p>',1685047607,1685775989,NULL),(374,6,1,'Edison Chen x Air Jordan1 白丝绸','/aliyun/56a05ad24ef09ed82fdc8107f58af4c7.jpg',3479.00,0.02,0.02,0.02,50.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047634363991.jpg\"/></p>',1685047693,1685047693,NULL),(375,6,1,'Adidas Yeezy 黄斑马','/aliyun/2e02112e59c0d8a30cf7ecb0c2a77ca1.jpg',3705.00,0.01,0.01,0.01,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047726999525.jpg\"/></p>',1685047730,1685047730,NULL),(376,6,1,'Air Jordan1 黑摩卡小倒钩','/aliyun/1a75cecbdd0cd4fc689ab30e52fd6877.jpg',4379.00,0.01,0.01,0.01,50.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047752368961.jpg\"/></p>',1685047758,1685047758,NULL),(377,6,2,'NIKE Air Force1 Low纯白','/aliyun/ff37afc1f7d52e9fccddc6d56a9746ce.jpg',909.00,0.45,0.45,0.45,50.00,45,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047844134014.png\" class=\"descV8-singleImage-image lazyload\"/></p>',1685047847,1685049237,NULL),(378,6,2,'Nike Air Force1Low 小麦色','/aliyun/8377c88054ad45ce987ab6d19ec9352c.jpg',989.00,0.40,0.40,0.40,50.00,40,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685047908280712.jpg\"/></p>',1685047945,1685048167,NULL),(379,6,2,'Nike耐克AirForce1 纯白高帮','/aliyun/4b9bae34a6ba09cd6687c86bc431834a.jpg',1038.00,0.40,0.40,0.40,50.00,38,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048013233294.jpg\" class=\"\" width=\"750\" height=\"598\"/></p>',1685048045,1685776021,NULL),(380,6,2,'Nike Dunk Low Retro黑白熊猫','/aliyun/17a92a3d02880de8034b99d63524cfe6.jpg',1079.00,0.30,0.30,0.30,50.00,30,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048090827595.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685048148,1685048148,NULL),(381,6,2,'Nike耐克Dunk Hise Vntg','/aliyun/26563083e98e216c8b589c879bcc036e.jpg',1182.00,0.20,0.20,0.20,50.00,20,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048253880514.jpg\"/></p>',1685048265,1685048265,NULL),(382,6,2,'Nike耐克 Dunk High SP白蓝','/aliyun/39f25ea3ab4fea87cc4e805c2c9d61e7.jpg',1342.00,0.10,0.10,0.10,50.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048348817226.jpg\"/></p>',1685048363,1685048363,NULL),(383,6,3,'OWO小众街头W英文字母潮流钛钢项链','/aliyun/5b185dc2d69b27e286a1bada36578a17.jpg',199.00,2.00,2.00,2.00,50.00,197,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048445383115.jpg\"/></p>',1685048446,1686124284,NULL),(384,6,3,'Calvin Klein清新柑橘香EDT50ML','/aliyun/a7bf6d3e055bef844f0989937cbadb63.jpg',209.00,1.80,1.80,1.80,50.00,180,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048514888218.jpg\"/></p>',1685048515,1685776073,NULL),(385,6,3,'奔驰 同名男士淡香水EDT25ML','/aliyun/dd643ea71cb89c2d610fcc7f281c36f9.jpg',219.00,1.70,1.70,1.70,50.00,166,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048539444812.jpg\"/></p>',1685048541,1686184928,NULL),(386,6,3,'匹克 态极 凉拖鞋','/aliyun/2744b137d187a7183e7c0214a07cf29d.jpg',269.00,1.50,1.50,3.00,50.00,148,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048605120499.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685048607,1685638908,NULL),(387,6,3,'CASIO卡西欧YOUTH小银块W-218HD','/aliyun/59a0c73ea9131b6fe3c108b242bdad39.jpg',299.00,1.00,1.00,1.00,50.00,95,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048666449723.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685048684,1686124247,NULL),(388,6,3,'MLB美职棒老爹系列潮流情侣手表NY619','/aliyun/6d2c590f53223f6c4fcc2e1d859031d4.jpg',359.00,0.90,0.90,0.90,50.00,90,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048743186333.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685048749,1685048749,NULL),(389,6,3,'LiNing音速9 冰淇淋','/aliyun/4426f1acc4223ee7fc8514d6f5392023.jpg',399.00,0.80,0.80,0.75,50.00,76,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048805159305.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685048806,1685776062,NULL),(390,6,3,'CASIO卡西欧钢铁之心线路MWA-100H-1A','/aliyun/6fd413ded0ba1e08ff465063c718efed.jpg',419.00,0.75,0.75,0.75,50.00,74,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685048936273716.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685048940,1685776055,NULL),(391,6,3,'CASIO卡西欧 经典运动手柄 双显MCW-200H','/aliyun/4b3c3f23ec2e7a88bd1b6d4d0e4d4cdf.jpg',459.00,0.72,0.72,0.72,50.00,72,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685049006628302.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685049011,1685049011,NULL),(392,6,3,'Nike Air Monarch4White Navy蓝白','/aliyun/81062be78f4c1c5a692cfdf7645c8b43.jpg',489.00,0.70,0.70,0.70,50.00,70,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685049068441979.jpg\"/></p>',1685049069,1685049069,NULL),(393,6,3,'Vans Old Skool Black 经典百搭','/aliyun/5671a475dcb4edf74531b32c5dccc399.jpg',489.00,0.50,0.50,0.50,50.00,50,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685049131265573.png\" class=\"descV8-singleImage-image lazyload\"/></p>',1685049140,1685776047,NULL),(394,6,4,'飞力仕健身棒','/aliyun/f272e40a95ed47a714f85ca5073469b5.jpg',99.00,31.20,31.20,31.20,70.00,2835,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685049485737517.jpg\"/><br/></p>',1685049486,1686185137,NULL),(395,6,4,'优调厚底国潮泼墨凉拖鞋','/aliyun/91993428e2c86d551586f7bd5a9217dd.jpg',99.00,27.16,27.16,27.16,70.00,2667,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685049550101556.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685049551,1686185036,NULL),(396,6,4,'马丁MARTIN 男士氨基酸清爽控油清洁竹炭洗面奶150ml','/aliyun/88c9d3a56368930dd3bfc140320533eb.jpg',99.00,27.16,27.16,27.16,70.00,2660,'<p><img src=\"/uploads/upload/admin/2023/05/26/1685049601687581.jpg\"/></p>',1685049605,1686185137,NULL),(397,10,1,'老庙K金项链 K金love牌项链锁骨链','/aliyun/e7c855c2b148eec4e947b25cf8e9a247.jpg',2999.00,0.08,0.08,0.08,60.00,8,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175296617621.jpg\"/></p>',1685175330,1685175330,NULL),(398,10,1,'周大生足金兰陵手镯金镶玉和田玉晴水叮当镯幸福铃兰女','/aliyun/b122775e3619aba0513c7d4125633226.jpg',3599.00,0.08,0.08,0.08,60.00,8,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175365360088.jpg\"/></p>',1685175366,1685175366,NULL),(399,10,1,'周大福珠宝首饰时尚简约经典百搭LOVE 18K玫瑰金','/aliyun/29dcd4b5c52fb5dd673fc63e871e8300.jpg',4199.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175423602027.jpg\"/></p>',1685175424,1685175441,NULL),(400,10,1,'周大福情约系列精致时尚新款白金钻石戒指','/aliyun/ef29bc7e9c761c58984b19d49b9f4b67.jpg',4699.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175491549556.jpg\"/></p>',1685175492,1685175492,NULL),(401,10,1,'宝格丽SavetheChidren慈善款925银','/aliyun/ae66713760df58e0917b2e8093bc774d.jpg',4899.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175526908247.jpg\"/></p>',1685175564,1685175564,NULL),(402,10,1,'老庙黄金戒指古韵金一期迭代好运莲莲','/aliyun/cbef7bfe91594d35e3b304ddb25ab8e0.jpg',7999.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175621270408.jpg\"/></p>',1685175622,1685175622,NULL),(403,10,1,'周大福MONOLIGUE独白 拜金主义系列复古黄金手链','/aliyun/b47ed90b97dbc8c46ef9002195d72ae2.jpg',10999.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175687127052.jpg\"/></p>',1685175703,1685175703,NULL),(404,10,1,'周大福SOINLOVE 光管截止18K金钻石承包烟花系列','/aliyun/04072cdd9ce14aa3e224dcd1bf1cec86.jpg',15999.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175763628859.jpg\"/></p>',1685175764,1685175764,NULL),(405,10,1,'老庙黄金手镯 鸿运升升系列 复古国潮百搭金镯子','/aliyun/50d5ad5ed8f37e81464c9f932b9a29fa.jpg',18389.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175844969525.jpg\"/></p>',1685175857,1685175857,NULL),(406,10,1,'老庙黄金手镯 古韵金系列 足金古韵优品富贵圆满手镯素圈','/aliyun/fb9e516bab0abf9c3edfaf8da23753e5.jpg',19139.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175899133460.jpg\"/></p>',1685175900,1685175900,NULL),(407,10,1,'BVLGARI宝格丽 简约精美时尚男女同款戒指玫瑰金色','/aliyun/4f80e784cb0e1029723476138032a783.jpg',38999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175930256701.jpg\"/></p>',1685175931,1685175931,NULL),(408,10,1,'BVLGARI 宝格丽B.ZERO1系列18K玫瑰金钻石项链','/aliyun/326e0c4280a2e5e6a1b7f50cf1c6ea1b.jpg',49999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685175969519142.jpg\"/></p>',1685175986,1685175986,NULL),(409,10,2,'TRUEME真我纯银项链镶嵌莫桑钻石吊坠心心相印白金色','/aliyun/d6811606060950d808f89fa2e1f8ede3.jpg',1199.00,1.20,1.20,1.20,50.00,118,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176107434006.jpg\"/></p>',1685176124,1685177806,NULL),(410,10,2,'周大福小心意系列简约时尚百搭18K金彩金钻石戒指钻戒','/aliyun/d073e80f93ebc305f967b051602c2d1b.jpg',1199.00,0.10,0.10,0.10,50.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176227629436.jpg\"/></p>',1685176228,1685176377,NULL),(411,10,2,'周大福主播首饰愿得伊人心足金戒指甜美爱心镂空黄金光沙开口戒指','/aliyun/bc714fba7d17c941554d3a42377b1af2.jpg',1299.00,0.15,0.10,0.10,50.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176330609539.jpg\"/></p>',1685176354,1685176386,NULL),(412,10,2,'周大生和田玉手链女黄金铃兰花硬金串珠古韵手串','/aliyun/26d99fafee67fc6d5bcd1b4d0425062e.jpg',1399.00,0.30,0.30,0.30,50.00,30,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176467801554.jpg\"/></p>',1685176468,1685176468,NULL),(413,10,2,'周大生黄金手链女黄金莲花莲蓬硬金两世欢和田玉莲花手链','/aliyun/bf33fd0b583505371aea9bf27ccbd848.jpg',1499.00,0.28,0.28,0.28,50.00,28,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176660332892.jpg\"/></p>',1685176662,1685176662,NULL),(414,10,2,'TRUE ME 18K白金莫桑石钻戒相伴一生经典节约求婚对接','/aliyun/353ddb35ea369902048bb9f1baf3ac18.jpg',1899.00,0.10,0.10,0.10,50.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176722258042.jpg\"/></p>',1685176724,1685176724,NULL),(415,10,2,'周大生PT950铂金蝴蝶结手链女可调节','/aliyun/8a5316bed1042376c914f32b60ba169b.jpg',1899.00,0.09,0.09,0.09,50.00,9,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176754402191.jpg\"/></p>',1685176756,1685176756,NULL),(416,10,3,'周大生双环纯银项链女ins小众设计锁骨链S925饰品项链','/aliyun/3f9efc0e0e42fbb32d8e22b80f4d9587.jpg',159.00,2.10,2.10,2.10,60.00,207,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176857736727.jpg\"/></p>',1685176858,1685216460,NULL),(417,10,3,'周大生都市光环三环轻奢S925银锁骨链','/aliyun/a08a26a161802f935734a456971ac0fe.jpg',169.00,2.00,2.00,2.00,60.00,198,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176890401176.jpg\"/></p>',1685176891,1685178018,NULL),(418,10,3,'周大生S925鹿角套纯银项链锁骨链','/aliyun/1deebca2bf34aee152f6aaf740d83d47.jpg',279.00,1.80,1.80,1.80,60.00,176,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176929469488.jpg\"/></p>',1685176930,1685216401,NULL),(419,10,3,'周大生珍珠银链女前卫欧美简约项链暖金色项链','/aliyun/cd6ccf7c76b70af63762ad0c9e7346d0.jpg',289.00,1.00,1.00,1.00,60.00,99,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685176978354542.jpg\"/></p>',1685176981,1685177845,NULL),(420,10,3,'周大生18K金爱心手链女彩金手饰可调节','/aliyun/ab1f2ec27a5c326700e91d21309493be.jpg',499.00,0.60,0.60,0.60,60.00,60,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685177023474596.jpg\"/></p>',1685177024,1685177024,NULL),(421,10,3,'周大生银S925双层猫爪手串女和田玉首饰猫爪转运手串','/aliyun/c92fe1cb37bbed33c0590fffacd3e0b5.jpg',509.00,0.40,0.40,0.40,60.00,40,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685177052673588.jpg\"/></p><p><br/></p>',1685177055,1685177055,NULL),(422,10,4,'轻奢莫比乌斯环镶嵌项链吊坠饰品','/aliyun/34bf11dccf40081d251426ab9dfde5dd.jpg',89.00,22.34,22.34,22.34,60.00,2179,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685177276860216.jpg\"/></p>',1685177280,1686143066,NULL),(423,10,4,'哥特简约复古钻石十字架项链吊坠','/aliyun/4f1cc710790e70f7ea95af0e8c3084bb.jpg',89.00,22.34,22.34,22.34,60.00,2170,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685177308842752.jpg\"/></p>',1685177309,1686138733,NULL),(424,10,4,'轻奢几何蓝色多圈圆项链吊坠','/aliyun/de2b7b287de5a14f3441615d6eab4c11.jpg',89.00,22.34,22.34,22.34,60.00,2161,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685177334153137.jpg\"/></p>',1685177337,1686143066,NULL),(425,10,4,'轻奢浅蓝白石圈圈项链吊坠','/aliyun/ecbf6b8fc87d04490fb6fd77f48b3971.jpg',89.00,22.34,22.34,22.34,60.00,2153,'<p><img src=\"/uploads/upload/admin/2023/05/27/1685177367334306.jpg\"/></p>',1685177368,1686143066,NULL),(426,11,1,'苹果14Promax 128G一台 颜色随机','/aliyun/09f93c769cef8cf957430558dd97d47b.jpg',9699.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211190853849.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211191,1685211262,NULL),(427,11,1,'苹果14Promax 256G一台 颜色随机','/aliyun/c290b96a5c675dd3b2c937f8b4319173.jpg',10599.00,0.03,0.03,7.00,60.00,0,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211200242967.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211254,1686196564,NULL),(428,11,1,'苹果14Promax 512G一台 颜色随机','/aliyun/33dc3870c3d00dec1bd1208a83552731.jpg',12399.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211272599922.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211300,1685211300,NULL),(429,11,1,'苹果14Promax 1TB一台 颜色随机','/aliyun/801b25b7ae107635a5b84d6b1b68acfd.jpg',13999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211334255028.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211336,1685211336,NULL),(430,11,2,'苹果14Plus 128G星光白','/aliyun/68785abd6b834befaa198cdd75e72a74.jpg',6699.00,0.09,0.09,0.09,60.00,9,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211467102894.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211469,1685211469,NULL),(431,11,2,'苹果14Plus 128G黄色','/aliyun/3d97c55a23bcf2ae8fdac7009c2c19b0.jpg',6699.00,0.09,0.09,0.09,60.00,9,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211499304178.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211501,1685211501,NULL),(432,11,2,'苹果14Plus 128G紫色','/aliyun/2ad4d09f0b0bc39cee6f5d92aca6a860.jpg',6699.00,0.09,0.09,0.09,60.00,9,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211531350297.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211532,1685211532,NULL),(433,11,2,'苹果14Plus 128G午夜黑','/aliyun/90b86c71b7a6a2eb1be6ad96cb6164e0.jpg',6699.00,0.09,0.09,0.09,60.00,9,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211581511932.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211582,1685211582,NULL),(434,11,2,'苹果14Plus 128G蓝色','/aliyun/c715bfebb758b284f0060cb3938b9c60.jpg',6699.00,0.09,0.09,0.09,60.00,9,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211616556569.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211617,1685211617,NULL),(435,11,3,'睿量REMAX RP-W58苹果磁吸无线充电器','/aliyun/3d55d5f6d4e4a406f7be6238aecae56c.jpg',139.00,7.50,7.50,7.50,60.00,656,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211684129593.jpg\"/></p>',1685211687,1686196822,NULL),(436,11,3,'睿量REMAX数显透明 10000mAh大容量双向快充电宝','/aliyun/c041ab38c43b29a9ba3bbb9d838d188d.jpg',169.00,4.10,4.10,4.10,60.00,371,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211737528184.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211738,1686196942,NULL),(437,11,3,'Disney迪士尼x漫威联名X03pro磁吸充电宝','/aliyun/55385312e1a44354bfc32df0d0f903a6.jpg',199.00,2.50,2.50,2.50,60.00,228,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211805882880.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685211810,1686196549,NULL),(438,11,3,'诺巴曼XX航拍飞行器无人机','/aliyun/7c4a9dc4e9a31a02b37735f9606f34f1.jpg',269.00,1.00,1.00,1.00,60.00,92,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211876555201.jpg\" class=\"descV8-singleImage-image lazyload\"/><br/></p>',1685211878,1686126486,NULL),(439,11,3,'Chiline泫音DWAJ1麻将发财發带夜光超长续航蓝牙耳机','/aliyun/67bc34b3e593d0b3719f2c7d4f8449a7.jpg',299.00,0.70,0.70,0.70,60.00,70,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685211972608634.jpg\"/></p>',1685211988,1685211988,NULL),(440,11,4,'联想LenovoK3Plus户外露营音箱悬空RGB灯光','/aliyun/451f06dd31b6f468eb3d687c002cb0ee.jpg',98.00,28.70,28.70,28.70,70.00,2147,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685212233928073.jpg\"/></p>',1685212236,1686196972,NULL),(441,11,4,'Baseus倍思小极快充充电器套装U+C口PD20W快充','/aliyun/90c3f021b890a769989c8697e4120015.jpg',98.00,28.52,28.52,28.52,70.00,2394,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685212340721127.jpg\"/></p>',1685212341,1686196972,NULL),(442,11,4,'Disney迪士尼CE-901V正品空气传导耳机游戏无延迟','/aliyun/22973f1f42363acee55f9042436e2ad3.jpg',98.00,28.52,28.52,28.52,70.00,2299,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685212391661086.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685212409,1686196972,NULL),(443,12,1,'苹果14Plus 256G午夜色','/aliyun/9e361e0c3118f50c21b760c5d65d76fa.jpg',7899.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222513516598.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222514,1685222514,NULL),(444,12,1,'苹果14Plus 256G星光色','/aliyun/92419c8c3bbcbd2ed54c5cca85164d75.jpg',7899.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222528798967.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222563,1685222563,NULL),(445,12,1,'苹果14Plus 256G黄色','/aliyun/174bd502c69f93175fb81754df2f4c38.jpg',7899.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222597175113.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222601,1685222601,NULL),(446,12,1,'苹果14Plus 256G紫色','/aliyun/6b2536ac354a718e53518b4b082b68da.jpg',7899.00,0.02,0.02,0.02,60.00,0,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222645319731.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222646,1685775929,NULL),(447,12,1,'苹果14Plus 256G 蓝色','/aliyun/933f7453574eec9a3615f3e6c896b609.jpg',7899.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222680555311.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222681,1685222681,NULL),(448,12,1,'苹果14Puls 512G 午夜色','/aliyun/892a55c08d86c22e8aa630334f60b566.jpg',9699.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222746965656.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222747,1685222747,NULL),(449,12,1,'苹果14Plus 512G 星光色','/aliyun/4dcc872f81896fd412ad14a892372563.jpg',9699.00,0.01,0.01,0.01,59.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222782925586.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222784,1685222784,NULL),(450,12,1,'苹果14Plus 512G 黄色','/aliyun/fac0572debafa03d634e749cf5841581.jpg',9699.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222811451936.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222812,1685222812,NULL),(451,12,1,'苹果14Plus 512G紫色','/aliyun/3dfafdb08de2ad70327f6cb64f62a90f.jpg',9699.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222836639360.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222838,1685222838,NULL),(452,12,1,'苹果14Plus 512G 蓝色','/aliyun/ffec83ac278eacb36b4d1d5f01e6b646.jpg',9699.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222862510128.jpg\" class=\"descV8-singleImage-image lazyload\"/></p>',1685222863,1685222863,NULL),(453,12,2,'苹果手表iWatch SE智能运动手表 白色44MM','/aliyun/6e5fc8eab72d91fb8f33b11c7234489e.jpg',2599.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685222993590719.jpg\"/><br/></p>',1685222995,1685222995,NULL),(454,12,2,'苹果手表iWatch SE智能运动手表 黑色44MM','/aliyun/4c7e384ba55c01fccf41fcca913d263f.jpg',2599.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223055253713.jpg\"/></p>',1685223058,1685223058,NULL),(455,12,2,'苹果手表iWatch SE智能运动手表 星光色44MM','/aliyun/b27a55a70501ef6b4d1710e94a799a0b.jpg',2599.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223089683692.jpg\"/></p>',1685223090,1685223090,NULL),(456,12,2,'苹果14 128G午夜色','/aliyun/7e08c23fc50a0c5d7efe5af36c7176fb.jpg',5999.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223145113464.jpg\"/></p>',1685223148,1685223148,NULL),(457,12,2,'苹果14 128G星光色','/aliyun/25462fc8fcfe7e5eef525c765f91634a.jpg',5999.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223174280538.jpg\"/></p>',1685223175,1685223175,NULL),(458,12,2,'苹果14 128G黄色','/aliyun/3433d4e5b83f494c3447c5b4a1defac6.jpg',5999.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223209801755.jpg\"/></p>',1685223210,1685223210,NULL),(459,12,2,'苹果14 128G紫色','/aliyun/4adf46d79bf855b776ddeb8f5b193c5c.jpg',5999.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223238246448.jpg\"/></p>',1685223239,1685223239,NULL),(460,12,2,'苹果14 128G蓝色','/aliyun/cfbf622bc7d6795658e393f46bfe779d.jpg',5999.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223269719489.jpg\"/></p>',1685223270,1685223270,NULL),(461,12,3,'apple原装20W USB-C手机充电器插头','/aliyun/87f7808508c24d9394f8f868f31f880a.jpg',129.00,3.50,3.50,3.50,60.00,343,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223349148356.jpg\"/></p>',1685223350,1686201745,NULL),(462,12,3,'苹果USB-C/雷霆3转Lightning闪电连接线','/aliyun/736ed0a5574419a498f817cef3938208.jpg',145.00,2.00,2.00,2.00,60.00,197,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223426678645.jpg\"/></p>',1685223427,1686196290,NULL),(463,12,3,'苹果 耳机lightning闪电接头的Earpods耳机','/aliyun/33e11bf2813e1b1f87d398d2bf10e01c.jpg',149.00,2.00,2.00,2.00,60.00,197,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223489388525.jpg\"/></p>',1685223490,1686193108,NULL),(464,12,3,'Apple magsafe 原装外接电池 磁吸 无线充电','/aliyun/9db425d4795e0a515c91194260fddd36.jpg',529.00,0.80,0.80,0.80,60.00,80,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223552846377.jpg\"/></p>',1685223553,1685775943,NULL),(465,12,4,'现代（HYUNDAI）Q7电脑音响家用桌面有线','/aliyun/d13a566b82960a0c0793901bba611dcf.jpg',65.00,30.50,30.50,30.50,60.00,2945,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223787932088.jpg\"/></p>',1685223789,1686201797,NULL),(466,12,4,'索盈入耳式蓝牙耳机千元音效颜色随机','/aliyun/588fcd483e31bfe365908302276240d2.jpg',65.00,30.50,30.50,30.50,60.00,2929,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223855824605.jpg\"/></p>',1685223856,1686201797,NULL),(467,12,4,'掌之友磁吸无线充电器','/aliyun/b6960de575fb940ef0fc7c2697ddc81c.jpg',65.00,30.50,30.50,30.50,60.00,2895,'<p><img src=\"/uploads/upload/admin/2023/05/28/1685223925372270.jpg\"/></p>',1685223926,1686201797,NULL),(468,13,1,'AppleWatch S8手表GPS+蜂窝款41MM颜色随机','/aliyun/8367c5c35e28385d15661b18720b4393.jpg',5499.00,0.02,0.02,0.02,60.00,2,NULL,1685224191,1685224191,NULL),(469,13,1,'AppleWatch S8手表GPS+蜂窝款45MM颜色随机','/aliyun/d21e496668eb0d155ebb28d8ceb52373.jpg',5899.00,0.02,0.02,0.02,60.00,2,NULL,1685224213,1685224213,NULL),(470,13,1,'AppleWatch UltraGPS+蜂窝款49MM黄色','/aliyun/f2032da4cd3351f3ff581eacf10e1170.jpg',5299.00,0.01,0.01,0.01,60.00,1,NULL,1685224259,1685224259,NULL),(471,13,1,'AppleWatch UltraGPS+蜂窝款49MM午夜色','/aliyun/b9909c66f92afce2247a36dc2a3f0ae3.jpg',6299.00,0.01,0.01,0.01,60.00,1,NULL,1685224296,1685224296,NULL),(472,13,1,'AppleWatch UltraGPS+蜂窝款49MM星光色','/aliyun/d6c6b57cb0bcb05dc467f165989ecc91.jpg',6299.00,0.01,0.01,0.01,60.00,1,NULL,1685224322,1685224322,NULL),(473,13,1,'AppleWatch UltraGPS+蜂窝款49MM星光色','/aliyun/eb0cac60dabfff753d064a2e81028e6f.jpg',6299.00,0.01,0.01,0.01,60.00,1,NULL,1685224346,1685224346,NULL),(474,13,1,'AppleWatch UltraGPS+蜂窝款49MM绿色','/aliyun/2811e0c14a268f1021ae5eed66c2dbc1.jpg',6299.00,0.01,0.01,0.01,60.00,1,NULL,1685224383,1685224383,NULL),(475,13,1,'AppleWatch UltraGPS+蜂窝款49MM橙色','/aliyun/e7131e53da2cccf80ec0f92e87d8bd7c.jpg',6299.00,0.01,0.01,0.01,60.00,1,NULL,1685224402,1685224402,NULL),(476,13,2,'AppleWatch SE GPS版40MM白色','/aliyun/e0ca18a0a4cae672629e647b6a3513a4.jpg',1999.00,0.10,0.10,0.10,60.00,10,NULL,1685224484,1685224484,NULL),(477,13,2,'AppleWatch SE GPS版40MM星光色','/aliyun/17242d5f1b26ec618584037876ad56e0.jpg',1999.00,0.10,0.10,0.10,60.00,10,NULL,1685224541,1685224541,NULL),(478,13,2,'AppleWatch SE GPS款40MM午夜色','/aliyun/b127a7dce7243a34cf9c422654595059.jpg',1999.00,0.10,0.10,0.10,60.00,10,NULL,1685224590,1685224590,NULL),(479,13,2,'AppleWatch SE GPS款44MM午夜色','/aliyun/c8acd5a3fdb7a84249185e6d83a6a553.jpg',2199.00,0.05,0.05,0.05,60.00,5,NULL,1685224639,1685224639,NULL),(480,13,2,'AppleWatch SE GPS款44MM星光色','/aliyun/0949329c7d7a21399951bb3e17c33f56.jpg',2199.00,0.05,0.05,0.05,60.00,5,NULL,1685224675,1685224675,NULL),(481,13,2,'AppleWatch SE GPS款44MM白色','/aliyun/777c303f9490b218ad78eaf83c031ec3.jpg',2199.00,0.05,0.05,0.05,60.00,5,NULL,1685224694,1685225035,NULL),(482,13,2,'AppleWatch S8 GPS款41MM','/aliyun/5b1e929c23e33a7dd958f85dce4fe8a3.jpg',2999.00,0.03,0.03,0.03,60.00,3,NULL,1685224736,1685225057,NULL),(483,13,2,'AppleWatch S8 GPS款41MM 星光色','/aliyun/f026e95914b0420885fce12e3b5d633f.jpg',2999.00,0.03,0.03,0.03,60.00,3,NULL,1685224799,1685225067,NULL),(484,13,2,'AppleWatch S8 GPS款41MM白色','/aliyun/0ed686c986a99d39f2633e98abb302fe.jpg',2999.00,0.03,0.03,0.03,60.00,3,NULL,1685224842,1685225077,NULL),(485,13,3,'华为手环6 标准版 青山黛','/aliyun/8420109eab4050ac9927450d4808caa8.jpg',239.00,1.00,1.00,1.00,60.00,100,NULL,1685225222,1685225222,NULL),(486,13,3,'华为手环6 标准版 樱语粉','/aliyun/c355b70da25ef416b000335405498f83.jpg',239.00,1.00,1.00,1.00,60.00,100,NULL,1685225281,1685225367,NULL),(487,13,3,'华为手环6 标准版 赤茶橘','/aliyun/99f46f4499a71bbd14c9a70145753ccb.jpg',309.00,0.80,0.80,0.80,60.00,80,NULL,1685225303,1685225378,NULL),(488,13,3,'华为手环6 标准版 曜石黑','/aliyun/437911682e445c6bde28b188c3c0f3ee.jpg',309.00,0.80,0.80,0.80,60.00,80,NULL,1685225406,1685225406,NULL),(489,13,4,'运动手环手表 暴力熊','/aliyun/05cc36d6aeabf1574617e57bd37a35f3.jpg',59.00,23.94,23.94,23.94,60.00,2393,NULL,1685225627,1686175247,NULL),(490,13,4,'运动手环手表 皮卡丘','/aliyun/3d1633ee97af754b9ad0551283414b41.jpg',59.00,23.94,23.94,23.94,60.00,2392,NULL,1685225656,1686175247,NULL),(491,13,4,'男士 商务手表','/aliyun/199fbbe88b8c2379e35a455cdd31500d.jpg',59.00,23.94,23.94,23.94,60.00,2392,NULL,1685225679,1686175247,NULL),(492,13,4,'男士 商务手表','/aliyun/7d1414b903548db48a0ef5752bb91e15.jpg',59.00,23.94,23.94,23.94,60.00,2391,NULL,1685225701,1686175247,NULL),(493,3,4,'有线3.5mm圆头手机耳机','/aliyun/737d973b1138861c32ccf9dca6bbfb35.jpg',19.00,22.20,22.20,22.20,60.00,1030,'<p><img src=\"/uploads/upload/admin/2023/05/29/1685297655658775.jpg\"/></p>',1685297656,1686206087,NULL),(494,3,4,'苹果充电线 赤橘色','/aliyun/f5daa2aea7d8335813e1ea5629ba7fa1.jpg',19.00,22.20,22.20,22.20,60.00,219,'<p><img src=\"/uploads/upload/admin/2023/05/29/1685297746259885.jpg\"/></p>',1685297748,1686205901,NULL),(495,2,4,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,5.85,5.85,0.00,20.00,567,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930153979239.jpg\" title=\"1680672408102979.jpg\" alt=\"1cca12560ac21063d607644e2a16601c.jpg\"/></p>',1685298441,1691037119,NULL),(496,2,3,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,2.00,2.00,0.00,20.00,193,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930111683126.jpg\" title=\"1680672035239845.jpg\" alt=\"b2f275b4d954307ec7d2903307282c4b.jpg\"/></p>',1685298528,1691207020,NULL),(497,14,1,'邪手 幻血姬 新13代i5 13400F/3060Ti 主机','/aliyun/62ec3060bf1d2b87c37aeb35a9706994.jpg',7199.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686168802981053.png\" title=\"1686168802981053.png\" alt=\"7199邪手 幻血姬 新13代i5 13400F306Ti 组装电脑游戏台式电脑主机 DIY组装机.png\"/></p>',1686168888,1686168888,NULL),(498,14,1,'华硕I5 13400F/RTX3080 10G电脑主机','/aliyun/efb20aedf13a7ff1e5d3bfd32e23fab5.jpg',7999.00,0.06,0.06,0.06,60.00,6,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686170358220689.png\" title=\"1686170358220689.png\" alt=\"7999.png\"/></p>',1686170414,1686170414,NULL),(499,14,1,'邪手水冷 13代i7 13700F/3060Ti 电脑主机','/aliyun/79eb77e0432603e247e31b579a01a062.jpg',7999.00,0.05,0.05,0.05,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686170443928090.png\" title=\"1686170443928090.png\" alt=\"7999邪手水冷.png\"/></p>',1686170569,1686170569,NULL),(500,14,1,'邪手 鬼灭 i7 13700F/RTX4070 12G主机','/aliyun/56e49a3d576c792d64fa57e136eda529.jpg',9599.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686170585920069.png\" title=\"1686170585920069.png\" alt=\"9599.png\"/></p>',1686170643,1686170643,NULL),(501,14,1,'华硕i7 13700K/4070Ti电脑主机游戏组装机','/aliyun/3814f6ee90959fc5e1fba93f3c23b54e.jpg',9999.00,0.03,0.03,0.03,60.00,3,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686170727940365.png\" title=\"1686170727940365.png\" alt=\"9999.png\"/></p>',1686171027,1686171027,NULL),(502,14,1,'GOF工蜂&金字塔 华硕4080 水冷DIY个性化异形电脑','/aliyun/4d61acd19dfc3dcd192c22797bba62cc.jpg',13999.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171127981820.png\" title=\"1686171127981820.png\" alt=\"13999.png\"/></p>',1686171312,1686171312,NULL),(503,14,1,'ROG华硕全家桶i9 13900K/4070TI显卡水冷主机','/aliyun/ae850f9f3a2f985db570b354d4a72743.jpg',19999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171355523944.png\" title=\"1686171355523944.png\" alt=\"19999.png\"/></p>',1686171376,1686171376,NULL),(504,14,1,'华硕ROG全家桶i9 13900K/4070TI猛禽显卡主机','/aliyun/b99c8311a4574db3e9ae80ba4391c1dd.jpg',21999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171412632859.png\" title=\"1686171412632859.png\" alt=\"21999.png\"/></p>',1686171429,1686171429,NULL),(505,14,1,'ROG华硕败家之眼i7 12700K/RTX3080主机','/aliyun/ea27a24eaf006f0cb9fb4940341add33.jpg',30999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171661299011.png\" title=\"1686171661299011.png\" alt=\"30999.png\"/></p>',1686171582,1686171678,NULL),(506,14,1,'微星（MSI)宙斯盾Ti5游戏电竞水冷高端高性能台式机电脑','/aliyun/5ffd9cd85a1419cabd1d35d9b1de026a.jpg',31999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171634683755.png\" title=\"1686171634683755.png\" alt=\"31999.png\"/></p>',1686171653,1686171653,NULL),(507,14,1,'华硕i7-13700KF/ROG4090RO姬吹雪DIY水冷','/aliyun/43c9d3ebd018039148969af7a0fec2e6.jpg',41999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171735782511.png\" title=\"1686171735782511.png\" alt=\"41999.png\"/></p>',1686171758,1686171758,NULL),(508,14,2,'雷蛇（Razer）黑寡妇蜘蛛V3 机械键盘有线键盘游戏键盘','/aliyun/c1219d28db17e4344e7950e162592c17.jpg',699.00,1.00,1.00,1.00,60.00,99,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171840300816.jpg\"/></p>',1686171842,1686192533,NULL),(509,14,2,'雷蛇（Razer） 利维坦巨兽5.1杜比环绕音效家用','/aliyun/e77740e8921fabca005432c3206e3567.jpg',899.00,0.80,0.80,0.80,65.00,80,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171893947186.jpg\"/></p>',1686171895,1686171895,NULL),(510,14,2,'哈曼卡顿水晶3代音响 电脑电视音箱音响','/aliyun/fc10bacc7632e8aa9f1c46876a4c48d6.jpg',1199.00,0.30,0.30,0.30,60.00,30,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686171960522920.jpg\"/></p>',1686171961,1686171961,NULL),(511,14,2,'泰坦军团34英寸165Hz曲面带鱼屏准4K升降旋转','/aliyun/97b65011be4fcb3860833c015d3562ce.jpg',1899.00,0.20,0.20,0.20,60.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172000394474.jpg\"/></p>',1686172021,1686172388,NULL),(512,14,2,'雷神银翼系列显示器专业电竞显示器 游戏娱乐办公PS5银翼','/aliyun/d7185eea0e6fa0e3956fca5249128f0d.jpg',2599.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172062336339.jpg\"/></p>',1686172063,1686172293,NULL),(513,14,2,'三星(SAMSUNG)34英寸准4K165Hz曲面电竞显示器','/aliyun/cf32c67283ec795d3a65819bcb512f61.jpg',2899.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172334224339.jpg\"/></p>',1686172335,1686172335,NULL),(514,14,2,'雷神星战28英寸4K超清旋转升降游戏电竞显示器','/aliyun/3de809313b876db5131e61360ee310a3.jpg',3299.00,0.10,0.10,0.10,60.00,10,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172370133393.jpg\"/></p>',1686172371,1686172371,NULL),(515,14,2,'雷神（ThundeRobot银翼 超清电竞游戏显示器','/aliyun/f9a455c1f707ff8ce1116ed240dd37cd.jpg',4499.00,0.09,0.09,0.09,60.00,9,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172449156584.jpg\"/></p><p><br/></p>',1686172451,1686172451,NULL),(516,14,3,'雷神琉璃幻彩机械键盘RGB灯条虹混彩背光白色红轴','/aliyun/a298073db0f2d2b8c525b0c9131b913a.jpg',129.00,3.61,3.61,3.61,70.00,360,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172530829968.jpg\"/></p>',1686172531,1686196276,NULL),(517,14,3,'雷神三模蓝牙游戏手柄G25 雷神手柄','/aliyun/0d2a6e3316bd72c776ae9a5096af0367.jpg',179.00,1.80,1.82,1.82,70.00,180,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172574201458.jpg\"/></p>',1686172575,1686196395,NULL),(518,14,3,'雷神双模蓝牙游戏手柄G50 雷神手柄','/aliyun/fbb6820ce7011437bed38b526c2a9f97.jpg',199.00,1.70,1.70,1.70,70.00,170,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172628318308.jpg\"/><br/></p>',1686172628,1686172628,NULL),(519,14,3,'雷蛇 Razer旋风黑V2X头戴式电竞游戏耳机 白色','/aliyun/392bc05e5827cdeceaf18621e892ade8.jpg',299.00,1.50,1.50,1.50,60.00,149,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172668494201.jpg\"/></p>',1686172670,1686188503,NULL),(520,14,3,'雷蛇 Razer旋风黑V2X头戴式电竞游戏耳机绿色','/aliyun/467c7f5ca716225926820d040294e984.jpg',299.00,1.50,1.50,1.50,60.00,149,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172699519512.jpg\"/></p><p><br/></p>',1686172702,1686188532,NULL),(521,14,3,'雷神大黄蜂联名款机械键盘电竞游戏键盘','/aliyun/e7a516f94e0544cbf8c0e689bf8f88ca.jpg',399.00,1.10,1.10,1.10,65.00,110,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686172743404678.jpg\"/></p>',1686172749,1686172749,NULL),(522,14,4,'RGB发光音律韵动鼠标垫800300','/aliyun/c93b56e2069cab6e69bb1436b9db5954.jpg',78.00,21.44,21.44,21.44,70.00,2128,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686173184215830.jpg\"/></p>',1686173188,1686196309,NULL),(523,14,4,'机械手感游戏键盘','/aliyun/15d39c457e6a8b80319a4076993e8b3a.jpg',78.00,21.44,21.44,21.44,70.00,2128,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686173214673937.jpg\"/></p>',1686173215,1686196309,NULL),(524,14,4,'电脑头戴式有线耳机','/aliyun/14e3ca877b1028b6a41878c9275f248d.jpg',78.00,21.44,21.44,21.44,70.00,2123,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686173246478411.jpg\"/></p>',1686173247,1686196395,NULL),(525,14,4,'英菲克金属灰有线鼠标','/aliyun/c45f3c47c8decf25ef6a93ac7ea3316a.jpg',78.00,21.44,21.44,21.44,70.00,2118,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686173288843667.jpg\"/></p>',1686173289,1686196395,NULL),(526,15,1,'小米平板5Pro 5G版 11英寸2.5K高清骁龙870','/aliyun/d4c2f41f0affc3eb8a2a2c8ddcda0b7b.jpg',2899.00,0.11,0.11,0.11,60.00,11,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686174745732965.jpg\"/></p>',1686174746,1686174746,NULL),(527,15,1,'RedmiBookPro14英寸视网膜屏轻薄笔记本','/aliyun/c38c459f742f2ea6dc6c26ae502117ff.jpg',4199.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686174814514415.jpg\"/></p>',1686174825,1686174825,NULL),(528,15,1,'小米游戏电视X Pro75英寸120Hz高刷智能电视','/aliyun/a7bb4912b143c56d86226288357d8d6e.jpg',4499.00,0.07,0.07,0.07,60.00,7,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686174879216785.jpg\"/></p>',1686174880,1686174880,NULL),(529,15,1,'小米9号平衡车 成人两轮电动体感车','/aliyun/6dafc390efd182d3bc17b63f4db035cb.jpg',4599.00,0.06,0.06,0.06,60.00,6,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686174913457419.jpg\"/></p>',1686174921,1686174921,NULL),(530,15,1,'米家小米出品尊享版550L大容量十字四门对开门冰箱','/aliyun/6808ff44ce40c0ddf1b87f1b61f24b3b.jpg',4899.00,0.06,0.06,0.06,60.00,6,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176165969791.jpg\"/></p>',1686176165,1686176165,NULL),(531,15,1,'米家小米出品15KG子母双筒分区洗衣机洗烘一体滚筒','/aliyun/4ec393705b558bbe44882cf8c4719e9a.jpg',4999.00,0.05,0.05,0.50,60.00,5,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176215928420.jpg\"/></p>',1686176217,1686176217,NULL),(532,15,1,'小米笔记本电脑3.2K高色域屏商务办公高清屏轻薄本','/aliyun/b24b03ce2bf0ebfd5611f447cea94c5d.jpg',5199.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176337882401.jpg\"/></p><p><br/></p>',1686176340,1686176340,NULL),(533,15,1,'小米86英寸超大屏 金属全面屏智能教育游戏电视','/aliyun/6ad1c48490931154db7344f63fffd030.jpg',5599.00,0.04,0.04,0.04,60.00,4,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176384464541.jpg\"/></p>',1686176385,1686176385,NULL),(534,15,1,'小米米家3匹 新一级能效智能互联客厅圆柱空调立式柜机','/aliyun/aba9b634530fd200c2ceba7dd3207651.jpg',8999.00,0.02,0.02,0.02,60.00,2,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176582541831.jpg\"/></p>',1686176584,1686176584,NULL),(535,15,1,'小米RedmiG Pro12代英特尔酷睿i916英寸游戏本','/aliyun/f0ff1d23e8cc225227e5cfb8519ef985.jpg',11099.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176622220551.jpg\"/></p>',1686176622,1686176622,NULL),(536,15,1,'小米电视 Redmi MAX 98英寸超大屏','/aliyun/7055f8fef6fffd382816ca583606e31b.jpg',15999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176881516642.jpg\"/></p>',1686176883,1686176883,NULL),(537,15,1,'小米电视 Redmi MAX 100英寸巨屏 金属全面屏','/aliyun/9a15d8980e28aafa412d4d9d748b9612.jpg',19999.00,0.01,0.01,0.01,60.00,1,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686176982653003.jpg\"/></p>',1686176982,1686176982,NULL),(538,15,2,'米家小米无线吸尘器2Lite 吸尘器','/aliyun/eca684fed634632803aabdfc31f43bf5.jpg',459.00,1.60,1.60,1.60,60.00,160,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177096889590.jpg\"/></p>',1686177098,1686177098,NULL),(539,15,2,'米家 小米暖风机电暖气 取暖器电暖器电热暖气片','/aliyun/98fe208e7aec134e2f56bebf11032039.jpg',499.00,1.00,1.00,1.00,60.00,100,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177123827432.jpg\"/></p>',1686177135,1686177590,NULL),(540,15,2,'米家智能微烤一体机 家用微波炉电烤箱光波炉','/aliyun/61c89adeceaa567296ea573115f9ca82.jpg',579.00,0.20,0.20,0.20,60.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177160780410.jpg\"/></p>',1686177161,1686177161,NULL),(541,15,2,'小米后视镜行车记录仪 高清全屏流媒体车载智能后视镜','/aliyun/cd0e8c3e44324ec91262769dbbece1e9.jpg',779.00,0.15,0.15,0.15,60.00,15,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177190285476.jpg\"/></p>',1686177191,1686177191,NULL),(542,15,2,'米家 小米纯净式无雾加湿器Pro','/aliyun/d0a4e8ef8ca288427e2acd1168b180c2.jpg',929.00,0.13,0.13,0.13,60.00,13,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177217544481.jpg\"/></p>',1686177218,1686177218,NULL),(543,15,2,'小米行李箱铝镁合金拉杆箱金属旅行箱高端商务密码箱20英寸银色','/aliyun/ccf7edcbbaaf8f6d45212212d1fc6e3b.jpg',999.00,0.20,0.20,0.20,60.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177260560145.jpg\"/></p>',1686177261,1686177371,NULL),(544,15,2,'小米米家空气净化器4Pro','/aliyun/975e7b7b79c1573e321c14029e378bd3.jpg',1079.00,0.20,0.20,0.20,60.00,20,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177348168808.jpg\"/></p>',1686177349,1686177349,NULL),(545,15,2,'小米路由器 AX9000 5G双频WIFI6 高通6核处理器','/aliyun/6f015aaedd977bf6a11b747ee70de025.jpg',1299.00,0.12,0.12,0.12,60.00,12,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177402367748.jpg\"/></p>',1686177407,1686177407,NULL),(546,15,2,'小米电视EA55 55英寸 金属全面屏 远场语音','/aliyun/fe1c8accc34d6c38e1761c705dc5663f.jpg',1399.00,0.12,0.12,0.12,60.00,12,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177440655119.jpg\"/></p>',1686177441,1686177441,NULL),(547,15,2,'小米米家小米出品10kg滚筒洗衣机全自动 直驱电机','/aliyun/1c86d37bd7a57bad98981ff0bf1c5328.jpg',1499.00,0.12,0.12,0.12,60.00,12,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177474495611.jpg\"/></p>',1686177481,1686177481,NULL),(548,15,2,'米家 小米扫地机器人 扫拖一体机 2Pro','/aliyun/2451786586a13091bbd9feff31ca9f4e.jpg',1799.00,0.12,0.12,0.12,60.00,12,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177511973598.jpg\"/></p>',1686177511,1686177511,NULL),(549,15,2,'九号平衡车 小九 体感智能骑行 遥控漂移 成人电动车','/aliyun/d1a50e928b0ace6ecf476574293a2876.jpg',1999.00,0.11,0.11,0.11,60.00,11,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177575129135.jpg\"/></p><p><br/></p>',1686177576,1686177576,NULL),(550,15,2,'小米 滚筒洗衣机 全自动 10kg 洗烘一体','/aliyun/6e5f6b5085c4ac83b25b8e366fd3dd9e.jpg',1999.00,0.11,0.11,0.11,60.00,11,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177615443274.jpg\"/></p>',1686177616,1686177616,NULL),(551,15,2,'小米（MI） 小米电视EA65 65英寸 金属全面屏','/aliyun/896afa9c326ea7aa46ed9093319c903f.jpg',1999.00,0.11,0.11,0.11,60.00,11,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686177976857104.jpg\"/></p>',1686177977,1686177977,NULL),(552,15,3,'小米体脂秤智能电子秤人体称重电子体脂称','/aliyun/318704d657fd57cf208ddb9b4482953b.jpg',69.00,4.30,4.30,4.30,70.00,430,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686178065406623.jpg\"/></p>',1686178066,1686178066,NULL),(553,15,3,'小米米家电水壶1A双层防烫304不锈钢烧水壶','/aliyun/b71e34f121b461a64003f6d0b5f7698b.jpg',79.00,3.20,3.20,3.20,65.00,320,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686178103471796.jpg\"/></p>',1686178117,1686178117,NULL),(554,15,3,'米家 小米电磁炉2','/aliyun/ef6f207c63a0a5d95392323cf7c55670.jpg',279.00,1.00,1.00,1.00,60.00,100,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686178153267490.jpg\"/></p>',1686178155,1686178155,NULL),(555,15,3,'米家 小米空气炸锅家用3.5L多功能智能空气锅','/aliyun/ea376dd8dd02b1bdb5aba37d9dc5a215.jpg',279.00,1.00,1.00,1.00,60.00,100,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686178180750184.jpg\"/></p>',1686178181,1686178181,NULL),(556,15,3,'小米（MI）米家智能破壁料','/aliyun/58395b736ef6146d3076c38775fe1f65.jpg',349.00,0.70,0.70,0.70,60.00,70,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686178224550701.jpg\"/></p>',1686178225,1686178225,NULL),(557,15,3,'米家 小米智能电压力锅5L 高压锅双胆','/aliyun/70c417450eb562447d50a47ebc565174.jpg',399.00,0.60,0.60,0.60,60.00,60,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686178250416912.jpg\"/></p>',1686178251,1686178251,NULL),(558,15,3,'米家小米mini筋膜枪 迷你按摩枪肌肉深层按摩放松器','/aliyun/e01ad18d00aac2f15afb180b6ed9f530.jpg',399.00,0.60,0.60,0.60,60.00,60,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686178283336468.jpg\"/></p>',1686178284,1686178284,NULL),(559,15,4,'德国黑金刚18件套指甲刀套装','/aliyun/ae9be6d61f2da858872148b3b97bb8ab.jpg',55.00,20.94,20.94,20.94,69.00,2094,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686179780403274.jpg\"/></p>',1686179781,1686179781,NULL),(560,15,4,'家用空气加湿器带氛围灯','/aliyun/da26f89a5198df3c66758815a957baa6.jpg',55.00,20.94,20.94,20.94,70.00,2094,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686179819136254.jpg\"/></p>',1686179820,1686179868,NULL),(561,15,4,'Mi 成人电动牙刷','/aliyun/ac96993fb97e0c1c91e75b7c8fa8179a.jpg',55.00,20.94,20.94,20.94,70.00,2094,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686179859958721.jpg\"/></p>',1686179859,1686179859,NULL),(562,15,4,'家用扫地机器人','/aliyun/6294f6841824c7b1eaea85238375399a.jpg',55.00,20.94,20.94,20.94,70.00,2094,'<p><img src=\"/uploads/upload/admin/2023/06/08/1686179897508865.jpg\"/></p>',1686179898,1686179898,NULL),(563,2,4,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,5.85,5.85,0.00,20.00,569,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930265814234.jpg\" title=\"1680672300655368.jpg\" alt=\"9d6ee5f371f1b4949dfe52e60b15cf93.jpg\"/></p>',1686930267,1691212296,NULL),(564,2,4,'九色哑光眼影盘','/aliyun/b646b08373c4b9131211e6040cba6903.jpg',19.90,50.00,80.00,80.00,20.00,7999,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930296792056.jpg\" title=\"1680672270180189.jpg\" alt=\"ae3cd6826cc5578f5b12b567879e463b.jpg\"/></p>',1686930303,1688548175,1688548175),(565,2,4,'LED智能手表','/aliyun/0d65d33f7847b9d3ff803714804c60dd.jpg',19.90,50.00,80.00,80.00,20.00,8000,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930343538963.jpg\" title=\"1680672237856474.jpg\" alt=\"653e8dfd1fe011e417ac3d8e37c7b52e.jpg\"/></p>',1686930345,1688550037,1688550037),(566,2,4,'一次性湿巾6包','/aliyun/9ad01a165500374f396bcbdb67bddd09.jpg',19.90,50.00,80.00,80.00,20.00,8000,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930375796602.jpg\" title=\"1680672204313821.jpg\" alt=\"f2af93eeba10c83729ab2a395113fab7.jpg\"/></p>',1686930376,1688551292,1688551292),(567,2,4,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,5.85,5.85,0.00,20.00,566,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930417120018.jpg\" title=\"1680672172413424.jpg\" alt=\"a1b12e0d9e8846c9549549aede3ff0a2.jpg\"/></p>',1686930419,1691212291,NULL),(568,2,4,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,5.85,5.85,0.00,20.00,570,'<p><img src=\"/uploads/upload/admin/2023/06/16/1686930447588892.jpg\" title=\"1680672139994221.jpg\" alt=\"0f4373debf22541dc75b638c6556c35f.jpg\"/></p>',1686930449,1691334519,NULL),(569,2,4,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,5.85,5.85,0.00,20.00,573,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688548314178610.png\" title=\"1688548314178610.png\" alt=\"2.png\"/></p>',1688548237,1691051931,NULL),(570,2,4,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,5.85,5.85,0.00,20.00,570,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688548373120855.png\" title=\"1688548373120855.png\" alt=\"3.png\"/></p>',1688548375,1691220508,NULL),(571,2,4,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,5.85,5.85,0.00,20.00,568,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688548414744227.png\" title=\"1688548414744227.png\" alt=\"4.png\"/></p>',1688548416,1691334519,NULL),(572,2,4,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,5.85,5.85,0.00,20.00,569,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688548474367223.jpg\" title=\"1688548474367223.jpg\" alt=\"5.jpg\"/></p>',1688548476,1691248582,NULL),(573,2,4,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,5.85,5.85,0.00,20.00,568,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688548503650054.jpg\" title=\"1688548503650054.jpg\" alt=\"6.jpg\"/></p>',1688548505,1691248560,NULL),(574,2,4,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,5.85,5.85,0.00,20.00,568,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688548531831658.jpg\" title=\"1688548531831658.jpg\" alt=\"7.jpg\"/></p>',1688548533,1691334519,NULL),(575,2,3,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,3.00,3.00,0.00,20.00,286,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688549301674918.png\" title=\"1688549301674918.png\" alt=\"11.png\"/></p>',1688549303,1691334531,NULL),(576,2,3,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',49.00,1.50,1.50,0.00,20.00,145,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688549334540755.png\" title=\"1688549334540755.png\" alt=\"22.png\"/></p>',1688549336,1691073239,NULL),(577,2,3,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,3.00,3.00,0.00,20.00,290,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688549371255811.png\" title=\"1688549371255811.png\" alt=\"33.png\"/></p>',1688549373,1691413395,NULL),(578,2,4,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,5.85,5.85,0.00,20.00,569,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688554597113991.png\" title=\"1688554597113991.png\" alt=\"5fb7ebcc221a3f2a30b7d172049bed6.png\"/></p>',1688554611,1691257279,NULL),(579,2,4,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,5.85,5.85,0.00,20.00,557,'<p><img src=\"/uploads/upload/admin/2023/07/05/1688555020413950.png\" title=\"1688555020413950.png\" alt=\"402281d4429726247a015df49adeb03.png\"/></p>',1688555022,1691334531,NULL),(580,17,1,'12','/aliyun/dd7c8de4cbbe2237206145dc876b859a.jpg',12.00,12.00,1.00,1.00,1.00,99,'<p>1231231</p>',1691246118,1691257259,NULL);
/*!40000 ALTER TABLE `la_box_award` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_box_award` with 580 row(s)
--

--
-- Table structure for table `la_box_draw`
--

DROP TABLE IF EXISTS `la_box_draw`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_box_draw` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL DEFAULT '' COMMENT '标题',
  `times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '抽取几次',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` int(1) unsigned NOT NULL DEFAULT '2' COMMENT '状态：1开启，2关闭',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='抽盒 - 抽取方式';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_box_draw`
--

LOCK TABLES `la_box_draw` WRITE;
/*!40000 ALTER TABLE `la_box_draw` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_box_draw` VALUES (1,'单抽',1,1,1,1669189211,1688669348),(2,'2连抽',2,2,1,1669189211,1688669371),(3,'3连抽',3,3,1,1669189211,1688669410),(4,'4连抽',4,4,1,1669189211,1688669432),(5,'5连抽',5,5,1,1669189211,1688669443);
/*!40000 ALTER TABLE `la_box_draw` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_box_draw` with 5 row(s)
--

--
-- Table structure for table `la_box_mark`
--

DROP TABLE IF EXISTS `la_box_mark`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_box_mark` (
  `id` int(10) unsigned NOT NULL,
  `icon` varchar(191) COLLATE utf8_unicode_ci DEFAULT '',
  `bg_thumb` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8_unicode_ci DEFAULT '',
  `sort` int(10) unsigned DEFAULT '0',
  `color` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='抽盒 - 奖赏类型';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_box_mark`
--

LOCK TABLES `la_box_mark` WRITE;
/*!40000 ALTER TABLE `la_box_mark` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_box_mark` VALUES (1,'/uploads/other/mark1.png','/uploads/other/mark_bg1.png','传说款',1,'#E6536D'),(2,'/uploads/other/mark2.png','/uploads/other/mark_bg2.png','史诗款',2,'#CC9933 '),(3,'/uploads/other/mark3.png','/uploads/other/mark_bg3.png','稀有款',3,'#1f19af'),(4,'/uploads/other/mark4.png','/uploads/other/mark_bg4.png','普通款',4,'#0D6BC9');
/*!40000 ALTER TABLE `la_box_mark` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_box_mark` with 4 row(s)
--

--
-- Table structure for table `la_box_rating`
--

DROP TABLE IF EXISTS `la_box_rating`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_box_rating` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `box_id` int(10) unsigned NOT NULL COMMENT '盒子ID',
  `user_id` int(10) unsigned NOT NULL COMMENT '用户ID',
  `goods_id` int(10) unsigned NOT NULL COMMENT '奖品ID',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '奖品名称',
  `star` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '星级',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `thumb` text COLLATE utf8mb4_unicode_ci COMMENT '图',
  `is_hidden` int(1) unsigned DEFAULT '2' COMMENT '是否匿名：1匿名，2不匿名',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='抽盒 - 评价';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_box_rating`
--

LOCK TABLES `la_box_rating` WRITE;
/*!40000 ALTER TABLE `la_box_rating` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_box_rating` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_box_rating` with 0 row(s)
--

--
-- Table structure for table `la_complain`
--

DROP TABLE IF EXISTS `la_complain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_complain` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT '用户ID',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '联系电话',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `thumb` text COLLATE utf8mb4_unicode_ci COMMENT '图',
  `reply` text COLLATE utf8mb4_unicode_ci COMMENT '回复内容',
  `status` int(1) unsigned DEFAULT '0',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='投诉';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_complain`
--

LOCK TABLES `la_complain` WRITE;
/*!40000 ALTER TABLE `la_complain` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_complain` VALUES (1,43,'投诉退款','15089402489','吗的太扯了吧搞不搞笑啊，都多少天了盒子都没摸到退款不让你他吗倒是发货啊',NULL,NULL,0,1689016344,1689016344),(2,43,'投诉退款','15089402489','请给个解释？不要觉得几百块钱我报不了警','/uploads/upload/index/2023/07/11/4ef10a6bfdd7978c3e2994547f40f9e6.jpg',NULL,0,1689016875,1689016875);
/*!40000 ALTER TABLE `la_complain` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_complain` with 2 row(s)
--

--
-- Table structure for table `la_complain_type`
--

DROP TABLE IF EXISTS `la_complain_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_complain_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='投诉 - 分类';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_complain_type`
--

LOCK TABLES `la_complain_type` WRITE;
/*!40000 ALTER TABLE `la_complain_type` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_complain_type` VALUES (1,'发货时间',0,1669619974,1669619974),(2,'投诉退款',1,1669620022,1683104558),(3,'延迟发货',2,1683104567,1683104567);
/*!40000 ALTER TABLE `la_complain_type` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_complain_type` with 3 row(s)
--

--
-- Table structure for table `la_config_group`
--

DROP TABLE IF EXISTS `la_config_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_config_group` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
  `sort` tinyint(4) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 配置组表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_config_group`
--

LOCK TABLES `la_config_group` WRITE;
/*!40000 ALTER TABLE `la_config_group` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_config_group` VALUES (1,'站点配置',1,1,'2022-07-11 01:50:06','2022-07-11 01:50:06'),(2,'存储配置',2,1,'2022-07-11 01:50:06','2022-07-11 01:50:06'),(5,'项目配置',5,1,'2022-07-11 03:01:41','2022-07-11 03:01:41'),(6,'短信配置',6,2,'2022-07-16 11:36:01','2022-07-16 11:36:01'),(7,'小程序配置',7,1,'2022-07-16 12:02:15','2022-07-16 12:02:17'),(9,'快递配置',10,1,'2022-10-09 10:05:02','2022-10-09 10:05:04'),(10,'提现配置',8,1,'2022-11-30 08:00:04','2022-11-30 08:00:05'),(11,'幸运盲盒配置',9,1,'2022-12-05 06:45:02','2022-12-05 06:45:03'),(12,'开红包设置',11,1,'2023-01-09 07:19:36','2023-01-09 07:19:37');
/*!40000 ALTER TABLE `la_config_group` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_config_group` with 9 row(s)
--

--
-- Table structure for table `la_configuration`
--

DROP TABLE IF EXISTS `la_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_configuration` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL DEFAULT '0' COMMENT '组ID',
  `label` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '配置项名称',
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '配置项字段',
  `val` text COLLATE utf8mb4_unicode_ci COMMENT '配置项值',
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'input' COMMENT '配置项类型，input输入框，radio单选，select下拉,image单图片',
  `content` text COLLATE utf8mb4_unicode_ci COMMENT '配置项类型的内容',
  `tips` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '输入提示',
  `sort` tinyint(4) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `translate` int(1) unsigned NOT NULL DEFAULT '2',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台 - 配置项表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_configuration`
--

LOCK TABLES `la_configuration` WRITE;
/*!40000 ALTER TABLE `la_configuration` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_configuration` VALUES (5,1,'标题','site_title','得运开盒','input','','',10,1,2,'2022-07-11 01:50:06','2023-08-01 20:50:08'),(17,2,'上传图片类型','storage_image_type','jpg,png,gif,jpeg','input',NULL,NULL,1,1,2,'2022-07-16 07:40:57','2022-07-16 07:40:57'),(18,2,'上传图片最大(M)','storage_image_size','5','input',NULL,NULL,2,1,2,'2022-07-16 07:41:34','2023-03-24 07:24:33'),(21,5,'项目Logo','app_logo','/aliyun/e0b901d2ed0e87979dadf96422531b64.jpg','image',NULL,'',1,1,1,'2022-07-16 08:54:49','2023-06-16 14:57:01'),(28,6,'是否开启真实短信','sms_switch','2','radio','{\"关闭\":\"2\",\"开启\":\"1\"}','',1,1,2,'2022-07-16 11:37:01','2022-07-18 01:17:27'),(29,6,'短信类型','sms_type','aliyun','radio','{\"阿里云\":\"aliyun\",\"腾讯云\":\"qcloud\"}',NULL,2,1,2,'2022-07-16 11:39:34','2022-07-16 13:01:20'),(30,6,'阿里云AccessKey','sms_aliyun_access_key',NULL,'input',NULL,'',3,1,2,'2022-07-16 11:42:01','2022-11-22 06:22:57'),(31,6,'阿里云SecretKey','sms_aliyun_secret_key',NULL,'input',NULL,NULL,4,1,2,'2022-07-16 11:42:55','2022-11-22 06:22:57'),(32,6,'阿里云Signname','sms_aliyun_signname',NULL,'input',NULL,NULL,5,1,2,'2022-07-16 11:44:21','2022-11-22 06:22:57'),(33,6,'阿里云Template_id','sms_aliyun_template_id',NULL,'input',NULL,NULL,6,1,2,'2022-07-16 11:45:18','2022-11-22 06:22:57'),(34,6,'腾讯云AccessKey','sms_qcloud_access_key',NULL,'input',NULL,NULL,7,1,2,'2022-07-16 11:50:11','2022-09-08 03:18:15'),(35,6,'腾讯云SecretKey','sms_qcloud_secret_key',NULL,'input',NULL,NULL,8,1,2,'2022-07-16 11:50:51','2022-09-08 03:18:15'),(36,6,'腾讯云Signname','sms_qcloud_signname',NULL,'input',NULL,NULL,9,1,2,'2022-07-16 11:51:28','2022-07-16 11:51:28'),(37,6,'腾讯云Template_id','sms_qcloud_template_id',NULL,'input',NULL,NULL,10,1,2,'2022-07-16 11:52:05','2022-09-08 03:18:15'),(38,7,'小程序Appid','mini_appid','wx0641f796c9c5ed4c','input',NULL,NULL,1,1,2,'2022-07-16 12:03:12','2023-08-01 19:31:53'),(39,7,'小程序Secret','mini_secret','bfd81f6343fb18fca1a501b946fb9c7a','input',NULL,NULL,2,1,2,'2022-07-16 12:08:47','2023-08-01 19:31:53'),(40,7,'支付商户号Key','mini_key','110aswdfcxasd41023651236541zxcsa','input',NULL,NULL,3,1,2,'2022-07-16 12:08:49','2023-07-05 08:26:14'),(41,7,'支付商户号','mini_mch','1608867833','input',NULL,NULL,4,1,2,'2022-07-16 12:08:52','2023-08-01 20:41:46'),(49,2,'上传音频类型','storage_audio_type','mp3','input',NULL,NULL,3,1,2,'2022-09-23 06:50:17','2022-09-23 06:50:17'),(50,2,'上传音频最大','storage_audio_size','5','input',NULL,NULL,4,1,2,'2022-09-23 06:51:04','2022-09-23 06:51:04'),(51,2,'上传视频类型','storage_video_type','mp4','input',NULL,NULL,5,1,2,'2022-09-23 06:52:03','2022-09-23 06:52:03'),(52,2,'上传视频最大(M)','storage_video_size','10','input',NULL,NULL,6,1,2,'2022-09-23 06:52:53','2022-09-23 06:52:53'),(53,2,'上传文件类型','storage_file_type','xlsl','input',NULL,NULL,7,1,2,'2022-09-23 06:54:29','2022-09-23 06:54:29'),(54,2,'上传文件最大(M)','storage_file_size','10','input',NULL,NULL,8,1,2,'2022-09-23 06:54:56','2022-09-23 06:54:56'),(71,9,'普通地区运费','express_fare','8','input',NULL,NULL,1,1,2,'2022-10-09 10:06:14','2023-05-25 14:31:33'),(84,9,'快递缓存时间','express_cache_times','30','input',NULL,NULL,2,1,2,'2022-10-21 09:57:01','2022-10-21 09:57:01'),(85,9,'快递Appcode','express_appcode','36972247bfa1478d8e9e4c753387170f','input',NULL,NULL,3,1,2,'2022-10-21 09:59:22','2023-07-05 08:26:51'),(86,9,'偏远地区运费','express_far_fare','25','input',NULL,'分别是：新疆，西藏，甘肃，宁夏，青海，内蒙古。',4,1,2,'2022-11-25 07:10:09','2022-11-25 07:10:09'),(87,10,'提现手续费(%)','withdraw_handling_rate','1','input',NULL,'',1,1,2,'2022-11-30 08:01:21','2023-05-24 14:15:43'),(88,10,'每日提现上限(次)','withdraw_day_max','10','input',NULL,NULL,2,1,2,'2022-11-30 08:02:39','2022-11-30 08:02:39'),(89,11,'奖品比例','luckbox_award_rate','1.00,3.00,26.00,70.00','input',NULL,'分别为：传说款，史诗款，稀有款，普通款（例：1.00,3.00,26.00,70.00 逗号拼接）',1,1,2,'2022-12-05 06:48:03','2022-12-05 06:50:50'),(90,11,'所需积分','luckbox_need_coin','6','input',NULL,NULL,2,1,2,'2022-12-05 10:08:46','2022-12-05 10:08:46'),(91,11,'超值隐藏所需进度','luckbox_hiden_need','10','input',NULL,NULL,3,1,2,'2022-12-05 10:11:14','2022-12-08 02:03:56'),(92,5,'分享海报','app_poster','/aliyun/7c6513c44ce16e9f2e53acbbd6809faf.jpg','image',NULL,NULL,2,1,1,'2022-12-08 06:39:43','2023-07-05 14:44:45'),(93,7,'支付回调接口','mini_notify_url','api/v1/wxpay/notify','input',NULL,NULL,5,1,2,'2022-12-10 03:51:10','2022-12-10 03:51:50'),(94,12,'开启所需积分','open_redpack_coin','888','input',NULL,NULL,1,1,2,'2023-01-09 07:21:10','2023-05-27 19:27:32'),(95,12,'最高红包金额','redpack_max_money','888','input',NULL,'仅作为展示',2,1,2,'2023-01-09 07:34:56','2023-01-09 07:34:56'),(96,2,'阿里云accessid:','access_key_id','LTAI5tCFMrVbTN25ddmxN4yM','input',NULL,'',10,1,2,'2023-05-03 13:55:40','2023-06-16 14:53:02'),(97,2,'阿里云accesskey','access_key_secret','LHejAFUZ4XAnv8KGl2dJaMqliQL5kL','input',NULL,NULL,11,1,2,'2023-05-03 13:56:36','2023-06-16 14:53:02'),(98,2,'阿里云oss实例地址','endpoint','oss-cn-shanghai.aliyuncs.com','input',NULL,NULL,13,1,2,'2023-05-03 13:59:25','2023-06-16 14:53:02'),(99,2,'阿里云存储空间名称:','bucket','qingyoumanghe','input',NULL,NULL,14,1,2,'2023-05-03 13:59:53','2023-06-16 14:53:02'),(100,5,'邀请好友背景图','share_bg','https://yundongmh.oss-cn-shanghai.aliyuncs.com/aliyun/6b7e4aada53782f576cf5286989d071d.jpg','image',NULL,NULL,3,1,2,'2023-05-05 12:11:27','2023-06-08 07:12:24'),(101,5,'邀请好友海报背景图','poster_bg','https://qingyoumanghe.oss-cn-shanghai.aliyuncs.com/aliyun/4ce1d54ad53b5a59af1ceaba83b06744.jpg','image',NULL,NULL,4,1,2,'2023-05-05 13:15:46','2023-07-05 14:44:45'),(102,1,'一级分佣比例%:','rebate_one','30','input',NULL,NULL,1,1,2,'2023-05-05 16:00:32','2023-07-05 08:26:26'),(103,1,'二级分佣比例%','rebate_two','20','input',NULL,NULL,2,1,2,'2023-05-05 16:00:52','2023-07-05 08:26:26'),(104,1,'三级分佣比例%','rebate_three','0','input',NULL,NULL,3,1,2,'2023-05-05 16:01:10','2023-05-06 07:30:23'),(105,1,'回收比例','dissolve_rate','20','input',NULL,NULL,0,1,2,'2023-05-23 20:09:02','2023-07-05 14:31:03'),(106,1,'首页弹窗内容','pop_con','1234','textarea',NULL,NULL,6,1,2,'2023-06-05 04:02:11','2023-08-07 16:17:06');
/*!40000 ALTER TABLE `la_configuration` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_configuration` with 48 row(s)
--

--
-- Table structure for table `la_delivery`
--

DROP TABLE IF EXISTS `la_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_delivery` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '快递公司',
  `code` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '快递编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='快递公司';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_delivery`
--

LOCK TABLES `la_delivery` WRITE;
/*!40000 ALTER TABLE `la_delivery` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_delivery` VALUES (1,'申通快递','sto'),(2,'EMS','ems'),(3,'顺丰快递','SFEXPRESS'),(4,'圆通快递','YTO'),(5,'中通快递','ZTO'),(6,'韵达快递','YUNDA'),(7,'天天快递','TTKDEX'),(8,'百世快递','HTKY'),(9,'德邦快递','DEPPON'),(10,'韵达快递','YUNDA'),(11,'京东','JD'),(12,'极兔速递','JITU');
/*!40000 ALTER TABLE `la_delivery` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_delivery` with 12 row(s)
--

--
-- Table structure for table `la_levels`
--

DROP TABLE IF EXISTS `la_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_levels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sort` int(1) unsigned NOT NULL COMMENT '权重',
  `name` varchar(191) CHARACTER SET utf8mb4 NOT NULL COMMENT '等级名称',
  `desc` varchar(191) CHARACTER SET utf8mb4 NOT NULL COMMENT '描述',
  `min` decimal(10,2) unsigned NOT NULL COMMENT '最小升级条件',
  `icon` varchar(191) CHARACTER SET utf8mb4 NOT NULL COMMENT '等级图标',
  `created_at` int(10) unsigned NOT NULL DEFAULT '0',
  `updated_at` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_levels`
--

LOCK TABLES `la_levels` WRITE;
/*!40000 ALTER TABLE `la_levels` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_levels` VALUES (1,1,'普通用户','注册即成',0.00,'0',0,0);
/*!40000 ALTER TABLE `la_levels` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_levels` with 1 row(s)
--

--
-- Table structure for table `la_luckbox_award`
--

DROP TABLE IF EXISTS `la_luckbox_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_luckbox_award` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `level` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '奖品等级',
  `type` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '奖品类型',
  `mark_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '赏类型',
  `title` varchar(191) NOT NULL DEFAULT '' COMMENT '奖品标题',
  `thumb` varchar(191) NOT NULL DEFAULT '' COMMENT '缩略图',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `real_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '普通比例',
  `status` int(1) unsigned DEFAULT '2',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='幸运盲盒 - 盒子奖品';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_luckbox_award`
--

LOCK TABLES `la_luckbox_award` WRITE;
/*!40000 ALTER TABLE `la_luckbox_award` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_luckbox_award` VALUES (1,1,1,1,'是','/aliyun/f4dafc89c3fe614d8cc675f2571b5e2e.jpg',0.10,0.10,2,1683255215,1686926813,1686926813),(2,1,3,4,'123','/aliyun/ba56c1ee1181d1eecc8ebfaecbcdf0cc.jpg',33.00,1.00,1,1690983638,1690983665,1690983665),(3,1,1,1,'122','/aliyun/475ac3b1d6a46e3def9033bcda18533e.jpg',999.00,1.00,1,1690999929,1691000243,1691000243);
/*!40000 ALTER TABLE `la_luckbox_award` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_luckbox_award` with 3 row(s)
--

--
-- Table structure for table `la_luckbox_join`
--

DROP TABLE IF EXISTS `la_luckbox_join`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_luckbox_join` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT '用户ID',
  `term_id` int(10) unsigned NOT NULL COMMENT '期号',
  `number` int(10) unsigned NOT NULL COMMENT '盲盒数字',
  `num` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '购买次数',
  `coin` decimal(10,0) unsigned DEFAULT '0',
  `money` decimal(10,2) unsigned DEFAULT '0.00',
  `status` int(1) DEFAULT '0' COMMENT '状态',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='幸运盲盒 - 参与记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_luckbox_join`
--

LOCK TABLES `la_luckbox_join` WRITE;
/*!40000 ALTER TABLE `la_luckbox_join` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_luckbox_join` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_luckbox_join` with 0 row(s)
--

--
-- Table structure for table `la_luckbox_notice`
--

DROP TABLE IF EXISTS `la_luckbox_notice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_luckbox_notice` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT '用户ID',
  `term_id` int(10) unsigned NOT NULL COMMENT '期数ID',
  `is_notice` int(1) unsigned NOT NULL DEFAULT '2' COMMENT '是否提醒：2没有，1提醒了',
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `term_id` (`term_id`) USING BTREE,
  KEY `user_id_term_id` (`user_id`,`term_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='幸运盲盒 - 中奖提醒';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_luckbox_notice`
--

LOCK TABLES `la_luckbox_notice` WRITE;
/*!40000 ALTER TABLE `la_luckbox_notice` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_luckbox_notice` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_luckbox_notice` with 0 row(s)
--

--
-- Table structure for table `la_luckbox_num`
--

DROP TABLE IF EXISTS `la_luckbox_num`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_luckbox_num` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `number` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='幸运盲盒 - 数字';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_luckbox_num`
--

LOCK TABLES `la_luckbox_num` WRITE;
/*!40000 ALTER TABLE `la_luckbox_num` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_luckbox_num` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_luckbox_num` with 0 row(s)
--

--
-- Table structure for table `la_luckbox_sign`
--

DROP TABLE IF EXISTS `la_luckbox_sign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_luckbox_sign` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT '用户ID',
  `term_id` int(10) unsigned NOT NULL COMMENT '期数',
  `coin` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '获得的积分',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `term_id` (`term_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='幸运盲盒 - 签到记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_luckbox_sign`
--

LOCK TABLES `la_luckbox_sign` WRITE;
/*!40000 ALTER TABLE `la_luckbox_sign` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_luckbox_sign` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_luckbox_sign` with 0 row(s)
--

--
-- Table structure for table `la_luckbox_term`
--

DROP TABLE IF EXISTS `la_luckbox_term`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_luckbox_term` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '期数标题',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `join_num` int(10) unsigned DEFAULT '0' COMMENT '加入人数',
  `luck_number` int(10) unsigned DEFAULT NULL COMMENT '本期幸运数字',
  `status` int(1) unsigned DEFAULT '0' COMMENT '状态',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='幸运盲盒 - 期';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_luckbox_term`
--

LOCK TABLES `la_luckbox_term` WRITE;
/*!40000 ALTER TABLE `la_luckbox_term` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_luckbox_term` VALUES (1,'2023032401',1679655600,0,NULL,1,1679630402,1679655603,NULL),(2,'2023032402',1679716800,0,NULL,1,1679655603,1679716802,NULL),(3,'2023032501',1679742000,0,NULL,1,1679716802,1679742002,NULL),(4,'2023032502',1679803200,0,NULL,1,1679742002,1679803202,NULL),(5,'2023032601',1679828400,0,NULL,1,1679803202,1679828402,NULL),(6,'2023032602',1679889600,0,NULL,1,1679828402,1679889602,NULL),(7,'2023032701',1679914800,0,NULL,1,1679889602,1679914802,NULL),(8,'2023032702',1679976000,0,NULL,1,1679914802,1679976002,NULL),(9,'2023032801',1680001200,0,NULL,1,1679976002,1680001202,NULL),(10,'2023032802',1680062400,0,NULL,1,1680001202,1680062402,NULL),(11,'2023032901',1680087600,0,NULL,1,1680062402,1680087602,NULL),(12,'2023032902',1680148800,0,NULL,1,1680087602,1680148802,NULL),(13,'2023033001',1680174000,0,NULL,0,1680148802,1680148802,NULL);
/*!40000 ALTER TABLE `la_luckbox_term` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_luckbox_term` with 13 row(s)
--

--
-- Table structure for table `la_migrations`
--

DROP TABLE IF EXISTS `la_migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_migrations`
--

LOCK TABLES `la_migrations` WRITE;
/*!40000 ALTER TABLE `la_migrations` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2019_08_19_081257_create_permission_tables',1),(3,'2019_08_20_155900_tags',1),(4,'2019_08_20_160154_categories',1),(5,'2019_08_20_160326_articles',1),(6,'2019_08_20_160552_article_tag',1),(7,'2019_08_23_085700_config_group',1),(8,'2019_08_23_102411_configuration',1),(9,'2019_08_26_101856_login_log',1),(10,'2019_08_26_101940_operate_log',1);
/*!40000 ALTER TABLE `la_migrations` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_migrations` with 10 row(s)
--

--
-- Table structure for table `la_operate_banners`
--

DROP TABLE IF EXISTS `la_operate_banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_operate_banners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '分类ID',
  `title` varchar(191) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '轮播图描述',
  `thumb` varchar(191) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '图片',
  `url_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '跳转方式：1不跳转，2跳转详情，3内部跳转，4跳转外连',
  `links` varchar(191) CHARACTER SET utf8mb4 DEFAULT NULL,
  `editor` text CHARACTER SET utf8mb4 COMMENT '详情',
  `status` tinyint(1) unsigned DEFAULT '2' COMMENT '状态：0禁用，1启用',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='运营 - 轮播图';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_operate_banners`
--

LOCK TABLES `la_operate_banners` WRITE;
/*!40000 ALTER TABLE `la_operate_banners` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_operate_banners` VALUES (1,1,NULL,'/uploads/upload/admin/2023/03/24/a4bffd7fee0b50134d1a86361acaf0ba.jpeg',3,'/pages/box/box',NULL,1,1669114057,1690999994),(2,2,NULL,'/uploads/upload/admin/2023/03/24/8c87896b5ba3f4e8bb8a6de1936b57ad.png',3,'/package/mine/mall-order',NULL,1,1669114250,1690999706),(3,2,NULL,'/uploads/upload/admin/2023/03/24/7a8b8fc4fff9b3439bdd86b8ea77dfbb.png',3,'/package/mine/mall-order',NULL,1,1669114273,1690999404),(4,2,NULL,'/uploads/upload/admin/2023/03/24/5136c5d96c5aba510fe6c9cab149c978.png',3,'/package/index/luck-box',NULL,2,1669114281,1691000272),(5,2,NULL,'/uploads/upload/admin/2023/03/24/3facda46607da6088a7117fe2f315c21.png',3,'/package/index/luck-box',NULL,1,1669114287,1690999553),(6,3,NULL,'/uploads/upload/admin/2023/03/24/54843efcc7978768e3566b16cf6fca8b.jpeg',1,NULL,NULL,1,1669197496,1690999402),(8,1,NULL,'/uploads/upload/admin/2023/03/24/7efc08bd12d4d35780929adb29dd1aa5.jpeg',3,'/package/index/exchange',NULL,1,1670554796,1691000424);
/*!40000 ALTER TABLE `la_operate_banners` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_operate_banners` with 7 row(s)
--

--
-- Table structure for table `la_operate_redpack`
--

DROP TABLE IF EXISTS `la_operate_redpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_operate_redpack` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '金额',
  `real_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '普通比例',
  `num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='运营 - 红包';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_operate_redpack`
--

LOCK TABLES `la_operate_redpack` WRITE;
/*!40000 ALTER TABLE `la_operate_redpack` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_operate_redpack` VALUES (1,28.00,1.00,100,1683104535,1684949645,NULL),(2,18.00,10.00,1000,1684949612,1684949649,NULL),(3,8.00,30.00,3000,1684949618,1685435740,NULL),(4,38.00,0.10,10,1684949631,1684949641,NULL),(5,5.00,18.00,1800,1685435764,1685435764,NULL);
/*!40000 ALTER TABLE `la_operate_redpack` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_operate_redpack` with 5 row(s)
--

--
-- Table structure for table `la_order`
--

DROP TABLE IF EXISTS `la_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_sn` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '订单号',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `data_id` int(10) DEFAULT NULL COMMENT '数据ID',
  `type` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单类型',
  `pay_type` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付类型：1微信，2支付宝',
  `total_money` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '支付金额',
  `coin` decimal(15,0) unsigned NOT NULL DEFAULT '0' COMMENT '使用金币数量',
  `coin_dis` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '金币抵扣金额',
  `money_dis` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '余额抵扣金额',
  `gold_dis` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '购物金抵扣金额',
  `pay_money` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际支付金额（微信，支付宝）',
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '第三方订单号',
  `pay_time` int(10) unsigned DEFAULT NULL COMMENT '支付时间',
  `refund_status` int(1) DEFAULT '0' COMMENT '退款状态：0未操作，1可退款，2待退款，3已退款',
  `status` int(1) DEFAULT '0' COMMENT '状态：-1支付失败，0待支付，1已完成',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='订单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_order`
--

LOCK TABLES `la_order` WRITE;
/*!40000 ALTER TABLE `la_order` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_order` VALUES (1,'C705468248714238',2,2,1,3,9.90,0,0.00,0.00,0.00,9.90,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/5da7edbaf00fc3e33dcb38e23fc2f07e.jpg\",\"price\":\"9.90\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688546824,1688546825,NULL),(2,'C705469890031812',2,2,1,2,49.50,0,0.00,49.50,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/5da7edbaf00fc3e33dcb38e23fc2f07e.jpg\",\"price\":\"9.90\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688546989,0,1,1688546989,1688546989,NULL),(3,'C705470175182480',2,2,1,2,9.90,0,0.00,9.90,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/5da7edbaf00fc3e33dcb38e23fc2f07e.jpg\",\"price\":\"9.90\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688547017,0,1,1688547017,1688547017,NULL),(4,'C705472673043270',2,2,1,2,9.90,0,0.00,9.90,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/5da7edbaf00fc3e33dcb38e23fc2f07e.jpg\",\"price\":\"9.90\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688547267,0,1,1688547267,1688547267,NULL),(5,'C705472774865162',2,2,1,2,49.50,0,0.00,49.50,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/5da7edbaf00fc3e33dcb38e23fc2f07e.jpg\",\"price\":\"9.90\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688547277,0,1,1688547277,1688547277,NULL),(6,'C705472991800059',2,2,1,2,49.50,0,0.00,49.50,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/5da7edbaf00fc3e33dcb38e23fc2f07e.jpg\",\"price\":\"9.90\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688547299,0,1,1688547299,1688547299,NULL),(7,'C705476088403557',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/81f19366d6d184c3b0e5a1cf973480ee.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688547608,0,1,1688547608,1688547608,NULL),(8,'C705480119067077',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688548011,0,1,1688548011,1688548011,NULL),(10,'C705523595911440',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552359,0,1,1688552359,1688552359,NULL),(11,'C705523706208672',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552370,0,1,1688552370,1688552370,NULL),(12,'C705524667418726',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552466,0,1,1688552466,1688552466,NULL),(13,'C705524755083215',2,2,1,3,83.30,0,0.00,29.14,0.00,54.16,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688552475,1688552476,NULL),(14,'C705525046733826',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552504,0,1,1688552504,1688552504,NULL),(16,'C705525132865684',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552513,0,1,1688552513,1688552513,NULL),(17,'C705525316441422',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552531,0,1,1688552531,1688552531,NULL),(18,'C705525449243548',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552544,0,1,1688552544,1688552544,NULL),(19,'C705525678556691',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552567,0,1,1688552567,1688552567,NULL),(20,'C705525765793223',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688552576,0,1,1688552576,1688552576,NULL),(22,'C705548617709485',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688554861,0,1,1688554861,1688554861,NULL),(24,'C705551476681306',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688555147,0,1,1688555147,1688555147,NULL),(25,'C705551493120620',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688555149,0,1,1688555149,1688555149,NULL),(26,'C705551619890941',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688555161,0,1,1688555161,1688555161,NULL),(27,'C705551642182532',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688555164,0,1,1688555164,1688555164,NULL),(28,'C705552008658328',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688555200,0,1,1688555200,1688555200,NULL),(29,'C705552173980503',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"苹果14来袭丨超然好货随机一件不支持七天无理由退款\",\"thumb\":\"\\/aliyun\\/26992efc68ca6f5a2b425dc192f75155.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688555217,0,1,1688555217,1688555217,NULL),(30,'C705567556199582',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556755,0,1,1688556755,1688556755,NULL),(31,'C705567611762899',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556761,0,1,1688556761,1688556761,NULL),(32,'C705567638823423',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556763,0,1,1688556763,1688556763,NULL),(33,'C705567799871100',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556779,0,1,1688556779,1688556779,NULL),(34,'C705567890155193',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556789,0,1,1688556789,1688556789,NULL),(36,'C705567987186435',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556798,0,1,1688556798,1688556798,NULL),(37,'C705568066411413',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556806,0,1,1688556806,1688556806,NULL),(38,'C705568820019827',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556882,0,1,1688556882,1688556882,NULL),(39,'C705568938272265',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556893,0,1,1688556893,1688556893,NULL),(40,'C705569019279311',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556901,0,1,1688556901,1688556901,NULL),(41,'C705569269992768',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556927,0,1,1688556927,1688556927,NULL),(42,'C705569881099483',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556988,0,1,1688556988,1688556988,NULL),(43,'C705569975874325',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688556997,0,1,1688556997,1688556997,NULL),(44,'C705570170659491',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688557017,0,1,1688557017,1688557017,NULL),(46,'C705570275995599',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688557027,0,1,1688557027,1688557027,NULL),(47,'C705570380211554',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688557038,0,1,1688557038,1688557038,NULL),(49,'C705570983036605',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688557098,0,1,1688557098,1688557098,NULL),(50,'C705572009813185',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688557200,0,1,1688557200,1688557200,NULL),(51,'C705572130698348',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688557213,0,1,1688557213,1688557213,NULL),(52,'C705578589614011',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688557858,0,1,1688557858,1688557858,NULL),(53,'C705581848229273',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558184,0,1,1688558184,1688558184,NULL),(54,'C705582021385134',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558202,0,1,1688558202,1688558202,NULL),(55,'C705582369241982',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558236,0,1,1688558236,1688558236,NULL),(56,'C705582953693645',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558295,0,1,1688558295,1688558295,NULL),(57,'C705583142937245',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558314,0,1,1688558314,1688558314,NULL),(58,'C705583415245345',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558341,0,1,1688558341,1688558341,NULL),(59,'C705583635095996',2,2,1,3,83.30,0,0.00,10.96,0.00,72.34,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688558363,1688558364,NULL),(60,'C705588567920868',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558856,0,1,1688558856,1688558856,NULL),(61,'C705588744193289',2,2,1,3,83.30,0,0.00,59.26,0.00,24.04,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688558874,1688558875,NULL),(62,'C705588954375644',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688558895,0,1,1688558895,1688558895,NULL),(63,'C705590923489290',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559092,0,1,1688559092,1688559092,NULL),(65,'C705591107544527',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559110,0,1,1688559110,1688559110,NULL),(66,'C705591180531730',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559118,0,1,1688559118,1688559118,NULL),(67,'C705591287949360',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559128,0,1,1688559128,1688559128,NULL),(68,'C705591361919133',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559136,0,1,1688559136,1688559136,NULL),(69,'C705591434361470',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559143,0,1,1688559143,1688559143,NULL),(70,'C705594219271712',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559421,0,1,1688559421,1688559421,NULL),(71,'C705594431698858',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688559443,0,1,1688559443,1688559443,NULL),(72,'C705624145808552',2,2,1,3,16.66,0,0.00,2.34,0.00,14.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688562414,1688562415,NULL),(73,'C705666860393091',2,2,1,3,16.66,0,0.00,2.34,0.00,14.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688566686,1688566686,NULL),(74,'C705666893150129',2,2,1,3,16.66,0,0.00,2.34,0.00,14.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688566689,1688566690,NULL),(75,'C705666946135208',2,2,1,3,83.30,0,0.00,2.34,0.00,80.96,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688566694,1688566695,NULL),(76,'C705668776953865',2,2,1,3,16.66,0,0.00,2.34,0.00,14.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688566877,1688566878,NULL),(77,'C705668832646405',2,2,1,3,83.30,0,0.00,2.34,0.00,80.96,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688566883,1688566884,NULL),(78,'C705671161092204',2,2,1,3,83.30,0,0.00,2.34,0.00,80.96,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688567116,1688567124,NULL),(79,'C705688916423042',2,2,1,3,49.98,0,0.00,35.90,0.00,14.08,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":3,\"invite_user_id\":null,\"draw_id\":3}',NULL,NULL,0,-1,1688568891,1688568895,NULL),(80,'C705688984952948',2,2,1,2,33.32,0,0.00,33.32,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":2,\"invite_user_id\":null,\"draw_id\":2}',NULL,1688568898,0,1,1688568898,1688568898,NULL),(81,'C705689319560151',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688568931,0,1,1688568931,1688568931,NULL),(82,'C705689556145017',2,2,1,3,83.30,0,0.00,10.08,0.00,73.22,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688568955,1688568959,NULL),(83,'C705689981179162',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688568998,0,1,1688568998,1688568998,NULL),(84,'C705690833302776',2,NULL,2,3,8.00,0,0.00,3.02,0.00,4.98,'{\"type\":1,\"order_list_id\":303,\"express_money\":\"8.00\",\"name\":\"12\",\"mobile\":\"15121212121\",\"address\":\"北京市北京城区东城区12\",\"ramk\":\"\"}',NULL,NULL,0,-1,1688569083,1688569087,NULL),(85,'C705691215227251',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569121,0,1,1688569121,1688569121,NULL),(86,'C705692382101713',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569238,0,1,1688569238,1688569238,NULL),(87,'C705695287502618',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569528,0,1,1688569528,1688569528,NULL),(88,'C705695598030762',2,2,1,2,33.32,0,0.00,33.32,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":2,\"invite_user_id\":null,\"draw_id\":2}',NULL,1688569559,0,1,1688569559,1688569559,NULL),(89,'C705696341555907',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569634,0,1,1688569634,1688569634,NULL),(90,'C705696459509692',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569645,0,1,1688569645,1688569645,NULL),(91,'C705696542949986',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569654,0,1,1688569654,1688569654,NULL),(92,'C705696727729326',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569672,0,1,1688569672,1688569672,NULL),(93,'C705696892317385',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569689,0,1,1688569689,1688569689,NULL),(94,'C705696961893788',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569696,0,1,1688569696,1688569696,NULL),(95,'C705697711034260',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569771,0,1,1688569771,1688569771,NULL),(96,'C705697780153945',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569778,0,1,1688569778,1688569778,NULL),(97,'C705697856846137',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569785,0,1,1688569785,1688569785,NULL),(98,'C705697942369626',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569794,0,1,1688569794,1688569794,NULL),(99,'C705698101116528',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569810,0,1,1688569810,1688569810,NULL),(100,'C705698177095786',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569817,0,1,1688569817,1688569817,NULL),(101,'C705698249641041',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569824,0,1,1688569824,1688569824,NULL),(102,'C705698350716154',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569835,0,1,1688569835,1688569835,NULL),(103,'C705698417992820',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569841,0,1,1688569841,1688569841,NULL),(104,'C705698491033964',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688569849,0,1,1688569849,1688569849,NULL),(105,'C705698567590455',2,2,1,3,83.30,0,0.00,70.40,0.00,12.90,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688569856,1688569860,NULL),(106,'C705706732454882',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688570673,0,1,1688570673,1688570673,NULL),(110,'C705707967888626',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688570796,0,1,1688570796,1688570796,NULL),(111,'C705708360262261',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688570836,0,1,1688570836,1688570836,NULL),(112,'C705708464807315',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688570846,0,1,1688570846,1688570846,NULL),(113,'C705708533552863',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688570853,0,1,1688570853,1688570853,NULL),(115,'C705708626159545',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688570862,0,1,1688570862,1688570862,NULL),(117,'C705709052688834',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688570905,0,1,1688570905,1688570905,NULL),(118,'C705710362889306',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688571036,0,1,1688571036,1688571036,NULL),(119,'C706783770349088',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1688578377,0,1,1688578377,1688578377,NULL),(120,'C706783965868117',2,2,1,2,49.98,0,0.00,49.98,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":3,\"invite_user_id\":null,\"draw_id\":3}',NULL,1688578396,0,1,1688578396,1688578396,NULL),(121,'C706784982036487',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688578498,0,1,1688578498,1688578498,NULL),(122,'C706788049053155',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688578804,0,1,1688578804,1688578804,NULL),(123,'C706800920165808',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688580092,0,1,1688580092,1688580092,NULL),(125,'C706801096203941',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688580109,0,1,1688580109,1688580109,NULL),(126,'C706801241184929',2,2,1,3,16.66,0,0.00,8.46,0.00,8.20,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688580124,1688580128,NULL),(127,'C706232696191906',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688623269,0,1,1688623269,1688623269,NULL),(128,'C706451191661707',5,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688645119,1688645123,NULL),(129,'C707612178359651',2,2,1,3,16.66,0,0.00,7.34,0.00,9.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688661217,1688661223,NULL),(130,'C707612512514133',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688661251,0,1,1688661251,1688661251,NULL),(131,'C707612835598981',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688661283,0,1,1688661283,1688661283,NULL),(132,'C707104947820110',6,2,1,3,33.32,0,0.00,0.00,0.00,33.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":2,\"invite_user_id\":null,\"draw_id\":2}',NULL,NULL,0,-1,1688710494,1688710498,NULL),(133,'C707107273821971',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1688710727,0,1,1688710727,1688710727,NULL),(134,'C707118995893964',8,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688711899,1688711902,NULL),(135,'C707203413242812',5,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688720341,1688720345,NULL),(136,'C707288422218349',20,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688728842,1688728848,NULL),(137,'C707290495850019',19,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688729049,1688729052,NULL),(138,'C707318386558664',22,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688731838,1688731843,NULL),(139,'C707394520368547',24,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688739452,1688739457,NULL),(140,'C708706114606070',13,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688770611,1688770617,NULL),(141,'C708960011385828',28,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688796001,1688796006,NULL),(142,'C708973957464037',28,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688797395,1688797399,NULL),(143,'C708976075277446',28,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688797607,1688797612,NULL),(144,'C708976311971432',28,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688797631,1688797633,NULL),(145,'C708978606152616',28,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688797860,1688797868,NULL),(146,'C708985143565608',28,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688798514,1688798518,NULL),(147,'C709802564453361',2,2,1,3,16.66,0,0.00,7.26,0.00,9.40,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688880256,1688880266,NULL),(148,'C709803078552453',2,2,1,3,16.66,0,0.00,7.26,0.00,9.40,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688880307,1688880311,NULL),(149,'C709803121950554',2,2,1,3,16.66,0,0.00,7.26,0.00,9.40,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688880312,1688880315,NULL),(150,'C709995598710433',35,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688899559,1688899563,NULL),(151,'C709139617781383',34,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1688913961,1688913964,NULL),(152,'C710701526871782',39,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1688970152,1688970161,NULL),(153,'C710877008583941',42,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,0,1688987700,1688987700,NULL),(154,'C710031365426659',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689003136,0,1,1689003136,1689003136,NULL),(155,'C710032369470225',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689003236,0,1,1689003236,1689003236,NULL),(157,'C710033422661387',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689003342,0,1,1689003342,1689003342,NULL),(158,'C710047495048172',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689004749,0,1,1689004749,1689004749,NULL),(159,'C710047604560218',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689004760,0,1,1689004760,1689004760,NULL),(160,'C710047715727715',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689004771,0,1,1689004771,1689004771,NULL),(161,'C710047778836401',3,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689004777,0,1,1689004777,1689004777,NULL),(162,'C713806578682045',47,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,0,1689180657,1689180657,NULL),(163,'C717900119344482',2,2,1,3,16.66,0,0.00,7.26,0.00,9.40,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1689590011,1689590017,NULL),(164,'C717901805421275',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1689590180,0,1,1689590180,1689590180,NULL),(165,'C717911596848269',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1689591159,0,1,1689591159,1689591159,NULL),(166,'C717935293445380',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689593529,0,1,1689593529,1689593529,NULL),(167,'C717936026205771',2,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1689593602,0,1,1689593602,1689593602,NULL),(168,'C718551465604183',2,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1689655146,0,1,1689655146,1689655146,NULL),(169,'C802192790708579',48,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1690919279,0,1,1690919279,1690919279,NULL),(170,'C802196801596601',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690919680,1690919681,NULL),(171,'C802227583299785',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690922758,1690922759,NULL),(172,'C802236003693753',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690923600,1690923601,NULL),(173,'C802534319068627',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":\"49\",\"draw_id\":5}',NULL,1690953431,0,1,1690953431,1690953431,NULL),(174,'C802534363621369',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690953436,1690953437,NULL),(175,'C802580149822557',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958014,1690958016,NULL),(176,'C802580191035658',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958019,1690958020,NULL),(177,'C802580433611192',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958043,1690958044,NULL),(178,'C802580716431776',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958071,1690958074,NULL),(179,'C802581460707953',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958146,1690958147,NULL),(180,'C802581628372815',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958162,0,1,1690958162,1690958162,NULL),(181,'C802581743295106',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958174,0,1,1690958174,1690958174,NULL),(182,'C802581825217956',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958182,0,1,1690958182,1690958182,NULL),(183,'C802581891596318',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958189,0,1,1690958189,1690958189,NULL),(184,'C802582001604328',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958200,1690958201,NULL),(185,'C802582266803832',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958226,1690958227,NULL),(186,'C802582309498793',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958230,0,1,1690958230,1690958230,NULL),(187,'C802582461287919',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958246,0,1,1690958246,1690958246,NULL),(188,'C802583078881495',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958307,0,1,1690958307,1690958307,NULL),(189,'C802583151589846',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958315,0,1,1690958315,1690958315,NULL),(190,'C802583301476150',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958330,0,1,1690958330,1690958330,NULL),(191,'C802583553606012',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958355,0,1,1690958355,1690958355,NULL),(192,'C802583641910600',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958364,0,1,1690958364,1690958364,NULL),(193,'C802583710359928',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958371,0,1,1690958371,1690958371,NULL),(194,'C802583716528035',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690958371,1690958372,NULL),(195,'C802583799903164',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958379,0,1,1690958379,1690958379,NULL),(198,'C802583916545875',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690958391,0,1,1690958391,1690958391,NULL),(199,'C802586430051568',48,NULL,2,2,8.00,0,0.00,8.00,0.00,0.00,'{\"type\":1,\"order_list_id\":597,\"express_money\":\"8.00\",\"name\":\"12345\",\"mobile\":\"19568818675\",\"address\":\"湖南省娄底市冷水江市金竹西路万盛广场\",\"ramk\":\"\"}',NULL,1690958643,0,1,1690958643,1690958643,NULL),(200,'C802588701238257',49,2,1,3,66.64,0,0.00,0.00,0.00,66.64,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":4,\"invite_user_id\":null,\"draw_id\":4}',NULL,NULL,0,-1,1690958870,1690958871,NULL),(201,'C802592530168421',49,2,1,3,66.64,0,0.00,0.00,0.00,66.64,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":4,\"invite_user_id\":null,\"draw_id\":4}',NULL,NULL,0,-1,1690959253,1690959253,NULL),(202,'C802596080889167',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690959608,1690959608,NULL),(203,'C802596114444594',49,2,1,3,33.32,0,0.00,0.00,0.00,33.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":2,\"invite_user_id\":null,\"draw_id\":2}',NULL,NULL,0,-1,1690959611,1690959612,NULL),(204,'C802598430857603',49,2,1,3,33.32,0,0.00,0.00,0.00,33.32,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":2,\"invite_user_id\":null,\"draw_id\":2}',NULL,NULL,0,-1,1690959843,1690959843,NULL),(205,'C802598542588760',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690959854,1690959855,NULL),(206,'C802621571330393',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690962157,1690962157,NULL),(207,'C802626847322372',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690962684,1690962686,NULL),(208,'C802666909462558',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690966690,1690966691,NULL),(209,'C802751941706113',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690975194,0,1,1690975194,1690975194,NULL),(210,'C802772897836234',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690977289,1690977290,NULL),(211,'C802819230545715',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1690981923,1690981923,NULL),(212,'C802819295945944',49,2,1,3,83.30,0,0.00,0.00,0.00,83.30,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,NULL,0,-1,1690981929,1690981930,NULL),(213,'C802819718024189',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690981971,0,1,1690981971,1690981971,NULL),(214,'C802819874371913',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690981987,0,1,1690981987,1690981987,NULL),(215,'C802820052283700',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690982005,0,1,1690982005,1690982005,NULL),(216,'C802820265351434',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690982026,0,1,1690982026,1690982026,NULL),(217,'C803967662972090',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1690996766,0,1,1690996766,1690996766,NULL),(218,'C803967926915929',49,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1690996792,0,1,1690996792,1690996792,NULL),(219,'C803987465058933',49,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1690998746,0,1,1690998746,1690998746,NULL),(220,'C803000295394294',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691000029,0,1,1691000029,1691000029,NULL),(221,'C803007228931826',49,NULL,2,2,8.00,0,0.00,8.00,0.00,0.00,'{\"type\":1,\"order_list_id\":634,\"express_money\":\"8.00\",\"name\":\"12\",\"mobile\":\"15121212121\",\"address\":\"北京市北京城区东城区12\",\"ramk\":\"\"}',NULL,1691000722,0,1,1691000722,1691000722,NULL),(222,'C803345719364746',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691034571,0,1,1691034571,1691034571,NULL),(223,'C803348055918142',49,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691034805,0,1,1691034805,1691034805,NULL),(224,'C803371101974787',50,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691037110,0,1,1691037110,1691037110,NULL),(225,'C803371196286554',50,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691037119,0,1,1691037119,1691037119,NULL),(226,'C803378522966584',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1691037852,1691037853,NULL),(227,'C803378573030599',49,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1691037857,1691037858,NULL),(228,'C803507985995398',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691050798,0,1,1691050798,1691050798,NULL),(229,'C803519319551701',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691051931,0,1,1691051931,1691051931,NULL),(230,'C803527177502441',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691052717,0,1,1691052717,1691052717,NULL),(231,'C803638129148889',49,16,3,3,6308.00,0,0.00,0.00,0.00,6308.00,'{\"id\":16,\"title\":\"苹果14 256G 支持移动联通5G\",\"thumb\":\"\\/uploads\\/upload\\/admin\\/2023\\/03\\/29\\/4f57cd59d70b73369eb16005f67ccacb.png\",\"price\":\"6300.00\",\"num\":\"1\",\"sku_id\":34,\"sku_name\":\"默认\",\"express_money\":\"8.00\",\"name\":\"12\",\"mobile\":\"15121212121\",\"address\":\"北京市北京城区东城区12\",\"ramk\":\"\"}',NULL,NULL,0,-1,1691063812,1691063813,NULL),(232,'C803638553231006',53,2,1,3,16.66,0,0.00,0.00,0.00,16.66,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,NULL,0,-1,1691063855,1691063856,NULL),(233,'C803732390894097',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691073239,0,1,1691073239,1691073239,NULL),(234,'C803741701675900',49,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691074170,0,1,1691074170,1691074170,NULL),(235,'C803756135395503',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691075613,0,1,1691075613,1691075613,NULL),(237,'C803756699377632',49,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691075669,0,1,1691075669,1691075669,NULL),(238,'C805058364345852',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691205836,0,1,1691205836,1691205836,NULL),(239,'C805064262649064',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691206426,0,1,1691206426,1691206426,NULL),(240,'C805067124458413',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691206712,0,1,1691206712,1691206712,NULL),(241,'C805070202692918',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691207020,0,1,1691207020,1691207020,NULL),(242,'C805092770704310',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691209277,0,1,1691209277,1691209277,NULL),(244,'C805122847506228',54,2,1,2,66.64,0,0.00,66.64,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":4,\"invite_user_id\":null,\"draw_id\":4}',NULL,1691212284,0,1,1691212284,1691212284,NULL),(245,'C805122912087392',54,2,1,2,66.64,0,0.00,66.64,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":4,\"invite_user_id\":null,\"draw_id\":4}',NULL,1691212291,0,1,1691212291,1691212291,NULL),(246,'C805122967468858',54,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691212296,0,1,1691212296,1691212296,NULL),(247,'C805205088670405',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691220508,0,1,1691220508,1691220508,NULL),(249,'C805485608649785',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691248560,0,1,1691248560,1691248560,NULL),(250,'C805485822246622',54,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691248582,0,1,1691248582,1691248582,NULL),(251,'C806572593091639',54,17,1,2,123.00,0,0.00,123.00,0.00,0.00,'{\"id\":17,\"title\":\"123\",\"thumb\":\"\\/aliyun\\/131dd5cea595f8dc2bea5ee1df1973e6.jpg\",\"price\":\"123.00\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691257259,0,1,1691257259,1691257259,NULL),(252,'C806572791893800',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691257279,0,1,1691257279,1691257279,NULL),(253,'C806297867684128',49,16,3,3,6308.00,0,0.00,0.00,0.00,6308.00,'{\"id\":16,\"title\":\"苹果14 256G 支持移动联通5G\",\"thumb\":\"\\/uploads\\/upload\\/admin\\/2023\\/03\\/29\\/4f57cd59d70b73369eb16005f67ccacb.png\",\"price\":\"6300.00\",\"num\":\"1\",\"sku_id\":35,\"sku_name\":\"默认\",\"express_money\":\"8.00\",\"name\":\"12\",\"mobile\":\"15121212121\",\"address\":\"北京市北京城区东城区12\",\"ramk\":\"\"}',NULL,NULL,0,-1,1691329786,1691329787,NULL),(254,'C806297988217179',49,16,3,3,6308.00,0,0.00,0.00,0.00,6308.00,'{\"id\":16,\"title\":\"苹果14 256G 支持移动联通5G\",\"thumb\":\"\\/uploads\\/upload\\/admin\\/2023\\/03\\/29\\/4f57cd59d70b73369eb16005f67ccacb.png\",\"price\":\"6300.00\",\"num\":\"1\",\"sku_id\":35,\"sku_name\":\"默认\",\"express_money\":\"8.00\",\"name\":\"12\",\"mobile\":\"15121212121\",\"address\":\"北京市北京城区东城区12\",\"ramk\":\"\"}',NULL,NULL,0,-1,1691329798,1691329799,NULL),(256,'C806300242589647',49,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691330024,0,1,1691330024,1691330024,NULL),(257,'C806345190634214',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691334519,0,1,1691334519,1691334519,NULL),(260,'C806345315790884',48,2,1,2,83.30,0,0.00,83.30,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":5,\"invite_user_id\":null,\"draw_id\":5}',NULL,1691334531,0,1,1691334531,1691334531,NULL),(261,'C807133956681153',54,2,1,2,16.66,0,0.00,16.66,0.00,0.00,'{\"id\":2,\"title\":\"超值新人福利 & 全家桶\",\"thumb\":\"\\/aliyun\\/db4e50f5c4176c754a365a697f498989.jpg\",\"price\":\"16.66\",\"num\":1,\"invite_user_id\":null,\"draw_id\":1}',NULL,1691413395,0,1,1691413395,1691413395,NULL);
/*!40000 ALTER TABLE `la_order` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_order` with 238 row(s)
--

--
-- Table structure for table `la_order_list`
--

DROP TABLE IF EXISTS `la_order_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_order_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单类型',
  `get_type` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '获取方式，1抽取，2赠送',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) unsigned DEFAULT '0' COMMENT '订单ID',
  `data_id` int(10) unsigned DEFAULT '0' COMMENT '盒子ID/期数ID',
  `goods_id` int(10) unsigned DEFAULT '0' COMMENT '商品ID',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '图片',
  `price` decimal(15,2) unsigned NOT NULL COMMENT '价格',
  `num` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '数量',
  `mark_id` int(10) DEFAULT NULL COMMENT '赏等级ID',
  `is_change` int(10) unsigned DEFAULT '0' COMMENT '0没有置换，1置换',
  `sku_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '规格',
  `status` int(1) DEFAULT '0' COMMENT '状态',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=732 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='订单 - 附表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_order_list`
--

LOCK TABLES `la_order_list` WRITE;
/*!40000 ALTER TABLE `la_order_list` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_order_list` VALUES (1,1,1,49,2,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688546989,1691038181,NULL),(2,1,1,49,2,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688546989,1691038181,NULL),(3,1,1,49,2,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688546989,1691038181,NULL),(4,1,1,49,2,2,260,'多功能心率血氧检测手环','/aliyun/884aa32b72b79db9587c0bdc9b09071d.jpg',38.88,1,2,0,NULL,5,1688546989,1691038181,NULL),(5,1,1,49,2,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688546989,1691038181,NULL),(6,1,1,49,3,2,566,'一次性湿巾6包','/aliyun/9ad01a165500374f396bcbdb67bddd09.jpg',19.90,1,4,0,NULL,5,1688547017,1691038181,NULL),(7,1,1,49,4,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688547267,1691038181,NULL),(8,1,1,49,5,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688547277,1691038181,NULL),(9,1,1,49,5,2,566,'一次性湿巾6包','/aliyun/9ad01a165500374f396bcbdb67bddd09.jpg',19.90,1,4,0,NULL,0,1688547277,1691038181,NULL),(10,1,1,49,5,2,565,'LED智能手表','/aliyun/0d65d33f7847b9d3ff803714804c60dd.jpg',19.90,1,4,0,NULL,0,1688547277,1691038181,NULL),(11,1,1,49,5,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688547277,1691038181,NULL),(12,1,1,49,5,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688547277,1691038181,NULL),(13,1,1,49,6,2,565,'LED智能手表','/aliyun/0d65d33f7847b9d3ff803714804c60dd.jpg',19.90,1,4,0,NULL,0,1688547299,1691038181,NULL),(14,1,1,49,6,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688547299,1691038181,NULL),(15,1,1,49,6,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688547299,1691038181,NULL),(16,1,1,49,6,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688547299,1691038181,NULL),(17,1,1,49,6,2,564,'九色哑光眼影盘','/aliyun/b646b08373c4b9131211e6040cba6903.jpg',19.90,1,4,0,NULL,0,1688547299,1691038181,NULL),(18,1,1,49,7,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688547608,1691038181,NULL),(19,1,1,49,7,2,566,'一次性湿巾6包','/aliyun/9ad01a165500374f396bcbdb67bddd09.jpg',19.90,1,4,0,NULL,0,1688547608,1691038181,NULL),(20,1,1,49,7,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688547608,1691038181,NULL),(21,1,1,49,7,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688547608,1691038181,NULL),(22,1,1,49,7,2,565,'LED智能手表','/aliyun/0d65d33f7847b9d3ff803714804c60dd.jpg',19.90,1,4,0,NULL,0,1688547608,1691038181,NULL),(23,1,1,49,8,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688548011,1691038181,NULL),(27,1,1,49,10,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688552359,1691038181,NULL),(28,1,1,49,10,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688552359,1691038181,NULL),(29,1,1,49,10,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688552359,1691038181,NULL),(30,1,1,49,10,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688552359,1691038181,NULL),(31,1,1,49,10,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1688552359,1691038181,NULL),(32,1,1,49,11,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688552370,1691038181,NULL),(33,1,1,49,11,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688552370,1691038181,NULL),(34,1,1,49,11,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688552370,1691038181,NULL),(35,1,1,49,11,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688552370,1691038181,NULL),(36,1,1,49,11,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688552370,1691038181,NULL),(37,1,1,49,12,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1688552466,1691038181,NULL),(38,1,1,49,12,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688552466,1691038181,NULL),(39,1,1,49,12,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688552466,1691038181,NULL),(40,1,1,49,12,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688552466,1691038181,NULL),(41,1,1,49,12,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688552466,1691038181,NULL),(42,1,1,49,14,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,4,0,NULL,0,1688552504,1691038181,NULL),(43,1,1,49,14,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1688552504,1691038181,NULL),(44,1,1,49,14,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1688552504,1691038181,NULL),(45,1,1,49,14,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,4,0,NULL,0,1688552504,1691038181,NULL),(46,1,1,49,14,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688552504,1691038181,NULL),(47,1,1,49,16,2,575,'29.00','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1688552513,1691038181,NULL),(48,1,1,49,16,2,575,'29.00','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1688552513,1691038181,NULL),(49,1,1,49,16,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1688552513,1691038181,NULL),(50,1,1,49,16,2,260,'多功能心率血氧检测手环','/aliyun/884aa32b72b79db9587c0bdc9b09071d.jpg',38.88,1,3,0,NULL,0,1688552513,1691038181,NULL),(51,1,1,49,16,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688552513,1691038181,NULL),(52,1,1,49,17,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1688552531,1691038181,NULL),(53,1,1,49,17,2,575,'29.00','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1688552531,1691038181,NULL),(54,1,1,49,17,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,4,0,NULL,0,1688552531,1691038181,NULL),(55,1,1,49,17,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1688552531,1691038181,NULL),(56,1,1,49,17,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688552531,1691038181,NULL),(57,1,1,49,18,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1688552544,1691038181,NULL),(58,1,1,49,18,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1688552544,1691038181,NULL),(59,1,1,49,18,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688552544,1691038181,NULL),(60,1,1,49,18,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688552544,1691038181,NULL),(61,1,1,49,18,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688552544,1691038181,NULL),(62,1,1,49,19,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688552567,1691038181,NULL),(63,1,1,49,19,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1688552567,1691038181,NULL),(64,1,1,49,19,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688552567,1691038181,NULL),(65,1,1,49,19,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688552567,1691038181,NULL),(66,1,1,49,19,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688552567,1691038181,NULL),(67,1,1,49,20,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688552576,1691038181,NULL),(68,1,1,49,20,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688552576,1691038181,NULL),(69,1,1,49,20,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1688552576,1691038181,NULL),(70,1,1,49,20,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1688552576,1691038181,NULL),(71,1,1,49,20,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688552576,1691038181,NULL),(76,1,1,49,22,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688554861,1691038181,NULL),(77,1,1,49,22,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,4,0,NULL,0,1688554861,1691038181,NULL),(78,1,1,49,22,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688554861,1691038181,NULL),(79,1,1,49,22,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688554861,1691038181,NULL),(80,1,1,49,22,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1688554861,1691038181,NULL),(84,1,1,3,24,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688555147,1688555155,NULL),(85,1,1,3,24,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688555147,1688555155,NULL),(86,1,1,3,24,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688555147,1688555155,NULL),(87,1,1,3,24,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688555147,1688555155,NULL),(88,1,1,3,24,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688555147,1688555155,NULL),(89,1,1,49,25,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688555149,1691038181,NULL),(90,1,1,49,25,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1688555149,1691038181,NULL),(91,1,1,49,25,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688555149,1691038181,NULL),(92,1,1,49,25,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688555149,1691038181,NULL),(93,1,1,49,25,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688555149,1691038181,NULL),(94,1,1,49,26,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688555162,1691038181,NULL),(95,1,1,49,26,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688555162,1691038181,NULL),(96,1,1,49,26,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688555162,1691038181,NULL),(97,1,1,49,26,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688555162,1691038181,NULL),(98,1,1,49,26,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688555162,1691038181,NULL),(99,1,1,3,27,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688555164,1688555196,NULL),(100,1,1,3,27,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688555164,1688555196,NULL),(101,1,1,3,27,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688555164,1688555196,NULL),(102,1,1,3,27,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688555164,1688555196,NULL),(103,1,1,3,27,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688555164,1688555196,NULL),(104,1,1,3,28,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688555200,1688555208,NULL),(105,1,1,3,28,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688555200,1688555208,NULL),(106,1,1,3,28,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688555200,1688555208,NULL),(107,1,1,3,28,2,575,'29.00','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1688555200,1688555208,NULL),(108,1,1,3,28,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1688555200,1688555208,NULL),(109,1,1,3,29,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1688555217,1688555217,NULL),(110,1,1,3,29,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,0,1688555217,1688555217,NULL),(111,1,1,3,29,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688555217,1688555217,NULL),(112,1,1,3,29,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688555217,1688555217,NULL),(113,1,1,3,29,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1688555217,1688555217,NULL),(114,1,1,3,30,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1688556755,1688556755,NULL),(115,1,1,3,30,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1688556755,1688556755,NULL),(116,1,1,3,30,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688556755,1688556755,NULL),(117,1,1,3,30,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688556755,1688556755,NULL),(118,1,1,3,30,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688556755,1688556755,NULL),(119,1,1,49,31,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688556761,1691038181,NULL),(120,1,1,49,31,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688556761,1691038181,NULL),(121,1,1,49,31,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688556761,1691038181,NULL),(122,1,1,49,31,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688556761,1691038181,NULL),(123,1,1,49,31,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688556761,1691038181,NULL),(124,1,1,3,32,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1688556763,1688556763,NULL),(125,1,1,3,32,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688556763,1688556763,NULL),(126,1,1,3,32,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1688556763,1688556763,NULL),(127,1,1,3,32,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1688556763,1688556763,NULL),(128,1,1,3,32,2,575,'29.00','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1688556763,1688556763,NULL),(129,1,1,3,33,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1688556780,1688556780,NULL),(130,1,1,3,33,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688556780,1688556780,NULL),(131,1,1,3,33,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1688556780,1688556780,NULL),(132,1,1,3,33,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1688556780,1688556780,NULL),(133,1,1,3,33,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1688556780,1688556780,NULL),(134,1,1,49,34,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688556789,1691038181,NULL),(135,1,1,49,34,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1688556789,1691038181,NULL),(136,1,1,49,34,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1688556789,1691038181,NULL),(137,1,1,49,34,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1688556789,1691038181,NULL),(138,1,1,49,34,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1688556789,1691038181,NULL),(142,1,1,3,36,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688556798,1688556876,NULL),(143,1,1,3,36,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688556798,1688556876,NULL),(144,1,1,3,36,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688556798,1688556876,NULL),(145,1,1,3,36,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688556798,1688556876,NULL),(146,1,1,3,36,2,575,'29.00','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1688556798,1688556876,NULL),(147,1,1,49,37,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1688556806,1691038181,NULL),(148,1,1,49,37,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1688556806,1691038181,NULL),(149,1,1,49,37,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1688556806,1691038181,NULL),(150,1,1,49,37,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688556806,1691038181,NULL),(151,1,1,49,37,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688556806,1691038181,NULL),(152,1,1,3,38,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688556882,1688556882,NULL),(153,1,1,3,38,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688556882,1688556882,NULL),(154,1,1,3,38,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,0,1688556882,1688556882,NULL),(155,1,1,3,38,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688556882,1688556882,NULL),(156,1,1,3,38,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1688556882,1688556882,NULL),(157,1,1,3,39,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,0,1688556893,1688556893,NULL),(158,1,1,3,39,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1688556893,1688556893,NULL),(159,1,1,3,39,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,0,1688556893,1688556893,NULL),(160,1,1,3,39,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688556893,1688556893,NULL),(161,1,1,3,39,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688556893,1688556893,NULL),(162,1,1,3,40,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1688556901,1688556901,NULL),(163,1,1,3,40,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,0,1688556901,1688556901,NULL),(164,1,1,3,40,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1688556901,1688556901,NULL),(165,1,1,3,40,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1688556901,1688556901,NULL),(166,1,1,3,40,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,0,1688556901,1688556901,NULL),(167,1,1,49,41,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688556927,1691038181,NULL),(168,1,1,49,41,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688556927,1691038181,NULL),(169,1,1,49,41,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688556927,1691038181,NULL),(170,1,1,49,41,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688556927,1691038181,NULL),(171,1,1,49,41,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688556927,1691038181,NULL),(172,1,1,49,42,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688556988,1691038181,NULL),(173,1,1,49,42,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688556988,1691038181,NULL),(174,1,1,49,42,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688556988,1691038181,NULL),(175,1,1,49,42,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688556988,1691038181,NULL),(176,1,1,49,42,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688556988,1691038181,NULL),(177,1,1,49,43,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688556997,1691038181,NULL),(178,1,1,49,43,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688556997,1691038181,NULL),(179,1,1,49,43,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1688556997,1691038181,NULL),(180,1,1,49,43,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1688556997,1691038181,NULL),(181,1,1,49,43,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688556997,1691038181,NULL),(182,1,1,49,44,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688557017,1691038181,NULL),(183,1,1,49,44,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1688557017,1691038181,NULL),(184,1,1,49,44,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1688557017,1691038181,NULL),(185,1,1,49,44,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688557017,1691038181,NULL),(186,1,1,49,44,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688557017,1691038181,NULL),(190,1,1,49,46,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688557027,1691038181,NULL),(191,1,1,49,46,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688557027,1691038181,NULL),(192,1,1,49,46,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688557027,1691038181,NULL),(193,1,1,49,46,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688557027,1691038181,NULL),(194,1,1,49,46,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688557027,1691038181,NULL),(195,1,1,49,47,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688557038,1691038181,NULL),(196,1,1,49,47,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688557038,1691038181,NULL),(197,1,1,49,47,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1688557038,1691038181,NULL),(198,1,1,49,47,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1688557038,1691038181,NULL),(199,1,1,49,47,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1688557038,1691038181,NULL),(203,1,1,49,49,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1688557098,1691038181,NULL),(204,1,1,49,49,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688557098,1691038181,NULL),(205,1,1,49,49,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688557098,1691038181,NULL),(206,1,1,49,49,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1688557098,1691038181,NULL),(207,1,1,49,49,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688557098,1691038181,NULL),(208,1,1,49,50,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688557200,1691038181,NULL),(209,1,1,49,51,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688557213,1691038181,NULL),(210,1,1,49,52,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688557858,1691038181,NULL),(211,1,1,49,52,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688557858,1691038181,NULL),(212,1,1,49,52,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688557858,1691038181,NULL),(213,1,1,49,52,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688557858,1691038181,NULL),(214,1,1,49,52,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688557858,1691038181,NULL),(215,1,1,49,53,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688558184,1691038181,NULL),(216,1,1,49,53,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688558184,1691038181,NULL),(217,1,1,49,53,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688558184,1691038181,NULL),(218,1,1,49,53,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688558184,1691038181,NULL),(219,1,1,49,53,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688558184,1691038181,NULL),(220,1,1,49,54,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688558202,1691038181,NULL),(221,1,1,49,54,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688558202,1691038181,NULL),(222,1,1,49,54,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1688558202,1691038181,NULL),(223,1,1,49,54,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688558202,1691038181,NULL),(224,1,1,49,54,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688558202,1691038181,NULL),(225,1,1,49,55,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688558236,1691038181,NULL),(226,1,1,49,55,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688558236,1691038181,NULL),(227,1,1,49,55,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688558236,1691038181,NULL),(228,1,1,49,55,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688558236,1691038181,NULL),(229,1,1,49,55,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688558236,1691038181,NULL),(230,1,1,49,56,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688558295,1691038181,NULL),(231,1,1,49,56,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688558295,1691038181,NULL),(232,1,1,49,56,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688558295,1691038181,NULL),(233,1,1,49,56,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688558295,1691038181,NULL),(234,1,1,49,56,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688558295,1691038181,NULL),(235,1,1,49,57,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688558314,1691038181,NULL),(236,1,1,49,57,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688558314,1691038181,NULL),(237,1,1,49,57,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688558314,1691038181,NULL),(238,1,1,49,57,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688558314,1691038181,NULL),(239,1,1,49,57,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688558314,1691038181,NULL),(240,1,1,49,58,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688558341,1691038181,NULL),(241,1,1,49,58,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688558341,1691038181,NULL),(242,1,1,49,58,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1688558341,1691038181,NULL),(243,1,1,49,58,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688558341,1691038181,NULL),(244,1,1,49,58,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688558341,1691038181,NULL),(245,1,1,49,60,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688558856,1691038181,NULL),(246,1,1,49,60,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688558856,1691038181,NULL),(247,1,1,49,60,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688558856,1691038181,NULL),(248,1,1,49,60,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688558856,1691038181,NULL),(249,1,1,49,60,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688558856,1691038181,NULL),(250,1,1,49,62,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688558895,1691038181,NULL),(251,1,1,49,62,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688558895,1691038181,NULL),(252,1,1,49,62,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688558895,1691038181,NULL),(253,1,1,49,62,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688558895,1691038181,NULL),(254,1,1,49,62,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688558895,1691038181,NULL),(255,1,1,3,63,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688559092,1688559104,NULL),(256,1,1,3,63,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688559092,1688559104,NULL),(257,1,1,3,63,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688559092,1688559104,NULL),(258,1,1,3,63,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688559092,1688559104,NULL),(259,1,1,3,63,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688559092,1688559104,NULL),(263,1,1,3,65,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688559110,1688559110,NULL),(264,1,1,3,65,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1688559110,1688559110,NULL),(265,1,1,3,65,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1688559110,1688559110,NULL),(266,1,1,3,65,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688559110,1688559110,NULL),(267,1,1,3,65,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1688559110,1688559110,NULL),(268,1,1,3,66,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1688559118,1688559118,NULL),(269,1,1,3,66,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688559118,1688559118,NULL),(270,1,1,3,66,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,0,1688559118,1688559118,NULL),(271,1,1,3,66,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1688559118,1688559118,NULL),(272,1,1,3,66,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688559118,1688559118,NULL),(273,1,1,3,67,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1688559128,1688559128,NULL),(274,1,1,3,67,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688559128,1688559128,NULL),(275,1,1,3,67,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688559128,1688559128,NULL),(276,1,1,3,67,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1688559128,1688559128,NULL),(277,1,1,3,67,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1688559128,1688559128,NULL),(278,1,1,3,68,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688559136,1688559136,NULL),(279,1,1,3,68,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688559136,1688559136,NULL),(280,1,1,3,68,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1688559136,1688559136,NULL),(281,1,1,3,68,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688559136,1688559136,NULL),(282,1,1,3,68,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,0,1688559136,1688559136,NULL),(283,1,1,3,69,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688559143,1688559417,NULL),(284,1,1,3,69,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688559143,1688559417,NULL),(285,1,1,3,69,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688559143,1688559417,NULL),(286,1,1,3,69,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688559143,1688559417,NULL),(287,1,1,3,69,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688559143,1688559417,NULL),(288,1,1,3,70,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1688559421,1688559421,NULL),(289,1,1,3,70,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688559421,1688559421,NULL),(290,1,1,3,70,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688559421,1688559421,NULL),(291,1,1,3,70,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688559421,1688559421,NULL),(292,1,1,3,70,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1688559421,1688559421,NULL),(293,1,1,3,71,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688559443,1688559443,NULL),(294,1,1,3,71,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1688559443,1688559443,NULL),(295,1,1,3,71,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1688559443,1688559443,NULL),(296,1,1,3,71,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1688559443,1688559443,NULL),(297,1,1,3,71,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1688559443,1688559443,NULL),(298,1,1,49,80,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1688568898,1691038181,NULL),(299,1,1,49,80,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688568898,1691038181,NULL),(300,1,1,49,81,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688568931,1691038181,NULL),(301,1,1,49,81,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688568931,1691038181,NULL),(302,1,1,49,81,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1688568931,1691038181,NULL),(303,1,1,49,81,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1688568931,1691038181,NULL),(304,1,1,49,81,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1688568931,1691038181,NULL),(305,1,1,49,83,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688568998,1691038181,NULL),(306,1,1,49,85,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1688569121,1691038181,NULL),(307,1,1,49,85,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688569121,1691038181,NULL),(308,1,1,49,85,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688569121,1691038181,NULL),(309,1,1,49,85,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688569121,1691038181,NULL),(310,1,1,49,85,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569121,1691038181,NULL),(311,1,1,49,86,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1688569238,1691038181,NULL),(312,1,1,49,86,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688569238,1691038181,NULL),(313,1,1,49,86,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1688569238,1691038181,NULL),(314,1,1,49,86,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688569238,1691038181,NULL),(315,1,1,49,86,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569238,1691038181,NULL),(316,1,1,49,87,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569528,1691038181,NULL),(317,1,1,49,87,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688569528,1691038181,NULL),(318,1,1,49,87,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569528,1691038181,NULL),(319,1,1,49,87,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688569528,1691038181,NULL),(320,1,1,49,87,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569528,1691038181,NULL),(321,1,1,49,88,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688569559,1691038181,NULL),(322,1,1,49,88,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569559,1691038181,NULL),(323,1,1,49,89,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569634,1691038181,NULL),(324,1,1,49,89,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569634,1691038181,NULL),(325,1,1,49,89,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688569634,1691038181,NULL),(326,1,1,49,89,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569634,1691038181,NULL),(327,1,1,49,89,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569634,1691038181,NULL),(328,1,1,49,90,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688569645,1691038181,NULL),(329,1,1,49,90,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569645,1691038181,NULL),(330,1,1,49,90,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569645,1691038181,NULL),(331,1,1,49,90,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569645,1691038181,NULL),(332,1,1,49,90,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688569645,1691038181,NULL),(333,1,1,49,91,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688569654,1691038181,NULL),(334,1,1,49,91,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688569654,1691038181,NULL),(335,1,1,49,91,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688569654,1691038181,NULL),(336,1,1,49,91,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688569654,1691038181,NULL),(337,1,1,49,91,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688569654,1691038181,NULL),(338,1,1,49,92,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569672,1691038181,NULL),(339,1,1,49,92,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569672,1691038181,NULL),(340,1,1,49,92,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688569672,1691038181,NULL),(341,1,1,49,92,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688569672,1691038181,NULL),(342,1,1,49,92,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569672,1691038181,NULL),(343,1,1,49,93,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688569689,1691038181,NULL),(344,1,1,49,93,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569689,1691038181,NULL),(345,1,1,49,93,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569689,1691038181,NULL),(346,1,1,49,93,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569689,1691038181,NULL),(347,1,1,49,93,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1688569689,1691038181,NULL),(348,1,1,49,94,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569696,1691038181,NULL),(349,1,1,49,94,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688569696,1691038181,NULL),(350,1,1,49,94,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1688569696,1691038181,NULL),(351,1,1,49,94,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569696,1691038181,NULL),(352,1,1,49,94,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688569696,1691038181,NULL),(353,1,1,49,95,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688569771,1691038181,NULL),(354,1,1,49,95,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688569771,1691038181,NULL),(355,1,1,49,95,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688569771,1691038181,NULL),(356,1,1,49,95,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688569771,1691038181,NULL),(357,1,1,49,95,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1688569771,1691038181,NULL),(358,1,1,49,96,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688569778,1691038181,NULL),(359,1,1,49,96,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688569778,1691038181,NULL),(360,1,1,49,96,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569778,1691038181,NULL),(361,1,1,49,96,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569778,1691038181,NULL),(362,1,1,49,96,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569778,1691038181,NULL),(363,1,1,49,97,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569785,1691038181,NULL),(364,1,1,49,97,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569785,1691038181,NULL),(365,1,1,49,97,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1688569785,1691038181,NULL),(366,1,1,49,97,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688569785,1691038181,NULL),(367,1,1,49,97,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569785,1691038181,NULL),(368,1,1,49,98,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688569794,1691038181,NULL),(369,1,1,49,98,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688569794,1691038181,NULL),(370,1,1,49,98,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688569794,1691038181,NULL),(371,1,1,49,98,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688569794,1691038181,NULL),(372,1,1,49,98,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569794,1691038181,NULL),(373,1,1,49,99,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1688569810,1691038181,NULL),(374,1,1,49,99,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569810,1691038181,NULL),(375,1,1,49,99,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688569810,1691038181,NULL),(376,1,1,49,99,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569810,1691038181,NULL),(377,1,1,49,99,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688569810,1691038181,NULL),(378,1,1,49,100,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569817,1691038181,NULL),(379,1,1,49,100,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1688569817,1691038181,NULL),(380,1,1,49,100,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569817,1691038181,NULL),(381,1,1,49,100,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688569817,1691038181,NULL),(382,1,1,49,100,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688569817,1691038181,NULL),(383,1,1,49,101,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688569824,1691038181,NULL),(384,1,1,49,101,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569824,1691038181,NULL),(385,1,1,49,101,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569824,1691038181,NULL),(386,1,1,49,101,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',39.00,1,3,0,NULL,5,1688569824,1691038181,NULL),(387,1,1,49,101,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688569824,1691038181,NULL),(388,1,1,49,102,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569835,1691038181,NULL),(389,1,1,49,102,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1688569835,1691038181,NULL),(390,1,1,49,102,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569835,1691038181,NULL),(391,1,1,49,102,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688569835,1691038181,NULL),(392,1,1,49,102,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569835,1691038181,NULL),(393,1,1,49,103,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1688569841,1691038181,NULL),(394,1,1,49,103,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,5,1688569841,1691038181,NULL),(395,1,1,49,103,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688569841,1691038181,NULL),(396,1,1,49,103,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688569841,1691038181,NULL),(397,1,1,49,103,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688569841,1691038181,NULL),(398,1,1,49,104,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688569849,1691038181,NULL),(399,1,1,49,104,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688569849,1691038181,NULL),(400,1,1,49,104,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688569849,1691038181,NULL),(401,1,1,49,104,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569849,1691038181,NULL),(402,1,1,49,104,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688569849,1691038181,NULL),(403,1,1,3,106,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1688570673,1688570673,NULL),(404,1,1,3,106,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1688570673,1688570673,NULL),(405,1,1,3,106,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688570673,1688570673,NULL),(406,1,1,3,106,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1688570673,1688570673,NULL),(407,1,1,3,106,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1688570673,1688570673,NULL),(414,1,1,3,110,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688570796,1688570796,NULL),(415,1,1,3,110,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1688570796,1688570796,NULL),(416,1,1,3,110,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,0,1688570796,1688570796,NULL),(417,1,1,3,110,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688570796,1688570796,NULL),(418,1,1,3,110,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1688570796,1688570796,NULL),(419,1,1,3,111,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1688570836,1688570842,NULL),(420,1,1,3,111,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688570836,1688570842,NULL),(421,1,1,3,111,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688570836,1688570842,NULL),(422,1,1,3,111,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688570836,1688570842,NULL),(423,1,1,3,111,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688570836,1688570842,NULL),(424,1,1,3,112,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688570846,1688570846,NULL),(425,1,1,3,112,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688570846,1688570846,NULL),(426,1,1,3,112,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688570846,1688570846,NULL),(427,1,1,3,112,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1688570846,1688570846,NULL),(428,1,1,3,112,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1688570846,1688570846,NULL),(429,1,1,3,113,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1688570853,1688570853,NULL),(430,1,1,3,113,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1688570853,1688570853,NULL),(431,1,1,3,113,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688570853,1688570853,NULL),(432,1,1,3,113,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1688570853,1688570853,NULL),(433,1,1,3,113,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688570853,1688570853,NULL),(437,1,1,3,115,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1688570862,1688570862,NULL),(438,1,1,3,115,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688570862,1688570872,NULL),(439,1,1,3,115,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1688570862,1688570862,NULL),(440,1,1,3,115,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1688570862,1688570862,NULL),(441,1,1,3,115,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1688570862,1688570862,NULL),(442,1,1,3,117,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688570905,1688570905,NULL),(443,1,1,3,117,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1688570905,1688570905,NULL),(444,1,1,3,117,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1688570905,1688570905,NULL),(445,1,1,3,117,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1688570905,1688570905,NULL),(446,1,1,3,117,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1688570905,1688570905,NULL),(447,1,1,3,118,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1688571036,1688571036,NULL),(448,1,1,3,118,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1688571036,1688571036,NULL),(449,1,1,3,118,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1688571036,1688571036,NULL),(450,1,1,3,118,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1688571036,1688571036,NULL),(451,1,1,3,118,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1688571036,1688571036,NULL),(452,1,1,49,119,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1688578377,1691038181,NULL),(453,1,1,49,119,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1688578377,1691038181,NULL),(454,1,1,49,119,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,5,1688578377,1691038181,NULL),(455,1,1,49,119,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688578377,1691038181,NULL),(456,1,1,49,119,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688578377,1691038181,NULL),(457,1,1,49,120,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688578396,1691038181,NULL),(458,1,1,49,120,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1688578396,1691038181,NULL),(459,1,1,49,120,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688578396,1691038181,NULL),(460,1,1,49,121,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688578498,1691038181,NULL),(461,1,1,49,122,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1688578804,1691038181,NULL),(462,1,1,49,123,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1688580092,1691038181,NULL),(463,1,1,49,125,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1688580109,1691038181,NULL),(464,1,1,49,127,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1688623269,1691038181,NULL),(465,1,1,49,130,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688661251,1691038181,NULL),(466,1,1,49,131,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1688661283,1691038181,NULL),(467,1,1,49,133,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1688710727,1691038181,NULL),(468,1,1,3,154,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1689003136,1689003136,NULL),(469,1,1,3,154,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1689003136,1689003136,NULL),(470,1,1,3,154,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1689003136,1689003136,NULL),(471,1,1,3,154,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1689003136,1689003136,NULL),(472,1,1,3,154,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1689003136,1689003136,NULL),(473,1,1,3,155,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,0,1689003236,1689003236,NULL),(474,1,1,3,155,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1689003236,1689003236,NULL),(475,1,1,3,155,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1689003236,1689003236,NULL),(476,1,1,3,155,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1689003236,1689003236,NULL),(477,1,1,3,155,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1689003236,1689003236,NULL),(478,1,1,3,157,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1689003342,1689003342,NULL),(479,1,1,3,157,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1689003342,1689003342,NULL),(480,1,1,3,157,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1689003342,1689003342,NULL),(481,1,1,3,157,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1689003342,1689003342,NULL),(482,1,1,3,157,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1689003342,1689003342,NULL),(483,1,1,3,158,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1689004749,1689004749,NULL),(484,1,1,3,158,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1689004749,1689004749,NULL),(485,1,1,3,158,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1689004749,1689004749,NULL),(486,1,1,3,158,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1689004749,1689004749,NULL),(487,1,1,3,158,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1689004749,1689004749,NULL),(488,1,1,3,159,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1689004760,1689004760,NULL),(489,1,1,3,159,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1689004760,1689004760,NULL),(490,1,1,3,159,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1689004760,1689004760,NULL),(491,1,1,3,159,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1689004760,1689004760,NULL),(492,1,1,3,159,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1689004760,1689004760,NULL),(493,1,1,3,160,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1689004771,1689004771,NULL),(494,1,1,3,160,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1689004771,1689004771,NULL),(495,1,1,3,160,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1689004771,1689004771,NULL),(496,1,1,3,160,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1689004771,1689004771,NULL),(497,1,1,3,160,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1689004771,1689004771,NULL),(498,1,1,3,161,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1689004777,1689004777,NULL),(499,1,1,3,161,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1689004777,1689004777,NULL),(500,1,1,3,161,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,0,1689004777,1689004777,NULL),(501,1,1,3,161,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1689004777,1689004777,NULL),(502,1,1,3,161,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1689004777,1689004777,NULL),(503,1,1,49,164,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1689590180,1691038181,NULL),(504,1,1,49,165,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1689591159,1691038181,NULL),(505,1,1,49,166,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1689593529,1691038181,NULL),(506,1,1,49,166,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1689593529,1691038181,NULL),(507,1,1,49,166,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1689593529,1691038181,NULL),(508,1,1,49,166,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1689593529,1691038181,NULL),(509,1,1,49,166,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1689593529,1691038181,NULL),(510,1,1,49,167,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1689593602,1691038181,NULL),(511,1,1,49,167,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1689593602,1691038181,NULL),(512,1,1,49,167,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1689593602,1691038181,NULL),(513,1,1,49,167,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1689593602,1691038181,NULL),(514,1,1,49,167,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',49.00,1,3,0,NULL,5,1689593602,1691038181,NULL),(515,1,1,49,168,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1689655146,1691038181,NULL),(516,1,1,48,169,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690919279,1690919279,NULL),(517,1,1,48,173,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1690953431,1690953440,NULL),(518,1,1,48,173,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1690953431,1690953440,NULL),(519,1,1,48,173,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1690953431,1690953440,NULL),(520,1,1,48,173,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1690953431,1690953440,NULL),(521,1,1,48,173,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1690953431,1690953440,NULL),(522,1,1,48,180,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1690958162,1690958168,NULL),(523,1,1,48,180,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1690958162,1690958168,NULL),(524,1,1,48,180,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,5,1690958162,1690958168,NULL),(525,1,1,48,180,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1690958162,1690958168,NULL),(526,1,1,48,180,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,5,1690958162,1690958168,NULL),(527,1,1,48,181,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1690958174,1690958174,NULL),(528,1,1,48,181,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958174,1690958174,NULL),(529,1,1,48,181,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',49.00,1,3,0,NULL,0,1690958174,1690958174,NULL),(530,1,1,48,181,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1690958174,1690958174,NULL),(531,1,1,48,181,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958174,1690958174,NULL),(532,1,1,48,182,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1690958182,1690958182,NULL),(533,1,1,48,182,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958182,1690958182,NULL),(534,1,1,48,182,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1690958182,1690958182,NULL),(535,1,1,48,182,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1690958182,1690958182,NULL),(536,1,1,48,182,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958182,1690958182,NULL),(537,1,1,48,183,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690958189,1690958189,NULL),(538,1,1,48,183,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1690958189,1690958189,NULL),(539,1,1,48,183,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958189,1690958189,NULL),(540,1,1,48,183,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1690958189,1690958189,NULL),(541,1,1,48,183,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1690958189,1690958189,NULL),(542,1,1,48,186,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958230,1690958230,NULL),(543,1,1,48,186,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1690958230,1690958230,NULL),(544,1,1,48,186,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690958230,1690958230,NULL),(545,1,1,48,186,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1690958230,1690958230,NULL),(546,1,1,48,186,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1690958230,1690958230,NULL),(547,1,1,48,187,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958246,1690958246,NULL),(548,1,1,48,187,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958246,1690958246,NULL),(549,1,1,48,187,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1690958246,1690958246,NULL),(550,1,1,48,187,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958246,1690958246,NULL),(551,1,1,48,187,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690958246,1690958246,NULL),(552,1,1,48,188,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958307,1690958307,NULL),(553,1,1,48,188,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1690958307,1690958307,NULL),(554,1,1,48,188,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690958307,1690958307,NULL),(555,1,1,48,188,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958307,1690958307,NULL),(556,1,1,48,188,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690958307,1690958307,NULL),(557,1,1,48,189,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1690958315,1690958315,NULL),(558,1,1,48,189,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958315,1690958315,NULL),(559,1,1,48,189,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1690958315,1690958315,NULL),(560,1,1,48,189,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1690958315,1690958315,NULL),(561,1,1,48,189,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690958315,1690958315,NULL),(562,1,1,48,190,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1690958330,1690958330,NULL),(563,1,1,48,190,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958330,1690958330,NULL),(564,1,1,48,190,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1690958330,1690958330,NULL),(565,1,1,48,190,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',49.00,1,3,0,NULL,0,1690958330,1690958330,NULL),(566,1,1,48,190,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1690958330,1690958330,NULL),(567,1,1,48,191,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958355,1690958355,NULL),(568,1,1,48,191,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1690958355,1690958355,NULL),(569,1,1,48,191,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958355,1690958355,NULL),(570,1,1,48,191,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1690958355,1690958355,NULL),(571,1,1,48,191,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1690958355,1690958355,NULL),(572,1,1,48,192,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1690958364,1690958364,NULL),(573,1,1,48,192,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958364,1690958364,NULL),(574,1,1,48,192,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1690958364,1690958364,NULL),(575,1,1,48,192,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690958364,1690958364,NULL),(576,1,1,48,192,2,271,'宇航员公仔','/aliyun/d9fdff30aaeec62057578e14ef534fcb.jpg',19.90,1,4,0,NULL,0,1690958364,1690958364,NULL),(577,1,1,48,193,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690958371,1690958371,NULL),(578,1,1,48,193,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1690958371,1690958371,NULL),(579,1,1,48,193,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1690958371,1690958371,NULL),(580,1,1,48,193,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1690958371,1690958371,NULL),(581,1,1,48,193,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1690958371,1690958371,NULL),(582,1,1,48,195,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1690958380,1690958380,NULL),(583,1,1,48,195,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1690958380,1690958380,NULL),(584,1,1,48,195,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1690958380,1690958380,NULL),(585,1,1,48,195,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1690958380,1690958380,NULL),(586,1,1,48,195,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1690958380,1690958380,NULL),(593,1,1,48,198,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1690958391,1690958391,NULL),(594,1,1,48,198,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1690958391,1690958391,NULL),(595,1,1,48,198,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1690958391,1690958391,NULL),(596,1,1,48,198,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1690958391,1690958391,NULL),(597,1,1,48,198,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,1,1690958391,1690958642,NULL),(598,1,1,48,209,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1690975194,1690975194,NULL),(599,1,1,48,209,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690975194,1690975194,NULL),(600,1,1,48,209,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690975194,1690975194,NULL),(601,1,1,48,209,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1690975194,1690975194,NULL),(602,1,1,48,209,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1690975194,1690975194,NULL),(603,1,1,49,213,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1690981971,1691038181,NULL),(604,1,1,49,213,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1690981971,1691038181,NULL),(605,1,1,49,213,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1690981971,1691038181,NULL),(606,1,1,49,213,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1690981971,1691038181,NULL),(607,1,1,49,213,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1690981971,1691038181,NULL),(608,1,1,49,214,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1690981987,1691038181,NULL),(609,1,1,49,214,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1690981987,1691038181,NULL),(610,1,1,49,214,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,5,1690981987,1691038181,NULL),(611,1,1,49,214,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1690981987,1691038181,NULL),(612,1,1,49,214,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',49.00,1,3,0,NULL,5,1690981987,1691038181,NULL),(613,1,1,49,215,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1690982005,1691038181,NULL),(614,1,1,49,215,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1690982005,1691038181,NULL),(615,1,1,49,215,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1690982005,1691038181,NULL),(616,1,1,49,215,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,5,1690982005,1691038181,NULL),(617,1,1,49,215,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1690982005,1691038181,NULL),(618,1,1,49,216,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1690982026,1691038181,NULL),(619,1,1,49,216,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1690982026,1691038181,NULL),(620,1,1,49,216,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1690982026,1691038181,NULL),(621,1,1,49,216,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1690982026,1691038181,NULL),(622,1,1,49,216,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1690982026,1691038181,NULL),(623,1,1,48,217,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1690996766,1690996766,NULL),(624,1,1,48,217,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1690996766,1690996766,NULL),(625,1,1,48,217,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,0,1690996766,1690996766,NULL),(626,1,1,48,217,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1690996766,1690996766,NULL),(627,1,1,48,217,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1690996766,1690996766,NULL),(628,1,1,49,218,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1690996792,1691038181,NULL),(629,1,1,49,219,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,5,1690998746,1691038181,NULL),(630,1,1,49,220,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1691000029,1691038181,NULL),(631,1,1,49,220,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1691000029,1691038181,NULL),(632,1,1,49,220,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,0,1691000029,1691038181,NULL),(633,1,1,49,220,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,0,1691000029,1691038181,NULL),(634,1,1,49,220,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,1,1691000029,1691038181,NULL),(635,1,1,49,222,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1691034571,1691038181,NULL),(636,1,1,49,222,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1691034571,1691038181,NULL),(637,1,1,49,222,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691034571,1691038181,NULL),(638,1,1,49,222,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1691034571,1691038181,NULL),(639,1,1,49,222,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1691034571,1691038181,NULL),(640,1,1,49,223,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1691034805,1691038181,NULL),(641,1,1,49,224,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1691037110,1691038181,NULL),(642,1,1,49,225,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1691037119,1691038181,NULL),(643,1,1,49,225,2,495,'靓贝洁洗脸巾','/aliyun/d30a6927157c80ff95bac9fdd7d97556.jpg',19.90,1,4,0,NULL,0,1691037119,1691038181,NULL),(644,1,1,49,225,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1691037119,1691038181,NULL),(645,1,1,49,225,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691037119,1691038181,NULL),(646,1,1,49,225,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1691037119,1691038181,NULL),(647,1,1,49,228,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1691050798,1691050798,NULL),(648,1,1,49,228,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,0,1691050798,1691050798,NULL),(649,1,1,49,228,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1691050798,1691050798,NULL),(650,1,1,49,228,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1691050798,1691051973,NULL),(651,1,1,49,228,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1691050798,1691050807,NULL),(652,1,1,49,229,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1691051931,1691051951,NULL),(653,1,1,49,229,2,569,'网红抖音翻转章鱼抱枕公仔','/aliyun/901a59f969f2a62e84405bb7f4254e17.jpg',19.00,1,4,0,NULL,5,1691051931,1691051951,NULL),(654,1,1,49,229,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,5,1691051931,1691051951,NULL),(655,1,1,49,229,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1691051931,1691051951,NULL),(656,1,1,49,229,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,5,1691051931,1691051951,NULL),(657,1,1,49,230,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1691052717,1691052717,NULL),(658,1,1,49,230,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1691052717,1691052717,NULL),(659,1,1,49,230,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1691052717,1691052717,NULL),(660,1,1,49,230,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691052717,1691052717,NULL),(661,1,1,49,230,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1691052717,1691052717,NULL),(662,1,1,49,233,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1691073239,1691073239,NULL),(663,1,1,49,233,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1691073239,1691073239,NULL),(664,1,1,49,233,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1691073239,1691073239,NULL),(665,1,1,49,233,2,576,'智能蓝牙音箱家用闹钟','/aliyun/4abd12eb8d87d00ec57fcf83fc218228.jpg',49.00,1,3,0,NULL,0,1691073239,1691073239,NULL),(666,1,1,49,233,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691073239,1691073239,NULL),(667,1,1,49,234,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1691074170,1691074190,NULL),(668,1,1,49,235,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691075613,1691075613,NULL),(669,1,1,49,235,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1691075613,1691075613,NULL),(670,1,1,49,235,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1691075613,1691075613,NULL),(671,1,1,49,235,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,0,1691075613,1691075613,NULL),(672,1,1,49,235,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1691075613,1691075613,NULL),(675,1,1,49,237,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1691075669,1691425135,NULL),(676,1,1,49,237,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1691075669,1691075669,NULL),(677,1,1,49,237,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1691075669,1691075669,NULL),(678,1,1,49,237,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,5,1691075669,1691233954,NULL),(679,1,1,49,237,2,266,'精品大功率负离子吹风机','/aliyun/6ddc932cfe55761fc4dc85b1ae2158e3.jpg',69.00,1,3,0,NULL,5,1691075669,1691425566,NULL),(680,1,1,54,238,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1691205836,1691206361,NULL),(681,1,1,54,239,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,5,1691206426,1691212113,NULL),(682,1,1,54,240,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1691206712,1691212268,NULL),(683,1,1,54,241,2,496,'家用充电眼部按摩仪','/aliyun/35700b21c0db521ad0d222a9e0ae14da.jpg',96.00,1,3,0,NULL,0,1691207020,1691207020,NULL),(684,1,1,54,242,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1691209277,1691212107,NULL),(688,1,1,54,244,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,0,1691212284,1691212284,NULL),(689,1,1,54,244,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1691212284,1691212284,NULL),(690,1,1,54,244,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1691212284,1691219057,NULL),(691,1,1,54,244,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1691212284,1691212284,NULL),(692,1,1,54,245,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1691212291,1691212291,NULL),(693,1,1,54,245,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,0,1691212291,1691212291,NULL),(694,1,1,54,245,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691212291,1691212291,NULL),(695,1,1,54,245,2,567,'GM墨镜','/aliyun/c894b92e0764820f0ff80dc286d25b32.jpg',19.90,1,4,0,NULL,5,1691212291,1691214460,NULL),(696,1,1,54,246,2,563,'绿色小马公仔','/aliyun/cada57ec59193703bb628eac484fb56c.jpg',19.90,1,4,0,NULL,5,1691212296,1691213806,NULL),(697,1,1,54,246,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1691212296,1691213632,NULL),(698,1,1,54,246,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1691212296,1691212313,NULL),(699,1,1,54,246,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1691212296,1691212309,NULL),(700,1,1,54,246,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1691212296,1691213629,NULL),(701,1,1,48,247,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,5,1691220508,1691220516,NULL),(702,1,1,48,247,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1691220508,1691220516,NULL),(703,1,1,48,247,2,570,'鳄鱼趴趴抱枕毛绒玩具','/aliyun/27791febab51754b3e839b7733392ce5.jpg',19.00,1,4,0,NULL,5,1691220508,1691220516,NULL),(704,1,1,48,247,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,5,1691220508,1691220516,NULL),(705,1,1,48,247,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,5,1691220508,1691220516,NULL),(706,1,1,54,249,2,573,'有线3.5mm圆头手机耳机','/aliyun/3e8bb587f45c3a76c24ea31c56353817.jpg',19.00,1,4,0,NULL,5,1691248560,1691248574,NULL),(707,1,1,54,250,2,572,'苹果充电线 赤橘色','/aliyun/dc261ced2822198fdc0a21b7517bdd59.jpg',19.00,1,4,0,NULL,0,1691248582,1691248582,NULL),(708,1,1,54,250,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1691248582,1691248582,NULL),(709,1,1,54,250,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,0,1691248582,1691248582,NULL),(710,1,1,54,250,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691248582,1691248582,NULL),(711,1,1,54,250,2,267,'USB空气加湿器','/aliyun/09854560015d8b576ce2857e755049f6.jpg',89.00,1,3,0,NULL,0,1691248582,1691248582,NULL),(712,1,1,54,251,17,580,'12','/aliyun/dd7c8de4cbbe2237206145dc876b859a.jpg',12.00,1,1,0,NULL,5,1691257259,1691257267,NULL),(713,1,1,54,252,2,578,'华为Tag硅胶保护套','/aliyun/2d8790699a0b75d9b7c1e026ef867446.jpg',18.00,1,4,0,NULL,0,1691257279,1691257279,NULL),(714,1,1,49,256,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,5,1691330024,1691330027,NULL),(715,1,1,48,257,2,268,'小黄鸭颈部按摩仪','/aliyun/0b4adbb0b3ec4d8725c3f46a0389c9d9.jpg',89.00,1,3,0,NULL,0,1691334519,1691334519,NULL),(716,1,1,48,257,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1691334519,1691334519,NULL),(717,1,1,48,257,2,574,'苹果14 气垫手机壳 风生水起','/aliyun/a690002f1daba872578d53c0a9e8e3f6.jpg',19.00,1,4,0,NULL,0,1691334519,1691334519,NULL),(718,1,1,48,257,2,568,'AJ钥匙扣','/aliyun/2523c38f5e3f00f375dba5bf9b3ceefc.jpg',19.90,1,4,0,NULL,0,1691334519,1691334519,NULL),(719,1,1,48,257,2,571,'三合一数据线','/aliyun/abe7fe5df2497022a338d3a4b544e9eb.jpg',19.00,1,4,0,NULL,0,1691334519,1691334519,NULL),(726,1,1,48,260,2,251,'章鱼公仔','/aliyun/ccd5bdbd8fe02f3ef7f51ec9407b6008.jpg',19.90,1,4,0,NULL,0,1691334531,1691334531,NULL),(727,1,1,48,260,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1691334531,1691334531,NULL),(728,1,1,48,260,2,252,'10000毫安网红充电宝','/aliyun/aafe672817727b31cbdff36952a3e02f.jpg',73.00,1,3,0,NULL,0,1691334531,1691334531,NULL),(729,1,1,48,260,2,579,'手机支架懒人支撑架','/aliyun/f8d96956d7346291e30c5649940d6834.jpg',18.00,1,4,0,NULL,0,1691334531,1691334531,NULL),(730,1,1,48,260,2,575,'无线蓝牙鼠标 颜色随机','/aliyun/1d870de072295866b50503d293e65605.jpg',29.00,1,3,0,NULL,0,1691334531,1691334531,NULL),(731,1,1,54,261,2,577,'新款俄罗斯方块游戏机手掌机','/aliyun/2fb25d9da5a1856ae226b8259102b3ac.jpg',29.00,1,3,0,NULL,0,1691413395,1691413395,NULL);
/*!40000 ALTER TABLE `la_order_list` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_order_list` with 683 row(s)
--

--
-- Table structure for table `la_order_list_change`
--

DROP TABLE IF EXISTS `la_order_list_change`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_order_list_change` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_list_id` int(10) unsigned NOT NULL COMMENT '订单附表ID',
  `order_id` int(10) unsigned DEFAULT NULL COMMENT '置换订单ID',
  `change_id` int(10) unsigned DEFAULT NULL COMMENT '置换商品ID',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '原来商品标题',
  `thumb` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '原来商品图',
  `price` decimal(15,2) unsigned DEFAULT NULL COMMENT '原来商品价格',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='订单 - 更换商品';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_order_list_change`
--

LOCK TABLES `la_order_list_change` WRITE;
/*!40000 ALTER TABLE `la_order_list_change` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_order_list_change` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_order_list_change` with 0 row(s)
--

--
-- Table structure for table `la_order_list_ship`
--

DROP TABLE IF EXISTS `la_order_list_ship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_order_list_ship` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_list_id` int(10) unsigned NOT NULL,
  `express_money` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '运费',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '收件人',
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号',
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '地址',
  `ramk` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '备注',
  `express_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '快递名称',
  `express_num` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '快递单号',
  `express_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '快递编号',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `order_list_id` (`order_list_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='订单 - 发货表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_order_list_ship`
--

LOCK TABLES `la_order_list_ship` WRITE;
/*!40000 ALTER TABLE `la_order_list_ship` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_order_list_ship` VALUES (1,597,8.00,'12345','19568818675','湖南省娄底市冷水江市金竹西路万盛广场','','','','',1690958643,1690958643),(2,634,8.00,'12','15121212121','北京市北京城区东城区12','','','','',1691000722,1691000722);
/*!40000 ALTER TABLE `la_order_list_ship` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_order_list_ship` with 2 row(s)
--

--
-- Table structure for table `la_recharge_rate`
--

DROP TABLE IF EXISTS `la_recharge_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_recharge_rate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `money` decimal(10,2) NOT NULL COMMENT '获得余额',
  `rmb` decimal(10,2) NOT NULL COMMENT '价值人民币',
  `weigh` int(10) NOT NULL COMMENT '权重',
  `created_at` int(10) DEFAULT NULL COMMENT '创建时间',
  `updated_at` int(10) DEFAULT NULL COMMENT '更新时间',
  `deleted_at` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COMMENT='充值金额表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_recharge_rate`
--

LOCK TABLES `la_recharge_rate` WRITE;
/*!40000 ALTER TABLE `la_recharge_rate` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_recharge_rate` VALUES (1,50.00,50.00,7,2147483647,1685961266,NULL),(2,30.00,30.00,8,2147483647,1685961277,NULL),(3,10.00,10.00,9,1685872900,1685961242,NULL),(4,100.00,95.00,6,1685961302,1685961475,NULL),(5,300.00,280.00,5,1685961423,1685961556,NULL),(6,500.00,450.00,4,1685961569,1685961569,NULL);
/*!40000 ALTER TABLE `la_recharge_rate` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_recharge_rate` with 6 row(s)
--

--
-- Table structure for table `la_shop_brand`
--

DROP TABLE IF EXISTS `la_shop_brand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 商品品牌';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_brand`
--

LOCK TABLES `la_shop_brand` WRITE;
/*!40000 ALTER TABLE `la_shop_brand` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_brand` VALUES (1,'Apple',8,1,1669110578,1683357746),(4,'Nike',0,2,1669113355,1683357705),(5,'国货',9,2,1673346615,1683357703),(6,'外星人笔记本',0,1,1680074738,1683357747);
/*!40000 ALTER TABLE `la_shop_brand` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_brand` with 4 row(s)
--

--
-- Table structure for table `la_shop_cat`
--

DROP TABLE IF EXISTS `la_shop_cat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `thumb` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 商品分类';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_cat`
--

LOCK TABLES `la_shop_cat` WRITE;
/*!40000 ALTER TABLE `la_shop_cat` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_cat` VALUES (1,0,'家用电器',0,'/uploads/upload/admin/2023/03/24/7cf42d48ace76a267437158a98f933d0.png',2,1669107234,1680073205),(2,0,'品牌潮鞋',2,'/uploads/upload/admin/2023/03/29/a5c47932fede049a6d2c44997fb06e13.png',1,1669108304,1680079837),(3,0,'美妆护肤',0,'/uploads/upload/admin/2023/03/24/e96c040dd0733f42418c0dc854112c34.png',2,1669108331,1680077773),(4,0,'手机专区',0,'/uploads/upload/admin/2023/03/24/d220f609a3055c1799317f871a4bc7e1.png',2,1669108351,1680077773),(5,0,'Apple',5,'/uploads/upload/admin/2023/03/28/e57c2bcdaf8064128125cc743155dce6.png',1,1669108361,1680078696),(6,0,'服饰包包',1,'/uploads/upload/admin/2023/03/29/902d9b716b2cde313f2e9ed7fd2897b3.png',1,1670557804,1680079848),(7,0,'时尚手办',3,'/uploads/upload/admin/2023/03/29/193820bd3c7a1c91061fe20fa62f3448.png',1,1673167749,1680079832),(8,0,'国货之家',4,'/uploads/upload/admin/2023/03/29/3393c0a9758fb12f77485e866e627866.png',1,1680078551,1680079822);
/*!40000 ALTER TABLE `la_shop_cat` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_cat` with 8 row(s)
--

--
-- Table structure for table `la_shop_change`
--

DROP TABLE IF EXISTS `la_shop_change`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_change` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '缩略图',
  `price` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '现价',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序',
  `sales` int(10) unsigned DEFAULT NULL COMMENT '总销量',
  `editor` text COLLATE utf8mb4_unicode_ci COMMENT '详情',
  `status` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '1启用，2禁用',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 置换商品';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_change`
--

LOCK TABLES `la_shop_change` WRITE;
/*!40000 ALTER TABLE `la_shop_change` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_change` VALUES (1,5,'ceshi','/uploads/upload/admin/2023/05/03/a2c9661af2f9c0d350bc44122f183116.png',999.00,0,NULL,NULL,2,1683102525,1683360103,1683360103),(2,5,'1123','/aliyun/19b6a16d59e4e1e08d85a04d73d60c00.jpg',111.00,0,NULL,NULL,1,1690983701,1690999281,1690999281),(3,5,'123','/aliyun/f8457ce471ed2920753c2d60d0177fcc.jpg',99.00,0,NULL,NULL,1,1691000152,1691000152,NULL);
/*!40000 ALTER TABLE `la_shop_change` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_change` with 3 row(s)
--

--
-- Table structure for table `la_shop_collect`
--

DROP TABLE IF EXISTS `la_shop_collect`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_collect` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `path` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 收藏';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_collect`
--

LOCK TABLES `la_shop_collect` WRITE;
/*!40000 ALTER TABLE `la_shop_collect` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_collect` VALUES (1,6,'24',1683109167,1683109167),(2,3834,'',1686183136,1686183137);
/*!40000 ALTER TABLE `la_shop_collect` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_collect` with 2 row(s)
--

--
-- Table structure for table `la_shop_goods`
--

DROP TABLE IF EXISTS `la_shop_goods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `brand_id` int(11) unsigned DEFAULT '0' COMMENT '品牌ID',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '缩略图',
  `old_price` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '原价',
  `price` decimal(15,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '现价',
  `is_attribute` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '1单规格，2多规格',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序',
  `sales` int(10) unsigned DEFAULT NULL COMMENT '总销量',
  `stock` int(10) unsigned DEFAULT '0' COMMENT '总库存',
  `editor` text COLLATE utf8mb4_unicode_ci COMMENT '详情',
  `status` int(1) unsigned NOT NULL DEFAULT '1' COMMENT '1启用，2禁用',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 商品';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_goods`
--

LOCK TABLES `la_shop_goods` WRITE;
/*!40000 ALTER TABLE `la_shop_goods` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_goods` VALUES (6,5,1,'1111','/uploads/upload/admin/2023/03/29/161f4fb31e09f32e9dde05344a9280aa.jpeg',999.00,999.00,1,0,0,999,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680051679676562.jpg\" title=\"1680051679676562.jpg\" alt=\"ee282423ecdc028c.jpg\"/></p>',1,1680051772,1680073241,1680073241),(7,5,5,'1','/uploads/upload/admin/2023/03/29/962583ba9cd0cd2fbe052eb225193c23.jpeg',1.00,1.00,1,0,1,1,'<p>1</p>',2,1680051837,1680073165,1680073165),(13,5,5,'1','/uploads/upload/admin/2023/03/29/c7cd7e4cb196b2481cd20065c963259d.jpeg',1.00,1.00,1,0,1,1,'<p>1</p>',1,1680075198,1680077053,1680077053),(15,5,1,'13','/uploads/upload/admin/2023/03/29/000379a79c6a419cd9a60b8f491bd617.png',2.00,2.00,1,1,2,2,'',1,1680076953,1680077053,1680077053),(16,5,1,'苹果14 256G 支持移动联通5G','/uploads/upload/admin/2023/03/29/4f57cd59d70b73369eb16005f67ccacb.png',6500.00,6300.00,1,10,9,6,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680077400746987.jpg\" title=\"1680077400746987.jpg\" alt=\"1679815566203802.jpg\"/></p>',1,1680077468,1691329799,NULL),(17,5,1,'苹果13 128G 国行双卡5G','/uploads/upload/admin/2023/03/29/c2cf963f775a937365a75c9b1ff2b546.png',4380.00,4200.00,1,9,3,0,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680077741858953.jpg\" title=\"1680077741858953.jpg\" alt=\"1679815925285997.jpg\"/></p>',1,1680077745,1686111276,NULL),(18,2,4,'JordanAJ1运动鞋春新款板鞋','/uploads/upload/admin/2023/03/29/7512cffc32861593f6f6ab59eff4a28f.png',1438.00,1388.00,1,3,1,1,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680078196379346.jpg\" title=\"1680078196379346.jpg\" alt=\"1679730416980652.jpg\"/></p>',1,1680078200,1680078228,NULL),(19,2,4,'Jordan耐克乔丹AJ5男子运动鞋春新款缓震透气轻便','/uploads/upload/admin/2023/03/29/b9a097057864569aae277f2129d2f36d.png',2080.00,1980.00,1,4,3,0,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680078321928008.jpg\" title=\"1680078321928008.jpg\" alt=\"1679751841291144.jpg\"/></p>',1,1680078326,1683102624,NULL),(20,6,NULL,'YOL7轻奢女包高级感复古小方包小众时尚单肩斜挎包','/uploads/upload/admin/2023/03/29/a16a71fa748cde7e244af9f85b54aa0f.png',1680.00,1580.00,1,1,0,1,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680078823902510.jpg\" title=\"1680078823902510.jpg\" alt=\"1679856940645350.jpg\"/></p>',1,1680078841,1680079782,NULL),(21,6,NULL,'YOL7轻奢高级感包包妈妈手提包女斜挎','/uploads/upload/admin/2023/03/29/3eb448d80294215a4e709001d3835796.png',1999.00,1839.00,1,2,0,1,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680078977529736.jpg\" title=\"1680078977529736.jpg\" alt=\"1679856993721740.jpg\"/></p>',1,1680078981,1680079766,NULL),(22,7,NULL,'美杜莎手办1/4雕像幕后旋律动漫模型艺术摆件私人定制GK','/uploads/upload/admin/2023/03/29/3e0d28cef2e4fb04161f756e01d5d30b.png',3999.00,3860.00,1,5,2,0,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680079080914401.jpg\" title=\"1680079080914401.jpg\" alt=\"1679820700243678.jpg\"/></p>',1,1680079084,1686111376,NULL),(23,7,NULL,'暴力熊大摆件空山基积木熊公仔潮玩手办','/uploads/upload/admin/2023/03/29/23d488c484ddf54d1fe1c1106937d522.png',2999.00,2860.00,1,6,0,2,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680079209707054.jpg\" title=\"1680079209707054.jpg\" alt=\"1679820966973052.jpg\"/></p>',1,1680079212,1680079736,NULL),(24,8,5,'HUAWEI/华为Mate 50','/uploads/upload/admin/2023/03/29/af4519b02279405bc798c7061a7c9382.png',5699.00,5500.00,1,8,0,0,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680079492713077.jpg\" title=\"1680079492713077.jpg\" alt=\"微信图片_20230329164424.jpg\"/></p>',1,1680079495,1680079715,NULL),(25,8,5,'华为 Mate 40 Pro正品华为mate40pro','/uploads/upload/admin/2023/03/29/ae774d269ae12733ad1593b8565a04ff.png',4499.00,4380.00,1,7,0,0,'<p><img src=\"/uploads/upload/admin/2023/03/29/1680079648944009.jpg\" title=\"1680079648944009.jpg\" alt=\"1679816340638597.jpg\"/></p>',1,1680079652,1680079722,NULL);
/*!40000 ALTER TABLE `la_shop_goods` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_goods` with 14 row(s)
--

--
-- Table structure for table `la_shop_hotsearch`
--

DROP TABLE IF EXISTS `la_shop_hotsearch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_hotsearch` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 热门搜索';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_hotsearch`
--

LOCK TABLES `la_shop_hotsearch` WRITE;
/*!40000 ALTER TABLE `la_shop_hotsearch` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_hotsearch` VALUES (1,'苹果手机',0,1,1684934884,1684934907),(2,'苹果14',0,1,1684934892,1684934907);
/*!40000 ALTER TABLE `la_shop_hotsearch` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_hotsearch` with 2 row(s)
--

--
-- Table structure for table `la_shop_sku`
--

DROP TABLE IF EXISTS `la_shop_sku`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_sku` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `old_price` decimal(10,2) unsigned NOT NULL,
  `price` decimal(10,2) unsigned NOT NULL,
  `sales` int(10) unsigned NOT NULL,
  `stock` int(10) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `thumb` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - sku';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_sku`
--

LOCK TABLES `la_shop_sku` WRITE;
/*!40000 ALTER TABLE `la_shop_sku` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_sku` VALUES (11,18,'默认',1438.00,1388.00,1,1,'11',1,NULL),(12,19,'默认',2080.00,1980.00,3,0,'12',1,NULL),(25,17,'默认',4380.00,4200.00,3,0,'25',1,NULL),(26,24,'默认',5699.00,5500.00,0,0,'26',1,NULL),(27,25,'默认',4499.00,4380.00,0,0,'27',1,NULL),(28,23,'默认',2999.00,2860.00,0,2,'28',1,NULL),(29,22,'默认',3999.00,3860.00,2,0,'29',1,NULL),(30,21,'默认',1999.00,1839.00,0,1,'30',1,NULL),(31,20,'默认',1680.00,1580.00,0,1,'31',1,NULL),(35,16,'默认',6500.00,6300.00,9,6,'35',1,NULL);
/*!40000 ALTER TABLE `la_shop_sku` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_sku` with 10 row(s)
--

--
-- Table structure for table `la_shop_spec`
--

DROP TABLE IF EXISTS `la_shop_spec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_spec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 商品规格属性';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_spec`
--

LOCK TABLES `la_shop_spec` WRITE;
/*!40000 ALTER TABLE `la_shop_spec` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_spec` VALUES (11,18,'默认'),(12,19,'默认'),(25,17,'默认'),(26,24,'默认'),(27,25,'默认'),(28,23,'默认'),(29,22,'默认'),(30,21,'默认'),(31,20,'默认'),(35,16,'默认');
/*!40000 ALTER TABLE `la_shop_spec` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_spec` with 10 row(s)
--

--
-- Table structure for table `la_shop_spec_value`
--

DROP TABLE IF EXISTS `la_shop_spec_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_shop_spec_value` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) unsigned NOT NULL,
  `spec_id` int(10) unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_checked` int(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='商城 - 商品规格';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_shop_spec_value`
--

LOCK TABLES `la_shop_spec_value` WRITE;
/*!40000 ALTER TABLE `la_shop_spec_value` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_shop_spec_value` VALUES (11,18,11,'默认',1),(12,19,12,'默认',1),(25,17,25,'默认',1),(26,24,26,'默认',1),(27,25,27,'默认',1),(28,23,28,'默认',1),(29,22,29,'默认',1),(30,21,30,'默认',1),(31,20,31,'默认',1),(35,16,35,'默认',1);
/*!40000 ALTER TABLE `la_shop_spec_value` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_shop_spec_value` with 10 row(s)
--

--
-- Table structure for table `la_sys_rule`
--

DROP TABLE IF EXISTS `la_sys_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_sys_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '标题',
  `desc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `editor` text CHARACTER SET utf8mb4 COMMENT '详情',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='系统 - 规则协议';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_sys_rule`
--

LOCK TABLES `la_sys_rule` WRITE;
/*!40000 ALTER TABLE `la_sys_rule` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_sys_rule` VALUES (1,'用户协议','用户协议','<p><strong>多多盲盒APP用户服务协议</strong></p><p><br/></p><p>本协议更新时间：2022年9月23日</p><p><br/></p><p>本协议生效时间：2022年9月23日</p><p><br/></p><p>欢迎您（下称“您”或者“用户”）与多多盲盒APP平台共同签署本</p><p><br/></p><p>《多多盲盒APP用户服务协议》（下称“本协议”）并使用多多盲盒APP(下称“多多盲盒”）平台服务</p><p><br/></p><p>服务条款前所列索引关键词仅为帮助您理解该条款表达的主旨之用，不影响或限制本协议条款的含义或解释。【为维护您自身权益，建议您仔细阅读各条款具体表述审慎说读】您在申请注册流程中点击同意本协议之前，应当认真阅读本协议。请您务必审慎阅读、充分理解各条款内容，特别是免除或者限制责任的条款、法律适用和争议解决条款。免除或者限制责任的条款将以粗体下划线标识，您应重点阅读。如您对协议有任何疑问，可向多多盲盒APP平台客服咨询。</p><p><br/></p><p>本协议是您与多多盲盒APP平台所有者之间就多多盲盒APP平台服务等相关事宜所订立的契约，请您仔细阅读本协议，本协议即构成对双方有约束力的法律文件。</p><p><br/></p><p>第一条特别提示</p><p><br/></p><p>1、我司（以下简称“我司”）在此特别提醒您（用户），在多多盲盒平台购买商品之前，请认真阅读本《多多盲盒用户协议》（以下简称“协议”），确保您充分理解本协议中各条款，包括免除多多盲盒责任的条款及限制用户权利的条款。请您审慎阅读并选择接受或不接受本协议。除非您接受本协议所有条款，否则您无权注册、登录或充值购买使用本协议所涉服务。您的注册、点击确认、登录、使用、充值、购买等行为将视为对本协议的接受，并同意接受本协议各项条款的约束。</p><p><br/></p><p>2、本协议约定多多盲盒与用户之间关于“多多盲盒”平台应用服务（以下简称“服务”）的权利义务。“用户”是指注册登录、使用本服务的个人。本协议由多多盲盒根据必要进行更新。如用户继续使用平台服务，即视为用户同意更新后的协议。</p><p><br/></p><p>3、在遵守本协议的前提下，多多盲盒将给予用户一项个人的、不可转让及非排他性的许可，以使用多多盲盒平台（以下简称“本平台”）。用户可以为非商业目的在单一台终端设备上安装、使用、显示、运行本平台。</p><p><br/></p><p>&nbsp;</p><p><br/></p><p>第二条账号注册</p><p><br/></p><p>1. 在用户开始注册程序使用本平台服务前，用户应具备中华人民共和国法律规定的完全民事行为能力。若用户不具备前述民事行为能力，则用户及用户的监护人应依照法律规定承担因此而导致的一切后果。</p><p><br/></p><p>2、用户应诚信向本平台提供注册资料，用户确认其提供的注册资料真实、准确、完整、合法有效，用户注册资料如有变动的，应及时更新其注册资料。如果用户提供的注册资料不合法、不真实、不准确的，用户需承担因此引起的相应责任及后果，并且本平台保留终止用户使用本平台各项服务的权利。</p><p><br/></p><p>3、用户按照注册页面提示填写信息、阅读并同意本协议且完成全部注册程序后，将由平台默认生成用户唯一的“多多盲盒”账号，“多多盲盒”账号应当使用手机号码绑定注册。用户应谨慎合理地保存、使用其用户名和密码，用户若发现任何非法使用用户账号或存在安全漏洞的情况，请立即通知本平台并向公安机关报案。</p><p><br/></p><p>4、多多盲盒可以根据用户需求或产品需要对账号注册和绑定的方式进行变更，包括使用第三方账户登录等。</p><p><br/></p><p>5、如果用户有被多多盲盒封禁的先例或涉嫌虚假注册及滥用他人名义注册，及其他不能得到许可的理由，多多盲盒有权拒绝其注册申请。</p><p><br/></p><p>6、用户不能修改系统自动分配给用户的ID-“多多盲盒ID”。多多盲盒ID所有权属于多多盲盒。</p><p><br/></p><p>7、用户所填写的个人信息如有变动，应及时登录多多盲盒 app更改个人信息，用户因未及时更改造成的损失，本平台概不负责。</p><p><br/></p><p>第三条服务内容</p><p><br/></p><p>（一）交易条款</p><p><br/></p><p>1、用户可以浏览多多盲盒App了解多多盲盒提供的服务内容。平台根据商品的品类设定如“Apple全家桶”“小米有品”“数码宝贝”、“电竞选手”“华为全场景”等不同主题的箱子。用户可根据自身喜好和需求选择箱子进行“开箱”。用户在多多盲盒页面点击“对应盲盒”，即可查看箱子内的全部商品。箱子内商品按照价值分为“普通商品”“隐藏商品”，并对应的向用户公示初始状态下不同商品占该箱子内全部商品数量的比例。2、多多盲盒规则：平台会在系统中预置每个箱子内不同的商品，并向用户公示每个箱子在初始模式下（即未开箱状态下）不同商品的占比。每套盲盒初始时皆是全新的盲盒，但您加入购买时，不保证您选择的那套为满盒状态有可能已经被其他玩家抽走部分盲盒。盲盒内的商品直到被用户全部抽取完毕，平台才会根据比例再次重新预置。由于盲盒数量有限，这是正常的情况：抽盒时，您可以选择任何一个未被拆开的盲盒抽取，抽取时您需要先行购买该盲盒，支付完成后才可以拆开查看内容：。平台承诺公开的比例与系统数据一致，并保证不对盲盒内商品进行任何人为干预。用户接受或同意本协议，即为接受本平台多多盲盒规则。</p><p><br/></p><p>（二）、实名认证</p><p><br/></p><p>1、您充分理解并同意，平台会根据您的实名认证信息判断您是否年满18周岁、您提交的实名身份信息是否规范或实名验证是否通过等，从而决定是否对您的账号予以服务限制（包括但不限干限制支付、限制登陆等）。</p><p><br/></p><p>2、为满足相关法律法规政策及相关主管部门的要求，您应提供真实身份信息进行实名认证，同时您同意我们通过阿里云实人认证系统将您的姓名和身份证号提交至国家统一身份认证系统进行真实身份验证。若未完成实名认证。则我们无法为您提供全部服务（包括但不限于限制支付、限制登陆等）。若您仍然希望使用我们产品的全部服务，则您应完成实名认证，实名认证过程中阿里云实人认证系统会收集您的实名身份信息（包括姓名和身份证号、人脸识别信息）。人脸识别相关验证数据，在加密后仅用于与公安权威数据平台数据源进行比对。</p><p><br/></p><p>（三）、其他条款</p><p><br/></p><p>1、商品价格、数量、商品介绍、库存等商品信息随时都有可能发生变动，任何变动多多盲盒不作特别通知，请您至商品页面自行查看。多多盲盒会尽最大努力保证您所浏览的商品信息的准确性：但由于商品种类繁多、商品信息的数量较大以及互联网技术因素等客观原因，商品信息页面显示可能会有一定的滞后性或差错，您对此表示知悉和理解。</p><p><br/></p><p>2、在遵守相关法律法规前提下，根据合作广告主的要求，多多盲盒有权决定用户在“多多盲盒”应用界面上看到的广告内容及发布方式。</p><p><br/></p><p>3、用户在本平台购买的商品及服务的种类与购买价格由本平台全权决定和解释。</p><p><br/></p><p>4、用户“多多盲盒”应用中显示的累计账户余额可能与多多盲盒服务器端存在统计差异，实际账户余额以服务器端的数据为准。用户对账户余额存在异议，可提供相关记录联系客服处理。</p><p><br/></p><p>第四条支付</p><p><br/></p><p>1、当您点击支付页面将跳转支付平台，您可以根据需要进行选择并支付，支付成功即视为您已阅读、理解，并认同按本协议的相关规定。</p><p><br/></p><p>2、支付成功后，您将获得对应的多多盲盒次数，多多盲盒后不支持多多盲盒费用退还，请谨慎选择，并确认您的消费需求后再进行消费。</p><p><br/></p><p>3、订单信息的准确性：在您提交订单购买时，请仔细确认所购商品的名称、价格、数量、型号、规格、尺寸、颜色（部分商品涉及到型号、规格、尺寸、颜色等但没有标明规格信息和提供选择，或标写“随机”时，由多多盲盒随机配送）：提货时收货人姓名、联系电话、收货地址等信息。若收货人并非您本人，收货人的行为和意思表示将视为您的行为和意思表示，您应对收货人的行为及意思表示产生的法律后果承担连带责任，您提交订单即表示对订单中所确认的订购商品、收货信息等内容的准确性负责。如果因为您填写的收货人姓名、联系电话、收货地址等信息错误，导致延期配送、不能配送、或商品交付给非您本意的收货人的，由此造成的损失需由您自行承担：因此造成任何损失或增加费用的，应由您完全独自承担。</p><p><br/></p><p>4、我们非常重视对未成年人个人信息的保护，根据相关法律法规的规定，若您是18周岁以下的未成年人，使用多多盲盒服务前，应事先取得您的家长或法定监护人的书面同意。如果您阅读并签署了用户协议，且在多多盲盒明确提示后，您仍然进行了用户注册和产品购买，则视为您已经取得了家长或法定监护人的同意或追认，您的消费行为应当产生法律效力，并应当承担与用户相关的法律责任。多多盲盒依据本协议及相关法律规定所实施的行为对您也具有法律约束力。</p><p><br/></p><p>5、未成年人的消费行为需由监护人陪同并监管，平台不接受以“未成年人自行充值消费”等具有不可控、不可证性质的理由提出的退款要求，如有疑问请提供针对未成年人消费行为未得到合理监管的相关证明，并积极配合平台处理。</p><p><br/></p><p>第五条商品提货</p><p><br/></p><p>多多盲盒获得的商品或者您商城购买获得的商品都会进入到您的仓，您需要填写准确的默认收货地址，我们将以该地址信息作为向您提供服务时所依凭据，如果由收货地址不准确而造成的损失，应由您完全独自承担；由于盲盒商品拥有一定的特殊性，商品的具体发货时间由该商品库存和排队人数决定，但不会超过最晚发货日期，最晚发货日期提取订单页面已有标明，请留意查看：商品提取后，将会在1-2个工作日内安排发货，在极少缺货的情况下可能会有延时，但不会超过30个工作日：自动发货的订单，您因各种理由拒收造成的损失由您个人承担：发货后可在提取记录中查看相关的物流消息：中国大陆地区包邮，不包括偏远地区（比如新疆、西藏、内蒙古等），港澳台及海外地区无法配送：平台中大部分商品提取时需要支付邮费，用户选择提货后，平台商品未发货前可联系客服撤销，如平台商品已经发货，不能以任何理由选择撤回。</p><p><br/></p><p>第六条售后</p><p><br/></p><p>1、用户确认，因本平台提供服务的特殊性，已经开启的盲盒不支持七天无理由退换，所以您直接使用现金支付方式购买的盲盒，如仓库有未打开的盲盒，您可以联系客服人员申请退货退款。</p><p><br/></p><p>2、收到商品后，请您及时签收，商品任何瑕疵或质量问题，请及时联系客服人员。您无正当理由拒绝签收，需由您承担商品毁损、灭失的风险及因此产生的费用。</p><p><br/></p><p>3、“盲盒”类产品具有随机性的特点，您在购买平台上某一“盲盒”产品后，平台随机并实时开出您所得商品，多次购买同一系列产品可能使您收到多款重复的商品，不属于售后范围内，建议您理性消费，用户对此完全了解并接受，且不持任何疑义。</p><p><br/></p><p>4、由于灯光、设备、显示器分辨率等因素，图片恐有色差，以实物为准：原厂瑕疵（见商品详情页面规则须知）、非可控客观因素（天气、意外等）均可能不属于售后范围。</p><p><br/></p><p>5、如遇外箱严重破损等情况请拒签，缺件、断裂、发错等严重商品质量问题，请您在收到商品后的7天内明确商品问题并联系客服处理售后，7天后售后事宜将转交供应商客户人员跟进处理。</p><p><br/></p><p>6、因质量问题的售后处理流程：您需要在商品物流签收后7天内联系客服申请退换货。平台所有商品均由第三方提供，因沟通可能产生3到5个工作日的必要时间，用户对此充分理解，并同意给予一定的宽限期。平台将及时跟进，为您提供良好的用户体验和服务。如果商品符合退换货条件，平台将提示供应商尽快提供售后服务。如平台合作商品无库存，平台将向其他供应商采购同一商品，另行采购可能增加您等待的时间，请知晓。部分需要品牌方售后的，多多盲盒将为您提供售后联系方式，售后期间多多盲盒将全程提供协助。品牌方可提供售后范围为部件换新／整件换新／修复，处理时效以品牌方通知为准。</p><p><br/></p><p>7、在您对产品提出异议时，多多盲盒会根据您提供的商品问题证据进行判断，您应对证据的真实性、关联性、完整性、准确性和及时性负责。</p><p><br/></p><p>8、您应在规定的退货时间内（签收后7天内）申请退换货，收到同意退换货通知，请及时（最晚不超过3天）将商品寄回并向多多盲盒在线客服提供物流单号。</p><p><br/></p><p>9、退货商品寄回至商品签收前，多多盲盒将与您共同关注商品的运输及签收情况，商品在运输途中的风险由您承担。</p><p><br/></p><p>第七条用户账户安全</p><p><br/></p><p>1、注册用户的登陆账号、登陆密码用户应当妥善保管并采取必要的保密措施。因用户原因导致账号被盗或造成其他损失，多多盲盒对此不承担任何法律责任。</p><p><br/></p><p>2、用户如果遗失自己的登陆密码，需及时通知多多盲盒，并按照多多盲盒的指导来解决该问题。</p><p><br/></p><p>3、多多盲盒账号为个人账号，为保障用户账户安全，用户不得赠予、借用、租用、转让或售卖多多盲盒账号或者以其他方式许可第三者使用多多盲盒账号，否则用户自行承担由此产生的全部法律责任，并与实际使用人承担连带责任。</p><p><br/></p><p>第八条 服务的变更、中断、终止</p><p><br/></p><p>1、因设备维修或更换、故障和通信中断等技术原因以及其他不能预见，不能克服并不能避免且对真箱提供服务造成重大影响的客观事件，包括但不限于自然灾害如洪水、地震、风暴等以及社会事件如战争、动乱、政府行为等（以下简称“不可抗力”）而中断业务，多多盲盒可视情况事前或事后通知用户，由此引发的损害及后果多多盲盒不承担任何责任。</p><p><br/></p><p>&nbsp;</p><p><br/></p><p>2、多多盲盒临时中断服务时将在多多盲盒网站或微信公众号公告。</p><p><br/></p><p>3、如果因多多盲盒临时中断业务而导致用户账户余额数据丢失，多多盲盒会给予丢失数据的用户相应的账户余额补偿。但因不可抗力导致的业务中断发生时，多多盲盒不给予用户补偿，用户对此完全了解并接受，且不持任何疑义。</p><p><br/></p><p>4、当多多盲盒用户发生如下情况之一时，多多盲盒可单方面终止本协议，取消用户继续使用多多盲盒产品及服务的资格：</p><p><br/></p><p>(1) 用户死亡；</p><p><br/></p><p>(2) 用户盗用他人的个人信息或手机号注册；</p><p><br/></p><p>(3) 注册用户时提供虚假信息；</p><p><br/></p><p>(4) 以非法手段（包括且不限于黑客攻击、利用系统技术 bug等）来积累或使用账户余额；</p><p><br/></p><p>(5) 妨碍其他用户的正常使用：</p><p><br/></p><p>(6) 伪称是多多盲盒的工作人员或管理人员；</p><p><br/></p><p>(7) 擅自强行更改多多盲盒的计算机系统，或威胁侵入系统：</p><p><br/></p><p>(8) 擅自传播谣言，用各种手段来毁损多多盲盒的名誉与妨碍多多盲盒的正常营业：</p><p><br/></p><p>(9) 利用多多盲盒的产品及服务宣传垃圾广告；其他违反本协议的行为及违法、犯罪行为。</p><p><br/></p><p>第九条用户个人隐私信息保护</p><p><br/></p><p>1、因为以下原因导致的客户个人隐私泄露，多多盲盒不承担任何责任：</p><p><br/></p><p>(1) 多多盲盒根据法律法规规定或有权机关的指示提供用户的个人隐私信息：</p><p><br/></p><p>(2) 由于用户将其用户密码告知他人或与他人共享注册账户与密码，由此导致的任何个人信息的泄漏，或其他非因多多盲盒原因导致的个人隐私信息的泄露：</p><p><br/></p><p>(3) 用户自行向第三方公开其个人隐私信息；</p><p><br/></p><p>(4) 用户与多多盲盒及合作单位之间就用户个人隐私信息的使用公开达成约定，多多盲盒因此向合作单位公开用户个人隐私信息；</p><p><br/></p><p>(5) 任何由于黑客攻击、电脑病毒侵入及其他非因多多盲盒原因导致用户个人隐私信息的泄露。</p><p><br/></p><p>2、用户同意多多盲盒可在以下事项中免费使用用户的个人隐私信息：</p><p><br/></p><p>(1) 向用户及时发送重要通知，如应用更新、本协议条款的变更；</p><p><br/></p><p>(2) 多多盲盒内部进行审计、数据分析和研究等，以改进多多盲盒的产品、服务和与用户之间的沟通：</p><p><br/></p><p>(3) 依本协议约定，多多盲盒管理、审查用户信息及进行处理措施；</p><p><br/></p><p>(4) 多多盲盒可能将收集到的用户信息，用于在其他功能或服务中向用户提供特定内容，包括但不限于展示广告、对用户阅读过的内容进行信息安全类提示、基于特征标签进行间接人群画像并提供更加精准和个性化的服务和内容等：</p><p><br/></p><p>(5) 适用法律法规规定的其他事项。</p><p><br/></p><p>3、根据相关法律法规及国家标准，以下情形中，多多盲盒可能会收集、使用、共享、传输、披露用户的个人信息，无需征求用户的授权同意：</p><p><br/></p><p>(1) 与国家安全、国防安全等国家利益直接相关的：与公共安全、公共卫生、公众知情等重大公共利益直接相关的：</p><p><br/></p><p>(2) 与犯罪侦查、起诉、审判和判决执行等直接相关的：</p><p><br/></p><p>(3) 出于维护用户个人的生命、财产、声誉等重大合法权益但又很难得到本人同意</p><p><br/></p><p>(4) 所收集的个人信息是用户自行向社会公众公开的；</p><p><br/></p><p>(5) 从合法公开披露的信息中收集个人信息的，如合法的新闻报道、政府信息公开等渠道：</p><p><br/></p><p>(6) 根据用户要求签订和提供服务所必需的，如收货地址、联系方式等：</p><p><br/></p><p>(7) 用于维护所提供的产品或服务的安全稳定运行所必需的，例如发现、处置产品或服务的故障；</p><p><br/></p><p>(8) 为开展合法的新闻报道所必需的；</p><p><br/></p><p>(9) 出于公共利益开展统计或学术研究所必需的；</p><p><br/></p><p>(10) 法律法规规定的其他情形。</p><p><br/></p><p>4、多多盲盒将会尽其商业上的合理努力保障用户在本软件／平台及服务中的数据存储安全，但是并不能就此提供完全保证，包括但不限于以下情形：</p><p><br/></p><p>(1) 多多盲盒不对用户在本软件／平台及服务中相关数据的删除或存储失败负责</p><p><br/></p><p>(2) 多多盲盒有权根据实际情况自行决定单个用户在本软件／平台及服务中数据的最长存储期限，并在服务器上为其分配数据最大存储空间等：</p><p><br/></p><p>(3) 如果用户停使用本软件／平台及服务或服务被终或取消，多多盲盒可以从服务器上永久删除用户数据。服务停止、终止或取消后，多多盲盒没有义务向用户返还任何数据。</p><p><br/></p><p>第十条用户使用规范</p><p><br/></p><p>1、多多盲盒用户不能利用多多盲盒的账号或提供的服务进行如下行为：（1)用户擅自更改、消除或毁损多多盲盒广告业务提供的各种信息；（2)利用技术手段批量建立虚假账号（3)侵害多多盲盒以及第三者的知识产权：（4)提交、发布虚假信息，或盗用他人资料，冒充、利用他人名义：（5)未经多多盲盒许可，而传播广告或淫秽、暴力等信息；（6)其他不遵守本协议的行为；（7)其他违法以及不正当的行为。2、除非法律允许或多多盲盒书面许可，用户使用本平台过程中不得从事下列行为：（1)删除本平台及其副本上关于著作权的信息：（2)对本平台进行反向工程、反向汇编、反向编译，或者以其他方式尝试发现本平台的源代码：（3)对多多盲盒拥有知识产权的内容进行使用、出租、出借、复制、修改、链接、转载、汇编、发表、出版、发立镜像站点等；（4)对本平台或者本平台运行过程中释放到任何终端内存中的数据、平台运行过程中客户端与服务器端的交互数据，以及本平台运行所必需的系统数据，进行复品，形式包括但不限于使用插件、外挂或非多多盲盒经授权的第三方工具／服务接入本平台和相关系统：（5)通过修改或伪造平台运行中的指令、数据，增加、删减、变动平台的功能或运行效果，或者将用于上述用途的平台、方法进行运营或向公众传播，无论这些行为是否为商业目的：（6)通过非多多盲盒开发、授权的第三方平台、插件、外挂、系统，登录或使用真箱平台及服务，或制作、发布、传播上述工具：（7)自行或者授权他人、第三方平台对本平台及其组件、模块、数据进行干扰：（8)其他未经多多盲盒明示授权的行为。</p><p><br/></p><p>第十一条免责条款</p><p><br/></p><p>1、多多盲盒提供的服务中包括广告，用户同意在使用过程中显示多多盲盒与第三方供应商、合作伙伴提供的广告。用户应自行对该广告信息进行的交易负责，对用户因该广告信息进行的交易或前述广告商提供的内容而遭受的损失或损害，多多盲盒不承担任何责任，由交易双方按照法律规定自行处理和解决。</p><p><br/></p><p>2、由于多多盲盒服务的特殊属性，非现金直接购买的商品多多盲盒不支持7天无理由退换货，仅支持有条件售后，即产品有瑕疵和质量问题的情况下，多多盲盒可提供更换服务，售后服务自用户签收之日起算为期7天，7天届满视为产品无瑕疵、无质量问题，验收合格且交易成功。</p><p><br/></p><p>3、“盲盒”“抽赏”消费，具有随机性的特点，对此您已充分了解。您应该对您充值、消费行为的性质和后果审慎评估和判断后作出选择和行为，并对您在多多盲盒平台上的一切消费行为负责。对此，您不应以未开到特定款式的商品为由要求多多盲盒退款、赔偿或承担任何责任。多多盲盒无法且不会对因前述问题而导致的任何损失或损害承担责任。</p><p><br/></p><p>4、用户理解并同意，因用户违反本协议或相关服务条款的规定，导致或产生第三方主张的任何索赔、要求或损失，用户应当独立承担责任；多多盲盒因此遭受损失的，用户也应当一并赔偿。</p><p><br/></p><p>5、用户理解并同意，多多盲盒平台同大多数互联网平台一样，可能会受多种因素影响，包括但不限于用户原因网络服务质量、社会环境等；也可能会受各种安全问题的侵扰；包括但不限于他人非法利用用户资料，进行现实中的骚扰用户下载安装的其他平台或访问的其他网站中可能含有病毒、木马程序或其他恶意程序，威胁用户的终端设备信息和数据安全，继而影响本平台的正常使用等。因此，用户应加强信息安全及个人信息的保护意识，注意密码保护，以免遭受损失。</p><p><br/></p><p><br/></p>',NULL,1688556383),(2,'活动规则','抽盒活动规则','<p style=\"text-align: center;\"><span style=\"font-size: 24px;\"><strong>玩法风险告知</strong></span></p><p><br/></p><p><br/></p><p>尊敬的用户，为了使您能够充分了解多多芒盒玩法的特殊性以及风险性，请您在使用多多芒盒服务前仔细阅读以下内容:</p><p><br/></p><p>1.请知晓多多芒盒抽奖玩法存在概率性和不确定性，不能保证您定能够拍中心仪的商品，请根据自身的需求合理消费。</p><p><br/></p><p>2.多多芒盒中的物品分为高级款-稀有款-史诗款-传说款:前端页面展示出来的概率和后端设置概率是一致性的.</p><p>为了让开盒体验更加公平有趣，我们利用可证明的公平算法来确保随机化过程的透明性，计算过程被完全记录下来，是完全透明和不能被篡改的.<br/></p><p><br/></p><p>3.抽堂玩法中的概率是根据数学中的几率统计学进行测算:例如，设定传说款的中奖概率为1%，并不是100次抽奖一定有1次开出传说款:也不是第100次抽奖才会出现1次传说款:而是每一次抽奖中传说款的概率全是按照公示的概率数值进行抽奖，第1次、第100次、第1000次...无论任意次数，抽奖中传说款的概率都是1%。</p><p><br/></p><p><br/></p><p>4“多多芒盒”类产品具有随机性的特点，您在购买平台上“多多芒盒产品后，平台随机并实时开出您应得商品.多次购买同一系列产品可能使您收到多款重复的商品，不属于售后范围内，建议您理性消费。商品有任何瑕疵或质量问题，请及时联系客服人员您无正当理由拒绝签收将不支持七天无理由退换货商品。</p><p><br/></p><p><br/></p><p>5.平台展示的任意一套多多芒盒，都会百分百开出实物商品，用户都可以选择提取发货。提取商品后具体的发货时间由该商品的库存和排队人数决定，因地震、疫情等不可抗力原因会影响发货时间。若您获得的实物商品都不选择提取，而是选择重抽卡，有可能导致您最终只有少量甚至没有任何实物商品，对此造成的后果须自行承担。</p><p><br/></p><p>&nbsp;</p><p><br/></p><p><br/></p><p>6.若您是未满18周岁的未成年人，在使用多多芒盒服务前应取得家长或法定监护人的书面同意:未成年的消费行为需由监护人陪同并监管:平台会根据相关法律法规决定是否对您的账号予以服务限制。</p><p><br/></p><p><br/></p><p>7.若您对上述内容有任何不理解的，可通过小程序或者APP内的在线客服联系平台进行进一步咨询为了保障您的合清 大提示您，多多芒盒玩法存在概率性和不确定性，请确认您的消费需求后再进行消费</p><p><br/></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s1\">支付购买需知</span></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">1.</span><span class=\"s1\">当您点击支付页面将跳转支付平台</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">,</span><span class=\"s1\">您可以根据需要进行选择</span></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s1\">并支付，支付成功即视为您已阅读、理解，并认同按本协议的相关规定。</span></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">2</span><span class=\"s1\">、支付成功后，您将获得对应的开箱次数，开箱后不支持开箱费用退还</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">,</span><span class=\"s1\">请谨慎选择，并确认您的消费需求后再进行消费。</span></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">3</span><span class=\"s1\">、订单信息的准确性</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">;</span><span class=\"s1\">在您提交订单购买时，请仔细确认所购商品的名称、价格、数量、型号、规格、尺寸、颜色</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">(</span><span class=\"s1\">部分商品涉及到型号、规格、尺寸、颜色等但没有标明规格信息和提供选择</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">,</span><span class=\"s1\">或标写“随机”时，由开箱随机配送</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">);</span><span class=\"s1\">提货时收货人姓名、联系电话、收货、地址等信息。您提交订单即表示对订单中所确认的订购商品、收货信息等内容的准确性负责。如果因为您填写的收货人姓名，联系电话，收货地址等信息错误，导致延期配送</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">,</span><span class=\"s1\">不能配送，或商品交付给非您本意的收货人的，由此造成的损失需由您自行承担因此造成任何损失或增加费用的，应由您完全独自承担。</span></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">4</span><span class=\"s1\">、我们非常重视对末成年人个人信息的保护，根据相关法律泛规的规定，若您是</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">18</span><span class=\"s1\">周岁以下的未成年人，使用开箱服务前，应事先取得您的家长或法定监护人的书面同意。如果您囵读并签署了用户协议，目在开箱明确提示后，您仍然进行了用户注册和产品购买，则视为您已经取得了家长或法定监护人的同意或追认</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">,</span><span class=\"s1\">您的消费行为应当产生法律效力，并应当承担与用户相关的法律责任。开箱依据本协议及相关法律规定所实施的行为对您也具有法律约束力。</span></p><p class=\"p2\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; min-height: 22px; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\"></span><br/></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">8.</span><span class=\"s1\">若您对上述内容有任何不理解的，可通过小程序或者</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">APP</span><span class=\"s1\">内的在线客服联系平台进行进一步咨询为了保障您的合清</span><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\">&nbsp;</span><span class=\"s1\">大提示您，多多盲盒玩法存在概率性和不确定性，请确认您的消费需求后再进行消费。</span></p><p class=\"p2\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; min-height: 22px; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\"></span><br/></p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal; text-size-adjust: auto;\"><span class=\"s2\" style=\"font-family: UICTFontTextStyleBody;\"></span></p><p style=\"white-space: normal;\">平台运营者规范</p><p style=\"white-space: normal;\">1.盲盒经营者提供商品或者服务应明码标价，不得在标价之外加价出售商品，不得实施不按规定明码标价、哄抬价格、价格欺诈等违法行为。</p><p style=\"white-space: normal;\">2.盲盒经营者不得通过后台操纵改变抽取结果、随意调整抽取概率等方式变相诱导消费。不得以折现、回购、换购等方式拒绝或者故意拖延发放盲盒。不得设置空盒。</p><p style=\"white-space: normal;\">3.盲盒经营者应建立追踪记录制度，确保消费者所抽取的商品发放到位，并自觉接受监督。相关记录留存时间一般不少于 3 年。</p><p class=\"p1\" style=\"margin-top: 0px; margin-bottom: 0px; font-stretch: normal; font-size: 17px; line-height: normal; white-space: normal;\"><br/></p><p><br/></p>',NULL,1688556707),(3,'购买须知','抽盒购买须知','<p style=\"white-space: normal;\">1：平台下单协议：</p><p>2：商品抽赏存在概率性，付费请谨慎。</p><p>3：未成年人禁止下单！未听劝阻私自下单后果自负。</p><p>4：本店所有上架商品均为正品，如遇假冒伪劣可跟客服联系进行退换。</p><p>5：本店填写地址后将在3-7天内发货。</p><p>6：本店（全新商品只包全新，不包官方瑕疵。个别商品会拆开盒子检查型号。默认无运输盒。二手商品默认8成新，盒子默认盒损，配件为盒说全）</p><p>7：奖池内容具有不确定性，客户下单后货物仅质量问题申请退换货，有质量问题请收到货七天内联系客服处理，具体退换规则请联系客服咨询。</p><p><br/></p><p><br/></p>',NULL,1688556110),(4,'规则说明','置换商城规则说明','<p>用户可使用本平台活动日赠送的兑换码免费兑换活动盲盒开启</p>',NULL,1685788723),(5,'规则说明','邮费规则说明','<p>获得的商品或者您商城购买获得的商品都会进入到您的仓库，您需要填写准确的默认收货地址，我们将以该地址信息作为向您提供服务时所依凭据，如果由收货地址不准确而造成的损失，应由您完全独自承担由于盲盒商品拥有一定的特殊性，商品的具体发货时间由该商品库存和排队人数决定，<span style=\"color: rgb(224, 62, 45);\">发货时间为2-3天</span>，但不会超过最晚发货日期，最晚发货日期是3天，提取订单页面已有标明，请留意查看:虚拟商品提取后，将会在<span style=\"color: rgb(224, 62, 45);\">3-7个工作日内发货</span>，鞋类 包类 发货大概<span style=\"color: rgb(224, 62, 45);\">3-7个工作日</span>，手机3C数码产品3天内发货在极少缺货的情况下可能会有延时:自动发货的订单，您因各种理由拒收造成的损失由您个人承担;发货后可在提取记录中查看相关的物流消息中国大陆地区不包括偏远地区 (比如新疆、西藏、内蒙古等)，港澳台及海外地区可能无法配送;平台中大部分商品提取时需要支付邮费:一旦选择提货，不能以任何理由选择撤回<strong style=\"white-space: normal;\"><span style=\"color: rgb(224, 62, 45);\">平台基础运费统一全部按照8元一件</span></strong>，不支持合并发货，请知悉<br/>如受疫情及交通管控影响，您的包裹可能会延迟配送，请耐心等候，感谢您的理解!</p>',NULL,1688556140),(6,'关于我们','商务合作','<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><strong>关于我们</strong></span><br/><strong>Abount us</strong><br/>欧气潮玩是电商购物平台，秉承着让潮玩与购物结合的理念在购物的同时结合当下潮流的潮物玩法，给予用户打造趣味多样化的购物体验</p><p><br/></p><p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><strong>商务合作</strong></span><br/><strong>Business cooperation</strong><br/>欧气潮玩合作内容有:<br/>1、拥有正版优质的商品、服务要入驻本平台或者您有意向成为我们的下游合作商<br/>2、其他潮物类电商需要流量合作<br/>3、有潮玩产品有团队，需要发布潮物类商品的</p>',NULL,1686926637),(7,'隐私政策','隐私政策','<p>多多芒盒APP用户服务协议</p><p><br/></p><p>本协议更新时间：2023年6月6日</p><p><br/></p><p>本协议生效时间：2023年6月6日</p><p><br/></p><p>欢迎您（下称“您”或者“用户”）与多多芒盒APP平台共同签署本</p><p><br/></p><p>《多多芒盒APP用户服务协议》（下称“本协议”）并使用多多芒盒APP(下称“多多芒盒”）平台服务</p><p><br/></p><p>服务条款前所列索引关键词仅为帮助您理解该条款表达的主旨之用，不影响或限制本协议条款的含义或解释。【为维护您自身权益，建议您仔细阅读各条款具体表述审慎说读】您在申请注册流程中点击同意本协议之前，应当认真阅读本协议。请您务必审慎阅读、充分理解各条款内容，特别是免除或者限制责任的条款、法律适用和争议解决条款。免除或者限制责任的条款将以粗体下划线标识，您应重点阅读。如您对协议有任何疑问，可向多多芒盒APP平台客服咨询。</p><p><br/></p><p>本协议是您与多多芒盒APP平台所有者之间就多多芒盒APP平台服务等相关事宜所订立的契约，请您仔细阅读本协议，本协议即构成对双方有约束力的法律文件。</p><p><br/></p><p>第一条特别提示</p><p><br/></p><p>1、我司（以下简称“我司”）在此特别提醒您（用户），在多多芒盒平台购买商品之前，请认真阅读本《多多芒盒用户协议》（以下简称“协议”），确保您充分理解本协议中各条款，包括免除多多芒盒责任的条款及限制用户权利的条款。请您审慎阅读并选择接受或不接受本协议。除非您接受本协议所有条款，否则您无权注册、登录或充值购买使用本协议所涉服务。您的注册、点击确认、登录、使用、充值、购买等行为将视为对本协议的接受，并同意接受本协议各项条款的约束。</p><p><br/></p><p>2、本协议约定多多芒盒与用户之间关于“多多芒盒”平台应用服务（以下简称“服务”）的权利义务。“用户”是指注册登录、使用本服务的个人。本协议由多多芒盒根据必要进行更新。如用户继续使用平台服务，即视为用户同意更新后的协议。</p><p><br/></p><p>3、在遵守本协议的前提下，多多芒盒将给予用户一项个人的、不可转让及非排他性的许可，以使用多多芒盒平台（以下简称“本平台”）。用户可以为非商业目的在单一台终端设备上安装、使用、显示、运行本平台。</p><p><br/></p><p>&nbsp;</p><p><br/></p><p>第二条账号注册</p><p><br/></p><p>1. 在用户开始注册程序使用本平台服务前，用户应具备中华人民共和国法律规定的完全民事行为能力。若用户不具备前述民事行为能力，则用户及用户的监护人应依照法律规定承担因此而导致的一切后果。</p><p><br/></p><p>2、用户应诚信向本平台提供注册资料，用户确认其提供的注册资料真实、准确、完整、合法有效，用户注册资料如有变动的，应及时更新其注册资料。如果用户提供的注册资料不合法、不真实、不准确的，用户需承担因此引起的相应责任及后果，并且本平台保留终止用户使用本平台各项服务的权利。</p><p><br/></p><p>3、用户按照注册页面提示填写信息、阅读并同意本协议且完成全部注册程序后，将由平台默认生成用户唯一的“多多芒盒”账号，“多多芒盒”账号应当使用手机号码绑定注册。用户应谨慎合理地保存、使用其用户名和密码，用户若发现任何非法使用用户账号或存在安全漏洞的情况，请立即通知本平台并向公安机关报案。</p><p><br/></p><p>4、多多芒盒可以根据用户需求或产品需要对账号注册和绑定的方式进行变更，包括使用第三方账户登录等。</p><p><br/></p><p>5、如果用户有被多多芒盒封禁的先例或涉嫌虚假注册及滥用他人名义注册，及其他不能得到许可的理由，多多芒盒有权拒绝其注册申请。</p><p><br/></p><p>6、用户不能修改系统自动分配给用户的ID-“多多芒盒ID”。多多芒盒ID所有权属于多多芒盒。</p><p><br/></p><p>7、用户所填写的个人信息如有变动，应及时登录多多芒盒 app更改个人信息，用户因未及时更改造成的损失，本平台概不负责。</p><p><br/></p><p>第三条服务内容</p><p><br/></p><p>（一）交易条款</p><p><br/></p><p>1、用户可以浏览多多芒盒App了解多多芒盒提供的服务内容。平台根据商品的品类设定如“Apple全家桶”“小米有品”“数码宝贝”、“电竞选手”“华为全场景”等不同主题的箱子。用户可根据自身喜好和需求选择箱子进行“开箱”。用户在多多芒盒页面点击“对应盲盒”，即可查看箱子内的全部商品。箱子内商品按照价值分为“普通商品”“隐藏商品”，并对应的向用户公示初始状态下不同商品占该箱子内全部商品数量的比例。2、多多芒盒规则：平台会在系统中预置每个箱子内不同的商品，并向用户公示每个箱子在初始模式下（即未开箱状态下）不同商品的占比。每套盲盒初始时皆是全新的盲盒，但您加入购买时，不保证您选择的那套为满盒状态有可能已经被其他玩家抽走部分盲盒。盲盒内的商品直到被用户全部抽取完毕，平台才会根据比例再次重新预置。由于盲盒数量有限，这是正常的情况：抽盒时，您可以选择任何一个未被拆开的盲盒抽取，抽取时您需要先行购买该盲盒，支付完成后才可以拆开查看内容：。平台承诺公开的比例与系统数据一致，并保证不对盲盒内商品进行任何人为干预。用户接受或同意本协议，即为接受本平台多多芒盒规则。</p><p><br/></p><p>（二）、实名认证</p><p><br/></p><p>1、您充分理解并同意，平台会根据您的实名认证信息判断您是否年满18周岁、您提交的实名身份信息是否规范或实名验证是否通过等，从而决定是否对您的账号予以服务限制（包括但不限干限制支付、限制登陆等）。</p><p><br/></p><p>2、为满足相关法律法规政策及相关主管部门的要求，您应提供真实身份信息进行实名认证，同时您同意我们通过阿里云实人认证系统将您的姓名和身份证号提交至国家统一身份认证系统进行真实身份验证。若未完成实名认证。则我们无法为您提供全部服务（包括但不限于限制支付、限制登陆等）。若您仍然希望使用我们产品的全部服务，则您应完成实名认证，实名认证过程中阿里云实人认证系统会收集您的实名身份信息（包括姓名和身份证号、人脸识别信息）。人脸识别相关验证数据，在加密后仅用于与公安权威数据平台数据源进行比对。</p><p><br/></p><p>（三）、其他条款</p><p><br/></p><p>1、商品价格、数量、商品介绍、库存等商品信息随时都有可能发生变动，任何变动多多芒盒不作特别通知，请您至商品页面自行查看。多多芒盒会尽最大努力保证您所浏览的商品信息的准确性：但由于商品种类繁多、商品信息的数量较大以及互联网技术因素等客观原因，商品信息页面显示可能会有一定的滞后性或差错，您对此表示知悉和理解。</p><p><br/></p><p>2、在遵守相关法律法规前提下，根据合作广告主的要求，多多芒盒有权决定用户在“多多芒盒”应用界面上看到的广告内容及发布方式。</p><p><br/></p><p>3、用户在本平台购买的商品及服务的种类与购买价格由本平台全权决定和解释。</p><p><br/></p><p>4、用户“多多芒盒”应用中显示的累计账户余额可能与多多芒盒服务器端存在统计差异，实际账户余额以服务器端的数据为准。用户对账户余额存在异议，可提供相关记录联系客服处理。</p><p><br/></p><p>第四条支付</p><p><br/></p><p>1、当您点击支付页面将跳转支付平台，您可以根据需要进行选择并支付，支付成功即视为您已阅读、理解，并认同按本协议的相关规定。</p><p><br/></p><p>2、支付成功后，您将获得对应的多多芒盒次数，多多芒盒后不支持多多芒盒费用退还，请谨慎选择，并确认您的消费需求后再进行消费。</p><p><br/></p><p>3、订单信息的准确性：在您提交订单购买时，请仔细确认所购商品的名称、价格、数量、型号、规格、尺寸、颜色（部分商品涉及到型号、规格、尺寸、颜色等但没有标明规格信息和提供选择，或标写“随机”时，由多多芒盒随机配送）：提货时收货人姓名、联系电话、收货地址等信息。若收货人并非您本人，收货人的行为和意思表示将视为您的行为和意思表示，您应对收货人的行为及意思表示产生的法律后果承担连带责任，您提交订单即表示对订单中所确认的订购商品、收货信息等内容的准确性负责。如果因为您填写的收货人姓名、联系电话、收货地址等信息错误，导致延期配送、不能配送、或商品交付给非您本意的收货人的，由此造成的损失需由您自行承担：因此造成任何损失或增加费用的，应由您完全独自承担。</p><p><br/></p><p>4、我们非常重视对未成年人个人信息的保护，根据相关法律法规的规定，若您是18周岁以下的未成年人，使用多多芒盒服务前，应事先取得您的家长或法定监护人的书面同意。如果您阅读并签署了用户协议，且在多多芒盒明确提示后，您仍然进行了用户注册和产品购买，则视为您已经取得了家长或法定监护人的同意或追认，您的消费行为应当产生法律效力，并应当承担与用户相关的法律责任。多多芒盒依据本协议及相关法律规定所实施的行为对您也具有法律约束力。</p><p><br/></p><p>5、未成年人的消费行为需由监护人陪同并监管，平台不接受以“未成年人自行充值消费”等具有不可控、不可证性质的理由提出的退款要求，如有疑问请提供针对未成年人消费行为未得到合理监管的相关证明，并积极配合平台处理。</p><p><br/></p><p>第五条商品提货</p><p><br/></p><p>多多芒盒获得的商品或者您商城购买获得的商品都会进入到您的仓，您需要填写准确的默认收货地址，我们将以该地址信息作为向您提供服务时所依凭据，如果由收货地址不准确而造成的损失，应由您完全独自承担；由于盲盒商品拥有一定的特殊性，商品的具体发货时间由该商品库存和排队人数决定，但不会超过最晚发货日期，最晚发货日期提取订单页面已有标明，请留意查看：商品提取后，将会在1-2个工作日内安排发货，在极少缺货的情况下可能会有延时，但不会超过30个工作日：自动发货的订单，您因各种理由拒收造成的损失由您个人承担：发货后可在提取记录中查看相关的物流消息：中国大陆地区包邮，不包括偏远地区（比如新疆、西藏、内蒙古等），港澳台及海外地区无法配送：平台中大部分商品提取时需要支付邮费，用户选择提货后，平台商品未发货前可联系客服撤销，如平台商品已经发货，不能以任何理由选择撤回。</p><p><br/></p><p>第六条售后</p><p><br/></p><p>1、用户确认，因本平台提供服务的特殊性，已经开启的盲盒不支持七天无理由退换，所以您直接使用现金支付方式购买的盲盒，如仓库有未打开的盲盒，您可以联系客服人员申请退货退款。</p><p><br/></p><p>2、收到商品后，请您及时签收，商品任何瑕疵或质量问题，请及时联系客服人员。您无正当理由拒绝签收，需由您承担商品毁损、灭失的风险及因此产生的费用。</p><p><br/></p><p>3、“盲盒”类产品具有随机性的特点，您在购买平台上某一“盲盒”产品后，平台随机并实时开出您所得商品，多次购买同一系列产品可能使您收到多款重复的商品，不属于售后范围内，建议您理性消费，用户对此完全了解并接受，且不持任何疑义。</p><p><br/></p><p>4、由于灯光、设备、显示器分辨率等因素，图片恐有色差，以实物为准：原厂瑕疵（见商品详情页面规则须知）、非可控客观因素（天气、意外等）均可能不属于售后范围。</p><p><br/></p><p>5、如遇外箱严重破损等情况请拒签，缺件、断裂、发错等严重商品质量问题，请您在收到商品后的7天内明确商品问题并联系客服处理售后，7天后售后事宜将转交供应商客户人员跟进处理。</p><p><br/></p><p>6、因质量问题的售后处理流程：您需要在商品物流签收后7天内联系客服申请退换货。平台所有商品均由第三方提供，因沟通可能产生3到5个工作日的必要时间，用户对此充分理解，并同意给予一定的宽限期。平台将及时跟进，为您提供良好的用户体验和服务。如果商品符合退换货条件，平台将提示供应商尽快提供售后服务。如平台合作商品无库存，平台将向其他供应商采购同一商品，另行采购可能增加您等待的时间，请知晓。部分需要品牌方售后的，多多芒盒将为您提供售后联系方式，售后期间多多芒盒将全程提供协助。品牌方可提供售后范围为部件换新／整件换新／修复，处理时效以品牌方通知为准。</p><p><br/></p><p>7、在您对产品提出异议时，多多芒盒会根据您提供的商品问题证据进行判断，您应对证据的真实性、关联性、完整性、准确性和及时性负责。</p><p><br/></p><p>8、您应在规定的退货时间内（签收后7天内）申请退换货，收到同意退换货通知，请及时（最晚不超过3天）将商品寄回并向多多芒盒在线客服提供物流单号。</p><p><br/></p><p>9、退货商品寄回至商品签收前，多多芒盒将与您共同关注商品的运输及签收情况，商品在运输途中的风险由您承担。</p><p><br/></p><p>第七条用户账户安全</p><p><br/></p><p>1、注册用户的登陆账号、登陆密码用户应当妥善保管并采取必要的保密措施。因用户原因导致账号被盗或造成其他损失，多多芒盒对此不承担任何法律责任。</p><p><br/></p><p>2、用户如果遗失自己的登陆密码，需及时通知多多芒盒，并按照多多芒盒的指导来解决该问题。</p><p><br/></p><p>3、多多芒盒账号为个人账号，为保障用户账户安全，用户不得赠予、借用、租用、转让或售卖多多芒盒账号或者以其他方式许可第三者使用多多芒盒账号，否则用户自行承担由此产生的全部法律责任，并与实际使用人承担连带责任。</p><p><br/></p><p>第八条 服务的变更、中断、终止</p><p><br/></p><p>1、因设备维修或更换、故障和通信中断等技术原因以及其他不能预见，不能克服并不能避免且对真箱提供服务造成重大影响的客观事件，包括但不限于自然灾害如洪水、地震、风暴等以及社会事件如战争、动乱、政府行为等（以下简称“不可抗力”）而中断业务，多多芒盒可视情况事前或事后通知用户，由此引发的损害及后果多多芒盒不承担任何责任。</p><p><br/></p><p>&nbsp;</p><p><br/></p><p>2、多多芒盒临时中断服务时将在多多芒盒网站或微信公众号公告。</p><p><br/></p><p>3、如果因多多芒盒临时中断业务而导致用户账户余额数据丢失，多多芒盒会给予丢失数据的用户相应的账户余额补偿。但因不可抗力导致的业务中断发生时，多多芒盒不给予用户补偿，用户对此完全了解并接受，且不持任何疑义。</p><p><br/></p><p>4、当多多芒盒用户发生如下情况之一时，多多芒盒可单方面终止本协议，取消用户继续使用多多芒盒产品及服务的资格：</p><p><br/></p><p>(1) 用户死亡；</p><p><br/></p><p>(2) 用户盗用他人的个人信息或手机号注册；</p><p><br/></p><p>(3) 注册用户时提供虚假信息；</p><p><br/></p><p>(4) 以非法手段（包括且不限于黑客攻击、利用系统技术 bug等）来积累或使用账户余额；</p><p><br/></p><p>(5) 妨碍其他用户的正常使用：</p><p><br/></p><p>(6) 伪称是多多芒盒的工作人员或管理人员；</p><p><br/></p><p>(7) 擅自强行更改多多芒盒的计算机系统，或威胁侵入系统：</p><p><br/></p><p>(8) 擅自传播谣言，用各种手段来毁损多多芒盒的名誉与妨碍多多芒盒的正常营业：</p><p><br/></p><p>(9) 利用多多芒盒的产品及服务宣传垃圾广告；其他违反本协议的行为及违法、犯罪行为。</p><p><br/></p><p>第九条用户个人隐私信息保护</p><p><br/></p><p>1、因为以下原因导致的客户个人隐私泄露，多多芒盒不承担任何责任：</p><p><br/></p><p>(1) 多多芒盒根据法律法规规定或有权机关的指示提供用户的个人隐私信息：</p><p><br/></p><p>(2) 由于用户将其用户密码告知他人或与他人共享注册账户与密码，由此导致的任何个人信息的泄漏，或其他非因多多芒盒原因导致的个人隐私信息的泄露：</p><p><br/></p><p>(3) 用户自行向第三方公开其个人隐私信息；</p><p><br/></p><p>(4) 用户与多多芒盒及合作单位之间就用户个人隐私信息的使用公开达成约定，多多芒盒因此向合作单位公开用户个人隐私信息；</p><p><br/></p><p>(5) 任何由于黑客攻击、电脑病毒侵入及其他非因多多芒盒原因导致用户个人隐私信息的泄露。</p><p><br/></p><p>2、用户同意多多芒盒可在以下事项中免费使用用户的个人隐私信息：</p><p><br/></p><p>(1) 向用户及时发送重要通知，如应用更新、本协议条款的变更；</p><p><br/></p><p>(2) 多多芒盒内部进行审计、数据分析和研究等，以改进多多芒盒的产品、服务和与用户之间的沟通：</p><p><br/></p><p>(3) 依本协议约定，多多芒盒管理、审查用户信息及进行处理措施；</p><p><br/></p><p>(4) 多多芒盒可能将收集到的用户信息，用于在其他功能或服务中向用户提供特定内容，包括但不限于展示广告、对用户阅读过的内容进行信息安全类提示、基于特征标签进行间接人群画像并提供更加精准和个性化的服务和内容等：</p><p><br/></p><p>(5) 适用法律法规规定的其他事项。</p><p><br/></p><p>3、根据相关法律法规及国家标准，以下情形中，多多芒盒可能会收集、使用、共享、传输、披露用户的个人信息，无需征求用户的授权同意：</p><p><br/></p><p>(1) 与国家安全、国防安全等国家利益直接相关的：与公共安全、公共卫生、公众知情等重大公共利益直接相关的：</p><p><br/></p><p>(2) 与犯罪侦查、起诉、审判和判决执行等直接相关的：</p><p><br/></p><p>(3) 出于维护用户个人的生命、财产、声誉等重大合法权益但又很难得到本人同意</p><p><br/></p><p>(4) 所收集的个人信息是用户自行向社会公众公开的；</p><p><br/></p><p>(5) 从合法公开披露的信息中收集个人信息的，如合法的新闻报道、政府信息公开等渠道：</p><p><br/></p><p>(6) 根据用户要求签订和提供服务所必需的，如收货地址、联系方式等：</p><p><br/></p><p>(7) 用于维护所提供的产品或服务的安全稳定运行所必需的，例如发现、处置产品或服务的故障；</p><p><br/></p><p>(8) 为开展合法的新闻报道所必需的；</p><p><br/></p><p>(9) 出于公共利益开展统计或学术研究所必需的；</p><p><br/></p><p>(10) 法律法规规定的其他情形。</p><p><br/></p><p>4、多多芒盒将会尽其商业上的合理努力保障用户在本软件／平台及服务中的数据存储安全，但是并不能就此提供完全保证，包括但不限于以下情形：</p><p><br/></p><p>(1) 多多芒盒不对用户在本软件／平台及服务中相关数据的删除或存储失败负责</p><p><br/></p><p>(2) 多多芒盒有权根据实际情况自行决定单个用户在本软件／平台及服务中数据的最长存储期限，并在服务器上为其分配数据最大存储空间等：</p><p><br/></p><p>(3) 如果用户停使用本软件／平台及服务或服务被终或取消，多多芒盒可以从服务器上永久删除用户数据。服务停止、终止或取消后，多多芒盒没有义务向用户返还任何数据。</p><p><br/></p><p>第十条用户使用规范</p><p><br/></p><p>1、多多芒盒用户不能利用多多芒盒的账号或提供的服务进行如下行为：（1)用户擅自更改、消除或毁损多多芒盒广告业务提供的各种信息；（2)利用技术手段批量建立虚假账号（3)侵害多多芒盒以及第三者的知识产权：（4)提交、发布虚假信息，或盗用他人资料，冒充、利用他人名义：（5)未经多多芒盒许可，而传播广告或淫秽、暴力等信息；（6)其他不遵守本协议的行为；（7)其他违法以及不正当的行为。2、除非法律允许或多多芒盒书面许可，用户使用本平台过程中不得从事下列行为：（1)删除本平台及其副本上关于著作权的信息：（2)对本平台进行反向工程、反向汇编、反向编译，或者以其他方式尝试发现本平台的源代码：（3)对多多芒盒拥有知识产权的内容进行使用、出租、出借、复制、修改、链接、转载、汇编、发表、出版、发立镜像站点等；（4)对本平台或者本平台运行过程中释放到任何终端内存中的数据、平台运行过程中客户端与服务器端的交互数据，以及本平台运行所必需的系统数据，进行复品，形式包括但不限于使用插件、外挂或非多多芒盒经授权的第三方工具／服务接入本平台和相关系统：（5)通过修改或伪造平台运行中的指令、数据，增加、删减、变动平台的功能或运行效果，或者将用于上述用途的平台、方法进行运营或向公众传播，无论这些行为是否为商业目的：（6)通过非多多芒盒开发、授权的第三方平台、插件、外挂、系统，登录或使用真箱平台及服务，或制作、发布、传播上述工具：（7)自行或者授权他人、第三方平台对本平台及其组件、模块、数据进行干扰：（8)其他未经多多芒盒明示授权的行为。</p><p><br/></p><p>第十一条免责条款</p><p><br/></p><p>1、多多芒盒提供的服务中包括广告，用户同意在使用过程中显示多多芒盒与第三方供应商、合作伙伴提供的广告。用户应自行对该广告信息进行的交易负责，对用户因该广告信息进行的交易或前述广告商提供的内容而遭受的损失或损害，多多芒盒不承担任何责任，由交易双方按照法律规定自行处理和解决。</p><p><br/></p><p>2、由于多多芒盒服务的特殊属性，非现金直接购买的商品多多芒盒不支持7天无理由退换货，仅支持有条件售后，即产品有瑕疵和质量问题的情况下，多多芒盒可提供更换服务，售后服务自用户签收之日起算为期7天，7天届满视为产品无瑕疵、无质量问题，验收合格且交易成功。</p><p><br/></p><p>3、“盲盒”“抽赏”消费，具有随机性的特点，对此您已充分了解。您应该对您充值、消费行为的性质和后果审慎评估和判断后作出选择和行为，并对您在多多芒盒平台上的一切消费行为负责。对此，您不应以未开到特定款式的商品为由要求多多芒盒退款、赔偿或承担任何责任。多多芒盒无法且不会对因前述问题而导致的任何损失或损害承担责任。</p><p><br/></p><p>4、用户理解并同意，因用户违反本协议或相关服务条款的规定，导致或产生第三方主张的任何索赔、要求或损失，用户应当独立承担责任；多多芒盒因此遭受损失的，用户也应当一并赔偿。</p><p><br/></p><p>5、用户理解并同意，多多芒盒平台同大多数互联网平台一样，可能会受多种因素影响，包括但不限于用户原因网络服务质量、社会环境等；也可能会受各种安全问题的侵扰；包括但不限于他人非法利用用户资料，进行现实中的骚扰用户下载安装的其他平台或访问的其他网站中可能含有病毒、木马程序或其他恶意程序，威胁用户的终端设备信息和数据安全，继而影响本平台的正常使用等。因此，用户应加强信息安全及个人信息的保护意识，注意密码保护，以免遭受损失。</p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>',NULL,1688556176),(8,'积分奖励说明','邀请好友开盒奖励说明','<p>在本活动界面邀请好友下单即可获得积分，积分可用于开启红包。<br/></p>',NULL,1685025382),(9,'幸运盲盒规则','幸运盲盒规则','幸运盲盒规则',NULL,NULL),(10,'积分奖励说明','幸运盲盒积分奖励说明','<p>用户可使用本平台活动日赠送的兑换码免费兑换活动盲盒开启<br/></p>',NULL,1685788522),(11,'活动规则','开红包说明','活动规则',NULL,1673377261),(12,'申请协议','开红包说明','<p style=\"text-align: left;\">全国范围招募地区合作代理人。</p><p style=\"text-align: left;\">能吃苦，有团队，可地推的，并且保证可以如实推广，不得做出虚假、夸大等不切合实际的宣传</p>',NULL,1686180530);
/*!40000 ALTER TABLE `la_sys_rule` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_sys_rule` with 12 row(s)
--

--
-- Table structure for table `la_test`
--

DROP TABLE IF EXISTS `la_test`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_test` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_test`
--

LOCK TABLES `la_test` WRITE;
/*!40000 ALTER TABLE `la_test` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_test` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_test` with 0 row(s)
--

--
-- Table structure for table `la_user_recharge_log`
--

DROP TABLE IF EXISTS `la_user_recharge_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_user_recharge_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `out_trade_no` varchar(255) NOT NULL COMMENT '平台订单号',
  `transaction_id` varchar(255) DEFAULT NULL COMMENT '微信支付平台订单号',
  `pay_money` decimal(10,2) NOT NULL COMMENT '支付金额',
  `get_money` decimal(10,2) NOT NULL COMMENT '获得余额',
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '支付状态0:待支付1:支付完成',
  `pay_time` int(10) DEFAULT NULL,
  `created_at` int(10) NOT NULL COMMENT '创建时间',
  `updated_at` int(10) NOT NULL COMMENT '更新时间',
  `deleted_at` int(10) NOT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`),
  KEY `用户ID` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COMMENT='用户充值记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_user_recharge_log`
--

LOCK TABLES `la_user_recharge_log` WRITE;
/*!40000 ALTER TABLE `la_user_recharge_log` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_user_recharge_log` VALUES (1,48,'C802580713110542',NULL,450.00,500.00,0,NULL,1690958071,1690958071,0),(2,48,'C802581061406336',NULL,450.00,500.00,0,NULL,1690958106,1690958106,0),(3,48,'C802581270643523',NULL,450.00,500.00,0,NULL,1690958127,1690958127,0),(4,49,'C802588497432865',NULL,10.00,10.00,0,NULL,1690958849,1691038181,0),(5,49,'C802588521782121',NULL,10.00,10.00,0,NULL,1690958852,1691038181,0),(6,49,'C802588552258139',NULL,30.00,30.00,0,NULL,1690958855,1691038181,0),(7,48,'C802752125198774',NULL,450.00,500.00,0,NULL,1690975212,1690975212,0),(8,48,'C802752147524847',NULL,450.00,500.00,0,NULL,1690975214,1690975214,0),(9,48,'C802752170591188',NULL,450.00,500.00,0,NULL,1690975217,1690975217,0),(10,48,'C803429703559637',NULL,450.00,500.00,0,NULL,1691042970,1691042970,0);
/*!40000 ALTER TABLE `la_user_recharge_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_user_recharge_log` with 10 row(s)
--

--
-- Table structure for table `la_users`
--

DROP TABLE IF EXISTS `la_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mobile` varchar(11) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '手机号',
  `nickName` varchar(191) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '昵称',
  `avatar` varchar(191) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '头像',
  `openid` varchar(191) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'openid',
  `level` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '等级',
  `invite_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1正常，2禁用',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `openid` (`openid`) USING BTREE,
  UNIQUE KEY `invite_code` (`invite_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users`
--

LOCK TABLES `la_users` WRITE;
/*!40000 ALTER TABLE `la_users` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_users` VALUES (1,'','再见','/uploads/upload/index/2023/06/08/9b20c25c78fcbdfcce7c73f83862b14c.jpg','onJ-z5DApxwVoMokbihU-S-VcmSs',3,'5QKQS2SS',2,1686207916,1688546978),(2,'','黄七七没有腹肌','/uploads/upload/index/2023/07/05/cd0a6ba12dd93c9b7c1378a4e6c5124e.jpg','okvzp4lMtowF7tO8ybydBS0_b52Y',3,'QQRBJQ6M',1,1688546816,1690981940),(3,'','默认微信用户','/uploads/other/avatar3.png','okvzp4vsOzEfoIWHCySftwM2BD-E',3,'8H7RH0JN',1,1688555091,1688557022),(4,'','一颗','/uploads/upload/index/2023/07/05/1e4232388be6fa01dc0b8f6c603cce65.jpg','okvzp4o8I8ZtJkNG1XMKHU9qRtzE',2,'6NA81APN',1,1688570500,1688570500),(5,'17368380758','默认微信用户','/uploads/other/avatar3.png','okvzp4njbNZ-upuD7qULn3BOAvaE',2,'6UL9E3VM',1,1688645103,1688645110),(6,'','默认微信用户','/uploads/other/avatar3.png','okvzp4p6j8VGdGuePE3SaY8qZ2qY',2,'LKDDN4P5',1,1688710466,1688710466),(7,'','默认微信用户','/uploads/other/avatar3.png','okvzp4g-3H67aHhnzkzL1AH8pn-s',2,'F9KQ1FV3',1,1688711048,1688711048),(8,'','默认微信用户','/uploads/other/avatar3.png','okvzp4uNsHrPhdugxWbyu8MCeXtk',2,'QK9PDGHU',1,1688711887,1688711887),(9,'','DYVPBI','/uploads/upload/index/2023/07/07/b07d7df4d8b066256f4c28b72e63c0c8.jpg','okvzp4k_DDXCT25xImOgz86JGvww',2,'C8PC2I7E',1,1688712378,1688712378),(10,'','默认微信用户','/uploads/other/avatar3.png','okvzp4tCtzqZ06JDyJdSBzP0YfTA',2,'3LGO63RU',1,1688717089,1688717089),(11,'','默认微信用户','/uploads/other/avatar3.png','okvzp4sTbc-vl3JzXl9Ojt8X2gAg',2,'23U72CF8',1,1688722449,1688722449),(12,'','默认微信用户','/uploads/other/avatar3.png','okvzp4kfRSIqP6G2BeDwukq7wXCc',2,'CQ3OK258',1,1688722615,1688722615),(13,'','默认微信用户','/uploads/other/avatar3.png','okvzp4iosj_wwydunkdWaTW6cUPY',2,'9HTO9RMI',1,1688723428,1688723428),(14,'','默认微信用户','/uploads/other/avatar3.png','okvzp4uHJfqz3YgrYxXqmJH3_ywg',2,'GKJHS9U4',1,1688723443,1688723443),(15,'','BB','/uploads/other/avatar3.png','okvzp4vEcWtpDFmuEUa1_qWIjSSo',2,'B0L7I31L',1,1688723499,1688723499),(16,'','默认微信用户','/uploads/other/avatar3.png','okvzp4iIUQwL5EBFcunmcvDkS1tk',2,'02608NFH',1,1688723671,1688723671),(17,'','默认微信用户','/uploads/other/avatar3.png','okvzp4t-hf68LrxTK-K0Z435vi4M',2,'DHAQATID',1,1688725835,1688725835),(18,'','默认微信用户','/uploads/other/avatar3.png','okvzp4pYNoPd9xcYNLEhlH6-5VRo',2,'BLI5S2QR',1,1688726049,1688726049),(19,'19167836966','默认微信用户','/uploads/other/avatar3.png','okvzp4vX9kMhEMjFrm8KHnaQ1yjA',2,'6GUE8J5P',1,1688728318,1688732952),(20,'','默认微信用户','/uploads/other/avatar3.png','okvzp4tVwl_widdxuOVWDNp8ej0I',2,'U1PLKLIQ',1,1688728833,1688728833),(21,'','默认微信用户','/uploads/other/avatar3.png','okvzp4ofBYHOThP5BYlvNxRvTiqg',2,'QT29PN0R',1,1688731075,1688731075),(22,'','默认微信用户','/uploads/other/avatar3.png','okvzp4udrcgNk21WvCTfeyT7aJrA',2,'BIN9P0FD',1,1688731824,1688731824),(23,'','默认微信用户','/uploads/other/avatar3.png','okvzp4r-qWZFH1nN-bgM-ueJjL2U',2,'QIKPLAO4',1,1688736201,1688736201),(24,'','默认微信用户','/uploads/other/avatar3.png','okvzp4sr-82Nu2H3saSowqcxM8EY',2,'ME1ENOGB',1,1688739435,1688739435),(25,'','默认微信用户','/uploads/other/avatar3.png','okvzp4vFYeYU-wYxkFhf2O_R9Qsw',2,'K61T4E2E',1,1688742490,1688742490),(26,'','默认微信用户','/uploads/other/avatar3.png','okvzp4liYQ7Kk2odkMJgeOx239S8',2,'900TAKKP',1,1688742608,1688742608),(27,'','默认微信用户','/uploads/other/avatar3.png','okvzp4iQ8me2rXU92kjcJZMwiVnY',2,'TM95AU2K',1,1688783331,1688783331),(28,'18607672784','杨瑞鑫','/uploads/other/avatar3.png','okvzp4pEbikxBGC3fn6MSxJiPoD4',2,'CH19139L',1,1688795425,1688795445),(29,'','默认微信用户','/uploads/other/avatar3.png','okvzp4nIJRE0u8cR0Q5wHhRkuWX4',2,'JS7P0J19',1,1688802677,1688802677),(30,'','默认微信用户','/uploads/other/avatar3.png','okvzp4kUMNJEoMAvwvvjXr-3O7A4',2,'PKNMM9PH',1,1688802758,1688802758),(31,'','默认微信用户','/uploads/other/avatar3.png','okvzp4tLY8rqJ6mAU5ZjWxK-Vhi8',2,'M17OJV2O',1,1688822223,1688822223),(32,'','HM','/uploads/other/avatar3.png','okvzp4kSTtIGDWRSK59dL2ptvPpo',2,'QUMMT6SU',1,1688857617,1688857617),(33,'','默认微信用户','/uploads/other/avatar3.png','okvzp4voZffC8MDh568F3PieFpvQ',2,'J86D042F',1,1688878372,1688878372),(34,'','默认微信用户','/uploads/other/avatar3.png','okvzp4jjN3zl6kC-8oNT4LauW794',2,'7I039BSM',1,1688880872,1688880872),(35,'','默认微信用户','/uploads/other/avatar3.png','okvzp4hGZxcyIWT8S-W4RPrYOsz0',2,'APJPDPGF',1,1688896125,1688896125),(36,'','太乙','/uploads/upload/index/2023/07/09/4a51455dee430d0585a08f06b9dd71cd.jpg','okvzp4s-J1ab-ySBitFBzlEZS7h4',2,'T7PSFQ1N',1,1688903450,1688903450),(37,'','默认微信用户','/uploads/other/avatar3.png','okvzp4gQLC5TqvFhTkogZqRL1eQM',2,'V97UC728',1,1688949945,1688949945),(38,'','默认微信用户','/uploads/other/avatar3.png','okvzp4qQUQAIdVoRKp0Z1mjvamC4',2,'K3PLS9LG',1,1688969957,1688969957),(39,'','默认微信用户','/uploads/other/avatar3.png','okvzp4qFQG_L2o05XlTwjyWBfYEI',2,'S0JI20RE',1,1688970001,1688970001),(40,'','从小就很帅了','/uploads/upload/index/2023/07/10/06b2b5090f23f0736b673eed34d85775.jpg','okvzp4uES0PPzF0NY_Qz2YW8zrOQ',2,'NA7O3VJV',1,1688973133,1688973133),(41,'','默认微信用户','/uploads/other/avatar3.png','okvzp4hradnuGbnph_0sVqfiVSSg',2,'8PE18BC5',1,1688973302,1688973302),(42,'','默认微信用户','/uploads/other/avatar3.png','okvzp4kppbU8YbqF_9OnASufFxFQ',2,'FTNEJQN4',1,1688977716,1688977716),(43,'15089402489','默认微信用户','/uploads/other/avatar3.png','okvzp4p-LZIbdQgLFOdY07mLul6I',2,'80I95JPK',1,1689016116,1689016127),(44,'19509256244','默认微信用户','/uploads/other/avatar3.png','okvzp4vbtE2aoJPLz8-ehcrvrChA',2,'149SD9AD',1,1689016263,1689016271),(45,'','势不可挡','/uploads/other/avatar3.png','okvzp4ppPmfP_C4UztcoWoTQ5HN0',2,'L0QD9SMI',1,1689046412,1689046412),(46,'','默认微信用户','/uploads/other/avatar3.png','okvzp4t1rg75qv1L8m1DD79QYbRs',2,'L9RP1S57',1,1689068745,1689068745),(47,'','默认微信用户','/uploads/other/avatar3.png','okvzp4mUIPJfdw7G53xGTdrNjXL4',2,'4DSELHBP',1,1689180647,1689180647),(48,'19568818675','D','/uploads/upload/index/2023/08/02/523eb7427323bb45834eef48b3b56fe5.jpg','oTS2E65BABlg5NONg_BRLQb-n_QY',2,'F0DDJ7NJ',1,1690918342,1690918356),(49,'15101137201','黄七七没有腹肌','/uploads/upload/index/2023/08/02/f5d45661a88cd60b57ac582398c3a5d2.jpg','oTS2E61Hq8JVyYb5V2Vb-874TKkI',2,'VJRBOK5U',1,1690919643,1691038181),(50,'','默认微信用户','/uploads/other/avatar3.png','oTS2E66h6TPrVi32OL4VKgZ-LNjs',2,'JCGC4O2N',1,1691034999,1691038181),(51,'','默认微信用户','/uploads/upload/index/2023/08/03/c05ac42f76afbf650e2bc27076331da7.jpg','oTS2E698IKteZtI5KoBNHNuw5bpU',2,'FEFK22IT',1,1691040187,1691040187),(52,'','默认微信用户','/uploads/other/avatar3.png','oTS2E61o2oCbBdNa1mnW9Ioh-r64',2,'CSATSJU1',1,1691048141,1691048141),(53,'','默认微信用户','/uploads/other/avatar3.png','oTS2E6yxOFH832oK76hVxM8JAK8U',2,'646M1IRI',1,1691049976,1691049976),(54,'','默认微信用户可','/uploads/other/avatar3.png','oTS2E6-mfLtWaxgAduRaneH7WFoc',2,'44VN51QJ',1,1691063212,1691063212);
/*!40000 ALTER TABLE `la_users` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users` with 54 row(s)
--

--
-- Table structure for table `la_users_address`
--

DROP TABLE IF EXISTS `la_users_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT '用户id',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '姓名',
  `mobile` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号',
  `province` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '省',
  `city` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '市',
  `area` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '区',
  `site` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '详细地址',
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '全部地址',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否默认',
  `created_at` int(10) NOT NULL COMMENT '添加时间',
  `updated_at` int(10) NOT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户 - 收货地址';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_address`
--

LOCK TABLES `la_users_address` WRITE;
/*!40000 ALTER TABLE `la_users_address` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_users_address` VALUES (1,49,'12','15121212121','北京市','北京城区','东城区','12','北京市北京城区东城区12',1,1688569068,1691038181),(2,48,'12345','19568818675','湖南省','娄底市','冷水江市','金竹西路万盛广场','湖南省娄底市冷水江市金竹西路万盛广场',1,1690958591,1690958591);
/*!40000 ALTER TABLE `la_users_address` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_address` with 2 row(s)
--

--
-- Table structure for table `la_users_bind_log`
--

DROP TABLE IF EXISTS `la_users_bind_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_bind_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户 - 绑定记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_bind_log`
--

LOCK TABLES `la_users_bind_log` WRITE;
/*!40000 ALTER TABLE `la_users_bind_log` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_users_bind_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_bind_log` with 0 row(s)
--

--
-- Table structure for table `la_users_coin_log`
--

DROP TABLE IF EXISTS `la_users_coin_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_coin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `before` decimal(15,0) unsigned NOT NULL COMMENT '改变之前的余额',
  `change` varchar(191) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '改变的余额',
  `after` decimal(15,0) unsigned NOT NULL COMMENT '改变之后的价格',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '更改类型',
  `desc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `remark` varchar(191) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '备注',
  `created_at` int(10) unsigned NOT NULL,
  `updated_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户 - 金币/积分记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_coin_log`
--

LOCK TABLES `la_users_coin_log` WRITE;
/*!40000 ALTER TABLE `la_users_coin_log` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_users_coin_log` VALUES (1,NULL,49,0,'+12122.00',12122,1,'后台添加','',1690999237,1691038181);
/*!40000 ALTER TABLE `la_users_coin_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_coin_log` with 1 row(s)
--

--
-- Table structure for table `la_users_daili`
--

DROP TABLE IF EXISTS `la_users_daili`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_daili` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `superior` varchar(255) DEFAULT NULL COMMENT '邀请人',
  `name` varchar(255) NOT NULL COMMENT '姓名',
  `mobile` varchar(255) NOT NULL COMMENT '手机号',
  `status` int(1) NOT NULL COMMENT '状态',
  `created_at` int(10) DEFAULT NULL,
  `updated_at` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='推广员申请表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_daili`
--

LOCK TABLES `la_users_daili` WRITE;
/*!40000 ALTER TABLE `la_users_daili` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_users_daili` VALUES (1,1,'测试','测试','15163222859',1,1686208183,1686208198),(2,3,'1','2','1',1,1688557004,1688557022),(3,2,'g','y','5',1,1688567254,1688567268),(4,39,'','ghjjjjj','17765650572',0,1688970040,1688970040);
/*!40000 ALTER TABLE `la_users_daili` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_daili` with 4 row(s)
--

--
-- Table structure for table `la_users_friend_open_log`
--

DROP TABLE IF EXISTS `la_users_friend_open_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_friend_open_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `friend_id` int(10) unsigned NOT NULL DEFAULT '0',
  `box_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) NOT NULL DEFAULT '',
  `thumb` varchar(191) NOT NULL DEFAULT '',
  `get_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `get_coin` decimal(10,0) unsigned NOT NULL DEFAULT '0',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  `deleted_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `friend_id` (`friend_id`) USING BTREE,
  KEY `box_id` (`box_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户 - 好友开盒记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_friend_open_log`
--

LOCK TABLES `la_users_friend_open_log` WRITE;
/*!40000 ALTER TABLE `la_users_friend_open_log` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_users_friend_open_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_friend_open_log` with 0 row(s)
--

--
-- Table structure for table `la_users_gold_log`
--

DROP TABLE IF EXISTS `la_users_gold_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_gold_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `before` decimal(15,2) unsigned NOT NULL COMMENT '改变之前的余额',
  `change` varchar(191) NOT NULL DEFAULT '' COMMENT '改变的余额',
  `after` decimal(15,2) unsigned NOT NULL COMMENT '改变之后的价格',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '更改类型',
  `desc` varchar(191) DEFAULT '',
  `remark` varchar(191) DEFAULT '' COMMENT '备注',
  `created_at` int(10) unsigned NOT NULL,
  `updated_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户 - 购物金记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_gold_log`
--

LOCK TABLES `la_users_gold_log` WRITE;
/*!40000 ALTER TABLE `la_users_gold_log` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_users_gold_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_gold_log` with 0 row(s)
--

--
-- Table structure for table `la_users_info`
--

DROP TABLE IF EXISTS `la_users_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `coin` decimal(15,0) unsigned DEFAULT '0' COMMENT '积分',
  `money` decimal(15,2) unsigned DEFAULT '0.00' COMMENT '余额',
  `gold` decimal(15,2) unsigned DEFAULT '0.00' COMMENT '佣金',
  `luckbox_progress` int(10) unsigned DEFAULT '0' COMMENT '幸运盲盒隐藏进度',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户 - 附表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_info`
--

LOCK TABLES `la_users_info` WRITE;
/*!40000 ALTER TABLE `la_users_info` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_users_info` VALUES (1,1,0,0.00,0.00,0),(2,49,12122,9976.74,0.00,0),(3,3,0,17340.20,0.00,0),(4,4,0,0.00,0.00,0),(5,5,0,0.00,0.00,0),(6,6,0,0.00,0.00,0),(7,7,0,0.00,0.00,0),(8,8,0,0.00,0.00,0),(9,9,0,0.00,0.00,0),(10,10,0,0.00,0.00,0),(11,11,0,0.00,0.00,0),(12,12,0,0.00,0.00,0),(13,13,0,0.00,0.00,0),(14,14,0,0.00,0.00,0),(15,15,0,0.00,0.00,0),(16,16,0,0.00,0.00,0),(17,17,0,0.00,0.00,0),(18,18,0,0.00,0.00,0),(19,19,0,0.00,0.00,0),(20,20,0,0.00,0.00,0),(21,21,0,0.00,0.00,0),(22,22,0,0.00,0.00,0),(23,23,0,0.00,0.00,0),(24,24,0,0.00,0.00,0),(25,25,0,0.00,0.00,0),(26,26,0,0.00,0.00,0),(27,27,0,0.00,0.00,0),(28,28,0,0.00,0.00,0),(29,29,0,0.00,0.00,0),(30,30,0,0.00,0.00,0),(31,31,0,0.00,0.00,0),(32,32,0,0.00,0.00,0),(33,33,0,0.00,0.00,0),(34,34,0,0.00,0.00,0),(35,35,0,0.00,0.00,0),(36,36,0,0.00,0.00,0),(37,37,0,0.00,0.00,0),(38,38,0,0.00,0.00,0),(39,39,0,0.00,0.00,0),(40,40,0,0.00,0.00,0),(41,41,0,0.00,0.00,0),(42,42,0,0.00,0.00,0),(43,43,0,0.00,0.00,0),(44,44,0,0.00,0.00,0),(45,45,0,0.00,0.00,0),(46,46,0,0.00,0.00,0),(47,47,0,0.00,0.00,0),(48,48,0,9508.66,0.00,0),(51,51,0,0.00,0.00,0),(52,52,0,0.00,0.00,0),(53,53,0,0.00,0.00,0),(54,54,0,489.44,0.00,0);
/*!40000 ALTER TABLE `la_users_info` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_info` with 52 row(s)
--

--
-- Table structure for table `la_users_money_log`
--

DROP TABLE IF EXISTS `la_users_money_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_money_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `before` decimal(15,2) unsigned NOT NULL COMMENT '改变之前的余额',
  `change` varchar(191) NOT NULL DEFAULT '' COMMENT '改变的余额',
  `after` decimal(15,2) unsigned NOT NULL COMMENT '改变之后的价格',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '更改类型',
  `desc` varchar(191) DEFAULT '',
  `remark` varchar(191) DEFAULT '' COMMENT '备注',
  `created_at` int(10) unsigned NOT NULL,
  `updated_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=412 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户 - 余额记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_money_log`
--

LOCK TABLES `la_users_money_log` WRITE;
/*!40000 ALTER TABLE `la_users_money_log` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_users_money_log` VALUES (1,NULL,49,0.00,'+500.00',500.00,1,'后台添加','',1688546965,1691038181),(2,NULL,49,500.00,'-49.50',450.50,3,'购买抵扣','',1688546989,1691038181),(3,NULL,49,450.50,'+43.32',493.82,11,'商品退货','',1688547003,1691038181),(4,NULL,49,493.82,'-9.90',483.92,3,'购买抵扣','',1688547017,1691038181),(5,NULL,49,483.92,'+3.98',487.90,11,'商品退货','',1688547036,1691038181),(6,NULL,49,487.90,'-9.90',478.00,3,'购买抵扣','',1688547267,1691038181),(7,NULL,49,478.00,'-49.50',428.50,3,'购买抵扣','',1688547277,1691038181),(8,NULL,49,428.50,'-49.50',379.00,3,'购买抵扣','',1688547299,1691038181),(9,NULL,49,379.00,'-83.30',295.70,3,'购买抵扣','',1688547608,1691038181),(10,NULL,49,295.70,'-16.66',279.04,3,'购买抵扣','',1688548011,1691038181),(12,NULL,49,279.04,'-83.30',195.74,3,'购买抵扣','',1688552359,1691038181),(13,NULL,49,195.74,'-83.30',112.44,3,'购买抵扣','',1688552370,1691038181),(14,NULL,49,112.44,'-83.30',29.14,3,'购买抵扣','',1688552466,1691038181),(15,NULL,49,29.14,'-29.14',0.00,3,'购买抵扣','',1688552475,1691038181),(16,NULL,49,0.00,'+29.14',29.14,4,'购买失败退回','',1688552476,1691038181),(17,NULL,49,29.14,'+2000.00',2029.14,1,'后台添加','',1688552493,1691038181),(18,NULL,49,2029.14,'-83.30',1945.84,3,'购买抵扣','',1688552504,1691038181),(20,NULL,49,1945.84,'-83.30',1862.54,3,'购买抵扣','',1688552513,1691038181),(21,NULL,49,1862.54,'-83.30',1779.24,3,'购买抵扣','',1688552531,1691038181),(22,NULL,49,1779.24,'-83.30',1695.94,3,'购买抵扣','',1688552544,1691038181),(23,NULL,49,1695.94,'-83.30',1612.64,3,'购买抵扣','',1688552567,1691038181),(24,NULL,49,1612.64,'-83.30',1529.34,3,'购买抵扣','',1688552576,1691038181),(26,NULL,49,1529.34,'-83.30',1446.04,3,'购买抵扣','',1688554861,1691038181),(27,NULL,3,0.00,'+20000.00',20000.00,1,'后台添加','',1688555116,1688555116),(28,NULL,49,1446.04,'+7.80',1453.84,11,'商品退货','',1688555117,1691038181),(29,NULL,49,1453.84,'+3.80',1457.64,11,'商品退货','',1688555121,1691038181),(31,NULL,3,20000.00,'-83.30',19916.70,3,'购买抵扣','',1688555147,1688555147),(32,NULL,49,1457.64,'-83.30',1374.34,3,'购买抵扣','',1688555149,1691038181),(33,NULL,3,19916.70,'+19.34',19936.04,11,'商品退货','',1688555155,1688555155),(34,NULL,49,1374.34,'+33.36',1407.70,11,'商品退货','',1688555156,1691038181),(35,NULL,49,1407.70,'-83.30',1324.40,3,'购买抵扣','',1688555161,1691038181),(36,NULL,3,19936.04,'-83.30',19852.74,3,'购买抵扣','',1688555164,1688555164),(37,NULL,49,1324.40,'+17.80',1342.20,11,'商品退货','',1688555176,1691038181),(38,NULL,49,1342.20,'+3.80',1346.00,11,'商品退货','',1688555190,1691038181),(39,NULL,49,1346.00,'+11.76',1357.76,11,'商品退货','',1688555191,1691038181),(40,NULL,3,19852.74,'+32.40',19885.14,11,'商品退货','',1688555196,1688555196),(41,NULL,3,19885.14,'-83.30',19801.84,3,'购买抵扣','',1688555200,1688555200),(42,NULL,3,19801.84,'+36.38',19838.22,11,'商品退货','',1688555208,1688555208),(43,NULL,3,19838.22,'-83.30',19754.92,3,'购买抵扣','',1688555217,1688555217),(44,NULL,3,19754.92,'-83.30',19671.62,3,'购买抵扣','',1688556755,1688556755),(45,NULL,49,1357.76,'-83.30',1274.46,3,'购买抵扣','',1688556761,1691038181),(46,NULL,3,19671.62,'-83.30',19588.32,3,'购买抵扣','',1688556763,1688556763),(47,NULL,3,19588.32,'-83.30',19505.02,3,'购买抵扣','',1688556779,1688556779),(48,NULL,49,1274.46,'+29.96',1304.42,11,'商品退货','',1688556785,1691038181),(49,NULL,49,1304.42,'-83.30',1221.12,3,'购买抵扣','',1688556789,1691038181),(51,NULL,3,19505.02,'-83.30',19421.72,3,'购买抵扣','',1688556798,1688556798),(52,NULL,49,1221.12,'-83.30',1137.82,3,'购买抵扣','',1688556806,1691038181),(53,NULL,3,19421.72,'+20.96',19442.68,11,'商品退货','',1688556876,1688556876),(54,NULL,3,19442.68,'-83.30',19359.38,3,'购买抵扣','',1688556882,1688556882),(55,NULL,3,19359.38,'-83.30',19276.08,3,'购买抵扣','',1688556893,1688556893),(56,NULL,3,19276.08,'-83.30',19192.78,3,'购买抵扣','',1688556901,1688556901),(57,NULL,49,1137.82,'-83.30',1054.52,3,'购买抵扣','',1688556926,1691038181),(58,NULL,49,1054.52,'-83.30',971.22,3,'购买抵扣','',1688556988,1691038181),(59,NULL,49,971.22,'+20.98',992.20,11,'商品退货','',1688556994,1691038181),(60,NULL,49,992.20,'-83.30',908.90,3,'购买抵扣','',1688556997,1691038181),(61,NULL,49,908.90,'-83.30',825.60,3,'购买抵扣','',1688557017,1691038181),(63,NULL,49,825.60,'-83.30',742.30,3,'购买抵扣','',1688557027,1691038181),(64,NULL,49,742.30,'+30.14',772.44,11,'商品退货','',1688557035,1691038181),(65,NULL,49,772.44,'-83.30',689.14,3,'购买抵扣','',1688557038,1691038181),(67,NULL,49,689.14,'-83.30',605.84,3,'购买抵扣','',1688557098,1691038181),(68,NULL,49,605.84,'-16.66',589.18,3,'购买抵扣','',1688557200,1691038181),(69,NULL,49,589.18,'-16.66',572.52,3,'购买抵扣','',1688557213,1691038181),(70,NULL,49,572.52,'-83.30',489.22,3,'购买抵扣','',1688557858,1691038181),(71,NULL,49,489.22,'+21.54',510.76,11,'商品退货','',1688557873,1691038181),(72,NULL,49,510.76,'-83.30',427.46,3,'购买抵扣','',1688558184,1691038181),(73,NULL,49,427.46,'-83.30',344.16,3,'购买抵扣','',1688558202,1691038181),(74,NULL,49,344.16,'-83.30',260.86,3,'购买抵扣','',1688558236,1691038181),(75,NULL,49,260.86,'-83.30',177.56,3,'购买抵扣','',1688558295,1691038181),(76,NULL,49,177.56,'-83.30',94.26,3,'购买抵扣','',1688558314,1691038181),(77,NULL,49,94.26,'-83.30',10.96,3,'购买抵扣','',1688558341,1691038181),(78,NULL,49,10.96,'-10.96',0.00,3,'购买抵扣','',1688558363,1691038181),(79,NULL,49,0.00,'+10.96',10.96,4,'购买失败退回','',1688558364,1691038181),(80,NULL,49,10.96,'+3.98',14.94,11,'商品退货','',1688558779,1691038181),(81,NULL,49,14.94,'+3.98',18.92,11,'商品退货','',1688558780,1691038181),(82,NULL,49,18.92,'+19.20',38.12,11,'商品退货','',1688558782,1691038181),(83,NULL,49,38.12,'+3.80',41.92,11,'商品退货','',1688558783,1691038181),(84,NULL,49,41.92,'+3.60',45.52,11,'商品退货','',1688558784,1691038181),(85,NULL,49,45.52,'+7.80',53.32,11,'商品退货','',1688558785,1691038181),(86,NULL,49,53.32,'+3.98',57.30,11,'商品退货','',1688558794,1691038181),(87,NULL,49,57.30,'+3.98',61.28,11,'商品退货','',1688558798,1691038181),(88,NULL,49,61.28,'+3.98',65.26,11,'商品退货','',1688558800,1691038181),(89,NULL,49,65.26,'+3.60',68.86,11,'商品退货','',1688558803,1691038181),(90,NULL,49,68.86,'+3.80',72.66,11,'商品退货','',1688558805,1691038181),(91,NULL,49,72.66,'+3.60',76.26,11,'商品退货','',1688558808,1691038181),(92,NULL,49,76.26,'+3.98',80.24,11,'商品退货','',1688558810,1691038181),(93,NULL,49,80.24,'+17.80',98.04,11,'商品退货','',1688558819,1691038181),(94,NULL,49,98.04,'+3.98',102.02,11,'商品退货','',1688558820,1691038181),(95,NULL,49,102.02,'+3.80',105.82,11,'商品退货','',1688558821,1691038181),(96,NULL,49,105.82,'+3.98',109.80,11,'商品退货','',1688558823,1691038181),(97,NULL,49,109.80,'+3.60',113.40,11,'商品退货','',1688558826,1691038181),(98,NULL,49,113.40,'+3.80',117.20,11,'商品退货','',1688558828,1691038181),(99,NULL,49,117.20,'+3.98',121.18,11,'商品退货','',1688558834,1691038181),(100,NULL,49,121.18,'+3.60',124.78,11,'商品退货','',1688558837,1691038181),(101,NULL,49,124.78,'+3.98',128.76,11,'商品退货','',1688558840,1691038181),(102,NULL,49,128.76,'+13.80',142.56,11,'商品退货','',1688558842,1691038181),(103,NULL,49,142.56,'-83.30',59.26,3,'购买抵扣','',1688558856,1691038181),(104,NULL,49,59.26,'-59.26',0.00,3,'购买抵扣','',1688558874,1691038181),(105,NULL,49,0.00,'+59.26',59.26,4,'购买失败退回','',1688558875,1691038181),(106,NULL,49,59.26,'+3.98',63.24,11,'商品退货','',1688558881,1691038181),(107,NULL,49,63.24,'+7.80',71.04,11,'商品退货','',1688558883,1691038181),(108,NULL,49,71.04,'+14.60',85.64,11,'商品退货','',1688558885,1691038181),(109,NULL,49,85.64,'-83.30',2.34,3,'购买抵扣','',1688558895,1691038181),(110,NULL,3,19192.78,'-83.30',19109.48,3,'购买抵扣','',1688559092,1688559092),(111,NULL,3,19109.48,'+21.00',19130.48,11,'商品退货','',1688559104,1688559104),(113,NULL,3,19130.48,'-83.30',19047.18,3,'购买抵扣','',1688559110,1688559110),(114,NULL,3,19047.18,'-83.30',18963.88,3,'购买抵扣','',1688559118,1688559118),(115,NULL,3,18963.88,'-83.30',18880.58,3,'购买抵扣','',1688559128,1688559128),(116,NULL,3,18880.58,'-83.30',18797.28,3,'购买抵扣','',1688559136,1688559136),(117,NULL,3,18797.28,'-83.30',18713.98,3,'购买抵扣','',1688559143,1688559143),(118,NULL,3,18713.98,'+19.54',18733.52,11,'商品退货','',1688559417,1688559417),(119,NULL,3,18733.52,'-83.30',18650.22,3,'购买抵扣','',1688559421,1688559421),(120,NULL,3,18650.22,'-83.30',18566.92,3,'购买抵扣','',1688559443,1688559443),(121,NULL,49,2.34,'-2.34',0.00,3,'购买抵扣','',1688562414,1691038181),(122,NULL,49,0.00,'+2.34',2.34,4,'购买失败退回','',1688562415,1691038181),(123,NULL,49,2.34,'-2.34',0.00,3,'购买抵扣','',1688566686,1691038181),(124,NULL,49,0.00,'+2.34',2.34,4,'购买失败退回','',1688566686,1691038181),(125,NULL,49,2.34,'-2.34',0.00,3,'购买抵扣','',1688566689,1691038181),(126,NULL,49,0.00,'+2.34',2.34,4,'购买失败退回','',1688566690,1691038181),(127,NULL,49,2.34,'-2.34',0.00,3,'购买抵扣','',1688566694,1691038181),(128,NULL,49,0.00,'+2.34',2.34,4,'购买失败退回','',1688566695,1691038181),(129,NULL,49,2.34,'-2.34',0.00,3,'购买抵扣','',1688566877,1691038181),(130,NULL,49,0.00,'+2.34',2.34,4,'购买失败退回','',1688566878,1691038181),(131,NULL,49,2.34,'-2.34',0.00,3,'购买抵扣','',1688566883,1691038181),(132,NULL,49,0.00,'+2.34',2.34,4,'购买失败退回','',1688566884,1691038181),(133,NULL,49,2.34,'-2.34',0.00,3,'购买抵扣','',1688567116,1691038181),(134,NULL,49,0.00,'+2.34',2.34,4,'购买失败退回','',1688567124,1691038181),(135,NULL,49,2.34,'+17.80',20.14,11,'商品退货','',1688568873,1691038181),(136,NULL,49,20.14,'+3.98',24.12,11,'商品退货','',1688568875,1691038181),(137,NULL,49,24.12,'+3.98',28.10,11,'商品退货','',1688568878,1691038181),(138,NULL,49,28.10,'+7.80',35.90,11,'商品退货','',1688568880,1691038181),(139,NULL,49,35.90,'-35.90',0.00,3,'购买抵扣','',1688568891,1691038181),(140,NULL,49,0.00,'+35.90',35.90,4,'购买失败退回','',1688568895,1691038181),(141,NULL,49,35.90,'-33.32',2.58,3,'购买抵扣','',1688568898,1691038181),(142,NULL,49,2.58,'+14.60',17.18,11,'商品退货','',1688568903,1691038181),(143,NULL,49,17.18,'+17.80',34.98,11,'商品退货','',1688568905,1691038181),(144,NULL,49,34.98,'+5.80',40.78,11,'商品退货','',1688568919,1691038181),(145,NULL,49,40.78,'+13.80',54.58,11,'商品退货','',1688568920,1691038181),(146,NULL,49,54.58,'+19.20',73.78,11,'商品退货','',1688568922,1691038181),(147,NULL,49,73.78,'+13.80',87.58,11,'商品退货','',1688568923,1691038181),(148,NULL,49,87.58,'+5.80',93.38,11,'商品退货','',1688568924,1691038181),(149,NULL,49,93.38,'-83.30',10.08,3,'购买抵扣','',1688568931,1691038181),(150,NULL,49,10.08,'-10.08',0.00,3,'购买抵扣','',1688568955,1691038181),(151,NULL,49,0.00,'+10.08',10.08,4,'购买失败退回','',1688568959,1691038181),(152,NULL,49,10.08,'+5.80',15.88,11,'商品退货','',1688568983,1691038181),(153,NULL,49,15.88,'+3.80',19.68,11,'商品退货','',1688568992,1691038181),(154,NULL,49,19.68,'-16.66',3.02,3,'购买抵扣','',1688568998,1691038181),(155,NULL,49,3.02,'-3.02',0.00,3,'购买抵扣','',1688569083,1691038181),(156,NULL,49,0.00,'+3.02',3.02,4,'购买失败退回','',1688569087,1691038181),(157,NULL,49,3.02,'+5.80',8.82,11,'商品退货','',1688569092,1691038181),(158,NULL,49,8.82,'+19.20',28.02,11,'商品退货','',1688569094,1691038181),(159,NULL,49,28.02,'+14.60',42.62,11,'商品退货','',1688569097,1691038181),(160,NULL,49,42.62,'+5.80',48.42,11,'商品退货','',1688569099,1691038181),(161,NULL,49,48.42,'+14.60',63.02,11,'商品退货','',1688569100,1691038181),(162,NULL,49,63.02,'+17.80',80.82,11,'商品退货','',1688569102,1691038181),(163,NULL,49,80.82,'+7.80',88.62,11,'商品退货','',1688569104,1691038181),(164,NULL,49,88.62,'+5.80',94.42,11,'商品退货','',1688569107,1691038181),(165,NULL,49,94.42,'+5.80',100.22,11,'商品退货','',1688569109,1691038181),(166,NULL,49,100.22,'+14.60',114.82,11,'商品退货','',1688569112,1691038181),(167,NULL,49,114.82,'-83.30',31.52,3,'购买抵扣','',1688569121,1691038181),(168,NULL,49,31.52,'+17.80',49.32,11,'商品退货','',1688569223,1691038181),(169,NULL,49,49.32,'+13.80',63.12,11,'商品退货','',1688569226,1691038181),(170,NULL,49,63.12,'+14.60',77.72,11,'商品退货','',1688569228,1691038181),(171,NULL,49,77.72,'+14.60',92.32,11,'商品退货','',1688569230,1691038181),(172,NULL,49,92.32,'-83.30',9.02,3,'购买抵扣','',1688569238,1691038181),(173,NULL,49,9.02,'+17.80',26.82,11,'商品退货','',1688569495,1691038181),(174,NULL,49,26.82,'+17.80',44.62,11,'商品退货','',1688569497,1691038181),(175,NULL,49,44.62,'+13.80',58.42,11,'商品退货','',1688569500,1691038181),(176,NULL,49,58.42,'+5.80',64.22,11,'商品退货','',1688569502,1691038181),(177,NULL,49,64.22,'+5.80',70.02,11,'商品退货','',1688569505,1691038181),(178,NULL,49,70.02,'+17.80',87.82,11,'商品退货','',1688569518,1691038181),(179,NULL,49,87.82,'+17.80',105.62,11,'商品退货','',1688569520,1691038181),(180,NULL,49,105.62,'-83.30',22.32,3,'购买抵扣','',1688569528,1691038181),(181,NULL,49,22.32,'+13.80',36.12,11,'商品退货','',1688569542,1691038181),(182,NULL,49,36.12,'-33.32',2.80,3,'购买抵扣','',1688569559,1691038181),(183,NULL,49,2.80,'+7.40',10.20,11,'商品退货','',1688569574,1691038181),(184,NULL,49,10.20,'+1000.00',1010.20,1,'后台添加','',1688569628,1691038181),(185,NULL,49,1010.20,'-83.30',926.90,3,'购买抵扣','',1688569634,1691038181),(186,NULL,49,926.90,'+23.16',950.06,11,'商品退货','',1688569641,1691038181),(187,NULL,49,950.06,'-83.30',866.76,3,'购买抵扣','',1688569645,1691038181),(188,NULL,49,866.76,'+19.54',886.30,11,'商品退货','',1688569652,1691038181),(189,NULL,49,886.30,'-83.30',803.00,3,'购买抵扣','',1688569654,1691038181),(190,NULL,49,803.00,'+33.98',836.98,11,'商品退货','',1688569670,1691038181),(191,NULL,49,836.98,'-83.30',753.68,3,'购买抵扣','',1688569672,1691038181),(192,NULL,49,753.68,'+19.16',772.84,11,'商品退货','',1688569678,1691038181),(193,NULL,49,772.84,'-83.30',689.54,3,'购买抵扣','',1688569689,1691038181),(194,NULL,49,689.54,'+32.96',722.50,11,'商品退货','',1688569694,1691038181),(195,NULL,49,722.50,'-83.30',639.20,3,'购买抵扣','',1688569696,1691038181),(196,NULL,49,639.20,'-83.30',555.90,3,'购买抵扣','',1688569771,1691038181),(197,NULL,49,555.90,'+38.40',594.30,11,'商品退货','',1688569776,1691038181),(198,NULL,49,594.30,'-83.30',511.00,3,'购买抵扣','',1688569778,1691038181),(199,NULL,49,511.00,'+26.98',537.98,11,'商品退货','',1688569783,1691038181),(200,NULL,49,537.98,'-83.30',454.68,3,'购买抵扣','',1688569785,1691038181),(201,NULL,49,454.68,'+33.36',488.04,11,'商品退货','',1688569791,1691038181),(202,NULL,49,488.04,'-83.30',404.74,3,'购买抵扣','',1688569794,1691038181),(203,NULL,49,404.74,'+19.54',424.28,11,'商品退货','',1688569807,1691038181),(204,NULL,49,424.28,'-83.30',340.98,3,'购买抵扣','',1688569810,1691038181),(205,NULL,49,340.98,'+19.36',360.34,11,'商品退货','',1688569814,1691038181),(206,NULL,49,360.34,'-83.30',277.04,3,'购买抵扣','',1688569817,1691038181),(207,NULL,49,277.04,'+18.98',296.02,11,'商品退货','',1688569823,1691038181),(208,NULL,49,296.02,'-83.30',212.72,3,'购买抵扣','',1688569824,1691038181),(209,NULL,49,212.72,'+34.16',246.88,11,'商品退货','',1688569833,1691038181),(210,NULL,49,246.88,'-83.30',163.58,3,'购买抵扣','',1688569835,1691038181),(211,NULL,49,163.58,'+19.34',182.92,11,'商品退货','',1688569840,1691038181),(212,NULL,49,182.92,'-83.30',99.62,3,'购买抵扣','',1688569841,1691038181),(213,NULL,49,99.62,'+34.94',134.56,11,'商品退货','',1688569846,1691038181),(214,NULL,49,134.56,'-83.30',51.26,3,'购买抵扣','',1688569849,1691038181),(215,NULL,49,51.26,'+19.14',70.40,11,'商品退货','',1688569855,1691038181),(216,NULL,49,70.40,'-70.40',0.00,3,'购买抵扣','',1688569856,1691038181),(217,NULL,49,0.00,'+70.40',70.40,4,'购买失败退回','',1688569860,1691038181),(218,NULL,49,70.40,'+3.98',74.38,11,'商品退货','',1688569882,1691038181),(219,NULL,49,74.38,'+3.80',78.18,11,'商品退货','',1688569883,1691038181),(220,NULL,3,18566.92,'-83.30',18483.62,3,'购买抵扣','',1688570673,1688570673),(224,NULL,3,18483.62,'-83.30',18400.32,3,'购买抵扣','',1688570796,1688570796),(225,NULL,3,18400.32,'-83.30',18317.02,3,'购买抵扣','',1688570836,1688570836),(226,NULL,3,18317.02,'+18.98',18336.00,11,'商品退货','',1688570842,1688570842),(227,NULL,3,18336.00,'-83.30',18252.70,3,'购买抵扣','',1688570846,1688570846),(228,NULL,3,18252.70,'-83.30',18169.40,3,'购买抵扣','',1688570853,1688570853),(230,NULL,3,18169.40,'-83.30',18086.10,3,'购买抵扣','',1688570862,1688570862),(231,NULL,3,18086.10,'+3.80',18089.90,11,'商品退货','',1688570872,1688570872),(233,NULL,3,18089.90,'-83.30',18006.60,3,'购买抵扣','',1688570905,1688570905),(234,NULL,3,18006.60,'-83.30',17923.30,3,'购买抵扣','',1688571036,1688571036),(235,NULL,49,78.18,'+17.80',95.98,11,'商品退货','',1688578340,1691038181),(236,NULL,49,95.98,'+14.60',110.58,11,'商品退货','',1688578342,1691038181),(237,NULL,49,110.58,'+5.80',116.38,11,'商品退货','',1688578344,1691038181),(238,NULL,49,116.38,'-83.30',33.08,3,'购买抵扣','',1688578377,1691038181),(239,NULL,49,33.08,'+29.96',63.04,11,'商品退货','',1688578390,1691038181),(240,NULL,49,63.04,'-49.98',13.06,3,'购买抵扣','',1688578396,1691038181),(241,NULL,49,13.06,'+11.94',25.00,11,'商品退货','',1688578408,1691038181),(242,NULL,49,25.00,'+3.98',28.98,11,'商品退货','',1688578478,1691038181),(243,NULL,49,28.98,'+3.98',32.96,11,'商品退货','',1688578481,1691038181),(244,NULL,49,32.96,'+3.80',36.76,11,'商品退货','',1688578484,1691038181),(245,NULL,49,36.76,'-16.66',20.10,3,'购买抵扣','',1688578498,1691038181),(246,NULL,49,20.10,'-16.66',3.44,3,'购买抵扣','',1688578804,1691038181),(247,NULL,49,3.44,'+3.80',7.24,11,'商品退货','',1688580050,1691038181),(248,NULL,49,7.24,'+3.80',11.04,11,'商品退货','',1688580053,1691038181),(249,NULL,49,11.04,'+3.80',14.84,11,'商品退货','',1688580055,1691038181),(250,NULL,49,14.84,'+3.80',18.64,11,'商品退货','',1688580057,1691038181),(251,NULL,49,18.64,'+3.80',22.44,11,'商品退货','',1688580059,1691038181),(252,NULL,49,22.44,'+3.98',26.42,11,'商品退货','',1688580061,1691038181),(253,NULL,49,26.42,'+3.60',30.02,11,'商品退货','',1688580064,1691038181),(254,NULL,49,30.02,'+3.80',33.82,11,'商品退货','',1688580067,1691038181),(255,NULL,49,33.82,'-16.66',17.16,3,'购买抵扣','',1688580092,1691038181),(256,NULL,49,17.16,'+3.98',21.14,11,'商品退货','',1688580104,1691038181),(258,NULL,49,21.14,'-16.66',4.48,3,'购买抵扣','',1688580109,1691038181),(259,NULL,49,4.48,'+3.98',8.46,11,'商品退货','',1688580121,1691038181),(260,NULL,49,8.46,'-8.46',0.00,3,'购买抵扣','',1688580124,1691038181),(261,NULL,49,0.00,'+8.46',8.46,4,'购买失败退回','',1688580128,1691038181),(262,NULL,49,8.46,'+3.98',12.44,11,'商品退货','',1688580461,1691038181),(263,NULL,49,12.44,'+3.98',16.42,11,'商品退货','',1688580463,1691038181),(264,NULL,49,16.42,'+3.98',20.40,11,'商品退货','',1688580465,1691038181),(265,NULL,49,20.40,'-16.66',3.74,3,'购买抵扣','',1688623269,1691038181),(266,NULL,49,3.74,'+3.60',7.34,11,'商品退货','',1688623274,1691038181),(267,NULL,49,7.34,'-7.34',0.00,3,'购买抵扣','',1688661217,1691038181),(268,NULL,49,0.00,'+7.34',7.34,4,'购买失败退回','',1688661223,1691038181),(269,NULL,49,7.34,'+3.80',11.14,11,'商品退货','',1688661230,1691038181),(270,NULL,49,11.14,'+3.98',15.12,11,'商品退货','',1688661231,1691038181),(271,NULL,49,15.12,'+3.98',19.10,11,'商品退货','',1688661232,1691038181),(272,NULL,49,19.10,'+3.80',22.90,11,'商品退货','',1688661234,1691038181),(273,NULL,49,22.90,'+3.80',26.70,11,'商品退货','',1688661236,1691038181),(274,NULL,49,26.70,'-16.66',10.04,3,'购买抵扣','',1688661251,1691038181),(275,NULL,49,10.04,'+3.80',13.84,11,'商品退货','',1688661263,1691038181),(276,NULL,49,13.84,'+3.60',17.44,11,'商品退货','',1688661280,1691038181),(277,NULL,49,17.44,'-16.66',0.78,3,'购买抵扣','',1688661283,1691038181),(278,NULL,49,0.78,'+3.80',4.58,11,'商品退货','',1688710698,1691038181),(279,NULL,49,4.58,'+3.98',8.56,11,'商品退货','',1688710700,1691038181),(280,NULL,49,8.56,'+3.98',12.54,11,'商品退货','',1688710701,1691038181),(281,NULL,49,12.54,'+3.98',16.52,11,'商品退货','',1688710703,1691038181),(282,NULL,49,16.52,'+3.80',20.32,11,'商品退货','',1688710719,1691038181),(283,NULL,49,20.32,'+3.60',23.92,11,'商品退货','',1688710721,1691038181),(284,NULL,49,23.92,'-16.66',7.26,3,'购买抵扣','',1688710727,1691038181),(285,NULL,49,7.26,'-7.26',0.00,3,'购买抵扣','',1688880256,1691038181),(286,NULL,49,0.00,'+7.26',7.26,4,'购买失败退回','',1688880266,1691038181),(287,NULL,49,7.26,'-7.26',0.00,3,'购买抵扣','',1688880307,1691038181),(288,NULL,49,0.00,'+7.26',7.26,4,'购买失败退回','',1688880311,1691038181),(289,NULL,49,7.26,'-7.26',0.00,3,'购买抵扣','',1688880312,1691038181),(290,NULL,49,0.00,'+7.26',7.26,4,'购买失败退回','',1688880315,1691038181),(291,NULL,3,17923.30,'-83.30',17840.00,3,'购买抵扣','',1689003136,1689003136),(292,NULL,3,17840.00,'-83.30',17756.70,3,'购买抵扣','',1689003236,1689003236),(294,NULL,3,17756.70,'-83.30',17673.40,3,'购买抵扣','',1689003342,1689003342),(295,NULL,3,17673.40,'-83.30',17590.10,3,'购买抵扣','',1689004749,1689004749),(296,NULL,3,17590.10,'-83.30',17506.80,3,'购买抵扣','',1689004760,1689004760),(297,NULL,3,17506.80,'-83.30',17423.50,3,'购买抵扣','',1689004771,1689004771),(298,NULL,3,17423.50,'-83.30',17340.20,3,'购买抵扣','',1689004777,1689004777),(299,NULL,49,7.26,'-7.26',0.00,3,'购买抵扣','',1689590011,1691038181),(300,NULL,49,0.00,'+7.26',7.26,4,'购买失败退回','',1689590017,1691038181),(301,NULL,49,7.26,'+11111.00',11118.26,1,'后台添加','',1689590171,1691038181),(302,NULL,49,11118.26,'-16.66',11101.60,3,'购买抵扣','',1689590180,1691038181),(303,NULL,49,11101.60,'+13.80',11115.40,11,'商品退货','',1689590185,1691038181),(304,NULL,49,11115.40,'-16.66',11098.74,3,'购买抵扣','',1689591159,1691038181),(305,NULL,49,11098.74,'-83.30',11015.44,3,'购买抵扣','',1689593529,1691038181),(306,NULL,49,11015.44,'+34.76',11050.20,11,'商品退货','',1689593591,1691038181),(307,NULL,49,11050.20,'-83.30',10966.90,3,'购买抵扣','',1689593602,1691038181),(308,NULL,49,10966.90,'+26.98',10993.88,11,'商品退货','',1689593614,1691038181),(309,NULL,49,10993.88,'+3.80',10997.68,11,'商品退货','',1689599127,1691038181),(310,NULL,49,10997.68,'+3.98',11001.66,11,'商品退货','',1689599129,1691038181),(311,NULL,49,11001.66,'+3.80',11005.46,11,'商品退货','',1689599130,1691038181),(312,NULL,49,11005.46,'-16.66',10988.80,3,'购买抵扣','',1689655146,1691038181),(313,NULL,48,0.00,'+11111.00',11111.00,1,'后台添加','',1690918439,1690918439),(314,NULL,48,11111.00,'-16.66',11094.34,3,'购买抵扣','',1690919279,1690919279),(315,NULL,48,11094.34,'-83.30',11011.04,3,'购买抵扣','',1690953431,1690953431),(316,NULL,48,11011.04,'+19.54',11030.58,11,'商品退货','',1690953440,1690953440),(317,NULL,48,11030.58,'-83.30',10947.28,3,'购买抵扣','',1690958162,1690958162),(318,NULL,48,10947.28,'+49.98',10997.26,11,'商品退货','',1690958168,1690958168),(319,NULL,48,10997.26,'-83.30',10913.96,3,'购买抵扣','',1690958174,1690958174),(320,NULL,48,10913.96,'-83.30',10830.66,3,'购买抵扣','',1690958182,1690958182),(321,NULL,48,10830.66,'-83.30',10747.36,3,'购买抵扣','',1690958189,1690958189),(322,NULL,48,10747.36,'-83.30',10664.06,3,'购买抵扣','',1690958230,1690958230),(323,NULL,48,10664.06,'-83.30',10580.76,3,'购买抵扣','',1690958246,1690958246),(324,NULL,48,10580.76,'-83.30',10497.46,3,'购买抵扣','',1690958307,1690958307),(325,NULL,48,10497.46,'-83.30',10414.16,3,'购买抵扣','',1690958315,1690958315),(326,NULL,48,10414.16,'-83.30',10330.86,3,'购买抵扣','',1690958330,1690958330),(327,NULL,48,10330.86,'-83.30',10247.56,3,'购买抵扣','',1690958355,1690958355),(328,NULL,48,10247.56,'-83.30',10164.26,3,'购买抵扣','',1690958364,1690958364),(329,NULL,48,10164.26,'-83.30',10080.96,3,'购买抵扣','',1690958371,1690958371),(330,NULL,48,10080.96,'-83.30',9997.66,3,'购买抵扣','',1690958379,1690958379),(333,NULL,48,9997.66,'-83.30',9914.36,3,'购买抵扣','',1690958391,1690958391),(334,NULL,48,9914.36,'-8.00',9906.36,3,'购买抵扣','',1690958643,1690958643),(335,NULL,48,9906.36,'-83.30',9823.06,3,'购买抵扣','',1690975194,1690975194),(336,NULL,49,10988.80,'+3.80',10992.60,11,'商品退货','',1690981947,1691038181),(337,NULL,49,10992.60,'+3.80',10996.40,11,'商品退货','',1690981950,1691038181),(338,NULL,49,10996.40,'+3.80',11000.20,11,'商品退货','',1690981953,1691038181),(339,NULL,49,11000.20,'+3.80',11004.00,11,'商品退货','',1690981955,1691038181),(340,NULL,49,11004.00,'-83.30',10920.70,3,'购买抵扣','',1690981971,1691038181),(341,NULL,49,10920.70,'+19.36',10940.06,11,'商品退货','',1690981984,1691038181),(342,NULL,49,10940.06,'-83.30',10856.76,3,'购买抵扣','',1690981987,1691038181),(343,NULL,49,10856.76,'+26.98',10883.74,11,'商品退货','',1690982002,1691038181),(344,NULL,49,10883.74,'-83.30',10800.44,3,'购买抵扣','',1690982005,1691038181),(345,NULL,49,10800.44,'+33.18',10833.62,11,'商品退货','',1690982023,1691038181),(346,NULL,49,10833.62,'-83.30',10750.32,3,'购买抵扣','',1690982026,1691038181),(347,NULL,48,9823.06,'-83.30',9739.76,3,'购买抵扣','',1690996766,1690996766),(348,NULL,49,10750.32,'-16.66',10733.66,3,'购买抵扣','',1690996792,1691038181),(349,NULL,49,10733.66,'-16.66',10717.00,3,'购买抵扣','',1690998746,1691038181),(350,NULL,49,10717.00,'+5.80',10722.80,11,'商品退货','',1690998765,1691038181),(351,NULL,49,10722.80,'+3.80',10726.60,11,'商品退货','',1690999813,1691038181),(352,NULL,49,10726.60,'-83.30',10643.30,3,'购买抵扣','',1691000029,1691038181),(353,NULL,49,10643.30,'-8.00',10635.30,3,'购买抵扣','',1691000722,1691038181),(354,NULL,49,10635.30,'-83.30',10552.00,3,'购买抵扣','',1691034571,1691038181),(355,NULL,49,10552.00,'-16.66',10535.34,3,'购买抵扣','',1691034805,1691038181),(356,NULL,49,10535.34,'+3.80',10539.14,11,'商品退货','',1691034820,1691038181),(357,NULL,49,10539.14,'-16.66',10522.48,3,'购买抵扣','',1691037110,1691038181),(358,NULL,49,10522.48,'-83.30',10439.18,3,'购买抵扣','',1691037119,1691038181),(359,NULL,49,10439.18,'-83.30',10355.88,3,'购买抵扣','',1691050798,1691050798),(360,NULL,49,10355.88,'+3.98',10359.86,11,'商品退货','',1691050807,1691050807),(361,NULL,49,10359.86,'-83.30',10276.56,3,'购买抵扣','',1691051931,1691051931),(362,NULL,49,10276.56,'+33.54',10310.10,11,'商品退货','',1691051951,1691051951),(363,NULL,49,10310.10,'+3.80',10313.90,11,'商品退货','',1691051973,1691051973),(364,NULL,49,10313.90,'-83.30',10230.60,3,'购买抵扣','',1691052717,1691052717),(365,NULL,49,10230.60,'-83.30',10147.30,3,'购买抵扣','',1691073239,1691073239),(366,NULL,49,10147.30,'-16.66',10130.64,3,'购买抵扣','',1691074170,1691074170),(367,NULL,49,10130.64,'+3.80',10134.44,11,'商品退货','',1691074190,1691074190),(368,NULL,49,10134.44,'-83.30',10051.14,3,'购买抵扣','',1691075613,1691075613),(370,NULL,49,10051.14,'-83.30',9967.84,3,'购买抵扣','',1691075669,1691075669),(371,NULL,54,0.00,'+999.00',999.00,1,'后台添加','',1691205744,1691205744),(372,NULL,54,999.00,'-16.66',982.34,3,'购买抵扣','',1691205836,1691205836),(373,NULL,54,982.34,'+3.98',986.32,11,'商品退货','',1691206361,1691206361),(374,NULL,54,986.32,'-16.66',969.66,3,'购买抵扣','',1691206426,1691206426),(375,NULL,54,969.66,'-16.66',953.00,3,'购买抵扣','',1691206712,1691206712),(376,NULL,54,953.00,'-16.66',936.34,3,'购买抵扣','',1691207020,1691207020),(377,NULL,54,936.34,'-16.66',919.68,3,'购买抵扣','',1691209277,1691209277),(378,NULL,54,919.68,'+3.98',923.66,11,'商品退货','',1691212107,1691212107),(379,NULL,54,923.66,'+3.60',927.26,11,'商品退货','',1691212113,1691212113),(380,NULL,54,927.26,'+3.80',931.06,11,'商品退货','',1691212268,1691212268),(382,NULL,54,931.06,'-66.64',864.42,3,'购买抵扣','',1691212284,1691212284),(383,NULL,54,864.42,'-66.64',797.78,3,'购买抵扣','',1691212291,1691212291),(384,NULL,54,797.78,'-83.30',714.48,3,'购买抵扣','',1691212296,1691212296),(385,NULL,54,714.48,'+3.98',718.46,11,'商品退货','',1691212309,1691212309),(386,NULL,54,718.46,'+3.80',722.26,11,'商品退货','',1691212313,1691212313),(387,NULL,54,722.26,'+3.80',726.06,11,'商品退货','',1691213629,1691213629),(388,NULL,54,726.06,'+3.80',729.86,11,'商品退货','',1691213632,1691213632),(389,NULL,54,729.86,'+3.98',733.84,11,'商品退货','',1691213806,1691213806),(390,NULL,54,733.84,'+3.98',737.82,11,'商品退货','',1691214460,1691214460),(391,NULL,54,737.82,'+3.98',741.80,11,'商品退货','',1691219057,1691219057),(392,NULL,48,9739.76,'-83.30',9656.46,3,'购买抵扣','',1691220508,1691220508),(393,NULL,48,9656.46,'+18.80',9675.26,11,'商品退货','',1691220516,1691220516),(394,NULL,49,9967.84,'+3.80',9971.64,11,'商品退货','',1691233954,1691233954),(396,NULL,54,741.80,'-16.66',725.14,3,'购买抵扣','',1691248560,1691248560),(397,NULL,54,725.14,'+3.80',728.94,11,'商品退货','',1691248574,1691248574),(398,NULL,54,728.94,'-83.30',645.64,3,'购买抵扣','',1691248582,1691248582),(399,NULL,54,645.64,'-123.00',522.64,3,'购买抵扣','',1691257259,1691257259),(400,NULL,54,522.64,'+0.12',522.76,11,'商品退货','',1691257267,1691257267),(401,NULL,54,522.76,'-16.66',506.10,3,'购买抵扣','',1691257279,1691257279),(403,NULL,49,9971.64,'-16.66',9954.98,3,'购买抵扣','',1691330024,1691330024),(404,NULL,49,9954.98,'+3.98',9958.96,11,'商品退货','',1691330027,1691330027),(405,NULL,48,9675.26,'-83.30',9591.96,3,'购买抵扣','',1691334519,1691334519),(408,NULL,48,9591.96,'-83.30',9508.66,3,'购买抵扣','',1691334531,1691334531),(409,NULL,54,506.10,'-16.66',489.44,3,'购买抵扣','',1691413395,1691413395),(410,NULL,49,9958.96,'+3.98',9962.94,11,'商品退货','',1691425135,1691425135),(411,NULL,49,9962.94,'+13.80',9976.74,11,'商品退货','',1691425566,1691425566);
/*!40000 ALTER TABLE `la_users_money_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_money_log` with 388 row(s)
--

--
-- Table structure for table `la_users_sms_log`
--

DROP TABLE IF EXISTS `la_users_sms_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_sms_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mobile` varchar(191) CHARACTER SET utf8mb4 NOT NULL COMMENT '手机号',
  `code` varchar(255) CHARACTER SET utf8mb4 NOT NULL COMMENT '验证码',
  `type` int(10) unsigned NOT NULL COMMENT '事件类型',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '状态：2未使用，1已使用',
  `created_at` int(10) unsigned NOT NULL COMMENT '添加时间',
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mobile` (`mobile`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户 - 短信验证码';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_sms_log`
--

LOCK TABLES `la_users_sms_log` WRITE;
/*!40000 ALTER TABLE `la_users_sms_log` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_users_sms_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_sms_log` with 0 row(s)
--

--
-- Table structure for table `la_users_tree`
--

DROP TABLE IF EXISTS `la_users_tree`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_tree` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `path` longtext CHARACTER SET utf8,
  `bind_time` int(10) unsigned DEFAULT NULL,
  `return_times` int(10) unsigned DEFAULT '0',
  `created_at` int(10) unsigned DEFAULT NULL,
  `updated_at` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id` (`user_id`) USING BTREE,
  KEY `parent_id` (`parent_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户 - 关系树';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_tree`
--

LOCK TABLES `la_users_tree` WRITE;
/*!40000 ALTER TABLE `la_users_tree` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `la_users_tree` VALUES (1,1,0,'',NULL,5,1686207916,1686207916),(2,49,0,'',NULL,5,1688546816,1691038181),(3,3,0,'',NULL,5,1688555091,1688555091),(4,4,0,'',NULL,5,1688570500,1688570500),(5,5,0,'',NULL,5,1688645103,1688645103),(6,6,0,'',NULL,5,1688710466,1688710466),(7,7,0,'',NULL,5,1688711048,1688711048),(8,8,0,'',NULL,5,1688711887,1688711887),(9,9,0,'',NULL,5,1688712378,1688712378),(10,10,0,'',NULL,5,1688717089,1688717089),(11,11,0,'',NULL,5,1688722449,1688722449),(12,12,0,'',NULL,5,1688722615,1688722615),(13,13,0,'',NULL,5,1688723428,1688723428),(14,14,0,'',NULL,5,1688723443,1688723443),(15,15,0,'',NULL,5,1688723499,1688723499),(16,16,0,'',NULL,5,1688723671,1688723671),(17,17,0,'',NULL,5,1688725835,1688725835),(18,18,0,'',NULL,5,1688726049,1688726049),(19,19,0,'',NULL,5,1688728318,1688728318),(20,20,0,'',NULL,5,1688728833,1688728833),(21,21,0,'',NULL,5,1688731075,1688731075),(22,22,0,'',NULL,5,1688731824,1688731824),(23,23,0,'',NULL,5,1688736201,1688736201),(24,24,0,'',NULL,5,1688739435,1688739435),(25,25,0,'',NULL,5,1688742490,1688742490),(26,26,0,'',NULL,5,1688742608,1688742608),(27,27,0,'',NULL,5,1688783331,1688783331),(28,28,0,'',NULL,5,1688795425,1688795425),(29,29,0,'',NULL,5,1688802677,1688802677),(30,30,0,'',NULL,5,1688802758,1688802758),(31,31,0,'',NULL,5,1688822223,1688822223),(32,32,0,'',NULL,5,1688857617,1688857617),(33,33,0,'',NULL,5,1688878372,1688878372),(34,34,0,'',NULL,5,1688880872,1688880872),(35,35,0,'',NULL,5,1688896125,1688896125),(36,36,0,'',NULL,5,1688903450,1688903450),(37,37,0,'',NULL,5,1688949945,1688949945),(38,38,0,'',NULL,5,1688969957,1688969957),(39,39,0,'',NULL,5,1688970001,1688970001),(40,40,0,'',NULL,5,1688973133,1688973133),(41,41,0,'',NULL,5,1688973302,1688973302),(42,42,0,'',NULL,5,1688977716,1688977716),(43,43,0,'',NULL,5,1689016116,1689016116),(44,44,0,'',NULL,5,1689016263,1689016263),(45,45,0,'',NULL,5,1689046412,1689046412),(46,46,0,'',NULL,5,1689068745,1689068745),(47,47,0,'',NULL,5,1689180647,1689180647),(48,48,0,'',NULL,5,1690918342,1690918342),(51,51,0,'',NULL,5,1691040187,1691040187),(52,52,0,'',NULL,5,1691048141,1691048141),(53,53,0,'',NULL,5,1691049976,1691049976),(54,54,0,'',NULL,5,1691063212,1691063212);
/*!40000 ALTER TABLE `la_users_tree` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_tree` with 52 row(s)
--

--
-- Table structure for table `la_users_withdraw`
--

DROP TABLE IF EXISTS `la_users_withdraw`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `la_users_withdraw` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT '用户ID',
  `withdraw_fee` decimal(10,2) unsigned NOT NULL COMMENT '提现金额',
  `handling_fee` decimal(10,2) unsigned NOT NULL COMMENT '手续费',
  `pay_fee` decimal(10,2) unsigned NOT NULL COMMENT '到账金额',
  `qrcode` varchar(191) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '收款码',
  `fail_reason` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '失败原因',
  `vouchers` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '成功凭证',
  `status` int(10) NOT NULL COMMENT '状态：0待审核，1审核成功，-1审核失败',
  `created_at` int(10) unsigned NOT NULL COMMENT '添加时间',
  `updated_at` int(10) unsigned NOT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='用户 提现';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `la_users_withdraw`
--

LOCK TABLES `la_users_withdraw` WRITE;
/*!40000 ALTER TABLE `la_users_withdraw` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `la_users_withdraw` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `la_users_withdraw` with 0 row(s)
--

/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on: Tue, 08 Aug 2023 00:29:22 +0800
