<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DRIVER', 'local'),

    /*
    |--------------------------------------------------------------------------
    | Default Cloud Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Many applications store files both locally and in the cloud. For this
    | reason, you may specify a default "cloud" driver here. This driver
    | will be bound as the Cloud disk implementation in the container.
    |
    */

    'cloud' => env('FILESYSTEM_CLOUD', 's3'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been setup for each driver as an example of the required options.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL') . '/storage',
            'visibility' => 'public',
        ],

        's3' => [
            'driver' => 's3',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'url' => env('AWS_URL'),
        ],

        'database' => [
            'driver'     => 'local',
            'root'       => public_path('/static/database/'),
            'visibility' => 'public',
            'url' => env('APP_URL') . '/static/database/',
        ],

        'uploads' => [
            'driver'     => 'local',
            'root'       => public_path('/'),       // 上传地址
            'url'        => env('APP_URL'),         // 访问地址 Storage::disk('api')->url($filename); 使用
            'visibility' => 'public',               // 不用管
        ],

        'aliyun' => [
            'driver'     => 'oss',
            'access_id'  => env('OSS_ACCESS_ID'),                           // ID
            'access_key' => env('OSS_ACCESS_KEY'),                          // key
            'bucket'     => env('OSS_BUCKET'),                              // buket    dongxiongfei
            'endpoint'   => env('OSS_ENDPOINT'),                            // 地域节点 dongxiongfei.oss-cn-beijing.aliyuncs.com
            'cdnDomain'  => parse_url(env('OSS_URL'), PHP_URL_HOST),        // 域名切记不要到http://
            'isCName'    => env('OSS_ISCNAME'),                             // https true,http false
            'ssl'        => env('OSS_SLL'),
            'debug'      => false,
        ],

        'qiniuyun' => [
            'driver'  => 'qiniu',
            'domains' => [
                'default' => parse_url(env('QINIU_URL'), PHP_URL_HOST),   //你的七牛域名
                'https'   => env('QINIU_URL'),                            //你的HTTPS域名
                'custom'  => env('QINIU_URL'),                            //同上default
            ],
            'access_key' => env('QINIU_ACCESS_KEY'),   //AccessKey
            'secret_key' => env('QINIU_SECRET_KEY'),   //SecretKey
            'bucket'     => env('QINIU_BUCKET'),       //Bucket名字
        ],
    ],

];
