<?php

namespace App\ToolsClass\WxPay;

use Exception;
use Yansongda\Pay\Pay;
use App\Common\Method\Response;
use App\Models\Admin\Configuration;

/** 微信支付 */
class MiniPayTool
{
    /** 支付实例 */
    public $app;

    /** 支付配置 */
    protected $config;

    /** 初始化配置 */
    public function __construct()
    {
        $field = [
            'mini_appid', 'mini_key',
            'mini_mch', 'mini_notify_url'
        ];
        $config = Configuration::getVal($field);
        $config = [
            'miniapp_id'  =>  $config['mini_appid'],                                 // APP APPID
            'mch_id'      =>  $config['mini_mch'],                                   // 商户号
            'key'         =>  $config['mini_key'],                                   // key
            'notify_url'  =>  url($config['mini_notify_url']),
            'cert_client' => './static/wxcert/apiclient_cert.pem',                  // optional, 退款，红包等情况时需要用到
            'cert_key'    => './static/wxcert/apiclient_key.pem',                   // optional, 退款，红包等情况时需要用到
        ];
        $this->config = $config;
        $this->app = Pay::wechat($config);
    }

    /**
     * 统一下单
     *
     * @param array $data[
     *      $total_fee    支付金额*
     *      $out_trade_no 订单号*
     *      $body         支付信息*
     *      $openid       用户openid
     * ]
     * @return array
     */
    public function pay($data)
    {
        try {
            $data['total_fee'] = $data['total_fee'] * 100;
            $data['time_expire'] = date('YmdHis', time() + 300);
            $result = $this->app->miniapp($data);
            if (!$result) {
                return Response::error('微信支付吊起失败,请检查配置!');
            }
            $result = jsonDecode($result);
            return Response::success($result);
        } catch (Exception $e) {
            return Response::error('微信支付吊起失败,请检查配置!');
        }
    }

    /**
     * 退款
     *
     * @param  object $order
     */
    public function refund($order)
    {
        try {
            $order = [
                'out_trade_no' => $order->order_sn,
                'out_refund_no' => time(),
                'total_fee' => $order->real_money * 100,
                'refund_fee' => $order->real_money * 100,
                'refund_desc' => '退款',
                'type' => 'miniapp'
            ];
            $result = $this->app->refund($order);
            $result = jsonDecode($result);
            if ($result['return_code'] != 'SUCCESS') {
                return Response::error('退款失败!');
            }
            return Response::success();
        } catch (Exception $e) {
            return Response::error('请检查微信配置!');
        }
    }
}
