<?php
/**
 * Created by PhpStorm.
 * Author:  Godfrey
 * Date:    2023/1/1
 * Time:    20:42
 * Email:   yxw770@gmail.com
 */
namespace App\ToolsClass\WeChat;
use App\ToolsClass\WeChat\MiniProgramTool;
use App\Models\Admin\Configuration;
use App\Common\Method\Response;
/**
 * 小程序二维码类
 * Author:  huixiang
 * Date:    2023/5/5
 * Time:    20:42
 * Email:   43367628@qq.com
 * Class Qrcode
 */
class Qrcode
{
        /**
     * @var string TOKEN
     */
    public $token;
        /**
     * @var string 小程序APPID
     */
    private $appid;
    /**
     * @var string 小程序APPSECRET
     */
    private $appsecret;

    public function __construct()
    {
        $configModel = new Configuration();
        $this->appid = $configModel->getVal('mini_appid');
        $this->appsecret = $configModel->getVal('mini_secret');
        // $miniProgramTool = new MiniProgramTool();
        $this->token = $this->get_access_token();
    }
    
    public function get_access_token()
    {

            //过期了就重新请求accesstoken
            $appid = $this->appid ;//	小程序appidd
            $secret =  $this->appsecret;   //  小程序appsecret
            $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$appid&secret=$secret";
            $user_obj = $this->curlHttp($url);
            //请求到了之后存在缓存里面，最长时间7200秒，自动过期
            // Cache::set('access_token', $user_obj['access_token'], 7100);
            //返回access_token
            return $user_obj['access_token'];

    }

    //二进制转图片image/png
    public function data_uri($contents, $mime)
    {
        $base64 = base64_encode($contents);
        return ('data:' . $mime . ';base64,' . $base64);
    }

    /**
     * 发送get请求
     */
    public function curlHttp($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $output = curl_exec($ch);
        //释放curl句柄
        curl_close($ch);
        return json_decode($output, true);
    }

    public function curl_post_https($url, $data, $header = [])
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $output = curl_exec($ch);
        curl_close($ch);


        return $output;
    }
    
    public function getQrcode($data)
    {

        $access_token = $this->token; //获取cache里面的access_token
        //拼接请求的url地址
        $url="https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={$access_token}";
        //参数转为json类型
        $data=json_encode($data);
        //开始请求拿到二维码
        $result = $this->curl_post_https($url,$data);

        //调用方法，将二维码转为base64返回给前端
        $res = $this->UploadImageQrCode($result);

        return $res;
    }
    public function urlscheme($data1){
        $token = $this->token;
        $url1 = 'https://api.weixin.qq.com/wxa/generatescheme?access_token='.$token;
        $ch = curl_init();

        // $data1 = array("path"=>"", "query"=>"","env_version"=>"release");
        $data = json_encode(array("expire_type"=>1,"expire_interval"=>5,"jump_wxa"=>$data1));
        curl_setopt($ch, CURLOPT_URL, $url1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
    public function UploadImageQrCode($img){
		$saveimgfile_1 = './uploads/code';
		$fileimgname = time()."-".rand(1000,9999).".png";
	    $filecachs = $saveimgfile_1."/".$fileimgname;
		$fanhuistr = file_put_contents($filecachs,$img);
		return 'uploads/code/'.$fileimgname;
   	}
   	public function mobile($code)
    {
        try {
            $url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" . $this->token;
            $data = [
                'code' => $code
            ];
            $data = json_encode($data, JSON_UNESCAPED_UNICODE);
            $result = $this->curl_post_https($url, $data);
            if (isset($data['errcode'])) {
                throw new ApiException($result['errmsg']);
            }
            $res = json_decode($result,true);
            return Response::success($res['phone_info']['phoneNumber']);
        } catch (Exception $e) {
            return Response::error('发送失败!');
        }
    }
}