<?php

namespace App\ToolsClass\AliPay;

use Exception;
use Yansongda\Pay\Pay;
use App\Common\Method\Response;
use App\Models\Admin\Configuration;

/** 微信支付 */
class AliPayTool
{
    /** 支付实例 */
    public $app;

    /** 支付配置 */
    protected $config;

    /** 初始化配置 */
    public function __construct()
    {
        $field = [
            'ali_app_id', 'ali_public_key',
            'ali_private_key'
        ];
        $config = Configuration::getVal($field);
        $config = [
            'app_id'  =>  $config['ali_app_id'],                                 // APP APPID
            'ali_public_key'      =>  $config['ali_public_key'],                                   // 商户号
            'private_key'         =>  $config['ali_private_key'],                                   // key
            'notify_url'  =>  url('/api/v1/alipay/notify'),
            'return_url'  =>  url('/api/v1/alipay/notify'),
            'log' => [ // optional
                'file' => './logs/alipay.log',
                'level' => 'info', // 建议生产环境等级调整为 info，开发环境为 debug
                'type' => 'single', // optional, 可选 daily.
                'max_file' => 30, // optional, 当 type 为 daily 时有效，默认 30 天
            ],
            'http' => [ // optional
                'timeout' => 5.0,
                'connect_timeout' => 5.0,
                // 更多配置项请参考 [Guzzle](https://guzzle-cn.readthedocs.io/zh_CN/latest/request-options.html)
            ],
        ];
//        print_r($config);
//        exit;
        $this->config = $config;
        $this->app = Pay::alipay($config);
    }

    /**
     * 统一下单
     *
     * @param array $data[
     *      $total_fee    支付金额*
     *      $out_trade_no 订单号*
     *      $body         支付信息*
     *      $openid       用户openid
     * ]
     * @return array
     */
    public function pay($data)
    {
        try {
            $data['total_amount'] = number_format($data['total_amount'],2);
            $result = $this->app->scan($data);
//            $result = $this->app->miniapp($data);

            if (!$result) {
                return Response::error('支付拉起失败,请检查配置!');
            }
            $result = jsonDecode($result);
            return Response::success($result);
        } catch (Exception $e) {
            dd($e);

            return Response::error('支付拉起失败,请检查配置!');
        }
    }

    /**
     * 退款
     *
     * @param  object $order
     */
    public function refund($order)
    {
        try {
            $order = [
                'out_trade_no' => $order->order_sn,
                'out_refund_no' => time(),
                'total_fee' => $order->real_money * 100,
                'refund_fee' => $order->real_money * 100,
                'refund_desc' => '退款',
                'type' => 'miniapp'
            ];
            $result = $this->app->refund($order);
            $result = jsonDecode($result);
            if ($result['return_code'] != 'SUCCESS') {
                return Response::error('退款失败!');
            }
            return Response::success();
        } catch (Exception $e) {
            return Response::error('请检查支付宝配置!');
        }
    }
}
