<?php

namespace App\Services\User;

use App\ToolsClass\TimeTool;
use App\Models\User\Withdraw;
use App\Common\Method\Response;
use App\Models\Admin\Configuration;

/** 提现 */
class WithdrawModel extends Withdraw
{
    /** 未通过 */
    const STA_MIN_1 = -1;
    /** 申请中 */
    const STA_0 = 0;
    /** 已通过 */
    const STA_1 = 1;
    /** 状态 */
    static public $status = [
        self::STA_MIN_1 => '未通过',
        self::STA_0 => '申请中',
        self::STA_1 => '已通过',
    ];

    /**
     * 提现记录添加
     *
     * @param  object $userinfo
     * @param  string $money
     * @param  string $qrcode
     */
    public function withdraw($userinfo, $money, $qrcode)
    {
        // 判断今日提现上限
        $withdraw_day_max = Configuration::getVal('withdraw_day_max') ?? 10;
        $count = $this->where(['user_id' => $userinfo->user_id])
            ->whereBetween('created_at', TimeTool::day())
            ->whereIn('status', [self::STA_0, self::STA_1])
            ->count();
        if ($count >= $withdraw_day_max) {
            return Response::error('今日提现已达上限!');
        }
        // 判断金额
        if ($userinfo->gold < $money) {
            return Response::error('余额不足!');
        }
        $handling_rate = Configuration::getVal('withdraw_handling_rate') ?? 1;
        $handling_fee = calc($money, '*', $handling_rate / 100);
        $pay_fee = calc($money, '-', $handling_fee);
        $this->user_id = $userinfo->user_id;    // 用户ID
        $this->withdraw_fee = $money;           // 提现金额
        $this->handling_fee = $handling_fee;    // 手续费(低于0.01 不计算)
        $this->pay_fee = $pay_fee;              // 需支付金额
        $this->qrcode = $qrcode;                // 收款码
        if (!$this->save()) {
            return Response::error('提现记录添加失败!');
        }
        return Response::success();
    }
}
