<?php

namespace App\Services\User;

use App\Models\User\MoneyLog;
use App\Common\Method\Response;

/** 余额日志 */
class MoneyLogModel extends MoneyLog
{
    /** 后台添加 */
    const TYPE_1 = 1;
    /** 后台扣除 */
    const TYPE_2 = 2;
    /** 购买抵扣 */
    const TYPE_3 = 3;
    /** 购买失败退回 */
    const TYPE_4 = 4;
    /** 提现申请 */
    const TYPE_5 = 5;
    /** 提现驳回 */
    const TYPE_6 = 6;
    /** 幸运盲盒开奖 */
    const TYPE_7 = 7;
    /** 红包奖励 */
    const TYPE_8 = 8;
    /** 邀请好友开盒 */
    const TYPE_9 = 9;
    /** 下级返佣 */
    const TYPE_10 = 10;
    /** 商品退货 */
    const TYPE_11 = 11;
    /** 用户充值 */
    const TYPE_12 = 12;
    
    /** 余额类型 */
    public static $type = [
        self::TYPE_1 => '后台添加',
        self::TYPE_2 => '后台扣除',
        self::TYPE_3 => '购买抵扣',
        self::TYPE_4 => '购买失败退回',
        self::TYPE_5 => '提现申请',
        self::TYPE_6 => '提现驳回',
        self::TYPE_7 => '幸运盲盒开奖',
        self::TYPE_8 => '红包奖励',
        self::TYPE_9 => '邀请好友开盒',
        self::TYPE_10 => '下级好友开盒奖励',
        self::TYPE_11 => '商品退货',
        self::TYPE_12 => '用户充值',
    ];

    /**
     * 余额日志记录添加
     *
     * @param  object $userinfo
     * @param  string $money
     * @param  string $type
     * @param  string $remark
     */
    public function log($userinfo, $money, $type, $remark = '', $data_id = null)
    {
        // 改变金额
        $change = formatPrice($money);
        if (abs($change) < 0.01) {
            return Response::error('金额不正确!');
        }
        $before = $userinfo->money;             //改变之前的金额
        $after  = calc($before, '+', $change);  //改变之后的金额
        // 余额判断
        if ($after < 0) {
            return Response::error('余额不足!');
        }
        if ($money > 0) {
            $change = '+' . ltrim($change, '+');
        } else {
            $change = '-' . ltrim($change, '-');
        }
        // 添加记录
        $log = new self();
        $log->user_id = $userinfo->user_id;
        $log->before = $before;
        $log->change  = $change;
        $log->after = $after;
        $log->type = $type;
        $log->desc = self::$type[$type];
        $log->remark = $remark;
        $logResult = $log->save();
        // 用户金额修改
        $userinfo->money = $after;
        $result = $userinfo->save();
        if (!$logResult || !$result) {
            return Response::error('记录写入失败!');
        }
        return Response::success();
    }

    /**
     * 余额抵扣 (支付金额大于0.01)
     *
     * @param  string $pay_money    剩余支付金额
     * @param  object $userinfo     用户信息
     */
    public function discount($pay_money, $userinfo)
    {
        // 使用折扣(最少0.01元)
        $money = formatPrice($userinfo->money);         // 用户剩余余额
        $data['money_dis'] = formatPrice(0);             // 抵扣金额
        $data['pay_money'] = formatPrice($pay_money);   // 剩余支付金额
        // 余额大于0.01
        if ($money >= 0.01) {
            if ($money <= $pay_money) {
                // 余额不足（抵扣金额=余额，剩多少抵扣多少）
                $discount = $money;
                $pay_money = calc($pay_money, '-', $money);
            } else {
                // 余额充足（抵扣金额=支付金额，全部抵扣）
                $discount = $pay_money;
                $pay_money = 0;
            }
            $data['money_dis'] = formatPrice($discount);
            $data['pay_money'] = formatPrice($pay_money);
        }
        return $data;
    }
}
