<?php

namespace App\Services\User;

use App\Models\User\Info;
use App\Models\Admin\Configuration;
use App\Services\Luckbox\JoinModel;
use App\Services\Luckbox\TermModel;

/** 用户附表 */
class InfoModel extends Info
{
    /**
     * 获取幸运盲盒进度
     *
     * @param  object $user
     * @param  string $term_id
     */
    public function luckprogress($user, $term_id)
    {
        $userinfo = $user->userinfo;
        $termModel = new TermModel();
        $luckbox_hiden_need = Configuration::getVal('luckbox_hiden_need') ?? 10;
        // 查找上一期
        $last = $termModel->where('id', '<', $term_id)->latest('id')->first();
        $luckbox_progress = $user->userinfo->luckbox_progress;
        if ($last && $luckbox_progress < $luckbox_hiden_need) {
            $joinModel = new JoinModel();
            // 上一期没有中幸运奖(未中奖清零)
            $log = $joinModel->where(['user_id' => $user->id, 'term_id' => $last->id, 'status' => $joinModel::STA_1])->first();
            if (!$log) {
                $luckbox_progress = 0;
                $userinfo->luckbox_progress = 0;
                $userinfo->save();
            }
        }
        return $luckbox_progress;
    }
}
