<?php

namespace App\Services\User;

use App\Models\User\GoldLog;
use App\Common\Method\Response;

/** 购物金日志 */
class GoldLogModel extends GoldLog
{
    /** 后台添加 */
    const TYPE_1 = 1;
    /** 后台扣除 */
    const TYPE_2 = 2;
    /** 提现申请 */
    const TYPE_3 = 3;
    /** 提现驳回 */
    const TYPE_4 = 4;
    /** 邀请好友开盒 */
    const TYPE_5 = 5;
    /** 购物金类型 */
    public static $type = [
        self::TYPE_1 => '后台添加',
        self::TYPE_2 => '后台扣除',
        self::TYPE_3 => '提现申请',
        self::TYPE_4 => '提现驳回',
        self::TYPE_5 => '邀请好友开盒',
    ];

    /**
     * 购物金日志记录添加
     *
     * @param  object $userinfo
     * @param  string $gold
     * @param  string $type
     * @param  string $remark
     */
    public function log($userinfo, $gold, $type, $remark = '', $data_id = null)
    {
        // 改变金额
        $change = formatPrice($gold);
        if (abs($change) < 0.01) {
            return Response::error('金额不正确!');
        }
        $before = $userinfo->gold;             //改变之前的金额
        $after  = calc($before, '+', $change);  //改变之后的金额
        // 购物金判断
        if ($after < 0) {
            return Response::error('佣金不足!');
        }
        if ($gold > 0) {
            $change = '+' . ltrim($change, '+');
        } else {
            $change = '-' . ltrim($change, '-');
        }
        // 添加记录
        $log = new self();
        $log->user_id = $userinfo->user_id;
        $log->before = $before;
        $log->change  = $change;
        $log->after = $after;
        $log->type = $type;
        $log->desc = self::$type[$type];
        $log->remark = $remark;
        $logResult = $log->save();
        // 用户金额修改
        $userinfo->gold = $after;
        $result = $userinfo->save();
        if (!$logResult || !$result) {
            return Response::error('记录写入失败!');
        }
        return Response::success();
    }

    /**
     * 购物金抵扣 (支付金额大于0.01)
     *
     * @param  string $pay_money    剩余支付金额
     * @param  object $userinfo     用户信息
     */
    public function discount($pay_money, $userinfo)
    {
        // 使用折扣(最少0.01元)
        $gold = formatPrice($userinfo->gold);           // 用户剩余购物金
        $data['gold_dis'] = formatPrice(0);             // 抵扣金额
        $data['pay_money'] = formatPrice($pay_money);   // 剩余支付金额
        // 购物金大于0.01
        if ($gold >= 0.01) {
            if ($gold <= $pay_money) {
                // 购物金不足（抵扣金额=购物金，剩多少抵扣多少）
                $discount = $gold;
                $pay_money = calc($pay_money, '-', $gold);
            } else {
                // 购物金充足（抵扣金额=支付金额，全部抵扣）
                $discount = $pay_money;
                $pay_money = 0;
            }
            $data['gold_dis'] = formatPrice($discount);
            $data['pay_money'] = formatPrice($pay_money);
        }
        return $data;
    }
}
