<?php

namespace App\Services\Shop;

use App\Common\Method\Response;
use App\Models\Shop\Collect;

/** 商品收藏 */
class CollectModel extends Collect
{
    /**
     * 是否收藏
     *
     * @param  object  $user
     * @param  integer  $id
     * @return boolean
     */
    public function isCollect($user, $id)
    {
        $log = $this->where('user_id', $user->id)->first();
        if ($log) {
            $arr = explode(',', $log->path);
            if ($arr) {
                if (in_array($id, $arr)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 收藏
     *
     * @param  object $user
     * @param  string $goods_id
     */
    public function collect($user, $goods_id)
    {
        $log = $this->where('user_id', $user->id)->first();
        if ($log) {
            $arr = explode(',', $log->path);
            if ($arr) {
                if (in_array($goods_id, $arr)) {
                    $key = array_search($goods_id, $arr);
                    unset($arr[$key]);
                } else {
                    array_push($arr, $goods_id);
                }
            }
        } else {
            $log = new self();
            $log->user_id = $user->id;
            $arr = [$goods_id];
        }
        $arr = array_values($arr);
        $str = implode(',', $arr);
        $log->path = trim($str, ',');
        if ($log->save()) {
            return Response::success();
        }
        return Response::error('收藏失败!');
    }

    /**
     * 收藏ID列表
     *
     * @param  object $user
     */
    public function list($user)
    {
        $data = $this->where('user_id', $user->id)->first();
        if (!$data) {
            return [];
        }
        return explode(',', $data->path);
    }
}
