<?php

namespace App\Services\Order;

use App\Common\Method\Response;
use App\Models\Order\OrderList;
use App\Models\Admin\Configuration;

/** 附表 */
class OrderListModel extends OrderList
{
    /** 抽奖 */
    const TYPE_1 = 1;
    /** 天天抽奖 */
    const TYPE_2 = 2;
    /** 商城购买 */
    const TYPE_3 = 3;
    /** 奖品类型 */
    static public $type = [
        self::TYPE_1 => '抽奖',
        self::TYPE_2 => '天天抽奖',
        self::TYPE_3 => '商城购买',
    ];

    /** 购买 */
    const G_TYPE_1 = 1;
    /** 隐藏款（幸运盲盒） */
    const G_TYPE_2 = 2;
    /** 获取方式（用来区分奖品类型） */
    static public $get_type = [
        self::G_TYPE_1 => '购买',
        self::G_TYPE_2 => '隐藏款',
    ];

    /** 待提货 */
    const STA_0 = 0;
    /** 待发货 */
    const STA_1 = 1;
    /** 待收货 */
    const STA_2 = 2;
    /** 待评价 */
    const STA_3 = 3;
    /** 已完成 */
    const STA_4 = 4;
    /** 已退货 */
    const STA_5 = 5;
    /** 状态 */
    static public $status = [
        self::STA_0 => '待提货',
        self::STA_1 => '待发货',
        self::STA_2 => '待收货',
        self::STA_3 => '待评价',
        self::STA_4 => '已完成',
        self::STA_5 => '已退货',
    ];

    /**
     * 拆盒机盒子附表添加
     *
     * @param  object $order
     * @param  object $award
     * @param  object $box
     * @param  string $get_type
     */
    public function boxList($order, $box, $award, $get_type)
    {
        // 赏品入库
        $list = new self();
        $list->user_id = $order->user_id;
        $list->order_id = $order->id;
        $list->data_id = $box->id;
        $list->goods_id = $award->id;
        $list->type = self::TYPE_1;
        $list->title = $award->title;
        $list->thumb = $award->thumb;
        $list->price = $award->price;
        $list->get_type = $get_type;
        $list->mark_id = $award->markinfo->id;
        // 库存修改
        $award->num -= 1;
        if (!$list->save() || !$award->save()) {
            return Response::error('奖品添加失败!');
        }
        return Response::success($list);
    }

    /**
     * 商城附表添加
     *
     * @param  object $order
     * @param  string $get_type
     */
    public function shopList($order, $get_type)
    {
        // 赏品入库
        $list = new self();
        $list->type = self::TYPE_3;
        $list->user_id = $order->user_id;
        $list->order_id = $order->id;
        $list->goods_id = $order->data['id'];
        $list->title = $order->data['title'];
        $list->thumb = $order->data['thumb'];
        $list->price = $order->data['price'];
        $list->num = $order->data['num'];
        $list->get_type = $get_type;
        $list->sku_name = $order->data['sku_name'];
        $list->status = self::STA_1;
        if (!$list->save()) {
            return Response::error('奖品添加失败!');
        }
        return Response::success($list);
    }

    /**
     * 幸运盲盒隐藏款
     *
     * @param  object $user
     * @param  object $award
     * @param  string $get_type
     * @param  string $term_id
     */
    public function luckHideList($user, $award, $get_type, $term_id)
    {
        // 赏品入库
        $list = new self();
        $list->type = self::TYPE_2;
        $list->get_type = $get_type;
        $list->user_id = $user->id;
        $list->data_id = $term_id;
        $list->goods_id = $award->id;
        $list->title = $award->title;
        $list->thumb = $award->thumb;
        $list->price = $award->price;
        $list->num = 1;
        $list->mark_id = $award->mark_id;
        if (!$list->save()) {
            return Response::error('奖品添加失败!');
        }
        return Response::success($list);
    }

    /**
     * 计算运费
     *
     * @param  object $address
     */
    public function fareCale($address)
    {
        $far_list = ['新疆维吾尔自治区', '西藏自治区', '甘肃省', '宁夏回族自治区', '青海省', '内蒙古自治区'];
        if (in_array($address->province, $far_list)) {
            $money = Configuration::getVal('express_far_fare');
        } else {
            $money = Configuration::getVal('express_fare');
        }
        return formatPrice($money);
    }
}
