<?php

namespace App\Services\Operate;

use App\Common\Method\Response;
use App\Models\Operate\Redpack;
use App\Services\User\CoinLogModel;
use App\Services\User\MoneyLogModel;

class RedpackModel extends Redpack
{
    /**
     * 抽奖
     *
     * @param  object $user
     * @param  string $need
     */
    public function open($user, $need)
    {
        // 奖池剩余发数（剩余不够发数重置,重置后不够直接退出）
        $awardList = $this->get();
        if (sumData($awardList->toArray(), 'num') < 1) {
            $awardList = $this->reset();
            if (sumData($awardList->toArray(), 'num') < 1) {
                return Response::error('暂无红包!');
            }
        }
        // 开奖
        if (!$awardList->isEmpty()) {
            // 比例数组 && 奖品数据数组
            $rate_list = array_column($awardList->toArray(), 'num', 'id');
            $column = [];
            foreach ($awardList as $v) {
                $column[$v->id] = $v;
            }
            // 获取中奖ID 和 奖品
            $winning_id = luckDraw($rate_list, 1);
            $award = $column[$winning_id];
            $award->num -= 1;
            $awardRes = $award->save();
            // 用户积分减少
            $coinLogModel = new CoinLogModel();
            $coinRes = $coinLogModel->log($user->userinfo, -$need, $coinLogModel::TYPE_7, '开启红包扣除');
            // 用户余额添加
            $moneyLogModel  = new MoneyLogModel();
            $moneyRes = $moneyLogModel->log($user->userinfo, $award->money, $moneyLogModel::TYPE_8, '开红包获得奖励');
            if (!$awardRes || !$coinRes || !$moneyRes) {
                return Response::error('红包开启失败!');
            }
        }
        return Response::success($award);
    }

    /**
     * 重置奖品数量
     *
     */
    public function reset()
    {
        $list = $this->get();
        if (!$list->isEmpty()) {
            foreach ($list as $v) {
                $v->num = $v->real_rate * 100;
                $v->save();
            }
        }
        return $list;
    }
}
