<?php

namespace App\Services\Luckbox;

use Exception;
use App\Models\Luckbox\Term;
use App\Common\Method\Response;
use App\Services\User\InfoModel;
use App\Services\User\UsersModel;
use Illuminate\Support\Facades\DB;
use App\Services\User\GoldLogModel;
use App\Services\User\MoneyLogModel;
use App\Services\Order\OrderListModel;
use App\Http\Resources\Luckbox\JoinListResources;

class TermModel extends Term
{
    /** 每天签到次数 */
    const SING_TIMES = 2;
    /** 签到最小积分 */
    const SING_POINTS_MIN = 6;
    /** 签到最大积分 */
    const SING_POINTS_MAX = 30;
    /** 邀请信用户可获得积分次数 */
    const INVITE_USER_TIMES = 5;
    /** 邀请新用户每期最多可获得积分 */
    const INVITE_USER_POINTS_MAX = 60;
    /** 邀请好友开盒最高可获得积分 */
    const INVITE_OPEN_BOX_POINTS_MAX = 300000;

    /** 进行中 */
    const STA_0 = 0;
    /** 已开奖 */
    const STA_1 = 1;
    /** 状态 */
    static public $status = [
        self::STA_0 => '进行中',
        self::STA_1 => '已开奖',
    ];

    /**
     * 获取当前期数据
     *
     * @param  string $term_id
     */
    public function getFirst($term_id)
    {
        $term = $this->where('id', $term_id)
            ->where('end_time', '>', time())
            ->where('status', $this::STA_0)
            ->first();
        if (!$term) {
            return Response::error('本期已结束或不存在!');
        }
        return Response::success($term);
    }

    /**
     * 添加期数
     *
     * @param  string $num      01
     * @param  string $clock    12
     * @param  string $hours    7
     */
    public function add($num, $clock, $hours)
    {
        $title = date('Ymd') . $num;
        $log = new self();
        $log->title = $title;
        $log->end_time = mktime($clock, null, null, date('m'), date('d'), date('Y')) + $hours * 3600;
        if (!$log->save()) {
            return Response::error('添加期数失败!');
        }
        return Response::success();
    }


    /**
     * 幸运盲盒开奖
     *
     */
    public function open($num, $clock, $hours)
    {
        // 当前期数据
        $term = $this->where('status', $this::STA_0)
            ->orderByRaw('id desc')
            ->first();
        if ($term) {
            // 随机一个数字
            $number = NumModel::inRandomOrder()->take(1)->value('number');
            // 状态改变
            $term->luck_number = $number;
            $term->status = self::STA_1;
            $term->save();
            // 抽奖
            $awardModel = new AwardModel();
            $joinModel = new JoinModel();
            $award = $awardModel->factor()->where('real_rate', '>', 0)->get();  // 开奖奖品数据
            $list = $joinModel->where(['term_id' => $term->id])->get();         // 参与用户
            if (!$award->isEmpty() && !$list->isEmpty()) {
                DB::beginTransaction();
                try {
                    $type1_list = [];
                    $type2_list = [];
                    $type3_list = [];
                    $user2_list = [];
                    $user3_list = [];
                    $win_list = [];
                    $noticeModel = new NoticeModel();
                    $usersModel = new UsersModel();
                    $goldLogModel = new GoldLogModel();
                    $moneyLogModel = new MoneyLogModel();
                    $orderListModel = new OrderListModel();
                    $orderListType = $orderListModel::TYPE_2;
                    $orderListGType = $orderListModel::G_TYPE_1;
                    $goldType = $goldLogModel::TYPE_5;
                    $goldTypeDesc = $goldLogModel::$type[$goldType];
                    $moneyType = $moneyLogModel::TYPE_7;
                    $moneyTypeDesc = $moneyLogModel::$type[$moneyType];
                    // 比例数组 && 奖品数组
                    $rate_list = array_column($award->toArray(), 'real_rate', 'id');
                    $column = [];
                    foreach ($award as $v) {
                        $column[$v->id] = $v;
                    }
                    foreach ($list as $v) {
                        // 幸运奖修改状态
                        if ($v->number == $number) {
                            $win_list[$v->user_id] = $v->user_id;   // 中奖用户
                            $v->status = $joinModel::STA_1;
                            $v->save();
                        } else {
                            $v->status = $joinModel::STA_MIN_1;
                            $v->save();
                        }
                        for ($i = 1; $i <= $v->num; $i++) {
                            // 抽奖奖品
                            $winning_id = luckDraw($rate_list, 100);
                            $award = $column[$winning_id];
                            // 判断奖品类型
                            // 实物奖品
                            if ($award->type == $awardModel::TYPE_1) {
                                $type1_list[] = [
                                    'type' => $orderListType,
                                    'get_type' => $orderListGType,
                                    'user_id' => $v->user_id,
                                    'data_id' => $term->id,
                                    'goods_id' => $award->id,
                                    'title' => $award->title,
                                    'thumb' => imageUrl($award->thumb, false),
                                    'price' => $award->price,
                                    'num' => 1,
                                    'mark_id' => $award->mark_id,
                                    'created_at' => time(),
                                    'updated_at' => time(),
                                ];
                            }
                            // 现金
                            if ($award->type == $awardModel::TYPE_2) {
                                if (isset($user2_list[$v->user_id])) {
                                    $user2_list[$v->user_id] += $award->price;
                                } else {
                                    $user2_list[$v->user_id] = $award->price;
                                }
                            }
                            // 购物金
                            if ($award->type == $awardModel::TYPE_3) {
                                if (isset($user3_list[$v->user_id])) {
                                    $user3_list[$v->user_id] += $award->price;
                                } else {
                                    $user3_list[$v->user_id] = $award->price;
                                }
                            }
                        }
                    }
                    if ($user2_list) {
                        foreach ($user2_list as $k => $v) {
                            $user = $usersModel->where('id', $k)->first();
                            if ($user) {
                                $userinfo = $user->userinfo;
                                $type2_list[] = [
                                    'user_id' => $user->id,
                                    'data_id' => $term->id,
                                    'before' => $userinfo->money,
                                    'change' => '+' . $v,
                                    'after' => calc($userinfo->money, '+', $v),
                                    'type' => $moneyType,
                                    'desc' => $moneyTypeDesc,
                                    'remark' => $moneyTypeDesc,
                                    'created_at' => time(),
                                    'updated_at' => time(),
                                ];
                                $userinfo->money += $v;
                                $userinfo->save();
                            }
                        }
                    }
                    if ($user3_list) {
                        foreach ($user3_list as $k => $v) {
                            $user = $usersModel->where('id', $k)->first();
                            if ($user) {
                                $userinfo = $user->userinfo;
                                $type3_list[] = [
                                    'user_id' => $user->id,
                                    'data_id' => $term->id,
                                    'before' => $userinfo->gold,
                                    'change' => '+' . $v,
                                    'after' => calc($userinfo->gold, '+', $v),
                                    'type' => $goldType,
                                    'desc' => $goldTypeDesc,
                                    'remark' => $goldTypeDesc,
                                    'created_at' => time(),
                                    'updated_at' => time(),
                                ];
                                $userinfo->gold += $v;
                                $userinfo->save();
                            }
                        }
                    }
                    if ($type1_list) {  // 实物奖品
                        $orderListModel->insert($type1_list);
                    }
                    if ($type2_list) {  // 现金
                        $moneyLogModel->insert($type2_list);
                    }
                    if ($type3_list) {  // 购物金
                        $goldLogModel->insert($type3_list);
                    }
                    if ($win_list) {    // 中奖的用户ID数组
                        $notice_list = [];
                        if ($win_list) {
                            foreach ($win_list as $v) {
                                $notice_list[] = [
                                    'user_id' => $v,
                                    'term_id' => $term->id,
                                ];
                            }
                            if ($notice_list) {
                                $noticeModel->insert($notice_list);
                            }
                        }
                        InfoModel::whereIn('user_id', $win_list)->increment('luckbox_progress');
                    }
                    DB::commit();
                } catch (Exception $e) {
                    DB::rollBack();
                }
            }
        }
        // 开始下一期
        $this->add($num, $clock, $hours);
    }

    /**
     * 中奖记录
     *
     * @param  object $user
     * @param  string $term_id
     */
    public function info($user, $term_id)
    {
        $joinModel = new JoinModel();
        // 选取盲盒列表
        $joinList = $joinModel->where(['user_id' => $user->id, 'term_id' => $term_id])->get();
        $joinList = JoinListResources::collection($joinList);
        $data['joinList'] = $joinList;
        // 获取的购物金
        $goldLogModel = new GoldLogModel();
        $gold = $goldLogModel->where(['type' => $goldLogModel::TYPE_5, 'data_id' => $term_id, 'user_id' => $user->id])->sum('change');
        $data['gold'] = formatPrice($gold);
        // 获取的现金
        $moneyLogModel = new MoneyLogModel();
        $money = $moneyLogModel->where(['type' => $moneyLogModel::TYPE_7, 'data_id' => $term_id, 'user_id' => $user->id])->sum('change');
        $data['money'] = formatPrice($money);
        // 获取的实物奖品
        $orderListModel = new OrderListModel();
        $goods_num = $orderListModel->where(['type' => $orderListModel::TYPE_2, 'user_id' => $user->id, 'data_id' => $term_id])->count();
        $data['goods_num'] = $goods_num;
        return $data;
    }
}
