<?php

namespace App\Services\Luckbox;

use App\Common\Method\Response;
use App\Models\Luckbox\Join;

class JoinModel extends Join
{
    /** 编号选择不超过五种 */
    const NUMBER_MAX = 5;

    /** 未中奖 */
    const STA_MIN_1 = -1;
    /** 待开奖 */
    const STA_0 = 0;
    /** 已中奖 */
    const STA_1 = 1;
    /** 状态 */
    static public $status = [
        self::STA_MIN_1 => '未中奖',
        self::STA_0 => '待开奖',
        self::STA_1 => '已中奖',
    ];

    /**
     * 兑换编号
     *
     * @param  object $user
     * @param  object $term
     * @param  string $number
     * @param  string $num
     */
    public function join($user, $term, $number, $num)
    {
        // 本期人数添加
        $is_join = $this->where(['user_id' => $user->id, 'term_id' => $term->id])->first();
        if (!$is_join) {
            $term->join_num += 1;
            $term->save();
            if (!$term->save()) {
                return Response::error('人数添加失败!');
            }
        }
        // 兑换编号
        $log = $this->where(['user_id' => $user->id, 'term_id' => $term->id, 'number' => $number])->first();
        if ($log) {
            $log->num += $num;
        } else {
            $log = new self();
            $log->user_id = $user->id;
            $log->term_id = $term->id;
            $log->number = $number;
            $log->num = $num;
        }
        if (!$log->save()) {
            return Response::error('添加失败!');
        }
        return Response::success('添加成功!');
    }
}
