<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

// 邮箱验证
class EmailRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (is_string($value) && preg_match("/^[\w\d]+[\w\d-.]*@[\w\d-.]+\.[\w\d]{2,10}$/i", $value)) {
            return true;
        }
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return '邮箱格式不正确';
    }
}
