<?php

namespace App\Models\User;

use App\Models\Levels\Level;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;

/** 用户表 */
class Users extends Authenticatable implements JWTSubject
{
    protected $table = 'users';

    public $timestamps = true;

    public $dateFormat = "U";

    /** 图像修改器 */
    public function setAvatarAttribute($value)
    {
        $this->attributes['avatar'] = imageUrl($value, false);
    }
    /** 图像访问器 */
    public function getAvatarAttribute($value)
    {
        return imageUrl($value);
    }

    /** 关联用户附表 */
    public function userinfo()
    {
        return $this->hasOne(Info::class, 'user_id', 'id')->withDefault();
    }

    /** 关联用户等级 */
    public function levelinfo()
    {
        return $this->hasOne(Level::class, 'id', 'level')->withDefault();
    }

    /** 关联关系树 */
    public function treeinfo()
    {
        return $this->hasOne(Tree::class, 'user_id', 'id')->withDefault();
    }

    /** 关联绑定日志 */
    public function bindinfo()
    {
        return $this->hasMany(BindLog::class, 'user_id', 'id');
    }

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}
