<?php

namespace App\Models\User;

use App\Models\BaseModel;

// 用户树
class Tree extends BaseModel
{
    protected $table = 'users_tree';

    public $timestamps = true;

    protected $primaryKey = 'id';

    /** 关联用户 */
    public function userinfo()
    {
        return $this->belongsTo(Users::class, 'user_id', 'id')->withDefault();
    }

    /** 关联用户 */
    public function parentinfo()
    {
        return $this->belongsTo(Users::class, 'parent_id', 'id')->withDefault();
    }
}
