<?php

namespace App\Models\User;

use App\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;

class Friend extends BaseModel
{
    use SoftDeletes;

    protected $table = "users_friend_open_log";

    public $timestamps = true;

    /** 缩略图修改器 */
    public function setThumbAttribute($value)
    {
        $this->attributes['thumb'] = imageUrl($value, false);
    }
    public function getThumbAttribute($value)
    {
        return imageUrl($value);
    }
    
    /** 关联用户 */
    public function friend()
    {
        return $this->hasOne(Users::class, 'id', 'friend_id');
    }
}
