<?php

namespace App\Models\User;

use App\Models\BaseModel;

// 用户绑定记录
class BindLog extends BaseModel
{
    protected $table = "users_bind_log";

    public $timestamps = true;

    /** 关联用户 */
    public function userinfo()
    {
        return $this->belongsTo(Users::class, 'user_id', 'id')->withDefault();
    }

    /** 关联用户 */
    public function parentinfo()
    {
        return $this->belongsTo(Users::class, 'parent_id', 'id')->withDefault();
    }
}
