<?php

namespace App\Models\Order;

use App\Models\BaseModel;
use App\Models\User\Users;
use Illuminate\Database\Eloquent\SoftDeletes;

// 商品
class Order extends BaseModel
{
    use SoftDeletes;

    protected $table = "order";

    public $timestamps = true;

    /** 订单数据 */
    public function setDataAttribute($value)
    {
        if ($value) {
            $this->attributes['data'] = jsonEncode($value);
        }
    }
    public function getDataAttribute($value)
    {
        if ($value) {
            return jsonDecode($value);
        }
    }
    /** 地址数据 */
    public function setAddressAttribute($value)
    {
        if ($value) {
            $this->attributes['address'] = jsonEncode($value);
        }
    }
    public function getAddressAttribute($value)
    {
        if ($value) {
            return jsonDecode($value);
        }
    }

    /** 关联附表 */
    public function listinfo()
    {
        return $this->hasMany(OrderList::class, 'order_id', 'id');
    }

    /** 关联用户表 */
    public function userinfo()
    {
        return $this->belongsTo(Users::class, 'user_id', 'id')->withDefault();
    }
}
