<?php

namespace App\Models\Luckbox;

use App\Models\Box\Mark;
use App\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;

// 拆盒机奖品
class Award extends BaseModel
{
    use SoftDeletes;
    
    protected $table = "luckbox_award";

    public $timestamps = true;

    /** 缩略图修改器 */
    public function setThumbAttribute($value)
    {
        $this->attributes['thumb'] = imageUrl($value, false);
    }
    public function getThumbAttribute($value)
    {
        return imageUrl($value);
    }

    /** 富文本修改器 */
    public function setEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v, false), $value);
                }
            }
        }
        $this->attributes['editor'] = $value;
    }
    public function getEditorAttribute($value)
    {
        if ($value) {
            $data = getSrc($value);
            if ($data) {
                foreach ($data as $v) {
                    $value = str_ireplace($v, imageUrl($v), $value);
                }
            }
        }
        return $value;
    }

    /**
     * 关联赏类型
     */
    public function markinfo()
    {
        return $this->belongsTo(Mark::class, 'mark_id', 'id')->withDefault();
    }
}
