<?php

namespace App\Models\Box;

use App\Models\BaseModel;
use App\Models\User\Users;

class Rating extends BaseModel
{
    protected $table = "box_rating";

    public $timestamps = true;

    /** 缩略图修改器 */
    public function setThumbAttribute($value)
    {
        $this->attributes['thumb'] = imageUrl($value, false);
    }
    public function getThumbAttribute($value)
    {
        if ($value) {
            $value = explode(',', $value);
        }
        return imageUrl($value);
    }

    /**
     * 关联用户
     */
    public function userinfo()
    {
        return $this->hasOne(Users::class, 'id', 'user_id')->withDefault();
    }
}
