<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

// Base Model 类
class BaseModel extends Model
{
    public $timestamps = true;

    /** 插入数据时间格式 */
    protected $dateFormat = 'U';

    /**
     * 分页数据整合
     *
     * @param  object $data
     */
    public function page($data)
    {
        return [
            'total'        => $data->total(),                           // 总条数
            'current_page' => $data->currentPage(),                     // 当前页
            'last_page'    => $data->previousPageUrl() ? true : false,  // 上一页：true有，false没有
            'next_page'    => $data->nextPageUrl() ? true : false,      // 下一页：true有，false没有
            'data'         => $data->items(),                           // 数据信息
        ];
    }
}
