<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;

class Configuration extends Model
{
    protected $table = 'configuration';

    protected $guarded = ['id'];

    /** 数据修改器 */
    public function setValAttribute($value)
    {
        $this->attributes['val'] = $value;
        // url 转义
        if (isset($this->attributes['translate']) && $this->attributes['translate'] == 1) {
            $this->attributes['val'] = imageUrl($value, false);
        }
    }
    /** 数据修改器 */
    public function getValAttribute($value)
    {
        if (isset($this->attributes['translate']) && $this->attributes['translate'] == 1) {
            return imageUrl($value);
        }
        return $value;
    }

    /**
     * 获取 配置
     *
     * @param array|string $name  名称
     * @return string
     */
    public static function getVal($key)
    {
        if (is_string($key)) {
            $data = self::where('key', $key)->first();
            $data = $data->val;
        }
        if (is_array($key)) {
            $data = self::whereIn('key', $key)->get()->pluck('val', 'key')->toArray();
        }
        return $data;
    }
}
