<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class BindResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'         => $this->id,
            'avatar'     => $this->userinfo->avatar,
            'nickName'   => $this->userinfo->nickName,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
