<?php

namespace App\Http\Resources\Ship;

use App\Services\Order\OrderModel;
use Illuminate\Http\Resources\Json\JsonResource;

class ShipLogInfoResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'title'         => $this->title,
            'thumb'         => $this->thumb,
            'price'         => $this->orderinfo->data['price'],
            'sku_name'      => $this->orderinfo->data['sku_name'],
            'num'           => $this->num,
            'name'          => $this->shipinfo->name,
            'mobile'        => $this->shipinfo->mobile,
            'address'       => $this->shipinfo->address,
            'order_sn'      => $this->orderinfo->order_sn,
            'status'        => $this->status,
            'pay_time'      => date('Y-m-d H:i:s', $this->orderinfo->pay_time),
            'pay_type_desc' => OrderModel::$pay_type[$this->orderinfo->pay_type],
            'express_money' => $this->orderinfo->data['express_money'],
        ];
    }
}
