<?php

namespace App\Http\Resources\Redpack;

use Illuminate\Http\Resources\Json\JsonResource;

class LogResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'         => $this->id,
            'avatar'     => $this->friend->avatar,
            'nickName'   => $this->friend->nickName,
            'title'      => $this->title,
            'thumb'      => $this->thumb,
            'get_money'  => $this->get_money,
            'get_coin'   => $this->get_coin,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
