<?php

namespace App\Http\Resources\Box;

use Illuminate\Http\Resources\Json\JsonResource;

class RatingResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $avatar   = $this->userinfo->avatar;
        $nickName = $this->userinfo->nickName;
        // 匿名用户
        if ($this->is_hidden == 1) {
            $avatar   = imageUrl('/uploads/other/rating.png');
            $nickName = '*****';
        }
        return [
            'id'       => $this->id,
            'title'    => $this->title,
            'avatar'   => $avatar,
            'nickName' => $nickName,
            'star'     => $this->star,
            'content'  => $this->content,
            'thumb'    => $this->thumb,
        ];
    }
}
