<?php

namespace App\Http\Requests\Api\User;

use App\Http\Requests\BaseRequest;
use App\Rules\UrlRule;

/** 用户 */
class UserRequest extends BaseRequest
{
    // 自定义验证规则
    public function rule()
    {
        return [
            'type'     => ['required', 'integer', 'in:1,2'],
            'nickName' => ['required_if:type,2', 'nullable', 'string', 'between:1,10'],
            'avatar'   => ['required_if:type,1', 'nullable', 'string', new UrlRule],
        ];
    }

    // 自定义验证信息
    public function message()
    {
        return [
            'type.required'        => '请选择类型',
            'type.integer'         => '类型参数错误',
            'type.in'              => '类型选择不正确',
            'nickName.required_if' => '请填昵称',
            'nickName.string'      => '昵称参数错误',
            'nickName.between'     => '昵称过长',
            'avatar.required_if'   => '请选择头像',
            'avatar.string'        => '头像参数错误',
        ];
    }
}
