<?php

namespace App\Http\Requests\Api\Sms;

use App\Rules\MobileRule;
use Illuminate\Validation\Rule;
use App\Services\Sms\SmsLogModel;
use App\Http\Requests\BaseRequest;

/** 短信验证 */
class SmsRequest extends BaseRequest
{
    // 自定义验证场景
    public $scene = [
        'send'   => ['mobile', 'type'],
        'verify' => ['mobile', 'type', 'code'],
    ];

    // 自定义验证规则
    public function rule()
    {
        return [
            'mobile' => ['required', new MobileRule],
            'type'   => ['required', Rule::in(array_keys(SmsLogModel::$type))],
            'code'   => ['required', 'digits:4'],
        ];
    }

    // 自定义验证信息
    public function message()
    {
        return [
            // 手机号
            'mobile.required' => '请填写手机号',
            // 类型
            'type.required' => '请填写短信类型',
            'type.in'       => '短信类型不正确',
            // 验证码
            'code.required' => '请填写验证码',
            'code.digits'   => '验证码填写不正确',
        ];
    }
}
