<?php

namespace App\Http\Requests\Api\Ship;

use App\Rules\UrlRule;
use App\Http\Requests\BaseRequest;

class RatingRequest extends BaseRequest
{
    // 自定义验证规则
    public function rule()
    {
        return [
            'star'    => ['required', 'integer', 'between:1,5'],
            'content' => ['required', 'string', 'between:1,300'],
            'thumb'   => ['nullable', 'string', new UrlRule()],
        ];
    }

    // 自定义验证信息
    public function message()
    {
        return [
            'star.required'    => '请选择满意程度',
            'star.integer'     => '满意程度选择不正确',
            'star.between'     => '满意程度为1~5颗星',
            'content.required' => '请填写评价内容',
            'content.string'   => '评价内容参数不正确',
            'content.between'  => '评价内容过长',
            'thumb.string'     => '评价图片参数有误',
        ];
    }
}
