<?php

namespace App\Http\Requests\Api\Complain;

use App\Rules\UrlRule;
use App\Rules\MobileRule;
use App\Http\Requests\BaseRequest;

class ComplainRequest extends BaseRequest
{
    // 自定义验证规则
    public function rule()
    {
        return [
            'mobile'  => ['required', 'string', new MobileRule],
            'content' => ['required', 'string', 'between:1,300'],
            'thumb'   => ['nullable', 'string', new UrlRule()],
        ];
    }

    // 自定义验证信息
    public function message()
    {
        return [
            'mobile.required'  => '请填写手机号',
            'mobile.string'    => '手机号填写不正确',
            'content.required' => '请填写问题描述内容',
            'content.string'   => '问题描述内容参数不正确',
            'content.between'  => '问题描述内容过长',
            'thumb.string'     => '问题描述图片参数有误',
        ];
    }
}
