<?php

namespace App\Http\Requests\Admin\Shop;

use App\Http\Requests\BaseRequest;

// 商品
class ChangeRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'title'  => 'required|string|between:1,30',
            'cat_id' => 'required|integer|min:1',
            'thumb'  => 'required',
            'price'  => 'required_if:is_attribute,0|nullable|numeric|min:0.01',
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'title.required'    => '请填写商品名称',
            'title.string'      => '名称填写不正确',
            'title.between'     => '名称长度为1~30字符',
            'cat_id.required'   => '请选择分类',
            'cat_id.integer'    => '分类选择不正确',
            'cat_id.min'        => '分类选择不正确',
            'thumb.required'    => '请上传轮播图',
            'price.required_if' => '请填写置换价格',
            'price.numeric'     => '置换价格填写不正确',
            'price.min'         => '置换价格不能小于0.01',
        ];
    }
}
