<?php

namespace App\Http\Requests\Admin\Operate;

use App\Rules\NumericRule;
use App\Http\Requests\BaseRequest;

class RedpackRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'money'     => ['required', 'numeric', 'max:10000', new NumericRule('红包金额', 1)],
            'real_rate' => ['required', 'numeric', 'max:100', new NumericRule('红包概率', 2)],
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'money.required'     => '请填写红包金额',
            'money.numeric'      => '红包金额填写不正确',
            'money.max'          => '红包金额最大为10000',
            'real_rate.required' => '请填写红包概率',
            'real_rate.numeric'  => '红包概率填写不正确',
            'real_rate.max'      => '红包概率最大为100',
        ];
    }
}
