<?php

namespace App\Http\Requests\Admin\Operate;

use App\Rules\NumericRule;
use App\Http\Requests\BaseRequest;

class RechargeRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'money'     => ['required', 'numeric', 'max:10000', new NumericRule('获得金额', 1)],
            'rmb' => ['required', 'numeric', 'max:10000', new NumericRule('人民币', 2)],
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'money.required'     => '请填写获得余额',
            'money.numeric'      => '获得余额填写不正确',
            'money.max'          => '获得余额最大为10000',
            'rmb.required' => '请填写人民币价值',
            'rmb.numeric'  => '人民币价值填写不正确',
            'rmb.max'      => '人民币价值最大为10000',
        ];
    }
}
